/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class LoanContractBillRepository {
    public static Map<Long, DynamicObject> getContractBillByIds(List<Long> contractIds, String selectFields) {
        if (Arrays.stream(selectFields.split(",")).noneMatch(s -> s.equals("id"))) {
            selectFields = "id," + selectFields;
        }
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)selectFields, (QFilter[])new QFilter("id", "in", contractIds).toArray());
        return contractBills.stream().collect(Collectors.toMap(c -> c.getLong("id"), c -> c));
    }

    public static DynamicObjectCollection queryByFilter(QFilter qFilter, String selectFields) {
        return QueryServiceHelper.query((String)"cfm_loancontractbill", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static Map<Long, DynamicObject> loadContractBillByIds(Collection<Long> contractIds, String selectFields) {
        return TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loancontractbill", (String)selectFields, contractIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, ContractBillAmountSumDTO> getContractBillAmountSum(Map<Long, DynamicObject> contractBillMap, QFilter filter) {
        HashMap<Long, ContractBillAmountSumDTO> map = new HashMap<Long, ContractBillAmountSumDTO>(contractBillMap.size());
        DataSet dsAmount = LoanBillRepository.queryLoanBillAmountSumByContractIds(contractBillMap.keySet(), filter);
        try {
            for (Row row : dsAmount) {
                Long contractId = row.getLong("loancontractbill");
                ContractBillAmountSumDTO dto = new ContractBillAmountSumDTO(contractId);
                BigDecimal drawAmount = row.getBigDecimal("drawamount");
                BigDecimal repayAmount = row.getBigDecimal("repayamount");
                DynamicObject contractBill = contractBillMap.get(contractId);
                BigDecimal contractAmount = contractBill.getBigDecimal("amount");
                BigDecimal unDrawAmount = contractAmount.subtract(drawAmount);
                if (contractBill.getBoolean("iscycleloan")) {
                    unDrawAmount = unDrawAmount.add(repayAmount);
                }
                BigDecimal calculateRateAmount = row.getBigDecimal("calculaterateamount");
                BigDecimal notRepayAmount = row.getBigDecimal("notrepayamount");
                dto.setDrawedAmt(drawAmount).setUnDrawAmt(unDrawAmount).setCalIntAmt(calculateRateAmount).setRepayedAmt(repayAmount).setNotRepayAmt(notRepayAmount);
                map.put(contractId, dto);
            }
            contractBillMap.forEach((key, value) -> map.putIfAbsent((Long)key, new ContractBillAmountSumDTO((Long)key).setUnDrawAmt(value.getBigDecimal("amount")).setNotRepayAmt(value.getBigDecimal("amount"))));
            HashMap<Long, ContractBillAmountSumDTO> hashMap = map;
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)dsAmount);
        }
    }

    public static Map<Long, ContractBillAmountSumDTO> getContractBillDrawAmountSum(List<Long> contractIds) {
        QFilter qFilter = new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.AUDIT.getValue(), BillStatusEnum.SUBMIT.getValue()));
        return LoanContractBillRepository.getContractBillAmountSum(contractIds, qFilter);
    }

    public static Map<Long, ContractBillAmountSumDTO> getContractBillAmountSum(List<Long> contractIds, QFilter qFilter) {
        return LoanContractBillRepository.getContractBillAmountSum(LoanContractBillRepository.getContractBillByIds(contractIds, "id,amount,iscycleloan"), qFilter);
    }
}

