/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class PreInterestBillRepository {
    private static final String PRE_INTEREST_BILL_SELECT_PROPS = "id,sourcebillid,prestenddate,entrys.instenddate";

    public static Map<Long, Date> getPreInstEndDate(List<Long> loanBillIds) {
        HashMap<Long, Date> preInstEndDateMap = new HashMap<Long, Date>(loanBillIds.size());
        QFilter filter = new QFilter("sourcebillid", "in", loanBillIds).and("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()).and("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection preInterests = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)PRE_INTEREST_BILL_SELECT_PROPS, (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> preInterestMap = preInterests.stream().collect(Collectors.groupingBy(p -> p.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : preInterestMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<DynamicObject> preInts = entry.getValue();
            List lists = preInts.stream().sorted(Comparator.comparing(p -> p.getDate("prestenddate"), Comparator.reverseOrder())).collect(Collectors.toList());
            long id = ((DynamicObject)lists.get(0)).getLong("id");
            Date preInstEndDate = preInts.stream().filter(p -> p.getLong("id") == id).map(p -> p.getDate("entrys.instenddate")).max(Comparator.naturalOrder()).orElse(null);
            preInstEndDateMap.put(loanBillId, preInstEndDate);
        }
        return preInstEndDateMap;
    }

    public static BigDecimal getPreInstDifferAmt(DynamicObject bill, boolean fromContract) {
        String fieldName = fromContract ? "contractbillno" : "loanbillno";
        QFilter filter = new QFilter(fieldName, "=", (Object)bill.getString("billno"));
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        filter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        filter.and("writeoffstatus", "in", (Object)new String[]{WriteOffStatusEnum.NO_WRITEOFF.getValue(), WriteOffStatusEnum.PART_WRITEOFF.getValue()});
        DynamicObjectCollection preInstBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"nowriteoffamt", (QFilter[])filter.toArray(), null);
        return preInstBills.stream().map(v -> v.getBigDecimal("nowriteoffamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getInstDifferAmt(DynamicObject bill, boolean fromContract) {
        String fieldName = fromContract ? "contractbillno" : "loanbillno";
        QFilter filter = new QFilter(fieldName, "=", (Object)bill.getString("billno"));
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DynamicObjectCollection instBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"convertintamt", (QFilter[])filter.toArray(), null);
        filter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        DynamicObjectCollection preInstBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"actpreinstamt", (QFilter[])filter.toArray(), null);
        BigDecimal preInstAmt = preInstBills.stream().map(v -> v.getBigDecimal("actpreinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal instAmt = instBills.stream().map(v -> v.getBigDecimal("convertintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return preInstAmt.subtract(instAmt);
    }
}

