/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.repository.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class LoanBillDTO {
    private Long loanBillId;
    private Long contractId;
    private String contractNo;
    private BigDecimal convertRate = BigDecimal.ONE;

    public LoanBillDTO(Long loanBillId, Long contractId) {
        this.loanBillId = loanBillId;
        this.contractId = contractId;
    }

    public LoanBillDTO() {
    }

    public static List<LoanBillDTO> transfer(List<DynamicObject> loanBills) {
        ArrayList<LoanBillDTO> list = new ArrayList<LoanBillDTO>(loanBills.size());
        loanBills.forEach(d -> list.add(LoanBillDTO.buildLoanBillDTO(d)));
        return list;
    }

    public static List<LoanBillDTO> transfer(DynamicObjectCollection loanBills) {
        ArrayList<LoanBillDTO> list = new ArrayList<LoanBillDTO>(loanBills.size());
        loanBills.forEach(d -> list.add(LoanBillDTO.buildLoanBillDTO(d)));
        return list;
    }

    private static LoanBillDTO buildLoanBillDTO(DynamicObject loanBill) {
        LoanBillDTO billDTO = new LoanBillDTO(loanBill.getLong("id"), loanBill.getLong("loancontractbill.id"));
        if (loanBill.containsProperty("convertrate")) {
            billDTO.setConvertRate(loanBill.getBigDecimal("convertrate"));
        }
        return billDTO;
    }

    public Long getLoanBillId() {
        return this.loanBillId;
    }

    public Long getContractId() {
        return this.contractId;
    }

    public String getContractNo() {
        return this.contractNo;
    }

    public LoanBillDTO setContractNo(String contractNo) {
        this.contractNo = contractNo;
        return this;
    }

    public BigDecimal getConvertRate() {
        return this.convertRate;
    }

    public LoanBillDTO setConvertRate(BigDecimal convertRate) {
        this.convertRate = convertRate;
        return this;
    }
}

