/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.enums.OverRateTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.model.interest.RateExtInfo;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillRateHelper {
    public static List<RateExtInfo> getRateList(DynamicObject loanBill) {
        ArrayList<RateExtInfo> rateList = new ArrayList<RateExtInfo>(16);
        BigDecimal floatPoint = LoanBillRateHelper.getFloatRate(loanBill);
        DynamicObjectCollection rates = loanBill.getDynamicObjectCollection("rateadjust_entry");
        for (DynamicObject rateInfo : rates) {
            RateExtInfo info = new RateExtInfo();
            info.setEffectiveDate(rateInfo.getDate("ra_effectdate"));
            info.setConfirmDate(rateInfo.getDate("ra_confirmdate"));
            info.setRate(rateInfo.getBigDecimal("ra_yearrate"));
            info.setFloatRate(floatPoint);
            info.setNormalRate(LoanBillRateHelper.getNormalRate(floatPoint, info.getRate()));
            rateList.add(info);
        }
        rateList.sort(Comparator.comparing(RateInfo::getEffectiveDate));
        return rateList;
    }

    public static BigDecimal getFloatRate(DynamicObject loanBill) {
        BigDecimal floatPoint = loanBill.getBigDecimal("ratefloatpoint");
        floatPoint = floatPoint != null ? floatPoint.divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        return RateSignEnum.isAdd(loanBill.getString("ratesign")) ? floatPoint : floatPoint.negate();
    }

    public static BigDecimal getNormalRate(BigDecimal floatPoint, BigDecimal rate) {
        BigDecimal normalRate = rate.subtract(floatPoint);
        return normalRate.compareTo(BigDecimal.ZERO) > 0 ? normalRate : BigDecimal.ZERO;
    }

    public static RateExtInfo getOverRate(DynamicObject loanBill, List<RateExtInfo> rateList) {
        BigDecimal overRate;
        DynamicObject loanContract = loanBill.getDynamicObject("loancontractbill");
        if (loanContract == null || EmptyUtil.isEmpty(rateList)) {
            return null;
        }
        Date extendDate = loanBill.getDate("renewalexpiredate");
        Date expireDate = extendDate != null ? extendDate : loanBill.getDate("expiredate");
        String overRateType = loanContract.getString("overratetype");
        BigDecimal floatRate = LoanBillRateHelper.getFloatRate(loanBill);
        if (OverRateTypeEnum.isFixrate(overRateType)) {
            BigDecimal overRateValue = loanContract.getBigDecimal("overrate");
            overRate = EmptyUtil.isNoEmpty((BigDecimal)overRateValue) ? overRateValue : LoanBillRateHelper.getLatestRate(rateList, expireDate);
            floatRate = BigDecimal.ZERO;
        } else {
            overRate = LoanBillRateHelper.getLatestRate(rateList, expireDate);
            if (overRate == null) {
                return null;
            }
            BigDecimal floatRadio = loanContract.getBigDecimal("floatingratio");
            if (EmptyUtil.isNoEmpty((BigDecimal)floatRadio)) {
                overRate = overRate.multiply(Constants.ONE_HUNDRED.add(floatRadio)).divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP);
                floatRate = floatRate.multiply(Constants.ONE_HUNDRED.add(floatRadio)).divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP);
            }
        }
        if (overRate == null) {
            return null;
        }
        return RateExtInfo.build((Date)expireDate, (BigDecimal)overRate).setConfirmDate(expireDate).setNormalRate(overRate.subtract(floatRate)).setFloatRate(floatRate);
    }

    private static BigDecimal getLatestRate(List<RateExtInfo> rateList, Date expireDate) {
        List rateInfoList = rateList.stream().filter(r -> r.getEffectiveDate().compareTo(expireDate) <= 0).sorted(Comparator.comparing(RateInfo::getEffectiveDate)).collect(Collectors.toList());
        return EmptyUtil.isEmpty(rateInfoList) ? null : ((RateExtInfo)rateInfoList.get(rateInfoList.size() - 1)).getRate();
    }
}

