/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.calcint;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;

public class LoanBillRepaymentPlanHelper {
    public static List<PlanCallResult> getAllRepayList(Long loanBillId) {
        return LoanBillRepaymentPlanHelper.getAllRepayList(loanBillId, null);
    }

    public static List<PlanCallResult> getAllRepayList(Long loanBillId, Date endDate) {
        Map<Long, List<PlanCallResult>> repayListMap = LoanBillRepaymentPlanHelper.getAllRepayListMap(Collections.singletonList(loanBillId), endDate);
        return repayListMap.get(loanBillId);
    }

    public static Map<Long, List<PlanCallResult>> getAllRepayListMap(List<Long> loanBillIds) {
        return LoanBillRepaymentPlanHelper.getAllRepayListMap(loanBillIds, null);
    }

    public static Map<Long, List<PlanCallResult>> getAllRepayListMap(List<Long> loanBillIds, Date endDate) {
        HashMap<Long, List<PlanCallResult>> repayListMap = new HashMap<Long, List<PlanCallResult>>(10);
        DynamicObjectCollection repayBillColl = RepaymentBillRepository.queryRepaymentByLoanBillIds(loanBillIds, endDate);
        Map<Long, List<DynamicObject>> repayBillMap = repayBillColl.stream().collect(Collectors.groupingBy(r -> r.getLong("loans.e_loanbill")));
        for (Long loanBillId : loanBillIds) {
            ArrayList<PlanCallResult> repayBills = new ArrayList<PlanCallResult>(8);
            List<DynamicObject> repayBillList = repayBillMap.get(loanBillId);
            if (repayBillList != null) {
                for (DynamicObject repayBill : repayBillList) {
                    PlanCallResult info = new PlanCallResult();
                    info.setBizDate(DateUtils.truncateDate((Date)repayBill.getDate("bizdate")));
                    info.setPrinciple(repayBill.getBigDecimal("loans.e_repayamount"));
                    info.setPayInt(repayBill.getBoolean("loans.e_ispayinst"));
                    repayBills.add(info);
                }
                repayBills.sort(Comparator.comparing(PlanCallResult::getBizDate));
            }
            repayListMap.put(loanBillId, repayBills);
        }
        return repayListMap;
    }

    public static List<PlanCallResult> getAllRepayPlanList(DynamicObject loanBill) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(10);
        repayPlanList.addAll(LoanBillRepaymentPlanHelper.getRepayPlanList(loanBill));
        return repayPlanList;
    }

    public static List<PlanCallResult> getRepayPlanList(DynamicObject loanBill) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(10);
        DynamicObjectCollection colls = loanBill.getDynamicObjectCollection("repayplan_entry");
        for (DynamicObject repayPlan : colls) {
            PlanCallResult info = LoanBillRepaymentPlanHelper.buildPlanCallResult(DateUtils.truncateDate((Date)repayPlan.getDate("exrepaymentdate")), repayPlan.getBigDecimal("exdrawamount"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private static PlanCallResult buildPlanCallResult(Date bizDate, BigDecimal principle) {
        PlanCallResult plan = new PlanCallResult();
        plan.setBizDate(bizDate);
        plan.setPrinciple(principle);
        return plan;
    }
}

