/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.LoanBillIntBillInfo;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.PreInterestBillRepository;
import kd.tmc.cfm.common.repository.bean.LoanBillPreIntEndDate;
import kd.tmc.cfm.common.service.writeback.ILoanBillWriteService;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractLoanBillWriteService
implements ILoanBillWriteService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String PRE_INTEREST_BILL_SELECT_PROPS = "prestenddate,prestartdate,instenddate";

    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        for (DynamicObject loanBill : loanBills) {
            this.doWrite(loanBill, param);
        }
    }

    protected DynamicObject getContractBill(DynamicObject loanBill) {
        return loanBill.getDynamicObject("loancontractbill");
    }

    protected boolean isFreeRate(DynamicObject loanBill) {
        BigDecimal startLoanRate = loanBill.getBigDecimal("startloanrate");
        BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
        String interestType = loanBill.getString("interesttype");
        return BigDecimal.ZERO.compareTo(startLoanRate) == 0 && EmptyUtil.isEmpty((BigDecimal)loanRate) && EmptyUtil.isNoEmpty((String)interestType) && !InterestTypeEnum.isFloat((String)interestType);
    }

    protected Long getLoanMainOrgId(DynamicObject loanBill) {
        DynamicObject orgInfo;
        String mainOrgField = "org";
        if (DataSourceEnum.INVEST.getValue().equals(loanBill.getString("datasource"))) {
            mainOrgField = "creditorg";
        }
        return EmptyUtil.isNoEmpty((DynamicObject)(orgInfo = loanBill.getDynamicObject(mainOrgField))) ? orgInfo.getLong("id") : 0L;
    }

    protected Map<Long, LoanBillPreIntEndDate> getLoanBillLastPreInstEndDate(List<DynamicObject> loanBills) {
        HashMap<Long, LoanBillPreIntEndDate> map = new HashMap<Long, LoanBillPreIntEndDate>(loanBills.size());
        HashMap<Long, List> mainOrgMap = new HashMap<Long, List>(loanBills.size());
        for (DynamicObject loanBill : loanBills) {
            Long orgId = this.getLoanMainOrgId(loanBill);
            long l = loanBill.getLong("id");
            if (EmptyUtil.isNoEmpty((Long)orgId)) {
                List loanBillIdList = mainOrgMap.computeIfAbsent(orgId, o -> new ArrayList(8));
                loanBillIdList.add(l);
            }
            map.put(l, new LoanBillPreIntEndDate());
        }
        ArrayList<Long> notAutoLoanBillIds = new ArrayList<Long>(8);
        ArrayList<Long> redLoanBillIds = new ArrayList<Long>(8);
        for (Map.Entry entry : mainOrgMap.entrySet()) {
            Long l = (Long)entry.getKey();
            List billIds = (List)entry.getValue();
            redLoanBillIds.addAll(billIds);
            if (IntBillWriteOffHelper.isRedWriteOffParam(l)) {
                billIds.forEach(b -> ((LoanBillPreIntEndDate)map.get(b)).setRedWriteOffParam(true));
            }
            if (IntBillWriteOffHelper.isAutoRedWriteOffParam(l)) {
                billIds.forEach(b -> ((LoanBillPreIntEndDate)map.get(b)).setAutoRedWriteOffParam(true));
                continue;
            }
            notAutoLoanBillIds.addAll(billIds);
        }
        if (EmptyUtil.isNoEmpty(notAutoLoanBillIds)) {
            Map<Long, Date> preInstEndDateMap = PreInterestBillRepository.getPreInstEndDate(notAutoLoanBillIds);
            for (Map.Entry<Long, Date> entry : preInstEndDateMap.entrySet()) {
                ((LoanBillPreIntEndDate)map.get(entry.getKey())).setPreInstEndDate(entry.getValue());
            }
        }
        if (EmptyUtil.isNoEmpty(redLoanBillIds)) {
            Map<Long, LoanBillIntBillInfo> loanBillIntBillInfoMap = InterestBillRepository.getLoanBillIntBillInfo(redLoanBillIds);
            for (Map.Entry<Long, LoanBillIntBillInfo> entry : loanBillIntBillInfoMap.entrySet()) {
                ((LoanBillPreIntEndDate)map.get(entry.getKey())).setIntBillInfo(entry.getValue());
            }
        }
        return map;
    }

    protected void setEndPreInstDate(DynamicObject loanBill, Date preInstEndDate, Date instEndDate) {
        Date initEndPreInstDate = loanBill.getDate("initendpreinstdate");
        if (preInstEndDate == null && instEndDate == null) {
            loanBill.set("endpreinstdate", (Object)initEndPreInstDate);
        } else if (preInstEndDate == null) {
            loanBill.set("endpreinstdate", (Object)instEndDate);
        } else if (instEndDate == null) {
            loanBill.set("endpreinstdate", (Object)preInstEndDate);
        } else {
            loanBill.set("endpreinstdate", (Object)(preInstEndDate.compareTo(instEndDate) > 0 ? preInstEndDate : instEndDate));
        }
    }

    protected Date getPreInstEndDate(DynamicObject loanBill) {
        QFilter writeOffStatusFilter = new QFilter("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()).and("sourcebillid", "=", loanBill.getPkValue());
        Object[] preInterests = TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)PRE_INTEREST_BILL_SELECT_PROPS, (QFilter[])writeOffStatusFilter.toArray(), (String)"prestenddate  desc");
        Date preInstEndDate = null;
        if (EmptyUtil.isNoEmpty((Object[])preInterests)) {
            preInstEndDate = preInterests[0].getDynamicObjectCollection("entrys").stream().map(v -> v.getDate("instenddate")).max(Comparator.naturalOrder()).orElse(null);
        }
        return preInstEndDate;
    }

    protected List<Long> getBillIds(List<DynamicObject> bills) {
        return this.getBillIds(bills, "id");
    }

    protected List<Long> getBillIds(List<DynamicObject> bills, String propName) {
        return bills.stream().map(l -> l.getLong(propName)).collect(Collectors.toList());
    }
}

