/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanBillIntBillInfo;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.bean.BillAmountDTO;
import kd.tmc.cfm.common.repository.bean.LoanBillPreIntEndDate;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;

public class LoanBillIntBillWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.logger.info("\u4ed8\u606f\u5355\u786e\u8ba4\u3001\u53d6\u6d88\u786e\u8ba4, param:{}", (Object)param);
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        Map<Long, LoanBillPreIntEndDate> loanBillPreInstEndDateMap = this.getLoanBillLastPreInstEndDate(loanBills);
        Map<Long, BillAmountDTO> payedIntAmtMap = this.getContactPayedIntAmtMap(loanBills);
        for (DynamicObject loanBill : loanBills) {
            this.interestBillDo(loanBill, loanBillPreInstEndDateMap.get(loanBill.getLong("id")));
            DynamicObject contractBill = this.getContractBill(loanBill);
            BillAmountDTO payedIntAmt = payedIntAmtMap.get(contractBill.getLong("id"));
            contractBill.set("payinterestamount", (Object)(payedIntAmt != null ? payedIntAmt.getConvertAmount() : BigDecimal.ZERO));
        }
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        return param.isReSaveLoan() || LoanWBTypeEnum.isWriteIntAmt(param.getLoanWBType());
    }

    private Map<Long, BillAmountDTO> getContactPayedIntAmtMap(List<DynamicObject> loanBills) {
        List<Long> contractIds = this.getBillIds(loanBills, "loancontractbill.id");
        return InterestBillRepository.getInterestAmountByContractIds(contractIds);
    }

    private void interestBillDo(DynamicObject loanBill, LoanBillPreIntEndDate preIntEndDate) {
        LoanBillIntBillInfo intBillInfo = preIntEndDate.getIntBillInfo();
        Date endIntDate = null;
        if (intBillInfo != null) {
            loanBill.set("payinterestamount", (Object)intBillInfo.getPayedIntAmount());
            endIntDate = intBillInfo.getEndIntDate();
            loanBill.set("endinstdate", (Object)endIntDate);
            loanBill.set("lastpayinstdate", (Object)intBillInfo.getLastPayIntDate());
        }
        if (preIntEndDate.isRedWriteOffParam()) {
            this.setEndPreInstDate(loanBill, preIntEndDate.getPreInstEndDate(), endIntDate);
        }
    }
}

