/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RepayStateEnum;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillNoFixedTermWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        List<Long> loanBillIds = this.getBillIds(loanBills);
        Map<Long, Date> lastPayinstDateMap = InterestBillRepository.queryLastPayinstDate(loanBillIds);
        Map<Long, Date> lastRepayDateMap = RepaymentBillRepository.queryLastRepayDate(loanBillIds);
        for (DynamicObject loanBill : loanBills) {
            long loanBillId = loanBill.getLong("id");
            Date compareStartIntDate = loanBill.getDate("startintdate");
            compareStartIntDate = this.getMaxDate(compareStartIntDate, lastRepayDateMap.get(loanBillId));
            compareStartIntDate = this.getMaxDate(compareStartIntDate, lastPayinstDateMap.get(loanBillId));
            Date newEndDate = DateUtils.getNextYear((Date)compareStartIntDate, (int)1);
            String termYmd = TermHelper.getTerm_ymd((Date)loanBill.getDate("startintdate"), (Date)newEndDate);
            loanBill.set("expiredate", (Object)newEndDate);
            loanBill.set("term", (Object)termYmd);
            String repaymentWay = loanBill.getString("repaymentway");
            DynamicObjectCollection repayPlanEntryDC = loanBill.getDynamicObjectCollection("repayplan_entry");
            List repayPlans = repayPlanEntryDC.stream().filter(d -> RepayStateEnum.isUnpay(d.getString("repaystate"))).collect(Collectors.toList());
            if (!EmptyUtil.isNoEmpty(repayPlans) || repayPlans.size() != 1 && !RepaymentWayEnum.isBqhbdqhx((String)repaymentWay) && !RepaymentWayEnum.isBqhblsbq((String)repaymentWay)) continue;
            Date repayPlanLastDate = loanBill.getDate("expiredate");
            ((DynamicObject)repayPlans.get(repayPlans.size() - 1)).set("exrepaymentdate", (Object)repayPlanLastDate);
        }
    }

    private Date getMaxDate(Date bizDate, Date lastDate) {
        return null != lastDate && lastDate.after(bizDate) ? lastDate : bizDate;
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        if (param.isReSaveLoan()) {
            return true;
        }
        return LoanWBTypeEnum.isWriteRepayAndIntAmt(param.getLoanWBType()) && loanBill.getBoolean("isnofixedterm");
    }
}

