/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;

public class LoanBillRepayPlanWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        List<Long> loanBillIds = this.getBillIds(loanBills);
        Map<Long, List<DynamicObject>> repaymentMap = RepaymentBillRepository.queryRepaymentByLoanBillIds(loanBillIds);
        for (DynamicObject loanBill : loanBills) {
            List<DynamicObject> repaymentBills = repaymentMap.get(loanBill.getLong("id"));
            LoanBillRepayPlanHelper.updateLoanBillRepayPlanList(loanBill, repaymentBills);
        }
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.logger.info("\u8fd8\u6b3e\u8ba1\u5212\u4fdd\u5b58\u53cd\u5199, param:{}", (Object)param);
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        return param.isReSaveLoan() || LoanWBTypeEnum.isWriteRepayPlan(param.getLoanWBType());
    }
}

