/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillStatusWriteService
extends AbstractLoanBillWriteService {
    @Override
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        List<Long> contractIds = this.getBillIds(loanBills, "sourcebillid");
        Map<Long, Set<Long>> contractMap = LoanBillRepository.queryNotCloseLoanBillIds(new HashSet<Long>(contractIds));
        for (DynamicObject loanBill : loanBills) {
            this.updateContract(loanBill, contractMap);
        }
    }

    @Override
    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    private void updateContract(DynamicObject loanBill, Map<Long, Set<Long>> contractMap) {
        boolean isAllCloseLoanBill;
        DynamicObject contractBill = this.getContractBill(loanBill);
        BigDecimal repayAmount = loanBill.getBigDecimal("repayamount");
        BigDecimal notRepayAmount = loanBill.getBigDecimal("notrepayamount");
        DrawTypeEnum drawType = DrawTypeEnum.PARTPAYMENT;
        if (this.isFreeRate(loanBill) && notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
            drawType = DrawTypeEnum.CLOSEOUT;
            loanBill.set("closeoffdate", (Object)DateUtils.getCurrentDate());
        } else {
            Date lastRepayDate = loanBill.getDate("lastrepaydate");
            Date lastPayInstDate = loanBill.getDate("lastpayinstdate");
            boolean isPayLastInst = false;
            Date endInstDate = loanBill.getDate("endinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastRepayDate) && EmptyUtil.isNoEmpty((Object)endInstDate) && DateUtils.getNextDay((Date)endInstDate, (int)1).compareTo(lastRepayDate) >= 0) {
                isPayLastInst = true;
            }
            loanBill.set("closeoffdate", null);
            if (repayAmount.compareTo(BigDecimal.ZERO) == 0) {
                drawType = DrawTypeEnum.DRAWED;
            } else if (!isPayLastInst && notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
                drawType = DrawTypeEnum.ALLPAYMENT;
            } else if (isPayLastInst && notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
                drawType = DrawTypeEnum.CLOSEOUT;
                loanBill.set("closeoffdate", (Object)lastPayInstDate);
                this.updateIntPlans(loanBill);
            }
        }
        this.logger.info("loanBillId: {}, drawType: {}", loanBill.getPkValue(), (Object)drawType.getValue());
        loanBill.set("drawtype", (Object)drawType.getValue());
        BigDecimal contractRepayAmount = contractBill.getBigDecimal("repayamount");
        BigDecimal contractLoanAmt = contractBill.getBigDecimal("amount");
        Set<Long> loanBillIds = contractMap.get(contractBill.getLong("id"));
        boolean bl = isAllCloseLoanBill = EmptyUtil.isEmpty(loanBillIds) || loanBillIds.stream().allMatch(l -> l.equals(loanBill.getLong("id")));
        if (isAllCloseLoanBill && contractRepayAmount.compareTo(contractLoanAmt) == 0 && DrawTypeEnum.CLOSEOUT.getValue().equals(drawType.getValue()) && !contractBill.getBoolean("iscycleloan")) {
            contractBill.set("contractstatus", (Object)LoanContractStatusEnum.CLOSED.getValue());
            contractBill.set("closeoffdate", loanBill.get("closeoffdate"));
        } else if (LoanContractStatusEnum.CLOSED.getValue().equals(contractBill.getString("contractstatus"))) {
            contractBill.set("contractstatus", (Object)LoanContractStatusEnum.EXECUTING.getValue());
            contractBill.set("closeoffdate", null);
        }
    }

    private void updateIntPlans(DynamicObject loanBill) {
        DynamicObjectCollection intPlans = loanBill.getDynamicObjectCollection("interest_entry");
        for (int i = intPlans.size() - 1; i >= 0; --i) {
            DynamicObject intPlan = (DynamicObject)intPlans.get(i);
            if (intPlan.getInt("intstate") != 0) continue;
            intPlans.remove(i);
        }
    }

    @Override
    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        return param.isReSaveLoan() || LoanWBTypeEnum.isWriteRepayAndIntAmt(param.getLoanWBType());
    }
}

