/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.service.writeback.ILoanBillWriteService;

public class LoanBillWriteServiceChain {
    private final List<ILoanBillWriteService> handlers = new ArrayList<ILoanBillWriteService>(8);

    public LoanBillWriteServiceChain addHandler(ILoanBillWriteService ... handlerList) {
        this.handlers.addAll(Arrays.asList(handlerList));
        return this;
    }

    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.handlers.stream().filter(h -> h.doFiter(loanBill, param)).forEach(h -> h.doWrite(loanBill, param));
    }

    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        for (ILoanBillWriteService handler : this.handlers) {
            List<DynamicObject> loanBillLis = loanBills.stream().filter(l -> handler.doFiter((DynamicObject)l, param)).collect(Collectors.toList());
            if (loanBillLis.isEmpty()) continue;
            handler.doWrite(loanBillLis, param);
        }
    }
}

