/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.CostCalRequest;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.QueryTypeEnum;
import kd.tmc.cfm.common.helper.FinCostCalCommonHelper;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class AvgInterestRateDataRptPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(AvgInterestRateDataRptPlugin.class);
    private Date startDate = null;
    private Date endDate = null;
    private Map<String, Object> paramMaps = null;
    private String statDim;
    private Long statCurrencyId;
    private Long orgViewDOId;
    private Boolean splitBankCate = Boolean.FALSE;
    private Boolean splitBondCate = Boolean.FALSE;
    private boolean isSummary;
    private String bankLevel = "1";
    private static final List<String> UNIT_AMT = Arrays.asList("balance", "converamt", "avgamt", "estimatedinterest");
    private static final Map<String, String> ALL_TERMS = new HashMap<String, String>(16){
        {
            this.put("1", ResManager.loadKDString((String)"1\u5e74\u5185", (String)"AvgInterestRateDataRptPlugin_01", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("2", ResManager.loadKDString((String)"1-3\u5e74", (String)"AvgInterestRateDataRptPlugin_02", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"3-5\u5e74", (String)"AvgInterestRateDataRptPlugin_03", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("4", ResManager.loadKDString((String)"5-10\u5e74", (String)"AvgInterestRateDataRptPlugin_04", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("5", ResManager.loadKDString((String)"10\u5e74\u4ee5\u4e0a", (String)"AvgInterestRateDataRptPlugin_05", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("n", ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650", (String)"AvgInterestRateDataRptPlugin_00", (String)"tmc-cfm-report", (Object[])new Object[0]));
        }
    };
    private static final Map<String, String> REMAINING_TERMS = new HashMap<String, String>(16){
        {
            this.put("1", ResManager.loadKDString((String)"\u5df2\u7ed3\u6e05", (String)"AvgInterestRateDataRptPlugin_06", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("2", ResManager.loadKDString((String)"\u5df2\u903e\u671f", (String)"AvgInterestRateDataRptPlugin_07", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"1\u5e74\u5185", (String)"AvgInterestRateDataRptPlugin_08", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("4", ResManager.loadKDString((String)"1-3\u5e74", (String)"AvgInterestRateDataRptPlugin_09", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("5", ResManager.loadKDString((String)"3-5\u5e74", (String)"AvgInterestRateDataRptPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("6", ResManager.loadKDString((String)"5-10\u5e74", (String)"AvgInterestRateDataRptPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("7", ResManager.loadKDString((String)"10\u5e74\u4ee5\u4e0a", (String)"AvgInterestRateDataRptPlugin_12", (String)"tmc-cfm-report", (Object[])new Object[0]));
            this.put("n", ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650", (String)"AvgInterestRateDataRptPlugin_00", (String)"tmc-cfm-report", (Object[])new Object[0]));
        }
    };
    private static final List<Triple<String, String, String>> detailColumnsList = new ArrayList<Triple<String, String, String>>(){
        {
            this.add(Triple.of((Object)"orgname", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"AvgInterestRateDataRptPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"finproduct", (Object)ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"AvgInterestRateDataRptPlugin_14", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"contractbillno", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u7f16\u53f7", (String)"AvgInterestRateDataRptPlugin_15", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"billno", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u5355\u53f7", (String)"AvgInterestRateDataRptPlugin_16", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"textcreditor", (Object)ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"AvgInterestRateDataRptPlugin_17", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"loantype", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u7c7b\u578b", (String)"AvgInterestRateDataRptPlugin_18", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"type", (Object)ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b", (String)"AvgInterestRateDataRptPlugin_19", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"text"));
            this.add(Triple.of((Object)"allterm", (Object)ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650", (String)"AvgInterestRateDataRptPlugin_20", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"combofield"));
            this.add(Triple.of((Object)"remainingterm", (Object)ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"AvgInterestRateDataRptPlugin_21", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"combofield"));
            this.add(Triple.of((Object)"currency", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u5e01\u79cd", (String)"AvgInterestRateDataRptPlugin_22", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"currency"));
            this.add(Triple.of((Object)"tarcurrency", (Object)ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"AvgInterestRateDataRptPlugin_23", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"currency"));
            this.add(Triple.of((Object)"yearrate", (Object)ResManager.loadKDString((String)"\u5e74\u5229\u7387(%)", (String)"AvgInterestRateDataRptPlugin_24", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"decimal"));
            this.add(Triple.of((Object)"balance", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u4f59\u989d\u539f\u5e01", (String)"AvgInterestRateDataRptPlugin_25", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"amount"));
            this.add(Triple.of((Object)"exchangerate", (Object)ResManager.loadKDString((String)"\u6c47\u7387", (String)"AvgInterestRateDataRptPlugin_26", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"decimal"));
            this.add(Triple.of((Object)"converamt", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u4f59\u989d\u6298\u7b97\u5e01", (String)"AvgInterestRateDataRptPlugin_27", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"amount"));
            this.add(Triple.of((Object)"startdate", (Object)ResManager.loadKDString((String)"\u5f00\u59cb\u65e5", (String)"AvgInterestRateDataRptPlugin_28", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"date"));
            this.add(Triple.of((Object)"enddate", (Object)ResManager.loadKDString((String)"\u7ed3\u675f\u65e5", (String)"AvgInterestRateDataRptPlugin_29", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"date"));
            this.add(Triple.of((Object)"day", (Object)ResManager.loadKDString((String)"\u5929\u6570", (String)"AvgInterestRateDataRptPlugin_30", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"integer"));
            this.add(Triple.of((Object)"dayweight", (Object)ResManager.loadKDString((String)"\u5929\u6570\u6743\u91cd", (String)"AvgInterestRateDataRptPlugin_31", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"decimal"));
            this.add(Triple.of((Object)"avgamt", (Object)ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d\u6298\u7b97\u5e01", (String)"AvgInterestRateDataRptPlugin_32", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"amount"));
            this.add(Triple.of((Object)"estimatedinterest", (Object)ResManager.loadKDString((String)"\u9884\u8ba1\u5e74\u5229\u606f\u6298\u7b97\u5e01", (String)"AvgInterestRateDataRptPlugin_33", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"amount"));
            this.add(Triple.of((Object)"avginterestrate", (Object)ResManager.loadKDString((String)"\u5e73\u5747\u5229\u7387(%)", (String)"AvgInterestRateDataRptPlugin_34", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"decimal"));
            this.add(Triple.of((Object)"sumlevel", (Object)ResManager.loadKDString((String)"\u6392\u5e8f", (String)"AvgInterestRateDataRptPlugin_35", (String)"tmc-cfm-report", (Object[])new Object[0]), (Object)"decimal"));
        }
    };
    private static final List<String> orgDim = Arrays.asList("textcreditor", "finproduct", "type", "allterm", "remainingterm", "currencyname");
    private static final List<String> creditorDim = Arrays.asList("orgname", "finproduct", "type", "allterm", "remainingterm", "currencyname");
    private static final List<String> finproductDim = Arrays.asList("orgname", "textcreditor", "type", "allterm", "remainingterm", "currencyname");
    private static final List<String> typeDim = Arrays.asList("orgname", "textcreditor", "finproduct", "allterm", "remainingterm", "currencyname");
    private static final List<String> alltermDim = Arrays.asList("orgname", "textcreditor", "finproduct", "type", "remainingterm", "currencyname");
    private static final List<String> remainingtermDim = Arrays.asList("orgname", "textcreditor", "finproduct", "type", "allterm", "currencyname");
    private static final List<String> currencyDim = Arrays.asList("orgname", "textcreditor", "finproduct", "type", "allterm", "remainingterm");
    private static final String SL_FIELDS = "id,drawamount,banksyndicate_entry.e_bank.id as entryid, banksyndicate_entry.e_bank.id as ecreditor,banksyndicate_entry.e_bank.name as etextcreditor,banksyndicate_entry.e_shareamount as edrawamount,creditortype as ecreditortype";
    private static final String BOND_FIELDS = "id,drawamount,investor_entry.id as entryid, investor_entry.e_investorid as ecreditor, investor_entry.e_investorname as etextcreditor,investor_entry.e_investamount as edrawamount,investor_entry.e_investortype as ecreditortype";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        paramMap.putAll(queryParam.getCustomParam());
        this.initParams(paramMap);
        List orgIds = this.getQueryOrgIds(queryParam);
        DataSet resultDS = this.doQueryDataSet(paramMap, orgIds);
        if (this.isSummary) {
            List<String> statDims = Arrays.asList("org", "creditor", "finproduct", "allterm", "remainingterm", "currency");
            if (!statDims.contains(this.statDim)) {
                return ReportCommonHelper.createEmptyDataSet();
            }
            if ("creditor".equals(this.statDim) && "1".equals(this.bankLevel)) {
                resultDS = this.dealDataSetByBankLevel(resultDS);
            }
            resultDS = this.querySumDataSet(resultDS).addField("shortavg+longavg", "occupancysum").addField("shortinterestsum+longinterestsum", "calculatedinterestsum").addField("calculatedinterestsum/occupancysum*100", "totalavgrate").addField(String.valueOf(this.statCurrencyId), "tarcurrency");
        } else {
            resultDS = resultDS.addField("orgname", "neworgname");
        }
        return resultDS;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        if (this.isNeedOrgTree()) {
            return dataSet.addField(String.valueOf(this.statCurrencyId), "tarcurrency");
        }
        return dataSet.updateField("tarcurrency", String.valueOf(this.statCurrencyId));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        boolean isSummary = (Boolean)this.paramMaps.get("filter_summary");
        if (isSummary) {
            for (AbstractReportColumn column : columns) {
                switch (this.statDim) {
                    case "org": {
                        if (!(column instanceof ReportColumn) || !orgDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "creditor": {
                        if (!(column instanceof ReportColumn) || !creditorDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "finproduct": {
                        if (!(column instanceof ReportColumn) || !finproductDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "type": {
                        if (!(column instanceof ReportColumn) || !typeDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "allterm": {
                        if (!(column instanceof ReportColumn) || !alltermDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "remainingterm": {
                        if (!(column instanceof ReportColumn) || !remainingtermDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                        break;
                    }
                    case "currency": {
                        if (!(column instanceof ReportColumn) || !currencyDim.contains(((ReportColumn)column).getFieldKey())) break;
                        ((ReportColumn)column).setHide(true);
                    }
                }
            }
        } else {
            columns.clear();
            for (Triple<String, String, String> col : detailColumnsList) {
                columns.add((AbstractReportColumn)this.createColumn((String)col.getLeft(), (String)col.getMiddle(), (String)col.getRight()));
            }
            this.dealExtDetailCol(columns);
        }
        return columns;
    }

    protected boolean isNeedOrgTree() {
        return this.statDim.equals("org");
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return this.statDim.equals("org") ? Pair.of((Object)"orgid", (Object)"orgname") : Pair.of((Object)"org", (Object)"orgtext");
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        if (this.isSummary) {
            return bizDs;
        }
        DataSet ds = super.addSubRowDataSet(bizDs, paramMap);
        switch (this.statDim) {
            case "org": {
                ds = ds.updateField("orgname", "case when sumlevel = 1 then neworgname + '" + this.subDisplayName() + "' else orgname end");
                break;
            }
            case "creditor": {
                ds = ds.updateField("orgname", "case when sumlevel = 1 then textcreditor + orgname else orgname end");
                break;
            }
            case "finproduct": {
                ds = ds.updateField("orgname", "case when sumlevel = 1 then finproduct + orgname else orgname end");
                break;
            }
            case "type": {
                ds = ds.updateField("orgname", "case when sumlevel = 1 then type + orgname else orgname end");
                break;
            }
            case "org_currency": {
                ds = ds.updateField("orgname", "case when sumlevel = 1 then neworgname else orgname end");
                break;
            }
        }
        return ds.updateField("avginterestrate", "estimatedinterest/avgamt*100");
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        DataSet ds = super.addSumRowDataSet(bizDs, paramMap);
        if (this.isSummary) {
            ds = ds.updateFields(new String[]{"shortavgrate", "longavgrate", "totalavgrate", "weightterm"}, new String[]{"shortinterestsum/shortavg*100", "longinterestsum/longavg*100", "calculatedinterestsum/occupancysum*100", "case when weightamt=0 then 0 else weightperamt/weightamt end"});
            return ds;
        }
        return ds.updateField("avginterestrate", "estimatedinterest/avgamt*100");
    }

    public String sumNameField() {
        if (this.isSummary) {
            String sumFieldName = "";
            switch (this.statDim) {
                case "org": {
                    sumFieldName = "orgname";
                    break;
                }
                case "creditor": {
                    sumFieldName = "textcreditor";
                    break;
                }
                case "finproduct": {
                    sumFieldName = "finproduct";
                    break;
                }
                case "allterm": {
                    sumFieldName = "allterm";
                    break;
                }
                case "remainingterm": {
                    sumFieldName = "remainingterm";
                    break;
                }
                case "currency": {
                    sumFieldName = "currencyname";
                    break;
                }
            }
            return sumFieldName;
        }
        return "orgname";
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>(10);
        groupFields.add("tarcurrency");
        if (this.isSummary) {
            groupFields.add("sumlevel");
            return groupFields;
        }
        switch (this.statDim) {
            case "org": {
                groupFields.add("orgid");
                groupFields.add("orgname");
                groupFields.add("neworgname");
                break;
            }
            case "creditor": {
                groupFields.add("creditor");
                groupFields.add("textcreditor");
                break;
            }
            case "finproduct": {
                groupFields.add("finproduct");
                break;
            }
            case "type": {
                groupFields.add("type");
                break;
            }
            case "allterm": {
                groupFields.add("allterm");
                break;
            }
            case "remainingterm": {
                groupFields.add("remainingterm");
                break;
            }
            case "currency": {
                groupFields.add("currency");
                break;
            }
            case "org_currency": {
                groupFields.add("orgid");
                groupFields.add("orgname");
                groupFields.add("currency");
                groupFields.add("neworgname");
                break;
            }
            case "type_contractbillno": {
                groupFields.add("type");
                groupFields.add("contractbillno");
                break;
            }
        }
        return groupFields;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(10);
        if (this.isSummary) {
            sumFields.add("shortavg");
            sumFields.add("shortinterestsum");
            sumFields.add("longavg");
            sumFields.add("longinterestsum");
            sumFields.add("occupancysum");
            sumFields.add("calculatedinterestsum");
            sumFields.add("weightperamt");
            sumFields.add("weightamt");
        } else {
            sumFields.add("converamt");
            sumFields.add("avgamt");
            sumFields.add("estimatedinterest");
        }
        return sumFields;
    }

    public List<String> orderByFields() {
        ArrayList<String> orderByField = new ArrayList<String>(10);
        switch (this.statDim) {
            case "org": {
                orderByField.add("orgname");
                break;
            }
            case "creditor": {
                orderByField.add("textcreditor");
                break;
            }
            case "finproduct": {
                orderByField.add("finproduct");
                break;
            }
            case "type": {
                orderByField.add("type");
                break;
            }
            case "allterm": {
                orderByField.add("allterm");
                break;
            }
            case "remainingterm": {
                orderByField.add("remainingterm");
                break;
            }
            case "currency": {
                orderByField.add("currency");
                break;
            }
            case "org_currency": {
                orderByField.add("orgid");
                orderByField.add("currency");
                break;
            }
            case "type_contractbillno": {
                orderByField.add("type");
                orderByField.add("contractbillno");
                break;
            }
        }
        return orderByField;
    }

    protected List<String> orinalAmountField() {
        if (this.isSummary) {
            return new ArrayList<String>();
        }
        return UNIT_AMT;
    }

    private void initParams(Map<String, Object> paramMap) {
        this.paramMaps = paramMap;
        this.startDate = (Date)paramMap.get("filter_dateranges_startdate");
        this.endDate = (Date)paramMap.get("filter_dateranges_enddate");
        this.statDim = (String)paramMap.get("filter_statdim");
        String queryType = (String)paramMap.get("filter_queryway");
        DynamicObject orgViewDO = (DynamicObject)paramMap.get("filter_orgview");
        this.orgViewDOId = EmptyUtil.isNoEmpty((DynamicObject)orgViewDO) && QueryTypeEnum.isCompview((String)queryType) ? orgViewDO.getLong("id") : 0L;
        DynamicObject statCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        this.statCurrencyId = statCurrency.getLong("id");
        this.isSummary = (Boolean)paramMap.get("filter_summary");
        this.bankLevel = (String)paramMap.get("filter_banklevel");
    }

    private void dealExtDetailCol(List<AbstractReportColumn> columns) {
        ArrayList<Triple<String, String, String>> extDetailColumnsList = new ArrayList<Triple<String, String, String>>();
        this.addExtDetailColumList(extDetailColumnsList);
        for (Triple triple : extDetailColumnsList) {
            columns.add((AbstractReportColumn)this.createColumn((String)triple.getLeft(), (String)triple.getMiddle(), (String)triple.getRight()));
        }
    }

    private QFilter filterItemInfoToQFilter(String property, FilterItemInfo filterItemInfo) {
        String cp = filterItemInfo.getCompareType();
        QFilter qFilter = null;
        switch (cp) {
            case "LIKE": {
                qFilter = new QFilter(property, "like", (Object)("%" + filterItemInfo.getValue() + "%"));
                break;
            }
            case "NOT LIKE": {
                qFilter = new QFilter(property, "not like", (Object)("%" + filterItemInfo.getValue() + "%"));
                break;
            }
            case "=": {
                qFilter = new QFilter(property, "=", filterItemInfo.getValue());
                break;
            }
            case "<>": {
                qFilter = new QFilter(property, "!=", filterItemInfo.getValue());
                break;
            }
            case "lIKE": {
                qFilter = new QFilter(property, "like", (Object)(filterItemInfo.getValue() + "%"));
                break;
            }
            case "like": {
                qFilter = new QFilter(property, "like", (Object)("%" + filterItemInfo.getValue()));
                break;
            }
            case "ISNULL": {
                qFilter = new QFilter(property, "is null", null);
                break;
            }
            case "NOTISNULL": {
                qFilter = new QFilter(property, "is not null", null);
                break;
            }
        }
        return qFilter;
    }

    public QFilter buildFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        String loantype;
        String region;
        DynamicObjectCollection currency;
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("notrepayamount", ">=", (Object)0);
        qFilter.and(new QFilter("org.id", "in", orgIds));
        DynamicObjectCollection finproducts = (DynamicObjectCollection)paramMap.get("filter_finproduct");
        if (!CollectionUtils.isEmpty((Collection)finproducts)) {
            qFilter.and(new QFilter("finproduct.id", "in", (Object)finproducts.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (!CollectionUtils.isEmpty((Collection)(currency = (DynamicObjectCollection)paramMap.get("filter_currency")))) {
            qFilter.and(new QFilter("currency.id", "in", (Object)currency.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if ((region = (String)paramMap.get("filter_region")) != null) {
            String[] regions = region.substring(1, region.length() - 1).split(",");
            qFilter.and(new QFilter("region", "in", (Object)regions));
        }
        if ((loantype = (String)paramMap.get("filter_loantype")) != null) {
            ArrayList<String> loantypeList = new ArrayList<String>(Arrays.asList(loantype.split(",")));
            loantypeList.removeIf(String::isEmpty);
            if (EmptyUtil.isNoEmpty(loantypeList)) {
                if (loantypeList.contains("sl")) {
                    this.splitBankCate = true;
                }
                if (loantypeList.contains("bond")) {
                    this.splitBondCate = true;
                }
                qFilter.and(new QFilter("loantype", "in", loantypeList));
            }
        } else {
            this.splitBankCate = true;
            this.splitBondCate = true;
        }
        String orgType = (String)paramMap.get("filter_orgtype");
        if (orgType != null) {
            String[] orgTypes = orgType.substring(1, orgType.length() - 1).split(",");
            qFilter.and(new QFilter("lendernature", "in", (Object)orgTypes));
        }
        qFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, qFilter);
        ReportQueryParam queryParam = this.getQueryParam();
        if (EmptyUtil.isNoEmpty((Object)queryParam)) {
            List tableHeadFilters = queryParam.getFilter().getTableHeadFilterItems();
            for (FilterItemInfo filterItemInfo : tableHeadFilters) {
                if ("contractbillno".equals(filterItemInfo.getPropName())) {
                    qFilter.and(this.filterItemInfoToQFilter("loancontractbill.number", filterItemInfo));
                }
                if ("billno".equals(filterItemInfo.getPropName())) {
                    qFilter.and(this.filterItemInfoToQFilter("billno", filterItemInfo));
                }
                if ("orgname".equals(filterItemInfo.getPropName())) {
                    qFilter.and(this.filterItemInfoToQFilter("org.name", filterItemInfo));
                }
                if ("textcreditor".equals(filterItemInfo.getPropName())) {
                    qFilter.and(this.filterItemInfoToQFilter("textcreditor", filterItemInfo));
                }
                if (!"finproduct".equals(filterItemInfo.getPropName())) continue;
                qFilter.and(this.filterItemInfoToQFilter("finproduct.name", filterItemInfo));
            }
        }
        qFilter.and(this.initBizdateFitler(paramMap));
        logger.info("select all qFilter:{}", (Object)qFilter);
        return qFilter;
    }

    public QFilter initBizdateFitler(Map<String, Object> paramMap) {
        QFilter filter = new QFilter("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)this.endDate, (boolean)false));
        filter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)this.startDate, (boolean)true)).or(new QFilter("cleardate", "is null", null)));
        String bizDate = (String)paramMap.get("bizdateranges");
        Date currentDate = DateUtils.getCurrentDate();
        if (!EmptyUtil.isEmpty((String)bizDate)) {
            switch (bizDate) {
                case "thisyear": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstYearDate((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getLastDayOfCurYear())));
                    break;
                }
                case "thismonth": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfMonth((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getFirstDateOfNextMonth((Date)currentDate))));
                    break;
                }
                case "thisweek": {
                    filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getFirstDayOfWeek((Date)currentDate)).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextWeekMonday((Date)currentDate))));
                    break;
                }
                case "thisday": {
                    filter.and(new QFilter("bizdate", ">=", (Object)currentDate).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)currentDate, (int)1))));
                    break;
                }
            }
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(bizDate)) {
            Date bizDateStartDate = (Date)paramMap.get("bizdateranges_startdate");
            Date bizDateEndDate = (Date)paramMap.get("bizdateranges_enddate");
            if (!EmptyUtil.isEmpty((Object)bizDateStartDate) && !EmptyUtil.isEmpty((Object)bizDateEndDate)) {
                filter.and(new QFilter("bizdate", ">=", (Object)bizDateStartDate).and(new QFilter("bizdate", "<=", (Object)bizDateEndDate)));
            }
        }
        return filter;
    }

    private ReportColumn createColumn(String fieldKey, String caption, String type) {
        if ("allterm".equals(fieldKey) || "remainingterm".equals(fieldKey)) {
            ComboReportColumn comboReportColumn = new ComboReportColumn();
            comboReportColumn.setFieldKey(fieldKey);
            comboReportColumn.setFieldType(type);
            comboReportColumn.setCaption(new LocaleString(caption));
            ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(10);
            Map<String, String> tempMap = "allterm".equals(fieldKey) ? ALL_TERMS : REMAINING_TERMS;
            for (Map.Entry<String, String> entry : tempMap.entrySet()) {
                ValueMapItem item = new ValueMapItem();
                item.setName(new LocaleString(entry.getValue()));
                item.setValue(entry.getKey());
                comboItems.add(item);
            }
            comboReportColumn.setComboItems(comboItems);
            return comboReportColumn;
        }
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType(type);
        if ("balance".equals(fieldKey)) {
            reportColumn.setCurrencyField("currency");
        }
        if (Arrays.asList("converamt", "avgamt", "estimatedinterest").contains(fieldKey)) {
            reportColumn.setCurrencyField("tarcurrency");
        }
        if (Arrays.asList("loantype", "tarcurrency", "sumlevel").contains(fieldKey)) {
            reportColumn.setHide(true);
        }
        if ("billno".equals(fieldKey)) {
            reportColumn.setHyperlink(true);
        }
        if ("estimatedinterest".equals(fieldKey)) {
            reportColumn.setZeroShow(true);
        }
        reportColumn.setScale(10);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        return reportColumn;
    }

    public DataSet doQueryDataSet(Map<String, Object> paramMap, List<Long> orgIds) {
        DataSet repayResDs;
        long splitBankStartTime;
        DataSet repayDsCopy;
        long startTime = System.currentTimeMillis();
        QFilter qFilters = this.buildFilter(paramMap, orgIds);
        this.buildExtQfilter(paramMap, qFilters);
        logger.info("qFilters: {}", (Object)qFilters.toString());
        CostCalRequest costCalRequest = new CostCalRequest("cfm_loanbill", this.startDate, this.endDate, qFilters, this.statCurrencyId, this.orgViewDOId);
        DataSet allViewData = FinCostCalCommonHelper.getAllViewData((CostCalRequest)costCalRequest, paramMap);
        if (EmptyUtil.isEmpty((Long)this.orgViewDOId)) {
            DataSet exChangeDs = this.getExChangeRateDs(allViewData, paramMap);
            allViewData = allViewData.leftJoin(exChangeDs).on("currency", "tarcurrency").select(allViewData.getRowMeta().getFieldNames(), new String[]{"rate"}).finish();
        }
        allViewData = allViewData.select(new String[]{"id", "loantype", "interesttype", "orgid", "companyname orgname", "finproductid", "finproductname finproduct", "drawamount", "contractbillno", "billno", "creditortype", "creditor", "textcreditor", "currency", "currencyname", "startintdate", "expiredate", "begindate startdate", "(DATEADD('Day', 1, enddate)) as enddate", "intrate as yearrate", "srcprinciple as balance", "rate exchangerate", "srcprinciple*rate converamt", "daynum day", "dayweight", "perpetualbond", "cleardate", "isnofixedterm", "term", "residueterm", "srcprinciple*rate*dayweight  avgamt", "srcprinciple*rate*dayweight*intrate/100 estimatedinterest"});
        DataSet loanBillDs = (allViewData = allViewData.filter("estimatedinterest>0").filter("avgamt>0").groupBy(new String[]{"id", "loantype", "interesttype", "orgid", "orgname", "finproductid", "finproduct", "drawamount", "contractbillno", "billno", "creditortype", "creditor", "textcreditor", "currency", "currencyname", "startintdate", "expiredate", "startdate", "enddate", "yearrate", "exchangerate", "day", "dayweight", "perpetualbond", "isnofixedterm", "cleardate"}).sum("balance").sum("converamt").sum("avgamt").sum("estimatedinterest").finish()).copy().addField("id", "loanbillid");
        DataSet repaymentDs = TradeFinanceRptHelper.getRepaymentDs(loanBillDs, AvgInterestRateDataRptPlugin.getRepaymentFilter(costCalRequest.getQueryEndDate()));
        DataSet dataSet = repayDsCopy = repaymentDs != null ? repaymentDs.copy() : repaymentDs;
        if (this.splitBankCate.booleanValue()) {
            splitBankStartTime = System.currentTimeMillis();
            repayResDs = repaymentDs != null ? repaymentDs.copy().filter("loantype='sl'") : null;
            allViewData = AvgInterestRateDataRptPlugin.combineBizTypeData(allViewData, "cfm_loanbill", "sl", SL_FIELDS, repayResDs);
            logger.info("\u94f6\u56e2\u53d6\u6570\u8017\u65f6\uff1a" + (System.currentTimeMillis() - splitBankStartTime) / 1000L);
        }
        if (this.splitBondCate.booleanValue()) {
            splitBankStartTime = System.currentTimeMillis();
            repayResDs = repaymentDs != null ? repaymentDs.filter("loantype='bond'") : null;
            allViewData = AvgInterestRateDataRptPlugin.combineBizTypeData(allViewData, "cfm_loanbill_bond", "bond", BOND_FIELDS, repayResDs);
            logger.info("\u53d1\u503a\u53d6\u6570\u8017\u65f6\uff1a" + (System.currentTimeMillis() - splitBankStartTime) / 1000L);
        }
        if (this.splitBankCate.booleanValue() || this.splitBondCate.booleanValue()) {
            allViewData = this.filterByCreditor(allViewData, paramMap, this.splitBondCate);
        }
        allViewData = this.addTermFieldDS(allViewData.filter("avgamt>0"));
        logger.info("doQueryDataSet()\u65b9\u6cd5\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        allViewData = this.getNotRepayDs(allViewData, repayDsCopy);
        allViewData = this.reCombineExtResult(allViewData);
        return allViewData;
    }

    private DataSet filterByCreditor(DataSet result, Map<String, Object> paramMap, boolean isBond) {
        String creditor;
        String creditorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)creditorType) && isBond) {
            result = result.filter(String.format("creditortype= '%s'", creditorType));
        }
        if (EmptyUtil.isEmpty((String)(creditor = (String)paramMap.get("filter_creditor")))) {
            return result;
        }
        if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
            final String textCredit = creditor.split(";")[0];
            return result.filter(new FilterFunction(){

                public boolean test(Row row) {
                    return row.getString("textcreditor").contains(textCredit);
                }
            });
        }
        String creditorId = (String)paramMap.get("filter_creditorid");
        if (EmptyUtil.isNoEmpty((String)creditorId)) {
            final List creditList = Arrays.stream(creditorId.split(";")).filter(EmptyUtil::isNoEmpty).map(Long::valueOf).collect(Collectors.toList());
            result = result.filter(new FilterFunction(){

                public boolean test(Row row) {
                    return creditList.contains(row.getLong("creditor"));
                }
            });
        }
        return result;
    }

    private static QFilter getRepaymentFilter(Date endDate) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("bizdate", "<=", (Object)endDate);
        return qFilter;
    }

    private static DataSet combineBizTypeData(DataSet result, String entityName, String loanType, String bizSelectFields, DataSet repayResDs) {
        boolean isConDraAmount = Arrays.stream(result.getRowMeta().getFieldNames()).anyMatch(o -> "edrawamount".equals(o));
        if (!isConDraAmount) {
            result = result.addField("0", "edrawamount");
        }
        DataSet othreResult = result.copy().filter("loantype!='" + loanType + "'");
        Set slBillIds = FinCostCalCommonHelper.getDataSetIds((DataSet)(result = result.copy().filter(" loantype='" + loanType + "' ")), (String)"id");
        if (EmptyUtil.isNoEmpty((Object)slBillIds)) {
            logger.info("slorbondds size:{}", (Object)slBillIds.size());
            QFilter filter = new QFilter("id", "in", (Object)slBillIds);
            DataSet loanDataSet = AvgInterestRateDataRptPlugin.getFinanceCostDataSet("FinanceCostDataHelper.queryDataSet" + loanType, entityName, filter, bizSelectFields);
            if (LoanTypeEnum.isBond((String)loanType)) {
                loanDataSet = loanDataSet.updateField("edrawamount", "case when entryid=0 and edrawamount is null then drawamount else edrawamount end");
            }
            result = result.leftJoin(loanDataSet).on("id", "id").select(result.getRowMeta().getFieldNames(), new String[]{"entryid", "ecreditor", "etextcreditor", "edrawamount vamount", "ecreditortype"}).finish();
            result = result.updateFields(new String[]{"edrawamount", "creditor", "textcreditor", "creditortype"}, new String[]{"case when vamount!=null then vamount else edrawamount end", "case when vamount is null then creditor else ecreditor end", "case when vamount is null then textcreditor else etextcreditor end", "case when vamount is null then creditortype else ecreditortype end"}).select(new String[]{"id", "loantype", "interesttype", "orgid", "orgname", "finproductid", "finproduct", "drawamount", "edrawamount", "contractbillno", "billno", "creditortype", "entryid", "creditor", "textcreditor", "currency", "currencyname", "startintdate", "expiredate", "startdate", "enddate", "yearrate", "balance", "exchangerate", "converamt", "day", "dayweight", "perpetualbond", "isnofixedterm", "cleardate", "avgamt", "estimatedinterest"});
            result = AvgInterestRateDataRptPlugin.getSlAndBondRepayDs(result, repayResDs, loanType).removeFields(new String[]{"entryid"});
        }
        return othreResult.select(result.getRowMeta().getFieldNames()).union(result);
    }

    private static DataSet getSlAndBondRepayDs(DataSet result, DataSet repayResDs, String loanType) {
        if (repayResDs == null || repayResDs.isEmpty()) {
            logger.info("repayResDs is empty");
            return result;
        }
        repayResDs = repayResDs.copy().groupBy(new String[]{"loanid", "entryid", "repaydate", "isbuyback"}).sum("repayamt").finish();
        if ("sl".equals(loanType)) {
            repayResDs = AvgInterestRateDataRptPlugin.getAllRepayDs(repayResDs.copy());
            result = result.leftJoin(repayResDs.copy()).on("id", "loanid").on("creditor", "entryid").on("startdate", "repaydate").select(result.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("edrawamount", "edrawamount-(case when repayamt !=null then repayamt else 0 end)").removeFields(new String[]{"repayamt"});
        } else {
            result = AvgInterestRateDataRptPlugin.getBondRepayDs(result.copy(), repayResDs);
        }
        DataSet creditSumAmount = result.copy().groupBy(new String[]{"id", "startdate"}).sum("edrawamount").finish();
        result = "sl".equals(loanType) ? result.leftJoin(creditSumAmount).on("id", "id").on("startdate", "startdate").select(result.getRowMeta().getFieldNames(), new String[]{"case when edrawamount=0 then 1 else edrawamount end creditorSumamt"}).finish().updateFields(new String[]{"balance", "converamt", "avgamt", "estimatedinterest"}, new String[]{"balance*edrawamount/creditorSumamt", "balance*edrawamount/creditorSumamt*exchangerate", "avgamt*edrawamount/creditorSumamt", "estimatedinterest*edrawamount/creditorSumamt"}).removeFields(new String[]{"creditorSumamt"}) : result.leftJoin(creditSumAmount).on("id", "id").on("startdate", "startdate").select(result.getRowMeta().getFieldNames(), new String[]{"case when edrawamount=0 then 1 else edrawamount end creditorSumamt"}).finish().updateFields(new String[]{"balance", "converamt"}, new String[]{"edrawamount", "edrawamount*exchangerate"}).updateField("avgamt", "converamt*dayweight").updateField("estimatedinterest", "avgamt*yearrate/100").removeFields(new String[]{"creditorSumamt"});
        return result.orderBy(new String[]{"id", "textcreditor"});
    }

    private static DataSet getBondRepayDs(DataSet result, DataSet repayResDs) {
        DataSet newBackDs;
        DataSet backRepayDs = repayResDs.copy().filter("isbuyback");
        DataSet bankRepayAllDs = backRepayDs.copy().groupBy(new String[]{"loanid", "repaydate"}).sum("repayamt").finish();
        DataSet notBackRepayDs = repayResDs.filter("!isbuyback");
        if (!notBackRepayDs.isEmpty() && !(newBackDs = notBackRepayDs.copy().leftJoin(backRepayDs.copy()).on("loanid", "loanid").on("repaydate", "repaydate").select(notBackRepayDs.getRowMeta().getFieldNames(), new String[]{"loanid lid"}).finish().filter("lid=null").removeFields(new String[]{"lid"})).isEmpty()) {
            DataSet loanCreditorDs = result.copy().groupBy(new String[]{"id", "entryid"}).finish();
            DataSet notBackDs = newBackDs.leftJoin(loanCreditorDs).on("loanid", "id").select(new String[]{"loanid", "entryid", "repaydate", "isbuyback", "0 repayamt"}).finish();
            backRepayDs = backRepayDs.union(notBackDs);
        }
        if (!(backRepayDs = AvgInterestRateDataRptPlugin.getAllRepayDs(backRepayDs)).isEmpty()) {
            result = result.leftJoin(backRepayDs).on("id", "loanid").on("entryid", "entryid").on("startdate", "repaydate").select(result.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("edrawamount", "edrawamount-(case when repayamt !=null then repayamt else 0 end)").removeFields(new String[]{"repayamt"});
        }
        if (!notBackRepayDs.isEmpty()) {
            RowMeta rowMeta = new RowMeta(new String[]{"loanid", "startdate", "amount"}, new DataType[]{DataType.LongType, DataType.DateType, DataType.BigDecimalType});
            DataSetBuilder builder = Algo.create((String)"notbackds").createDataSetBuilder(rowMeta);
            DataSet resultResDs = result.copy().groupBy(new String[]{"id", "startdate"}).finish();
            for (Row resultRes : resultResDs) {
                Long id = resultRes.getLong("id");
                Date startDate = resultRes.getDate("startdate");
                DataSet repayamtDs = notBackRepayDs.copy().filter("loanid=" + id + " and to_char(repaydate, 'yyyyMMdd') <=" + DateUtils.formatString((Date)startDate, (String)"yyyyMMdd")).groupBy(new String[]{"loanid"}).sum("repayamt").finish();
                if (repayamtDs == null || repayamtDs.isEmpty()) continue;
                builder.append(new Object[]{id, startDate, ((Row)repayamtDs.iterator().next()).getBigDecimal("repayamt")});
            }
            DataSet repayDs = builder.build();
            if (!repayDs.isEmpty()) {
                result = result.leftJoin(bankRepayAllDs).on("id", "loanid").on("startdate", "repaydate").select(result.getRowMeta().getFieldNames(), new String[]{"repayamt brepayamt"}).finish().addField("case when brepayamt!=null then drawamount-brepayamt else drawamount end", "sumamount").removeFields(new String[]{"brepayamt"});
                result = result.leftJoin(repayDs).on("id", "loanid").on("startdate", "startdate").select(result.getRowMeta().getFieldNames(), new String[]{"amount"}).finish().updateField("edrawamount", "edrawamount-case when amount!=null then amount*edrawamount/sumamount else 0 end").removeFields(new String[]{"sumamount", "amount"});
            }
        }
        return result;
    }

    private static DataSet getAllRepayDs(DataSet repayResDs) {
        DataSetBuilder builder = Algo.create((String)"getAllRepayDs").createDataSetBuilder(repayResDs.getRowMeta());
        for (Row payDs : repayResDs.copy()) {
            Long loanId = payDs.getLong("loanid");
            Long entryId = payDs.getLong("entryid");
            Date repayDate = payDs.getDate("repaydate");
            DataSet resDs = repayResDs.copy().filter("loanid=" + loanId + " and entryid=" + entryId).filter("to_char(repaydate, 'yyyyMMdd') < " + DateUtils.formatString((Date)repayDate, (String)"yyyyMMdd")).select(repayResDs.getRowMeta().getFieldNames()).groupBy(new String[]{"loanid", "entryid"}).sum("repayamt").finish();
            if (resDs.isEmpty()) {
                builder.append(payDs);
                continue;
            }
            BigDecimal repayamt = payDs.getBigDecimal("repayamt");
            Row res = (Row)resDs.iterator().next();
            if (!resDs.isEmpty() && repayamt != null && res.getBigDecimal("repayamt") != null) {
                builder.append(new Object[]{loanId, entryId, repayDate, payDs.get("isbuyback"), repayamt.add(res.getBigDecimal("repayamt"))});
                continue;
            }
            builder.append(payDs);
        }
        repayResDs = builder.build();
        return repayResDs;
    }

    private static DataSet getFinanceCostDataSet(String algoKey, String entityName, QFilter filter, String selectField) {
        return QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)entityName, (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet addTermFieldDS(DataSet dataSet) {
        return dataSet.addField(String.valueOf(this.statCurrencyId), "tarcurrency").addField("Cast('" + DateUtils.formatString((Date)this.endDate, (String)"yyyy-MM-dd") + "' as Date)", "queryenddate").addField("DATEDIF(startintdate,expiredate,D)", "allday").addField("DATEDIF(queryenddate,expiredate,D)", "remainingday").addField("case when perpetualbond   or isnofixedterm  then  'n'  when allday<=366 then '1' when allday>366 and allday <=1096 then '2' when allday>1096 and allday<=1826 then '3' when allday>1826 and allday<=3651 then '4' when allday>3651 then '5' end", "allterm").addField("case when (perpetualbond  or isnofixedterm ) and (cleardate is null or  cleardate > queryenddate) then 'n' when (perpetualbond  or isnofixedterm ) and ( cleardate <= queryenddate) then '1' when remainingday<=0 and cleardate is not null and  cleardate  <= queryenddate then '1' when remainingday<=0 and (cleardate is null or  cleardate > queryenddate) then '2' when remainingday>0 and remainingday<=366 then '3' when remainingday>366 and remainingday <=1096 then '4' when remainingday>1096 and remainingday<=1826 then '5' when remainingday>1826 and remainingday<=3651 then '6' when remainingday>3651 then '7' end", "remainingterm").addField("case when perpetualbond   then '" + this.getLondTypeMsg() + "'  when isnofixedterm then '" + this.getShortTypeMsg() + "'  when DATEDIF(startintdate,expiredate,D)>366   then '" + this.getLondTypeMsg() + "'  when  DATEDIF(startintdate,expiredate,D)<=366 then '" + this.getShortTypeMsg() + "' end", "type").addField("estimatedinterest/avgamt*100", "avginterestrate");
    }

    private String getLondTypeMsg() {
        return ResManager.loadKDString((String)"\u957f\u671f\u501f\u6b3e", (String)"AvgInterestRateDataRptPlugin_36", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getShortTypeMsg() {
        return ResManager.loadKDString((String)"\u77ed\u671f\u501f\u6b3e", (String)"AvgInterestRateDataRptPlugin_37", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private DataSet querySumDataSet(DataSet dataSet) {
        DataSet sumData = dataSet.copy();
        switch (this.statDim) {
            case "org": {
                sumData = this.getSumDataByOrgDim(sumData);
                break;
            }
            case "creditor": {
                sumData = this.getSumDataByCreditorDim(sumData);
                break;
            }
            case "finproduct": {
                sumData = this.getSumDataByFinproductDim(sumData);
                break;
            }
            case "allterm": {
                sumData = this.getSumDataByAlltermDim(sumData);
                break;
            }
            case "remainingterm": {
                sumData = this.getSumDataByRemainingtermDim(sumData);
                break;
            }
            case "currency": {
                sumData = this.getSumDataByCurrencyDim(sumData);
            }
        }
        return sumData;
    }

    private DataSet getSumDataByOrgDim(DataSet sumData) {
        DataSet orgGroup = sumData.copy().groupBy(new String[]{"orgid", "orgname", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet orgDS = orgGroup.copy().groupBy(new String[]{"orgid", "orgname"}).finish().select(new String[]{"orgid", "orgname", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateOrgDS = this.updateFields(orgDS, orgGroup, "orgid");
        return updateOrgDS;
    }

    private DataSet getSumDataByCreditorDim(DataSet sumData) {
        DataSet creditorGroup = sumData.copy().groupBy(new String[]{"creditor", "textcreditor", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet creditrDS = creditorGroup.copy().groupBy(new String[]{"creditor", "textcreditor"}).finish().select(new String[]{"creditor", "textcreditor", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateCreditrDS = this.updateFields(creditrDS, creditorGroup, "creditor");
        if ("1".equals(this.bankLevel)) {
            updateCreditrDS = updateCreditrDS.groupBy(new String[]{"textcreditor"}).sum("shortavg").sum("shortinterestsum").sum("shortavgrate").sum("longavg").sum("longinterestsum").sum("longavgrate").sum("weightterm").sum("weightperamt").sum("weightamt").finish();
        }
        return updateCreditrDS;
    }

    private DataSet getSumDataByFinproductDim(DataSet sumData) {
        DataSet finproductGroup = sumData.groupBy(new String[]{"finproductid", "finproduct", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet finproductDS = finproductGroup.copy().groupBy(new String[]{"finproductid", "finproduct"}).finish().select(new String[]{"finproductid", "finproduct", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateFinproductDS = this.updateFields(finproductDS, finproductGroup, "finproductid");
        return updateFinproductDS;
    }

    private DataSet getSumDataByAlltermDim(DataSet sumData) {
        DataSet alltermGroup = sumData.groupBy(new String[]{"allterm", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet alltermDS = alltermGroup.copy().groupBy(new String[]{"allterm"}).finish().select(new String[]{"allterm", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateAlltermDS = this.updateFields(alltermDS, alltermGroup, "allterm");
        return updateAlltermDS;
    }

    private DataSet getSumDataByRemainingtermDim(DataSet sumData) {
        DataSet remainingtermGroup = sumData.groupBy(new String[]{"remainingterm", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet remainingtermDS = remainingtermGroup.copy().groupBy(new String[]{"remainingterm"}).finish().select(new String[]{"remainingterm", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateDS = this.updateFields(remainingtermDS, remainingtermGroup, "remainingterm");
        return updateDS;
    }

    private DataSet getSumDataByCurrencyDim(DataSet sumData) {
        DataSet currencyGroup = sumData.groupBy(new String[]{"currency", "currencyname", "type"}).sum("avgamt").sum("estimatedinterest").sum("avginterestrate").sum("notrepayamt * difdays", "weightperamt").sum("notrepayamt", "weightamt").finish();
        DataSet currencyDS = currencyGroup.copy().groupBy(new String[]{"currency", "currencyname"}).finish().select(new String[]{"currency", "currencyname", "0.0 as shortavg", "0.0 as shortinterestsum", "0.0 as shortavgrate", "0.0 as longavg", "0.0 as longinterestsum", "0.0 as longavgrate", "0.0 as weightterm", "0.0 as weightperamt", "0.0 as weightamt"});
        DataSet updateDS = this.updateFields(currencyDS, currencyGroup, "currency");
        return updateDS;
    }

    private DataSet updateFields(DataSet creditrDS, final DataSet creditorGroup, final String field) {
        final RowMeta rowMeta = creditrDS.getRowMeta();
        final List<String> filedNames = Arrays.asList("shortavg", "shortinterestsum", "longavg", "longinterestsum", "weightterm", "weightperamt", "weightamt");
        return creditrDS.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                Map<String, BigDecimal> amountMap = this.getAmount(creditorGroup.copy(), field, row.get(field));
                for (String filedName : rowMeta.getFieldNames()) {
                    if (filedNames.contains(filedName)) {
                        rowInfo.add(amountMap.get(filedName));
                        continue;
                    }
                    rowInfo.add(row.get(filedName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }

            private Map<String, BigDecimal> getAmount(DataSet dataSet, String field2, Object value) {
                DataSet longData;
                DataSet shortData;
                HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(4);
                if ("allterm".equals(field2) || "remainingterm".equals(field2)) {
                    shortData = dataSet.copy().where(field2 + "='" + value + "' and type = '" + AvgInterestRateDataRptPlugin.this.getShortTypeMsg() + "'");
                    longData = dataSet.copy().where(field2 + "='" + value + "' and type = '" + AvgInterestRateDataRptPlugin.this.getLondTypeMsg() + "' ");
                } else {
                    shortData = dataSet.copy().where(field2 + "=" + value + " and type = '" + AvgInterestRateDataRptPlugin.this.getShortTypeMsg() + "' ");
                    longData = dataSet.copy().where(field2 + "=" + value + " and type = '" + AvgInterestRateDataRptPlugin.this.getLondTypeMsg() + "' ");
                }
                for (Row row : shortData) {
                    amountMap.put("shortavg", row.getBigDecimal("avgamt"));
                    amountMap.put("shortinterestsum", row.getBigDecimal("estimatedinterest"));
                    amountMap.put("weightterm", this.calWeightValue(row));
                    BigDecimal preWeightPerAmt = amountMap.getOrDefault("weightperamt", BigDecimal.ZERO);
                    amountMap.put("weightperamt", preWeightPerAmt.add(row.getBigDecimal("weightperamt")));
                    BigDecimal preWeightAmt = amountMap.getOrDefault("weightamt", BigDecimal.ZERO);
                    amountMap.put("weightamt", preWeightAmt.add(row.getBigDecimal("weightamt")));
                }
                for (Row row : longData) {
                    amountMap.put("longavg", row.getBigDecimal("avgamt"));
                    amountMap.put("longinterestsum", row.getBigDecimal("estimatedinterest"));
                    amountMap.put("weightterm", this.calWeightValue(row));
                    BigDecimal preWeightPerAmt = amountMap.getOrDefault("weightperamt", BigDecimal.ZERO);
                    amountMap.put("weightperamt", preWeightPerAmt.add(row.getBigDecimal("weightperamt")));
                    BigDecimal preWeightAmt = amountMap.getOrDefault("weightamt", BigDecimal.ZERO);
                    amountMap.put("weightamt", preWeightAmt.add(row.getBigDecimal("weightamt")));
                }
                return amountMap;
            }

            private BigDecimal calWeightValue(Row row) {
                BigDecimal weightVal = BigDecimal.ZERO;
                BigDecimal divideAmt = row.getBigDecimal("weightamt");
                if (EmptyUtil.isNoEmpty((BigDecimal)divideAmt)) {
                    weightVal = row.getBigDecimal("weightperamt").divide(divideAmt, 2, RoundingMode.HALF_UP);
                }
                return weightVal;
            }
        });
    }

    private DataSet dealDataSetByBankLevel(DataSet dataSet) {
        DataSet bankDs = dataSet.copy().select("creditor").distinct();
        HashSet bankSet = new HashSet();
        bankDs.forEach(r -> bankSet.add(r.getLong("creditor")));
        QFilter bankQF = new QFilter("id", "in", bankSet);
        DataSet bdBankDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_bank"), (String)CreditorTypeEnum.BANK.getFormId(), (String)"id bankid, bank_cate.name bankcgname,bank_cate.id bankcgid", (QFilter[])bankQF.toArray(), null);
        dataSet = dataSet.leftJoin(bdBankDs).on("creditor", "bankid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"bankcgname", "bankcgid"}).finish();
        DataSet resultDataSet = dataSet.updateField("textcreditor", "case when bankcgname != null then bankcgname else textcreditor end");
        return resultDataSet;
    }

    public void addExtDetailColumList(List<Triple<String, String, String>> extDetailColumnsList) {
    }

    public DataSet reCombineExtResult(DataSet dataSet) {
        return dataSet;
    }

    public void buildExtQfilter(Map<String, Object> paramMap, QFilter qFilters) {
    }

    private DataSet getNotRepayDs(DataSet allViewData, DataSet repaymentDs) {
        DataSet tmpDistinctDs;
        DataSet loanDistinctDs = allViewData.copy().groupBy(new String[]{"id"}).max("drawamount").min("startdate").finish();
        if (null == repaymentDs) {
            tmpDistinctDs = loanDistinctDs.addField("drawamount", "notrepayamt");
        } else {
            DataSet repayDistinctDs = repaymentDs.groupBy(new String[]{"loanid"}).sum("repayamt").finish();
            tmpDistinctDs = loanDistinctDs.leftJoin(repayDistinctDs).on("id", "loanid").select(new String[]{"id", "drawamount", "startdate", "repayamt"}).finish().updateField("repayamt", "case when repayamt is null then 0 else repayamt end").addField("drawamount-repayamt", "notrepayamt");
        }
        allViewData = allViewData.leftJoin(tmpDistinctDs).on("id", "id").on("startdate", "startdate").select(allViewData.getRowMeta().getFieldNames(), new String[]{"notrepayamt"}).finish();
        return allViewData.addField("DATEDIF(startintdate,expiredate,D)", "difdays").updateField("notrepayamt", "case when notrepayamt is null then 0 else notrepayamt end");
    }
}

