/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.report.data.TradeFinanceDataListPlugin;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EnterpiseFinanceDataListPlugin
extends TradeFinanceDataListPlugin {
    private static Log logger = LogFactory.getLog(EnterpiseFinanceDataListPlugin.class);
    protected static final String LOANBILL_FORM_PROPS = "id, id as loanbillid, '' as summarycol,org.id as orgid,textdebtor as fincompanyname,creditortype as fincreditortype,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,  billno as loanbillno, finproduct.name as finproductname, creditorg.name as fincreditorname, loantype,amount,payinterestamount+calculaterateamount estinterestamt, 0 as findebtslevel,creditortype,creditorg as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1, interesttype,0 repayamt,0 repayamt1,0 notrepayamt,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, loancontractbill.amount as contractamt, settleintmode, repaymentway,term,basis,cleardate";

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        this.initParams(paramMap);
        DataSet loanBillDS = this.queryLoanBillDS(queryParam, paramMap);
        if (loanBillDS.isEmpty()) {
            return TradeFinanceFilterHelper.createEmptyDS();
        }
        DataSet repaymentDS = TradeFinanceFilterHelper.repaymentDs(loanBillDS, this.cutoffdate).groupBy(new String[]{"loanid"}).sum("repayamt").finish();
        if (repaymentDS != null) {
            loanBillDS = loanBillDS.leftJoin(repaymentDS).on("loanbillid", "loanid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"repayamt as paidamt"}).finish();
            loanBillDS = loanBillDS.updateField("paidamt", "case when paidamt=null then 0 else paidamt end");
        } else {
            loanBillDS = loanBillDS.addField("0", "paidamt");
        }
        loanBillDS = loanBillDS.addField("drawamount-paidamt", "unpaidamt");
        List<Long> loanBillIds = TradeFinanceFilterHelper.getloanBillIds(loanBillDS, "loanbillid");
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DataSet interestDS = TradeFinanceFilterHelper.interestDS(loanBillIds, this.cutoffdate, clazz);
        loanBillDS = loanBillDS.leftJoin(interestDS).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"paidintamt"}).finish().updateField("paidintamt", "case when paidintamt=null then 0 else paidintamt end").addField("estinterestamt-paidintamt", "unpaidintamt");
        DataSet interestRateDS = TradeFinanceFilterHelper.interestRateDS(loanBillIds, this.cutoffdate, clazz);
        loanBillDS = loanBillDS.leftJoin(interestRateDS).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"intrate"}).finish();
        loanBillDS = loanBillDS.updateField("unpaidamt", "case when unpaidamt>0 then unpaidamt else 0 end").updateField("unpaidintamt", "case when unpaidintamt>0 then unpaidintamt else 0 end");
        loanBillDS = this.addFeeAmtDs(loanBillDS, loanBillIds);
        return loanBillDS;
    }

    @Override
    public DataSet queryLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap) {
        List<String> extendedColumns = this.getExtendedColumnKeys(queryParam);
        String extendSelectProps = this.createExtendedColumnSelectStr(extendedColumns);
        QFilter qf = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        qf.and(new QFilter("creditorg", ">", (Object)0L)).and(new QFilter("creditortype", "in", Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.SETTLECENTER.getValue())));
        qf.or(new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue()));
        List orgIds = this.getQueryOrgIds(queryParam);
        qf.and(EnterpiseFinanceDataListPlugin.loanBillQFilter(paramMap));
        qf.and(EnterpiseFinanceDataListPlugin.initCriditorFilter(paramMap, orgIds));
        qf.and(new QFilter("loantype", "in", Arrays.asList("entrust", "ec")));
        ReportFilterParamHelper.addExtFilter(paramMap, qf);
        logger.info("Enterpise:query" + qf.toString());
        String selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? LOANBILL_FORM_PROPS : "id, id as loanbillid, '' as summarycol,org.id as orgid,textdebtor as fincompanyname,creditortype as fincreditortype,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,  billno as loanbillno, finproduct.name as finproductname, creditorg.name as fincreditorname, loantype,amount,payinterestamount+calculaterateamount estinterestamt, 0 as findebtslevel,creditortype,creditorg as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1, interesttype,0 repayamt,0 repayamt1,0 notrepayamt,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, loancontractbill.amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_invest_loanbill", (String)selectProps, (QFilter[])qf.toArray(), null);
    }

    public static QFilter loanBillQFilter(Map<String, Object> paramMap) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = ReportCommonHelper.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        qFilter.and(TradeFinanceRptHelper.initBizdateFitler(paramMap));
        qFilter.and(TradeFinanceRptHelper.initCurrencyFilter(paramMap));
        qFilter.and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        return qFilter;
    }

    public static QFilter initCriditorFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter creditorFilter = new QFilter("creditorg", "in", orgIds);
        String debtorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)debtorType)) {
            creditorFilter.and(new QFilter("debtortype", "in", Arrays.asList(debtorType.split(";"))));
        }
        String debtorStr = (String)paramMap.get("filter_creditor");
        String debtorIdStr = (String)paramMap.get("filter_creditorid");
        if (EmptyUtil.isNoEmpty((String)debtorStr)) {
            if ("0".equals(debtorIdStr)) {
                creditorFilter.and("textdebtor", "=", (Object)debtorStr);
            } else if (EmptyUtil.isEmpty((String)debtorIdStr)) {
                creditorFilter.and("textdebtor", "like", (Object)("%" + debtorStr + "%"));
            }
        }
        if (EmptyUtil.isNoEmpty((String)debtorIdStr) && !"0".equals(debtorIdStr)) {
            long[] debtorIds = Arrays.asList(debtorIdStr.split(";")).stream().mapToLong(Long::parseLong).toArray();
            creditorFilter.and("debtor", "in", (Object)debtorIds);
        }
        return creditorFilter;
    }
}

