/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.report.data.TradeFinanceSumDataListPlugin;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class EnterpiseFinanceSumDataListPlugin
extends TradeFinanceSumDataListPlugin {
    private static Log logger = LogFactory.getLog(EnterpiseFinanceSumDataListPlugin.class);
    private static String statDim = "org";
    private static boolean showStep = false;
    protected static final String LOAN_FIELDS = "id, id loanbillid, debtor orgid, textdebtor orgname,loantype,finproduct.name finproductname, creditortype as fincreditortype, currency loancurrency, currency.name loancurrencyname, creditortype, creditorg creditorid, drawamount,drawamount drawamount1, 1 userate, creditorg.name creditorname,0 repayamt,0 repayamt1,0 notrepayamt";

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.initParams(paramMap);
        DataSet ds = this.getLoanBillDS(queryParam, paramMap, null);
        if (ds.isEmpty()) {
            return TradeFinanceRptHelper.createEmptyDS();
        }
        statDim = (String)paramMap.get("filter_statdim");
        List<String> containLoanerDim = Arrays.asList("orgname,creditorname,loancurrencyname", "creditorname,orgname,loancurrencyname", "creditorname,loancurrencyname");
        if (containLoanerDim.contains(statDim)) {
            this.groupFields.add("creditorid");
        }
        ds = TradeFinanceRptHelper.addPaidAmtField(ds, this.cutoffdate);
        showStep = "step".equals(paramMap.get("filter_showttype"));
        if (showStep && "creditorname,loancurrencyname".equals(statDim)) {
            ds = TradeFinanceRptHelper.groupAndSumDataSet(ds, this.groupFields.toArray(new String[0]), AMT_FIELDS);
            DataSet exchangeRateSet = this.getExChangeRateDs(ds, paramMap);
            String unit = (String)paramMap.get("filter_currencyunit");
            String[] selectFields = this.initSelectFields(ds, unit, true, true);
            ds = ds.leftJoin(exchangeRateSet).on(this.getCurrencyField(), "tarcurrency").select(selectFields).finish();
            ds = TradeFinanceRptHelper.groupAndSumDataSet(ds, new String[]{"creditorid"}, new String[]{"drawamount", "drawamount_statccy", "unpaidamt", "unpaidamt_statccy"}).addNullField("creditorname");
        } else {
            List<String> noBorrowerDim = Arrays.asList("creditorname,loancurrencyname", "fincreditortype,loancurrencyname", "loancurrencyname", "finproductname,loancurrencyname");
            ArrayList list = new ArrayList(this.groupFields);
            if (noBorrowerDim.contains(statDim)) {
                list.remove("orgid");
            }
            ds = TradeFinanceRptHelper.groupAndSumDataSet(ds, list.toArray(new String[0]), AMT_FIELDS);
        }
        return ds;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return "creditorname,loancurrencyname".equals(statDim) ? Pair.of((Object)"creditorid", (Object)"creditorname") : Pair.of((Object)"org", (Object)"orgtext");
    }

    @Override
    protected boolean isNeedOrgTree() {
        return "creditorname,loancurrencyname".equals(statDim);
    }

    @Override
    public List<String> groupFields() {
        List<String> groupFields = super.groupFields();
        if ("creditorname,loancurrencyname".equals(statDim)) {
            groupFields.clear();
            groupFields.add("statcurrency");
        }
        return groupFields;
    }

    @Override
    public String subNameField() {
        String subNameField = super.subNameField();
        if ("creditorname,loancurrencyname".equals(statDim)) {
            return "creditorname";
        }
        return subNameField;
    }

    protected boolean isNeedDimCurrency() {
        return !showStep;
    }

    protected boolean isNeedCurrencyUnit() {
        return !showStep;
    }

    @Override
    protected DataSet getLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap, QFilter qFilter) {
        String algoKey = ((Object)((Object)this)).getClass().getName();
        QFilter qf = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        qf.and(new QFilter("creditorg", ">", (Object)0L)).and(new QFilter("creditortype", "in", Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.SETTLECENTER.getValue())));
        qf.or(new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue()));
        qf.and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        List orgIds = this.getQueryOrgIds(queryParam);
        qf.and(EnterpiseFinanceSumDataListPlugin.loanBillQFilter(paramMap, orgIds));
        qf.and(EnterpiseFinanceSumDataListPlugin.getCreditorFilter(paramMap));
        qf.and(new QFilter("loantype", "in", Arrays.asList("entrust", "ec")));
        qf.and(new QFilter("settlestatus", "!=", (Object)"addnew"));
        logger.info("EnterpiseSum:query" + qf.toString());
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloan"), (String)"cim_invest_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{qf}, null);
    }

    public static QFilter loanBillQFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = ReportCommonHelper.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        qFilter.and(new QFilter("creditorg.id", "in", orgIds));
        qFilter.and(TradeFinanceRptHelper.initBizdateFitler(paramMap));
        qFilter.and(TradeFinanceRptHelper.initCurrencyFilter(paramMap));
        return qFilter;
    }

    public static QFilter getCreditorFilter(Map<String, Object> paramMap) {
        String debtorStr;
        String debtorType = (String)paramMap.get("filter_creditortype");
        String debtorIdStr = (String)paramMap.get("filter_creditorid");
        QFilter creditorFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((String)debtorType)) {
            creditorFilter.and(new QFilter("debtortype", "in", Arrays.asList(debtorType.split(";"))));
        }
        if (EmptyUtil.isNoEmpty((String)(debtorStr = (String)paramMap.get("filter_creditor"))) && EmptyUtil.isEmpty((String)debtorIdStr)) {
            creditorFilter.and("textdebtor", "like", (Object)("%" + debtorStr + "%"));
        }
        if (EmptyUtil.isNoEmpty((String)debtorIdStr)) {
            long[] debtorIds = Arrays.asList(debtorIdStr.split(";")).stream().mapToLong(Long::parseLong).toArray();
            creditorFilter.and("debtor", "in", (Object)debtorIds);
        }
        return creditorFilter;
    }

    protected String getCurrencyField() {
        return "loancurrency";
    }

    private String[] initSelectFields(DataSet bizDataSet, String unit, boolean isNeedCurrencyUnit, boolean isNeedDimCurrency) {
        List<String> amountFields = this.orinalAmountField();
        String[] oralfields = bizDataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldList = new ArrayList<String>(oralfields.length);
        for (String field : oralfields) {
            if (fieldList.contains(field) || amountFields.contains(field)) continue;
            fieldList.add(field);
        }
        for (String field : amountFields) {
            if (isNeedCurrencyUnit) {
                fieldList.add(String.format(field + " / %s " + field, unit));
            } else {
                fieldList.add(field);
            }
            if (!isNeedDimCurrency) continue;
            if (isNeedCurrencyUnit) {
                fieldList.add(String.format("(" + field + " * rate) / %s " + this.getReportField(field), unit));
                continue;
            }
            fieldList.add("(" + field + " * rate) " + this.getReportField(field));
        }
        if (isNeedDimCurrency) {
            fieldList.add("tarcurrency");
            fieldList.add("rate");
        }
        return fieldList.toArray(new String[0]);
    }

    @Override
    protected String[] orderFields() {
        return new String[]{this.sumField, "creditorid"};
    }
}

