/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.report.data.TradeFinanceDataListPlugin;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class InternalFinanceDataListPlugin
extends TradeFinanceDataListPlugin {
    protected static final String LOANBILL_FORM_PROPS = "id, id as loanbillid, '' as summarycol,org.id as orgid, org.name as fincompanyname,bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, creditortype as fincreditortype, settlecenter.name as fincreditorname, loantype,amount,payinterestamount+calculaterateamount estinterestamt,0 as findebtslevel,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt, interesttype, loancontractbill.contractno as contractno,loancontractbill.currency as concurrency,loancontractbill.number as contractbillno, loancontractbill.guarantee as guaranteeway, loancontractbill.amount as contractamt, settleintmode, repaymentway,term,basis,cleardate";

    @Override
    protected DataSet queryLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap) {
        List<String> extendedColumns = this.getExtendedColumnKeys(queryParam);
        String extendSelectProps = this.createExtendedColumnSelectStr(extendedColumns);
        QFilter qFilter = InternalFinanceDataListPlugin.loanBillQFilter(paramMap);
        ReportFilterParamHelper.addExtFilter(paramMap, qFilter);
        QFilter filter = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        filter.and(new QFilter("org", ">", (Object)0L)).and(new QFilter("debtortype", "=", (Object)CreditorTypeEnum.INNERUNIT.getValue()));
        filter.or(new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue()));
        qFilter.and(new QFilter("settlestatus", "in", Arrays.asList("addnew", "accept")));
        qFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        QFilter creditorFilter = InternalFinanceDataListPlugin.getCreditorFilter(paramMap);
        String selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? LOANBILL_FORM_PROPS : "id, id as loanbillid, '' as summarycol,org.id as orgid, org.name as fincompanyname,bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, creditortype as fincreditortype, settlecenter.name as fincreditorname, loantype,amount,payinterestamount+calculaterateamount estinterestamt,0 as findebtslevel,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt, interesttype, loancontractbill.contractno as contractno,loancontractbill.currency as concurrency,loancontractbill.number as contractbillno, loancontractbill.guarantee as guaranteeway, loancontractbill.amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_loanbill", (String)selectProps, (QFilter[])new QFilter[]{filter, qFilter, creditorFilter}, null);
    }

    public static QFilter loanBillQFilter(Map<String, Object> paramMap) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Boolean includeClose = (Boolean)paramMap.get("filter_includecloseout");
        if (!includeClose.booleanValue()) {
            QFilter noCloseOffDate = new QFilter("closeoffdate", "=", null);
            Date cutOffDate = ReportCommonHelper.getCutOffDate(paramMap);
            QFilter lessThanCutOffDate = new QFilter("closeoffdate", "<=", (Object)cutOffDate).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue())).and(new QFilter("notrepayamount", ">", (Object)BigDecimal.ZERO));
            QFilter largeThanCutOffDate = new QFilter("closeoffdate", ">", (Object)cutOffDate);
            qFilter.and(lessThanCutOffDate.or(largeThanCutOffDate).or(noCloseOffDate));
        }
        qFilter.and(TradeFinanceFilterHelper.initOrgFilter(paramMap));
        qFilter.and(TradeFinanceFilterHelper.initBizdateFitler(paramMap));
        qFilter.and(TradeFinanceFilterHelper.initCurrencyFilter(paramMap));
        return qFilter;
    }

    public static QFilter getCreditorFilter(Map<String, Object> paramMap) {
        QFilter qFilter = null;
        String creditor = (String)paramMap.get("filter_creditorid");
        String[] ids = StringUtils.split((String)creditor, (String)";");
        List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
        if (idList.size() > 0) {
            qFilter = new QFilter("settlecenter.id", "in", idList);
        }
        return qFilter;
    }
}

