/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.report.data.TradeFinanceSumDataListPlugin;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class InternalFinanceSumDataListPlugin
extends TradeFinanceSumDataListPlugin {
    protected static final String LOAN_FIELDS = "id, id loanbillid, org.id orgid, org.name orgname,loantype,finproduct.name finproductname, creditortype as fincreditortype, currency loancurrency, currency.name loancurrencyname, creditortype, creditor creditorid, drawamount, drawamount drawamount1, 1 userate, settlecenter.name creditorname,0 repayamt,0 repayamt1,0 notrepayamt";

    @Override
    protected DataSet getLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap, QFilter qFilter) {
        String algoKey = ((Object)((Object)this)).getClass().getName();
        QFilter filter = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        filter.and(new QFilter("org", ">", (Object)0L)).and(new QFilter("debtortype", "=", (Object)CreditorTypeEnum.INNERUNIT.getValue()));
        filter.or(new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue()));
        qFilter.and(filter);
        qFilter.and(new QFilter("settlestatus", "in", Arrays.asList("addnew", "accept")));
        qFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        QFilter credFilter = InternalFinanceSumDataListPlugin.getCreditorFilter(paramMap);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloan"), (String)"ifm_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{qFilter, credFilter}, null);
    }

    public static QFilter getCreditorFilter(Map<String, Object> paramMap) {
        QFilter qFilter = null;
        String creditor = (String)paramMap.get("filter_creditorid");
        String[] ids = StringUtils.split((String)creditor, (String)";");
        List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
        if (idList.size() > 0) {
            qFilter = new QFilter("settlecenter.id", "in", idList);
        }
        return qFilter;
    }
}

