/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class LoanSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private List<String> dynamicColList = new ArrayList<String>(10);
    private Map<String, String> creditorKeyToNameMap = new HashMap<String, String>(10);
    private static final String[] FINPRODUCT_COMPANY = new String[]{"finproductname", "companyname"};
    private static final String[] COMPANY_FINPRODUCT = new String[]{"companyname", "finproductname"};
    private String[] statdim;

    private String[] getStatdim() {
        return this.statdim;
    }

    private void setStatdim(String statdim) {
        if ("finproductcompany".equals(statdim)) {
            this.statdim = FINPRODUCT_COMPANY;
        } else if ("companyfinproduct".equals(statdim)) {
            this.statdim = COMPANY_FINPRODUCT;
        }
    }

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        DataSet data = this.getDataSet(queryParam);
        if (data.isEmpty()) {
            RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
            return emptyDataSet;
        }
        DataSet rows = super.ChangeRowToColDataSet(data.copy(), "creditor", this.getStatdim()[0] + "," + this.getStatdim()[1], "p_");
        DataSet sortDataSet = this.saveMD5List(rows);
        DataSet rData = this.addBilledTotalCol(sortDataSet);
        data.close();
        rows.close();
        sortDataSet.close();
        return rData;
    }

    private DataSet addBilledTotalCol(DataSet rows) {
        StringBuilder sb = new StringBuilder();
        for (String colName : this.dynamicColList) {
            sb.append(colName).append('+');
        }
        rows = rows.copy().addField(sb.substring(0, sb.length() - 1), "billedtotal");
        this.dynamicColList.add("billedtotal");
        return rows;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    public String subNameField() {
        return this.getStatdim()[1];
    }

    public String sumNameField() {
        return this.getStatdim()[0];
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>(10);
        groupFields.add(this.getStatdim()[0]);
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return this.dynamicColList;
    }

    private StringBuilder getDataSetSort() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatdim()[0]).append(',').append(this.getStatdim()[1]).append(',');
        for (String dynamicCol : this.dynamicColList) {
            sb.append(dynamicCol).append(',');
        }
        return sb;
    }

    private DataSet saveMD5List(DataSet rows) {
        String[] fieldNames;
        RowMeta rowMetas = rows.copy().getRowMeta();
        for (String colName : fieldNames = rowMetas.getFieldNames()) {
            if (!colName.startsWith("p_")) continue;
            this.dynamicColList.add(colName);
        }
        Collections.sort(this.dynamicColList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        StringBuilder sort = this.getDataSetSort();
        return rows.copy().select(sort.substring(0, sort.length() - 1));
    }

    private DataSet nameTransformMD5(DataSet union) {
        if (union.isEmpty()) {
            return union;
        }
        Iterator creditorIter = union.copy().iterator();
        HashSet hashCodes = new HashSet(32);
        while (creditorIter.hasNext()) {
            Row row = (Row)creditorIter.next();
            String creditor = row.getString("creditor");
            String creditorHash = String.valueOf(this.getHashCode(hashCodes, creditor));
            this.creditorKeyToNameMap.put(creditorHash, creditor);
        }
        return union;
    }

    private DataSet getDataSet(ReportQueryParam param) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        paramMap.putAll(param.getCustomParam());
        this.setStatdim(String.valueOf(paramMap.get("statdim")));
        String select = "id,billno, finproduct.name finproductname,org as company,org.name as companyname,creditortype, textcreditor, creditor as creditorid, drawamount as amount,currency,currency.name currencyname";
        List orgIds = this.getQueryOrgIds(param);
        QFilter filter = ReportFilterParamHelper.initCfmReportFilterIncludeDrawType(paramMap, orgIds);
        QFilter creditorFilter = TradeFinanceRptHelper.getCreditorFilter(paramMap, "");
        DataSet loanBillDS = QueryServiceHelper.queryDataSet((String)"cfmLoanBill", (String)"cfm_loanbill", (String)select, (QFilter[])new QFilter[]{filter, creditorFilter}, null);
        DataSet exchangeRateSet = this.getExChangeRateDs(loanBillDS, paramMap);
        String currencyUnitNum = String.valueOf(paramMap.get("filter_currencyunit"));
        loanBillDS = loanBillDS.join(exchangeRateSet, JoinType.LEFT).on("currency", "tarcurrency").select(new String[]{"id", "finproductname", "companyname", "creditortype", "textcreditor", "creditorid", "amount"}, new String[]{"rate"}).finish().select("id,  finproductname,companyname,creditortype,textcreditor, creditorid, amount*rate/" + currencyUnitNum + " as amount ");
        DataSet bankDS = loanBillDS.copy().filter("creditortype='" + CreditorTypeEnum.BANK.getValue() + "'").select(new String[]{"finproductname", "companyname", "textcreditor", "creditorid", "amount"});
        Set<Long> finIdSet = this.getCreditorIds(bankDS);
        QFilter finIdQFilter = new QFilter("id", "in", finIdSet);
        DataSet finorgDS = QueryServiceHelper.queryDataSet((String)"finorg", (String)CreditorTypeEnum.BANK.getFormId(), (String)"id creditorid, case when bank_cate.name is null then name else bank_cate.name end  as creditorname", (QFilter[])finIdQFilter.toArray(), null);
        bankDS = bankDS.leftJoin(finorgDS).on("creditorid", "creditorid").select(new String[]{"finproductname", "companyname", "textcreditor", "amount"}, new String[]{"creditorname"}).finish().select(" finproductname,companyname, case when creditorname is null then textcreditor  else creditorname end as creditor, amount");
        DataSet nonBankDS = loanBillDS.copy().filter("creditortype !='bank'").select(new String[]{"finproductname", "companyname", "textcreditor  as creditor", "amount"});
        loanBillDS = bankDS.union(nonBankDS);
        loanBillDS = loanBillDS.groupBy((String[])ArrayUtils.addAll((Object[])this.getStatdim(), (Object[])new String[]{"creditor"})).sum("amount", "count").finish();
        return this.nameTransformMD5(loanBillDS);
    }

    private Set<Long> getCreditorIds(DataSet data) {
        HashSet<Long> finIdSet = new HashSet<Long>();
        for (Row r : data.copy()) {
            finIdSet.add(r.getLong("creditorid"));
        }
        return finIdSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn col = new ReportColumn();
        col.setFieldKey(this.getStatdim()[0]);
        col.setFieldType("text");
        col.setZeroShow(true);
        this.setCaption(col, this.getStatdim()[0]);
        columns.add((AbstractReportColumn)col);
        ReportColumn col1 = new ReportColumn();
        col1.setFieldKey(this.getStatdim()[1]);
        col1.setFieldType("text");
        col1.setZeroShow(true);
        this.setCaption(col1, this.getStatdim()[1]);
        columns.add((AbstractReportColumn)col1);
        for (String colMd5 : this.dynamicColList) {
            ReportColumn cols = new ReportColumn();
            cols.setFieldKey(colMd5);
            cols.setFieldType("amount");
            cols.setZeroShow(false);
            cols.setCurrencyField("statcurrency");
            this.setCaption(cols, colMd5, Boolean.TRUE);
            columns.add((AbstractReportColumn)cols);
        }
        return columns;
    }

    private void setCaption(ReportColumn cols, String col) {
        if ("finproductname".equals(col)) {
            cols.setCaption(new LocaleString(ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"LoanSumDataListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0])));
        } else {
            cols.setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"LoanSumDataListPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0])));
        }
        this.setCaption(cols, col, Boolean.FALSE);
    }

    private void setCaption(ReportColumn cols, String col, Boolean isBilledtotal) {
        if (!isBilledtotal.booleanValue()) {
            return;
        }
        if ("billedtotal".equals(col)) {
            cols.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"LoanSumDataListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0])));
        } else {
            String colName = this.creditorKeyToNameMap.get(col.substring(2, col.length()));
            cols.setCaption(new LocaleString(colName == null ? col : colName));
        }
    }
}

