/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class RepaymentDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String LOAN_BASE_FIELDS = "id, org.id as companyid, org.name as company,finproduct.id finproductid, finproduct finproduct, billno, bizdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill.number contractbillno, loancontractbill.contractno contractno, lastrepaydate, loantype, notrepayamount notrepayamt, ";
    private static final String LOAN_FIELDS = "id, org.id as companyid, org.name as company,finproduct.id finproductid, finproduct finproduct, billno, bizdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill.number contractbillno, loancontractbill.contractno contractno, lastrepaydate, loantype, notrepayamount notrepayamt, drawamount,textcreditor as finorginfo, 1 rate";
    private static final String LOAN_SL_FIELDS = "id, org.id as companyid, org.name as company,finproduct.id finproductid, finproduct finproduct, billno, bizdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill.number contractbillno, loancontractbill.contractno contractno, lastrepaydate, loantype, notrepayamount notrepayamt, banksyndicate_entry.e_shareamount drawamount, banksyndicate_entry.e_bank.name as finorginfo, banksyndicate_entry.e_shareamount/drawamount rate";
    private static final String LOAN_BOND_FIELDS = "id, org.id as companyid, org.name as company,finproduct.id finproductid, finproduct finproduct, billno, bizdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill.number contractbillno, loancontractbill.contractno contractno, lastrepaydate, loantype, notrepayamount notrepayamt, drawamount as sumdrawamount, investor_entry.e_investamount drawamount, investor_entry.e_investorname as finorginfo, investor_entry.e_investamount/drawamount rate";
    private static final String AMOUNT_REPYA_FIELDS = ",repayplan_entry.exrepaymentdate as exrepaydate, repayplan_entry.enotrepayamount as examount, 'repay' paymenttype";
    private static final String AMOUNT_INTEREST_FIELDS = ",interest_entry.interesdate as exrepaydate, interest_entry.interestcalamount as examount,'interest' paymenttype";
    private static final String GROUPFIELDS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, contractbillno, contractno, lastrepaydate, loantype, notrepayamt, exrepaydate, examount, paymenttype, sumdrawamount";
    private static final String SELECTFIELDS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, contractbillno, contractno, lastrepaydate, loantype, notrepayamt, drawamount, finorginfo, rate, exrepaydate, examount, paymenttype";
    private String repayDate;
    private String statDim;
    private List<String> yearGroupFields = null;
    private List<String> seasonGroupFields = null;
    private List<String> monthGroupFields = null;

    public DataSet queryDataSet(ReportQueryParam param) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        this.setCustomParam(param, paramMap);
        QFilter baseFilter = RepaymentDataListPlugin.getBaseFilter();
        QFilter filter = baseFilter.and(ReportFilterParamHelper.initCfmReportFilter(paramMap, this.getQueryOrgIds(param)));
        this.initParams(paramMap);
        String[] orderByField = this.getOrderByField(this.statDim);
        DataSet initDataSet = this.queryDataSet(paramMap, filter, orderByField);
        if (initDataSet == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        return initDataSet.addField("TO_CHAR(exrepaydate,'yyyy-MM-dd')", "exrepaydatetext");
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        if (this.statDim.equals("finproductfinorginfo")) {
            dataSet = dataSet.orderBy(new String[]{"finproduct desc", "finorginfo", "year", this.sumField, "season", "seasonsort", "month", "monthsort", "exrepaydate", "billno"});
        } else if (this.statDim.equals("finproductfinorgcomp")) {
            dataSet = dataSet.orderBy(new String[]{"finproduct desc", "finorginfo", "company", "year", this.sumField, "season", "seasonsort", "month", "monthsort", "exrepaydate", "billno"});
        } else {
            String groupFields = "company".equals(this.statDim) ? "company" : "finorginfo";
            dataSet = dataSet.orderBy(new String[]{groupFields + " desc", "year", this.sumField, "season", "seasonsort", "month", "monthsort", "exrepaydate", "billno"});
        }
        dataSet = dataSet.addFields(new String[]{"currencyid", "statcurrency"}, new String[]{"cny_original", "cny"});
        return dataSet.updateField("exrepaydatetext", "case when exrepaydatetext is null then paymenttype else exrepaydatetext end");
    }

    private void initParams(Map<String, Object> paramMap) {
        this.statDim = (String)paramMap.get("statdim");
        this.repayDate = (String)paramMap.get("repaydateranges");
        if ("finproductfinorginfo".equals(this.statDim)) {
            this.yearGroupFields = Arrays.asList("finproduct", "finorginfo", "year");
            this.seasonGroupFields = Arrays.asList("finproduct", "finorginfo", "year", "season");
            this.monthGroupFields = Arrays.asList("finproduct", "finorginfo", "year", "season", "month");
        } else if ("finproductfinorgcomp".equals(this.statDim)) {
            this.yearGroupFields = Arrays.asList("finproduct", "finorginfo", "company", "year");
            this.seasonGroupFields = Arrays.asList("finproduct", "finorginfo", "company", "year", "season");
            this.monthGroupFields = Arrays.asList("finproduct", "finorginfo", "company", "year", "season", "month");
        } else {
            String groupFields = "company".equals(this.statDim) ? "company" : "finorginfo";
            this.yearGroupFields = Arrays.asList(groupFields, "year");
            this.seasonGroupFields = Arrays.asList(groupFields, "year", "season");
            this.monthGroupFields = Arrays.asList(groupFields, "year", "season", "month");
        }
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("examount_original", "drawamount_original", "notrepayamt_original");
    }

    protected String getReportField(String field) {
        return field.split("_")[0];
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    private String[] getOrderByField(String statdim) {
        String[] orderByField = null;
        switch (statdim) {
            case "finproductfinorginfo": {
                orderByField = new String[]{"finproduct", "finorginfo"};
                break;
            }
            case "finproductfinorgcomp": {
                orderByField = new String[]{"finproduct", "finorginfo", "company"};
                break;
            }
            case "company": {
                orderByField = new String[]{"company"};
                break;
            }
            case "finorginfo": {
                orderByField = new String[]{"finorginfo"};
            }
        }
        return orderByField;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowSubTotal = (Boolean)paramMap.get("filter_isshowsubtotal");
        DataSet endDataSet = bizDs = bizDs.addFields(new String[]{"0", "0"}, new String[]{"seasonsort", "monthsort"});
        if (isShowSubTotal.booleanValue()) {
            String subNameField = this.subNameField();
            List<String> sumFields = this.sumAmountFields();
            switch (this.repayDate) {
                case "thismonth": {
                    DataSet dataSetMonth = this.addTotalDataSet(bizDs, this.monthGroupFields, sumFields, subNameField, "month", "0");
                    dataSetMonth = dataSetMonth.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"0", "1"});
                    endDataSet = bizDs.union(dataSetMonth);
                    break;
                }
                case "thisquarter": {
                    DataSet dataSetSeason = this.addTotalDataSet(bizDs, this.seasonGroupFields, sumFields, subNameField, "season", "0");
                    DataSet dataSetMonth = this.addTotalDataSet(bizDs, this.monthGroupFields, sumFields, subNameField, "month", "0");
                    dataSetSeason = dataSetSeason.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"2", "0"});
                    dataSetMonth = dataSetMonth.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"0", "1"});
                    endDataSet = bizDs.union(new DataSet[]{dataSetSeason, dataSetMonth});
                    break;
                }
                case "thisyear": {
                    DataSet dataSetYear = this.addTotalDataSet(bizDs, this.yearGroupFields, sumFields, subNameField, "year", "3");
                    DataSet dataSetSeason = this.addTotalDataSet(bizDs, this.seasonGroupFields, sumFields, subNameField, "season", "0");
                    dataSetYear = dataSetYear.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"0", "0"});
                    dataSetSeason = dataSetSeason.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"2", "0"});
                    endDataSet = bizDs.union(new DataSet[]{dataSetSeason, dataSetYear});
                    break;
                }
                case "nextmonth": {
                    DataSet dataSetMonth = this.addTotalDataSet(bizDs, this.monthGroupFields, sumFields, subNameField, "month", "0");
                    dataSetMonth = dataSetMonth.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"0", "1"});
                    endDataSet = bizDs.union(dataSetMonth);
                    break;
                }
                case "nextweek": 
                case "thisweek": {
                    break;
                }
                case "custom": {
                    DataSet dataSetSeason = this.addTotalDataSet(bizDs, this.seasonGroupFields, sumFields, subNameField, "season", "0");
                    dataSetSeason = dataSetSeason.updateFields(new String[]{"seasonsort", "monthsort"}, new String[]{"2", "0"});
                    endDataSet = bizDs.union(dataSetSeason);
                    break;
                }
            }
        }
        return endDataSet;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowTotal = (Boolean)paramMap.get("filter_isshowtotal");
        if (isShowTotal.booleanValue()) {
            DataSet dataSetSum = this.addTotalDataSet(bizDs.copy().filter("sumlevel=0 and level=1"), Collections.singletonList(this.sumField), this.sumAmountFields(), "paymenttype", "'" + this.getTotalMsg() + "'", "4");
            bizDs = bizDs.union(dataSetSum);
        }
        return bizDs;
    }

    public String sumNameField() {
        return "paymenttype";
    }

    public List<String> sumAmountFields() {
        return Collections.singletonList("examount");
    }

    private DataSet queryDataSet(Map<String, Object> paramMap, QFilter filter, String[] orderByField) {
        DataSet loanBillRepayDs = null;
        DataSet loanBillInterestDs = null;
        if (this.isNeedWarn(paramMap, "payprincipal")) {
            QFilter repayFilter = filter.copy().and(RepaymentDataListPlugin.queryPlanQFilter(paramMap, "repayplan_entry.exrepaymentdate"));
            repayFilter.and(new QFilter("repayplan_entry.enotrepayamount", ">", (Object)0));
            loanBillRepayDs = this.getBillAndEntryDs(paramMap, repayFilter, AMOUNT_REPYA_FIELDS);
        }
        if (this.isNeedWarn(paramMap, "payinterest")) {
            filter = filter.and(RepaymentDataListPlugin.queryPlanQFilter(paramMap, "interest_entry.interesdate"));
            filter.and(new QFilter("interest_entry.intstate", "=", (Object)"0"));
            loanBillInterestDs = this.getBillAndEntryDs(paramMap, filter, AMOUNT_INTEREST_FIELDS);
        }
        DataSet repayAndInterestDs = null;
        repayAndInterestDs = loanBillRepayDs == null ? loanBillInterestDs : (loanBillInterestDs == null ? loanBillRepayDs : loanBillRepayDs.union(loanBillInterestDs));
        if (repayAndInterestDs != null) {
            return repayAndInterestDs.select(new String[]{"concat(concat(TO_CHAR(exrepaydate,'yyyy'),'" + this.getYearstrMsg() + "'),case when MONTH(exrepaydate) >= 1 and MONTH(exrepaydate) <= 3 then '" + this.getQuarterFirstMsg() + "'when MONTH(exrepaydate) >= 4 and MONTH(exrepaydate) <= 6 then '" + this.getQuarterSecMsg() + "'when MONTH(exrepaydate) >= 7 and MONTH(exrepaydate) <= 9 then'" + this.getQuarterThirdMsg() + "'else'" + this.getQuarterForthMsg() + "' end) as season", "concat( TO_CHAR(exrepaydate,'yyyy'),'" + this.getYearTotalMsg() + "')as year", "concat( TO_CHAR(exrepaydate,'yyyy'),'" + this.getYearstrMsg() + "',TO_CHAR(exrepaydate,'MM'),'" + this.getMonthTotalMsg() + "') as month", "id", "companyid", "company", "finorginfo", "finproductid", "finproduct", "currencyid", "currency", "currencyobj", "billno", "drawamount as drawamount_original", "bizdate", "expiredate", "contractbillno", "contractno", "exrepaydate", "examount*rate as examount_original", "notrepayamt*rate notrepayamt_original", "( case when paymenttype='repay' then '" + this.getRepaymentMsg() + "' else '" + this.getInterestMsg() + "' end ) as paymenttype"}).orderBy(orderByField);
        }
        return repayAndInterestDs;
    }

    private DataSet getBillAndEntryDs(Map<String, Object> paramMap, QFilter filter, String fields) {
        QFilter loandTypeFilter;
        QFilter bondCredFilter = TradeFinanceRptHelper.getBondCreditorFilter(paramMap);
        DataSet bondBillDs = QueryServiceHelper.queryDataSet((String)"cfmLoanBill", (String)"cfm_loanbill_bond", (String)(LOAN_BOND_FIELDS + fields), (QFilter[])new QFilter[]{filter, bondCredFilter}, null);
        String otherName = ResManager.loadKDString((String)"\u5176\u5b83", (String)"RepaymentSumDataListPlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String SELECTS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, contractbillno,contractno, lastrepaydate, loantype, notrepayamt, sumdrawamount, exrepaydate, examount, paymenttype,case when drawamount is null then 0 else drawamount end as drawamount, case when rate is null then 0 else rate end as rate, case when finorginfo is null then '" + otherName + "' else finorginfo end as finorginfo";
        bondBillDs = bondBillDs.select(SELECTS.split(","));
        Object creditorId = paramMap.get("filter_creditorid");
        boolean onlyOther = TradeFinanceRptHelper.isOnlyOther(creditorId);
        boolean isOther = TradeFinanceRptHelper.isAddOther(paramMap);
        if (isOther) {
            DataSet otherDS = bondBillDs.copy().filter("rate!=1").groupBy(GROUPFIELDS.split(",")).sum("drawamount").sum("rate").finish().filter("rate!=1 and sumdrawamount!=drawamount");
            otherDS = otherDS.updateField("rate", "1-rate").updateField("drawamount", "sumdrawamount-drawamount").addField("'" + otherName + "'", "finorginfo");
            otherDS = otherDS.select(SELECTS.split(","));
            bondBillDs = onlyOther ? otherDS : bondBillDs.union(otherDS);
        }
        bondBillDs = bondBillDs.filter("drawamount>0").select(SELECTFIELDS.split(","));
        if (Boolean.TRUE.equals(paramMap.get("isloanbillbondonly"))) {
            return bondBillDs;
        }
        QFilter credFilter = TradeFinanceFilterHelper.initCriditorFilter(paramMap);
        DataSet flLoanBillDs = null;
        if (!onlyOther) {
            loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.FINLEASE.getValue());
            flLoanBillDs = QueryServiceHelper.queryDataSet((String)"cfmLoanBill", (String)"cfm_loanbill", (String)(LOAN_FIELDS + fields), (QFilter[])new QFilter[]{filter, loandTypeFilter, credFilter}, null);
            if (Boolean.TRUE.equals(paramMap.get("isloanbillflonly"))) {
                return flLoanBillDs;
            }
        }
        loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.BANKLOAN.getValue());
        QFilter loanFilter = loandTypeFilter.copy();
        if (onlyOther) {
            loanFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.OTHER.getValue()));
        }
        DataSet loanBillDs = null;
        if (!TradeFinanceRptHelper.isOnlyOther(creditorId)) {
            loanBillDs = QueryServiceHelper.queryDataSet((String)"cfmLoanBill", (String)"cfm_loanbill", (String)(LOAN_FIELDS + fields), (QFilter[])new QFilter[]{filter, loanFilter, credFilter}, null);
        }
        DataSet slBillDs = null;
        if (!onlyOther) {
            QFilter slCredFilter = TradeFinanceRptHelper.getSlCreditorFilter(paramMap);
            slBillDs = QueryServiceHelper.queryDataSet((String)"cfmLoanBill", (String)"cfm_loanbill", (String)(LOAN_SL_FIELDS + fields), (QFilter[])new QFilter[]{filter, slCredFilter}, null);
        }
        DataSet resData = bondBillDs;
        if (loanBillDs != null && !loanBillDs.isEmpty()) {
            resData = resData.union(loanBillDs);
        }
        if (slBillDs != null && !slBillDs.isEmpty()) {
            resData = resData.union(slBillDs);
        }
        if (flLoanBillDs != null && !flLoanBillDs.isEmpty()) {
            resData = resData.union(flLoanBillDs);
        }
        return resData.filter("drawamount>0");
    }

    private boolean isNeedWarn(Map<String, Object> paramMap, String key) {
        String warnings = (String)paramMap.get("warnings");
        if (EmptyUtil.isEmpty((String)warnings)) {
            return true;
        }
        return warnings.contains(key);
    }

    protected DataSet addTotalDataSet(DataSet rowSet, List<String> gruopFields, List<String> sumFields, String sumNameField, String season, String order_str) {
        Field[] fields;
        DataSet dsTemp = rowSet.copy();
        GroupbyDataSet gdsTemp = dsTemp.groupBy(gruopFields.toArray(new String[gruopFields.size()]));
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = rowSet.getRowMeta().getFields()) {
            if (gruopFields.contains(field.getName()) || sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(sumNameField)) {
                selectField.add(season + " as " + field.getName());
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add(order_str + " as " + this.sumField);
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        return ds.select(String.join((CharSequence)",", selectField));
    }

    public static QFilter queryPlanQFilter(Map<String, Object> paramMap, String datefield) {
        QFilter actfilter = null;
        Long actId = (Long)paramMap.get("accountbank");
        if (actId != null && actId.intValue() != 0) {
            actfilter = new QFilter("accountbank", "=", (Object)actId);
        }
        QFilter repayDateFilter = ReportFilterParamHelper.buildDateRangesFilter((String)paramMap.get("repaydateranges"), datefield, "repaydateranges", paramMap);
        return actfilter == null ? repayDateFilter : actfilter.and(repayDateFilter);
    }

    public static QFilter getBaseFilter() {
        QFilter filter = new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue())).and("org", "!=", (Object)0);
        return filter;
    }

    private String getRepaymentMsg() {
        return ResManager.loadKDString((String)"\u507f\u8fd8\u672c\u91d1", (String)"RepaymentDataListPlugin_8", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getYearstrMsg() {
        return ResManager.loadKDString((String)"\u5e74", (String)"RepaymentDataListPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getInterestMsg() {
        return ResManager.loadKDString((String)"\u4ed8\u5229\u606f", (String)"RepaymentDataListPlugin_9", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getQuarterFirstMsg() {
        return ResManager.loadKDString((String)"1\u5b63\u5ea6\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_12", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getQuarterSecMsg() {
        return ResManager.loadKDString((String)"2\u5b63\u5ea6\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getQuarterThirdMsg() {
        return ResManager.loadKDString((String)"3\u5b63\u5ea6\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_14", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getQuarterForthMsg() {
        return ResManager.loadKDString((String)"4\u5b63\u5ea6\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_21", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getYearTotalMsg() {
        return ResManager.loadKDString((String)"\u5e74\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_16", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getMonthTotalMsg() {
        return ResManager.loadKDString((String)"\u6708\u5c0f\u8ba1", (String)"RepaymentDataListPlugin_18", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getTotalMsg() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"RepaymentDataListPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private void setCustomParam(ReportQueryParam param, Map<String, Object> paramMap) {
        Map customParam = param.getCustomParam();
        if (customParam.containsKey("isloanbillbondonly")) {
            paramMap.put("isloanbillbondonly", customParam.get("isloanbillbondonly"));
        } else if (customParam.containsKey("isloanbillflonly")) {
            paramMap.put("isloanbillflonly", customParam.get("isloanbillflonly"));
        }
    }
}

