/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang.StringUtils;

public class RepaymentSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String LOAN_BASE_FIELDS = "id, org.id as companyid, org.name as company, finproduct.id finproductid, finproduct.name finproduct, billno, bizdate, expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill, lastrepaydate,loantype,";
    private static final String LOAN_FIELDS = "id, org.id as companyid, org.name as company, finproduct.id finproductid, finproduct.name finproduct, billno, bizdate, expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill, lastrepaydate,loantype,drawamount,textcreditor as creditorname, creditor as creditorid, 1 rate, creditortype";
    private static final String LOAN_SL_FIELDS = "id, org.id as companyid, org.name as company, finproduct.id finproductid, finproduct.name finproduct, billno, bizdate, expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill, lastrepaydate,loantype,banksyndicate_entry.e_shareamount drawamount, banksyndicate_entry.e_bank.name as creditorname, case when banksyndicate_entry.e_bank >0  then banksyndicate_entry.e_bank else banksyndicate_entry.id end creditorid, banksyndicate_entry.e_shareamount/drawamount rate, banksyndicate_entry.e_bank.finorgtype.type creditortype";
    private static final String LOAN_BOND_FIELDS = "id, org.id as companyid, org.name as company, finproduct.id finproductid, finproduct.name finproduct, billno, bizdate, expiredate, currency.id currencyid, currency.name currency, currency currencyobj, loancontractbill, lastrepaydate,loantype,drawamount as sumdrawamount, investor_entry.e_investamount drawamount, investor_entry.e_investorname as creditorname, case when investor_entry.e_investorid >0 then investor_entry.e_investorid else investor_entry.id end creditorid, investor_entry.e_investamount/drawamount rate, investor_entry.e_investortype creditortype";
    private static final String AMOUNT_REPYA_FIELDS = ",repayplan_entry.exrepaymentdate as exrepaydate, repayplan_entry.enotrepayamount as examount, 'repay' paymenttype";
    private static final String AMOUNT_INTEREST_FIELDS = ",interest_entry.interesdate as exrepaydate, interest_entry.interestcalamount as examount,'interest' paymenttype";
    private static final String[] SUBTOTALGROUPBYFIELDS_COM = new String[]{"company", "currency"};
    private static final String[] SUBTOTALGROUPBYFIELDS_CRE = new String[]{"creditorname", "currency"};
    private static final String[] SUBTOTALGROUPBYFIELDS_FIN = new String[]{"finproductid", "creditorname", "currency"};
    private static final String[] SUBTOTALGROUPBYFIELDS_FINCRECOM = new String[]{"finproductid", "creditorname", "company", "currency"};
    private static final String GROUPFIELDS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, loancontractbill, lastrepaydate, loantype, exrepaydate, examount, paymenttype, sumdrawamount";
    private static final String SELECTFIELDS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, loancontractbill, lastrepaydate, loantype, drawamount, creditorname, creditorid, rate, creditortype, exrepaydate, examount, paymenttype";
    private String statDim;
    private String sumNameField;
    private String[] subTotalGroupByFields;
    private String[] orderBys;
    private static final Long DEFAULTORGVIEWID = 8L;

    public DataSet queryDataSet(ReportQueryParam param) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        this.setCustomParam(param, paramMap);
        QFilter baseFilter = RepaymentSumDataListPlugin.getBaseFilter();
        QFilter filter = baseFilter.and(ReportFilterParamHelper.initCfmReportFilter(paramMap, this.getQueryOrgIds(param)));
        this.initParams(paramMap);
        String[] orderByField = this.getOrderByField(this.statDim);
        DataSet initDataSet = this.queryDataSet(paramMap, filter, orderByField);
        if (initDataSet == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        String bankLevel = (String)paramMap.get("banklevel");
        if ("1".equals(bankLevel) && !"companycny".equals(this.statDim)) {
            initDataSet = TradeFinanceRptHelper.transToBankCate(initDataSet);
            DataSet loanBillBankds = initDataSet.copy().filter("creditortype='bank'");
            HashSet<Long> bankIds = new HashSet<Long>(16);
            loanBillBankds.copy().forEach(bank -> bankIds.add(bank.getLong("creditorid")));
            DataSet bankDs = TradeFinanceRptHelper.getBankDs(bankIds);
            initDataSet = initDataSet.leftJoin(bankDs).on("creditorid", "bankid").select(initDataSet.getRowMeta().getFieldNames(), new String[]{"bankcgid"}).finish().updateField("creditorid", "case when bankcgid!=null then bankcgid else creditorid end");
        }
        return this.getSumDataSet(initDataSet, this.statDim);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String showType = (String)paramMap.get("filter_showttype");
        String statDim = (String)paramMap.get("statdim");
        if (!"step".equals(showType) || !"companycny".equals(statDim)) {
            return this.addDetail(dataSet);
        }
        dataSet = dataSet.addField("'0'", "isgroupnode");
        DataSet totalDs = this.addSumRowDataSetLocal(dataSet, paramMap);
        dataSet = this.getTreeDs(dataSet, queryParam);
        if (totalDs != null && !totalDs.isEmpty()) {
            totalDs = totalDs.updateFields(new String[]{"pid", "isgroupnode"}, new String[]{"0", "'0'"}).updateField("rowid", String.valueOf(DBServiceHelper.genGlobalLongId())).select(dataSet.getRowMeta().getFieldNames());
            dataSet = dataSet.union(totalDs);
        }
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        dataSet = dataSet.updateField("statcurrency", String.valueOf(tarCurrencyId));
        return this.addDetail(dataSet);
    }

    private DataSet getTreeDs(DataSet dataSet, ReportQueryParam queryParam) {
        DataSet companyCountDs;
        DataSet oneRowDs;
        dataSet = dataSet.filter("companyid is not null");
        DataSet orgDataSet = this.getOrgTreeView(queryParam);
        DataSet orgBaseDs = this.getOrgDataDs(orgDataSet, dataSet);
        DataSet orgDs = this.getSumDataSetByLevel(orgBaseDs.copy(), this.sumAmountFields(), "company,companyid,currencyid,currency,creditorname,creditorid,amount,tarcurrency,rate,statcurrency").filter("examount>0");
        dataSet = this.getDsUpdataRowid(dataSet, null).updateField("pid", "companyid");
        Set<Long> companyIds = this.getDataIds(dataSet.copy().groupBy(new String[]{"companyid"}).finish(), "companyid");
        Set<Long> orgPids = this.getDataIds(orgDs.copy().filter("rowid in (" + StringUtils.join(companyIds, (String)",") + ")"), "pid");
        orgPids.retainAll(companyIds);
        DataSet downOrgDataDs = null;
        if (orgPids.size() > 0) {
            downOrgDataDs = orgBaseDs.copy().filter("companyid in (" + StringUtils.join(orgPids, (String)",") + ")").updateField("pid", "companyid");
            downOrgDataDs = this.getDsUpdataRowid(downOrgDataDs, null);
        }
        if (downOrgDataDs != null) {
            orgDs = orgDs.union(downOrgDataDs.copy().select(orgDs.getRowMeta().getFieldNames()));
        }
        if (orgPids.size() > 0) {
            DataSet downDataSet = dataSet.copy().filter("companyid in (" + StringUtils.join(orgPids, (String)",") + ")");
            downDataSet = downDataSet.leftJoin(downOrgDataDs).on("companyid", "pid").select(downDataSet.getRowMeta().getFieldNames(), new String[]{"rowid newpid"}).finish().updateField("pid", "newpid").removeFields(new String[]{"newpid"});
            dataSet = dataSet.filter("companyid not in (" + StringUtils.join(orgPids, (String)",") + ")");
            dataSet = dataSet.union(downDataSet);
        }
        if (!(oneRowDs = (companyCountDs = dataSet.copy().groupBy(new String[]{"pid"}).count().finish()).filter("count=1")).isEmpty()) {
            Set<Long> oneCompanyIds = this.getDataIds(oneRowDs, "pid");
            oneRowDs = dataSet.filter("pid in (" + StringUtils.join(oneCompanyIds, (String)",") + ")");
            DataSet oneOrgDs = orgDs.filter("rowid in (" + StringUtils.join(oneCompanyIds, (String)",") + ")");
            oneRowDs = oneOrgDs.leftJoin(oneRowDs).on("rowid", "pid").select(new String[]{"cast(rowid as String) newrowid", "pid newpid", "isgroupnode newisgroupnode"}, oneRowDs.getRowMeta().getFieldNames()).finish().updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{"newrowid", "newpid", "newisgroupnode"}).removeFields(new String[]{"newrowid", "newpid", "newisgroupnode"});
            dataSet = dataSet.filter("pid not in (" + StringUtils.join(oneCompanyIds, (String)",") + ")");
            orgDs = orgDs.filter("rowid not in (" + StringUtils.join(oneCompanyIds, (String)",") + ")");
            dataSet = dataSet.union(oneRowDs);
            Set<Long> orgPIds = this.getDataIds(dataSet, "pid");
            if (EmptyUtil.isNoEmpty(orgPids)) {
                String levelStr = "case when rowid in (" + StringUtils.join(orgPIds, (String)",") + ") then '1' else '0' end";
                dataSet = dataSet.updateFields(new String[]{"isgroupnode"}, new String[]{levelStr});
            } else {
                dataSet = dataSet.updateField("isgroupnode", "'0'");
            }
        }
        orgDs = orgDs.select(dataSet.getRowMeta().getFieldNames()).updateField("rowid", "cast(rowid as Long)");
        return dataSet.updateField("rowid", "cast(rowid as Long)").union(orgDs).orderBy(new String[]{"companyid"});
    }

    private DataSet getOrgTreeView(ReportQueryParam queryParam) {
        DataSet orgDataSet;
        List orgIds = this.getQueryOrgIds(queryParam);
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String queryWay = (String)paramMap.get("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)DEFAULTORGVIEWID).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
        } else {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView.getLong("id")).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
        }
        return orgDataSet;
    }

    private DataSet getOrgDataDs(DataSet orgDataSet, DataSet dataSet) {
        Set<Long> orgRowIds = this.getDataIds(orgDataSet, "rowid");
        String pidStr = "case when pid in (" + StringUtils.join(orgRowIds, (String)",") + ") then pid else 0 end";
        orgDataSet = orgDataSet.updateFields(new String[]{"pid"}, new String[]{pidStr});
        Set<Long> orgPIds = this.getDataIds(orgDataSet, "pid");
        Set<Long> companyids = this.getDataIds(dataSet.copy().groupBy(new String[]{"companyid"}).finish(), "companyid");
        orgPIds.addAll(companyids);
        String levelStr = "case when rowid in (" + StringUtils.join(orgPIds, (String)",") + ") then '1' else '0' end";
        orgDataSet = orgDataSet.updateFields(new String[]{"isgroupnode"}, new String[]{levelStr});
        DataSet dataSetGroup = dataSet.copy().groupBy(new String[]{"companyid", "statcurrency"}).sum("examount").finish();
        DataSet orgDs = orgDataSet.leftJoin(dataSetGroup).on("rowid", "companyid").select(new String[]{"rowid", "orgname company", "isgroupnode", "pid", "level"}, new String[]{"companyid", "statcurrency", "examount"}).finish().addNullField(new String[]{"currencyid", "currency", "creditorname", "creditorid", "amount", "tarcurrency", "rate", "sumlevel"});
        return orgDs;
    }

    private DataSet getDsUpdataRowid(DataSet dataSet, Map<Long, Long> pidToRowidMap) {
        final RowMeta rowMeta = dataSet.getRowMeta();
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : rowMeta.getFieldNames()) {
                    if ("rowid".equals(fieldName)) {
                        rowInfo.add(DBServiceHelper.genGlobalLongId());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return dataSet;
    }

    private Set<Long> getDataIds(DataSet dataSet, String field) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Row row : dataSet.copy()) {
            if (!EmptyUtil.isNoEmpty((Long)row.getLong(field))) continue;
            ids.add(row.getLong(field));
        }
        return ids;
    }

    protected DataSet addSumRowDataSetLocal(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowTotal = (Boolean)paramMap.get("filter_isshowtotal");
        if (isShowTotal.booleanValue()) {
            String sumNameField = this.sumNameField();
            DataSet totalDs = this.addAllTotalDataSet(bizDs, this.sumAmountFields(), Collections.singletonList("statcurrency"), sumNameField);
            return totalDs;
        }
        return null;
    }

    private void initParams(Map<String, Object> paramMap) {
        switch (this.statDim = (String)paramMap.get("statdim")) {
            case "companycny": {
                this.sumNameField = "creditorname";
                this.subTotalGroupByFields = SUBTOTALGROUPBYFIELDS_COM;
                this.orderBys = new String[]{"company desc", "currency", this.sumField};
                break;
            }
            case "creditorcny": {
                this.sumNameField = "company";
                this.subTotalGroupByFields = SUBTOTALGROUPBYFIELDS_CRE;
                this.orderBys = new String[]{"creditorname desc", "currency", this.sumField};
                break;
            }
            case "finprocreditorcny": {
                this.sumNameField = "currency";
                this.subTotalGroupByFields = SUBTOTALGROUPBYFIELDS_FIN;
                this.orderBys = new String[]{"finproductid desc", "creditorname", "currency", this.sumField};
                break;
            }
            case "finprocreditorcompcny": {
                this.sumNameField = "currency";
                this.subTotalGroupByFields = SUBTOTALGROUPBYFIELDS_FINCRECOM;
                this.orderBys = new String[]{"finproductid desc", "creditorname", "company", "currency", this.sumField};
                break;
            }
        }
    }

    protected List<String> orinalAmountField() {
        return Collections.singletonList("amount");
    }

    public String sumNameField() {
        return this.sumNameField;
    }

    public List<String> sumAmountFields() {
        return Collections.singletonList("examount");
    }

    public List<String> groupFields() {
        return new ArrayList<String>(Arrays.asList(this.subTotalGroupByFields));
    }

    public List<String> orderByFields() {
        return Arrays.asList(this.orderBys);
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    protected String getReportField(String field) {
        return "examount";
    }

    private String[] getOrderByField(String statdim) {
        String[] orderByField = null;
        switch (statdim) {
            case "companycny": {
                orderByField = new String[]{"company"};
                break;
            }
            case "creditorcny": {
                orderByField = new String[]{"creditorname"};
                break;
            }
            case "finprocreditorcny": {
                orderByField = new String[]{"finproduct", "creditorname"};
                break;
            }
            case "finprocreditorcompcny": {
                orderByField = new String[]{"finproduct", "creditorname", "company"};
                break;
            }
        }
        return orderByField;
    }

    private DataSet queryDataSet(Map<String, Object> paramMap, QFilter filter, String[] orderByField) {
        DataSet repayAndInterestDs;
        DataSet loanBillRepayDs = null;
        DataSet loanBillInterestDs = null;
        if (this.isNeedWarn(paramMap, "payprincipal")) {
            QFilter repayFilter = filter.copy().and(RepaymentSumDataListPlugin.queryPlanQFilter(paramMap, "repayplan_entry.exrepaymentdate"));
            repayFilter.and(new QFilter("repayplan_entry.enotrepayamount", ">", (Object)0));
            loanBillRepayDs = this.getBillAndEntryDs(paramMap, repayFilter, AMOUNT_REPYA_FIELDS);
        }
        if (this.isNeedWarn(paramMap, "payinterest")) {
            filter = filter.and(RepaymentSumDataListPlugin.queryPlanQFilter(paramMap, "interest_entry.interesdate"));
            filter.and(new QFilter("interest_entry.intstate", "=", (Object)"0"));
            loanBillInterestDs = this.getBillAndEntryDs(paramMap, filter, AMOUNT_INTEREST_FIELDS);
        }
        if ((repayAndInterestDs = loanBillRepayDs == null ? loanBillInterestDs : (loanBillInterestDs == null ? loanBillRepayDs : loanBillRepayDs.union(loanBillInterestDs))) == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        DataSet ds = repayAndInterestDs.select(new String[]{"id", "companyid", "company", "creditorname", "creditorid", "finproductid", "finproduct", "currencyid", "currency", "currencyobj ", "billno", "bizdate", "expiredate", "loancontractbill", "exrepaydate", "examount*rate as examount", "( case when paymenttype='repay' then '" + this.getRepaymentMsg() + "' else '" + this.getInterestMsg() + "' end ) as paymenttype", "creditortype"}).orderBy(orderByField);
        if (loanBillRepayDs != null) {
            loanBillRepayDs.close();
        }
        if (loanBillInterestDs != null) {
            loanBillInterestDs.close();
        }
        repayAndInterestDs.close();
        return ds;
    }

    private DataSet getBillAndEntryDs(Map<String, Object> paramMap, QFilter filter, String fields) {
        String algoKey = ((Object)((Object)this)).getClass().getName();
        QFilter loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.BOND.getValue());
        QFilter bondCredFilter = TradeFinanceRptHelper.getBondCreditorFilter(paramMap);
        DataSet bondBillDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloanbond"), (String)"cfm_loanbill_bond", (String)(LOAN_BOND_FIELDS + fields), (QFilter[])new QFilter[]{filter, loandTypeFilter, bondCredFilter}, null);
        String otherName = ResManager.loadKDString((String)"\u5176\u5b83", (String)"RepaymentSumDataListPlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]);
        String SELECTS = "id, companyid, company, finproductid, finproduct, billno, bizdate, expiredate, currencyid, currency, currencyobj, loancontractbill, lastrepaydate, loantype, sumdrawamount, case when drawamount is null then 0 else drawamount end drawamount, creditorid, creditortype, exrepaydate, examount, paymenttype, case when rate is null then 0 else rate end as rate,creditorname";
        bondBillDs = bondBillDs.select(SELECTS.split(","));
        DataSet otherDS = null;
        if (TradeFinanceRptHelper.isAddOther(paramMap)) {
            otherDS = bondBillDs.copy().filter("rate!=1").groupBy(GROUPFIELDS.split(",")).sum("drawamount").sum("rate").finish().filter("rate!=1 and sumdrawamount!=drawamount");
            otherDS = otherDS.updateField("rate", "1-rate").updateField("drawamount", "sumdrawamount-drawamount");
            otherDS = otherDS.addField("'" + otherName + "'", "creditorname").addField("1", "creditorid").addField("null", "creditortype");
            otherDS = otherDS.select(SELECTS.split(","));
        }
        bondBillDs = bondBillDs.filter("rate!=0");
        if (otherDS != null) {
            bondBillDs = bondBillDs.union(otherDS);
        }
        bondBillDs = bondBillDs.select(SELECTFIELDS.split(","));
        if (Boolean.TRUE.equals(paramMap.get("isloanbillbondonly"))) {
            return bondBillDs;
        }
        QFilter credFilter = TradeFinanceFilterHelper.initCriditorFilter(paramMap);
        loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.FINLEASE.getValue());
        DataSet flLoanBillDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloan"), (String)"cfm_loanbill", (String)(LOAN_FIELDS + fields), (QFilter[])new QFilter[]{filter, loandTypeFilter, credFilter}, null);
        if (Boolean.TRUE.equals(paramMap.get("isloanbillflonly"))) {
            return flLoanBillDs;
        }
        loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.BANKLOAN.getValue());
        DataSet loanBillDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloan"), (String)"cfm_loanbill", (String)(LOAN_FIELDS + fields), (QFilter[])new QFilter[]{filter, loandTypeFilter, credFilter}, null);
        loandTypeFilter = ReportFilterParamHelper.getLoandTypeFilter(LoanTypeEnum.BANKSLOAN.getValue());
        QFilter slCredFilter = TradeFinanceRptHelper.getSlCreditorFilter(paramMap);
        DataSet slBillDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloansl"), (String)"cfm_loanbill", (String)(LOAN_SL_FIELDS + fields), (QFilter[])new QFilter[]{filter, loandTypeFilter, slCredFilter}, null);
        if (!slBillDs.isEmpty()) {
            loanBillDs = loanBillDs.union(slBillDs.updateField("creditortype", "case when creditortype='0' then 'bank' else 'finorg' end"));
        }
        if (!bondBillDs.isEmpty()) {
            loanBillDs = loanBillDs.union(bondBillDs);
        }
        if (!flLoanBillDs.isEmpty()) {
            loanBillDs = loanBillDs.union(flLoanBillDs);
        }
        return loanBillDs;
    }

    private boolean isNeedWarn(Map<String, Object> paramMap, String key) {
        String warnings = (String)paramMap.get("warnings");
        if (EmptyUtil.isEmpty((String)warnings)) {
            return true;
        }
        return warnings.contains(key);
    }

    private DataSet getSumDataSet(DataSet dataSet, String statdim) {
        dataSet = "finprocreditorcny".equals(statdim) ? dataSet.copy().groupBy(new String[]{"currencyid", "currency", "creditorname", "creditorid", "finproductid", "finproduct"}).sum("examount", "amount").finish() : ("finprocreditorcompcny".equals(statdim) ? dataSet.copy().groupBy(new String[]{"companyid", "company", "currencyid", "currency", "creditorname", "creditorid", "finproductid", "finproduct"}).sum("examount", "amount").finish() : dataSet.copy().groupBy(new String[]{"companyid", "company", "currencyid", "currency", "creditorname", "creditorid"}).sum("examount", "amount").finish());
        return dataSet;
    }

    public static QFilter queryPlanQFilter(Map<String, Object> paramMap, String datefield) {
        QFilter actfilter = null;
        Long actId = (Long)paramMap.get("accountbank");
        if (actId != null && actId.intValue() != 0) {
            actfilter = new QFilter("accountbank", "=", (Object)actId);
        }
        QFilter repayDateFilter = ReportFilterParamHelper.buildDateRangesFilter((String)paramMap.get("repaydateranges"), datefield, "repaydateranges", paramMap);
        return actfilter == null ? repayDateFilter : actfilter.and(repayDateFilter);
    }

    public static QFilter getBaseFilter() {
        QFilter filter = new QFilter("drawtype", "=", (Object)DrawTypeEnum.DRAWED.getValue()).or(new QFilter("drawtype", "=", (Object)DrawTypeEnum.PARTPAYMENT.getValue()));
        return filter;
    }

    private String getRepaymentMsg() {
        return ResManager.loadKDString((String)"\u507f\u8fd8\u672c\u91d1", (String)"RepaymentSumDataListPlugin_1", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private String getInterestMsg() {
        return ResManager.loadKDString((String)"\u4ed8\u5229\u606f", (String)"RepaymentSumDataListPlugin_2", (String)"tmc-cfm-report", (Object[])new Object[0]);
    }

    private void setCustomParam(ReportQueryParam param, Map<String, Object> paramMap) {
        Map customParam = param.getCustomParam();
        if (customParam.containsKey("isloanbillbondonly")) {
            paramMap.put("isloanbillbondonly", customParam.get("isloanbillbondonly"));
        } else if (customParam.containsKey("isloanbillflonly")) {
            paramMap.put("isloanbillflonly", customParam.get("isloanbillflonly"));
        }
        String showType = (String)paramMap.get("filter_showttype");
        String statDim = (String)paramMap.get("statdim");
        if ("step".equals(showType) && "companycny".equals(statDim)) {
            param.getFilter().addFilterItem("filter_isshowsubtotal", (Object)false);
        }
    }

    public DataSet addDetail(DataSet resultDS) {
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"RepaymentSumDataListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]);
        resultDS = resultDS.addField("case when (sumlevel = 0 or sumlevel=null) then '" + lvalue + "' else '' end as detail", "detail");
        return resultDS;
    }
}

