/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class TradeFinanceDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    protected static final String LOANBILL_FORM_PROPS = "id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, textcreditor as fincreditorname,creditortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype,loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate";
    protected static final String BOND_FORM_PROPS = "investor_entry.id as id, id as loanbillid, '' as summarycol, 0 as findebtslevel, org.id as orgid, org.name as fincompanyname, bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno,finproduct.name as finproductname,investor_entry.e_investorname as fincreditorname, investor_entry.e_investortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,'' as creditortype, investor_entry.id as creditorid, currency as loancurrency,currency.name as loancurrencyname,investor_entry.e_investamount as drawamount,drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt, interesttype, '' as contractbillno, '' as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt,settleintmode, repaymentway,term,basis,cleardate";
    protected static final String BANK_TEAM_PROPS = "banksyndicate_entry.id as id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname,banksyndicate_entry.e_bank.name as fincreditorname,'bank' as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,banksyndicate_entry.e_bank.finorgtype.type as creditortype,banksyndicate_entry.e_bank.id as creditorid, currency as loancurrency, currency.name as loancurrencyname, banksyndicate_entry.e_shareamount as drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype, loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate";
    protected static final String[] COMMON_GROUP_PROPS = new String[]{"loanbillid", "summarycol", "orgid", "fincompanyname", "drawdate", "expiredate", "loanbillno", "finproductname", "loantype", "amount", "estinterestamt", "creditortype", "loancurrency", "loancurrencyname", "drawamount1", "interesttype", "contractbillno", "contractno", "concurrency", "guaranteeway", "contractamt", "settleintmode", "repaymentway", "term", "basis", "cleardate"};
    private static final String FILEDS = "id loanbillid,'' as summarycol,org.id as orgid,org.name as fincompanyname,'' as fincreditortype,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,billno as loanbillno,finproduct.name as finproductname,loantype,amount,payinterestamount+calculaterateamount estinterestamt,'' as creditortype,currency as loancurrency,currency.name as loancurrencyname,drawamount as drawamount1,interesttype, '' as contractbillno, '' as contractno,loancontractbill.currency as concurrency,loancontractbill.guarantee as guaranteeway,drawamount as contractamt,settleintmode,repaymentway,0 as drawamount,term,basis,cleardate";
    protected static final String[] AMOUNT_SUM_FIELDS = new String[]{"drawamount_statccy", "unpaidamt_statccy", "unpaidintamt_statccy", "paidamt_statccy", "estinterestamt_statccy", "paidintamt_statccy", "feeamt_statccy", "compamt_statccy"};
    private static final String CUST_FIELD_SUFFIX = "_ek";
    protected Date cutoffdate;
    protected List<String> groupFields = new ArrayList<String>(10);
    private static final Log logger = LogFactory.getLog(TradeFinanceDataListPlugin.class);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        this.initParams(paramMap);
        DataSet loanBillDS = this.queryLoanBillDS(queryParam, paramMap);
        if (TradeFinanceRptHelper.isAddOther(paramMap)) {
            DataSet extraLoanBillDs = this.addExtraLoanBillDs(loanBillDS.copy().filter("loantype='bond'"), queryParam, paramMap);
            loanBillDS = TradeFinanceRptHelper.isOnlyOther(paramMap.get("filter_creditorid")) ? extraLoanBillDs : loanBillDS.union(extraLoanBillDs);
        }
        if (loanBillDS.isEmpty()) {
            return TradeFinanceRptHelper.createEmptyDS();
        }
        if (TradeFinanceRptHelper.isOther(paramMap.get("filter_creditorid"))) {
            loanBillDS = loanBillDS.filter("fincreditortype='other'");
        }
        List<Long> loanBillIds = TradeFinanceFilterHelper.getloanBillIds(loanBillDS, "loanbillid");
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DataSet repaymentDS = TradeFinanceFilterHelper.repaymentDs(loanBillDS, this.cutoffdate);
        loanBillDS = this.getLoanAndRepaymentDs(loanBillDS, repaymentDS);
        DataSet interestDS = TradeFinanceFilterHelper.interestDS(loanBillIds, this.cutoffdate, clazz);
        loanBillDS = this.getLoanAndInterestDs(loanBillDS, interestDS);
        loanBillDS = loanBillDS.updateField("estinterestamt", "case when estinterestamt is null then 0 else estinterestamt end").updateField("estinterestamt", "case when loantype in ('sl', 'bond') then estinterestamt*(drawamount/drawamount1) else estinterestamt end");
        loanBillDS = loanBillDS.addField("estinterestamt-paidintamt", "unpaidintamt").updateField("unpaidintamt", "case when unpaidintamt>=0 then unpaidintamt else 0 end");
        DataSet interestRateDS = TradeFinanceFilterHelper.interestRateDS(loanBillIds, this.cutoffdate, clazz);
        loanBillDS = loanBillDS.leftJoin(interestRateDS).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"intrate"}).finish();
        loanBillDS = this.addFeeAmtDs(loanBillDS, loanBillIds);
        return loanBillDS;
    }

    protected void initParams(Map<String, Object> paramMap) {
        this.cutoffdate = ReportCommonHelper.getCutOffDate(paramMap);
        String statDim = (String)paramMap.get("filter_statdim");
        this.groupFields = this.getGroupFieldByDim(statDim);
    }

    protected String getCurrencyField() {
        return "loancurrency";
    }

    protected Date getExChangeEffectdate() {
        return DateUtils.truncateDate((Date)(this.cutoffdate == null ? DateUtils.getCurrentDate() : this.cutoffdate));
    }

    public List<String> orderByFields() {
        List orderByField = super.orderByFields();
        orderByField.add("findebtslevel");
        orderByField.add("drawdate");
        return orderByField;
    }

    public String subNameField() {
        return "term";
    }

    public String sumNameField() {
        return "term";
    }

    public List<String> groupFields() {
        return new ArrayList<String>(this.groupFields);
    }

    public List<String> sumAmountFields() {
        return Arrays.asList(AMOUNT_SUM_FIELDS);
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("contractamt", "drawamount", "unpaidamt", "unpaidintamt", "paidamt", "estinterestamt", "paidintamt", "feeamt", "compamt");
    }

    protected String getReportField(String field) {
        return field + "_statccy";
    }

    protected DataSet queryLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap) {
        String lenderNature;
        List<String> extendedColumns = this.getExtendedColumnKeys(queryParam);
        String extendSelectProps = this.createExtendedColumnSelectStr(extendedColumns);
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter loanBillQFilter = TradeFinanceFilterHelper.loanBillQFilter(paramMap, orgIds);
        ReportFilterParamHelper.addExtFilter(paramMap, loanBillQFilter);
        loanBillQFilter.and(new QFilter("debtortype", "not in", Arrays.asList("custom", "other")));
        QFilter slQFilter = loanBillQFilter.copy();
        QFilter bondQFilter = loanBillQFilter.copy();
        QFilter flQFilter = loanBillQFilter.copy();
        loanBillQFilter.and(TradeFinanceFilterHelper.initCriditorFilter(paramMap));
        loanBillQFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, loanBillQFilter);
        QFilter loanQFilter = loanBillQFilter.copy();
        String selectProps = "";
        ArrayList<DataSet> dataDS = new ArrayList<DataSet>();
        String dataSource = paramMap.get("filter_datasource").toString();
        if (dataSource.contains(LoanTypeEnum.BOND.getValue()) && (lenderNature = (String)paramMap.get("filter_lendernature")).contains("outgroup")) {
            QFilter bondTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter(LoanTypeEnum.BOND.getValue());
            bondQFilter.and(bondTypeFilter);
            QFilter bondCredFilter = TradeFinanceRptHelper.getBondCreditorFilter(paramMap);
            bondQFilter.and(bondCredFilter);
            selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? BOND_FORM_PROPS : "investor_entry.id as id, id as loanbillid, '' as summarycol, 0 as findebtslevel, org.id as orgid, org.name as fincompanyname, bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno,finproduct.name as finproductname,investor_entry.e_investorname as fincreditorname, investor_entry.e_investortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,'' as creditortype, investor_entry.id as creditorid, currency as loancurrency,currency.name as loancurrencyname,investor_entry.e_investamount as drawamount,drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt, interesttype, '' as contractbillno, '' as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt,settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
            DataSet bondDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill_bond", (String)selectProps, (QFilter[])bondQFilter.toArray(), null);
            dataDS.add(bondDS);
        }
        if (dataSource.contains("fl")) {
            flQFilter.and(TradeFinanceFilterHelper.initCriditorFilter(paramMap));
            flQFilter.and(new QFilter("loantype", "=", (Object)LoanTypeEnum.FINLEASE.getValue()));
            flQFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, flQFilter);
            selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? LOANBILL_FORM_PROPS : "id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, textcreditor as fincreditorname,creditortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype,loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
            DataSet flDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)selectProps, (QFilter[])flQFilter.toArray(), null);
            dataDS.add(flDS);
        }
        if (dataSource.contains("entrustloan")) {
            loanBillQFilter.and(new QFilter("loantype", "in", Arrays.asList("entrust", "ec")));
            selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? LOANBILL_FORM_PROPS : "id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, textcreditor as fincreditorname,creditortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype,loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
            DataSet entrustloanBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)selectProps, (QFilter[])loanBillQFilter.toArray(), null);
            dataDS.add(entrustloanBillDS);
        }
        if (dataSource.contains("bankloan")) {
            loanQFilter.and("loantype", "=", (Object)LoanTypeEnum.BANKLOAN.getValue());
            selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? LOANBILL_FORM_PROPS : "id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname, textcreditor as fincreditorname,creditortype as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,creditortype,creditor as creditorid, currency as loancurrency, currency.name as loancurrencyname, drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype,loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
            DataSet loanBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)selectProps, (QFilter[])loanQFilter.toArray(), null);
            slQFilter.and(new QFilter("loantype", "=", (Object)LoanTypeEnum.BANKSLOAN.getValue()).and("banksyndicate_entry.e_shareamount", ">", (Object)0));
            QFilter slCredFilter = TradeFinanceRptHelper.getSlCreditorFilter(paramMap);
            slQFilter.and(slCredFilter);
            slQFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, slQFilter);
            selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? BANK_TEAM_PROPS : "banksyndicate_entry.id as id, id as loanbillid, '' as summarycol, 0 as findebtslevel,org.id as orgid, org.name as fincompanyname,bizdate as drawdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate, billno as loanbillno, finproduct.name as finproductname,banksyndicate_entry.e_bank.name as fincreditorname,'bank' as fincreditortype, loantype,amount,payinterestamount+calculaterateamount estinterestamt,banksyndicate_entry.e_bank.finorgtype.type as creditortype,banksyndicate_entry.e_bank.id as creditorid, currency as loancurrency, currency.name as loancurrencyname, banksyndicate_entry.e_shareamount as drawamount, drawamount as drawamount1,0 repayamt,0 repayamt1,0 notrepayamt,interesttype, loancontractbill.number as contractbillno,loancontractbill.contractno as contractno,loancontractbill.currency as concurrency, loancontractbill.guarantee as guaranteeway, amount as contractamt, settleintmode, repaymentway,term,basis,cleardate, " + extendSelectProps;
            DataSet slDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill", (String)selectProps, (QFilter[])slQFilter.toArray(), null);
            slDS = slDS.updateField("creditortype", "case when creditortype='0' then 'bank' else 'finorg' end").updateField("fincreditortype", "creditortype");
            dataDS.add(loanBillDS.union(slDS));
        }
        return (DataSet)dataDS.stream().reduce(DataSet::union).get();
    }

    protected List<String> getGroupFieldByDim(String statdim) {
        String[] groupFields = statdim.split(",");
        return Arrays.asList(groupFields);
    }

    protected DataSet getNoInvestorBondBill(DataSet dataSet, ReportQueryParam queryParam, Map<String, Object> paramMap) {
        if (!TradeFinanceRptHelper.isAddOther(paramMap)) {
            return null;
        }
        List<String> extendedColumns = this.getExtendedColumnKeys(queryParam);
        String extendSelectProps = this.createExtendedColumnSelectStr(extendedColumns);
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter loanBillQFilter = TradeFinanceFilterHelper.loanBillQFilter(paramMap, orgIds);
        ReportFilterParamHelper.addExtFilter(paramMap, loanBillQFilter);
        String lenderNature = (String)paramMap.get("filter_lendernature");
        String dataSource = paramMap.get("filter_datasource").toString();
        if (lenderNature.contains("outgroup") && dataSource.contains("bond")) {
            Set<Long> bondIds = TradeFinanceRptHelper.getBondIds(dataSet);
            if (bondIds.size() > 0) {
                loanBillQFilter.and(new QFilter("id", "not in", bondIds));
            }
            loanBillQFilter.and(new QFilter("loantype", "=", (Object)LoanTypeEnum.BOND.getValue()));
            String selectProps = EmptyUtil.isEmpty((String)extendSelectProps) ? FILEDS : "id loanbillid,'' as summarycol,org.id as orgid,org.name as fincompanyname,'' as fincreditortype,bizdate as drawdate, case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,billno as loanbillno,finproduct.name as finproductname,loantype,amount,payinterestamount+calculaterateamount estinterestamt,'' as creditortype,currency as loancurrency,currency.name as loancurrencyname,drawamount as drawamount1,interesttype, '' as contractbillno, '' as contractno,loancontractbill.currency as concurrency,loancontractbill.guarantee as guaranteeway,drawamount as contractamt,settleintmode,repaymentway,0 as drawamount,term,basis,cleardate, " + extendSelectProps;
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loanbill_bond", (String)selectProps, (QFilter[])loanBillQFilter.toArray(), null);
        }
        return null;
    }

    protected DataSet addExtraLoanBillDs(DataSet loanBillDS, ReportQueryParam queryParam, Map<String, Object> paramMap) {
        Field[] fields;
        DataSet dsTemp = loanBillDS.copy();
        String[] selectProps = COMMON_GROUP_PROPS;
        List<String> extendedColumns = this.getExtendedColumnKeys(queryParam);
        if (!EmptyUtil.isEmpty(extendedColumns)) {
            ArrayList<String> strings = new ArrayList<String>(Arrays.asList(COMMON_GROUP_PROPS));
            strings.addAll(extendedColumns);
            selectProps = strings.toArray(new String[0]);
        }
        GroupbyDataSet gdsTemp = dsTemp.groupBy(selectProps).sum("drawamount");
        DataSet ds = gdsTemp.finish().addNullField("fincreditortype");
        DataSet noInvestords = this.getNoInvestorBondBill(loanBillDS.copy(), queryParam, paramMap);
        if (noInvestords != null && !noInvestords.isEmpty()) {
            ds = ds.select(noInvestords.getRowMeta().getFieldNames());
            ds = ds.union(noInvestords);
        }
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = loanBillDS.getRowMeta().getFields()) {
            if (Arrays.asList(COMMON_GROUP_PROPS).contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if ("drawamount".equals(field.getName())) {
                selectField.add("drawamount1-drawamount as " + field.getName());
                continue;
            }
            if (field.getName().equals("fincreditorname")) {
                selectField.add(String.format(ResManager.loadKDString((String)"'\u5176\u5b83' as %s", (String)"TradeFinancePlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]), field.getName()));
                continue;
            }
            if (field.getName().equals("findebtslevel")) {
                selectField.add("1 as findebtslevel");
                continue;
            }
            if (field.getName().equals("id")) {
                selectField.add("loanbillid as id");
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add("0 as " + this.sumField);
                continue;
            }
            if (field.getName().endsWith(CUST_FIELD_SUFFIX)) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals("fincreditortype")) {
                selectField.add("'other' as fincreditortype");
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        return TradeFinanceRptHelper.genId(Arrays.asList("id", "creditorid"), ds.select(String.join((CharSequence)",", selectField))).where("drawamount > 0");
    }

    private DataSet getLoanAndRepaymentDs(DataSet loanBillDS, DataSet repaymentDS) {
        if (repaymentDS == null) {
            return loanBillDS;
        }
        loanBillDS = loanBillDS.updateField("notrepayamt", "drawamount");
        DataSet slorbackRepayDs = repaymentDS.copy().filter("loantype='sl' or isbuyback").groupBy(new String[]{"loanid", "entryid"}).sum("repayamt").finish();
        if (!slorbackRepayDs.isEmpty()) {
            loanBillDS = loanBillDS.leftJoin(slorbackRepayDs.copy()).on("loanbillid", "loanid").on("creditorid", "entryid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"repayamt vrepayamt"}).finish().updateField("repayamt", "case when vrepayamt!=null then vrepayamt else 0 end").updateField("notrepayamt", "drawamount-repayamt").removeFields(new String[]{"vrepayamt"});
        }
        DataSet slorbackRepayAllDs = slorbackRepayDs.groupBy(new String[]{"loanid"}).sum("repayamt").finish();
        DataSet notSlorbackRepayDs = repaymentDS.copy().filter("loantype!='sl' and !isbuyback").groupBy(new String[]{"loanid"}).sum("repayamt").finish();
        if (!notSlorbackRepayDs.isEmpty()) {
            loanBillDS = loanBillDS.leftJoin(slorbackRepayAllDs).on("loanbillid", "loanid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"repayamt slrepayamt"}).finish().addField("drawamount1-(case when slrepayamt!=null then slrepayamt else 0 end) ", "totaldrawamount").removeFields(new String[]{"slrepayamt"});
            loanBillDS = loanBillDS.leftJoin(notSlorbackRepayDs).on("loanbillid", "loanid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"case when repayamt!=null then repayamt*notrepayamt/totaldrawamount else 0 end repayamtrate"}).finish().updateField("repayamt1", "case when repayamtrate>notrepayamt then notrepayamt else repayamtrate end");
            loanBillDS = this.getCurrencyPresion(loanBillDS, notSlorbackRepayDs);
        }
        loanBillDS = loanBillDS.addField("repayamt+repayamt1", "paidamt");
        loanBillDS = loanBillDS.updateField("paidamt", "case when paidamt=null then 0 else paidamt end").updateField("paidamt", "case when paidamt>drawamount then drawamount else paidamt end").addField("case when drawamount-paidamt>0 then drawamount-paidamt else 0 end", "unpaidamt");
        return loanBillDS;
    }

    protected DataSet addExchangeRateAndCurrencyUnit(DataSet bizDataSet, Map<String, Object> paramMap) {
        DataSet resDs = super.addExchangeRateAndCurrencyUnit(bizDataSet, paramMap);
        DynamicObject standCur = (DynamicObject)paramMap.get("filter_statcurrency");
        int amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)standCur) ? standCur.getInt("amtprecision") : 2;
        return resDs.updateFields(new String[]{"drawamount_statccy", "paidamt_statccy", "unpaidamt_statccy", "estinterestamt_statccy", "paidintamt_statccy", "unpaidintamt_statccy"}, new String[]{String.format("round(drawamount_statccy, %s)", amtPrecision), String.format("round(paidamt_statccy, %s)", amtPrecision), String.format("round(unpaidamt_statccy, %s)", amtPrecision), String.format("round(estinterestamt_statccy, %s)", amtPrecision), String.format("round(paidintamt_statccy, %s)", amtPrecision), String.format("round(unpaidintamt_statccy, %s)", amtPrecision)});
    }

    private DataSet getCurrencyPresion(DataSet loanBillDS, DataSet repayDs) {
        loanBillDS = loanBillDS.updateField("repayamt1", "case when repayamt1=null then 0 else repayamt1 end");
        List<Long> currencyIds = TradeFinanceFilterHelper.getloanBillIds(loanBillDS, "loancurrency");
        DataSet currencyPresionDs = QueryServiceHelper.queryDataSet((String)"getCurrencyPresion", (String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)}, null);
        loanBillDS = loanBillDS.leftJoin(currencyPresionDs).on("loancurrency", "id").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"case when amtprecision=null then 2 else amtprecision end amtprecision"}).finish();
        loanBillDS = loanBillDS.updateField("repayamt1", "round(repayamt1, amtprecision)").removeFields(new String[]{"amtprecision"});
        DataSet distinctDs = loanBillDS.copy().select(new String[]{"loanbillid", "drawamount1"}).distinct();
        DataSet loanAllPaidDs = loanBillDS.copy().groupBy(new String[]{"loanbillid"}).sum("repayamt1").sum("drawamount").finish();
        loanAllPaidDs = distinctDs.leftJoin(loanAllPaidDs).on("loanbillid", "loanbillid").select(new String[]{"loanbillid", "drawamount1"}, new String[]{"repayamt1", "drawamount"}).finish().filter("drawamount1=drawamount").select(new String[]{"loanbillid", "repayamt1"});
        DataSet subAmtDs = loanAllPaidDs.leftJoin(repayDs).on("loanbillid", "loanid").select(new String[]{"loanbillid", "loanid", "repayamt-repayamt1 subamt"}).finish().filter("loanid!=null and subamt!=0");
        if (subAmtDs.isEmpty()) {
            return loanBillDS;
        }
        final HashMap<Long, BigDecimal> loanSubAmtMap = new HashMap<Long, BigDecimal>();
        for (Row subAmtD : subAmtDs) {
            loanSubAmtMap.put(subAmtD.getLong("loanbillid"), subAmtD.getBigDecimal("subamt"));
        }
        Set subIds = loanSubAmtMap.keySet();
        String loanIds = subIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        DataSet notSubDs = loanBillDS.filter("loanbillid not in (" + loanIds + ")");
        DataSet subDs = loanBillDS.filter("loanbillid in (" + loanIds + ")");
        final RowMeta rowMeta = loanBillDS.getRowMeta();
        subDs = subDs.map(new MapFunction(){
            BigDecimal subAmt = BigDecimal.ZERO;

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                Long loanbillId = row.getLong("loanbillid");
                BigDecimal notRepayAmt = row.getBigDecimal("notrepayamt");
                BigDecimal repayAmt = row.getBigDecimal("repayamt1");
                BigDecimal loanSubAmt = loanSubAmtMap.getOrDefault(loanbillId, BigDecimal.ZERO);
                if (loanSubAmt != null) {
                    this.subAmt = TradeFinanceDataListPlugin.this.getSubAmount(loanSubAmt, notRepayAmt, repayAmt);
                    loanSubAmtMap.put(loanbillId, loanSubAmt.subtract(this.subAmt));
                }
                for (String filedName : rowMeta.getFieldNames()) {
                    if ("repayamt1".equals(filedName)) {
                        rowInfo.add(repayAmt.add(this.subAmt));
                        continue;
                    }
                    rowInfo.add(row.get(filedName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return notSubDs.union(subDs);
    }

    private BigDecimal getSubAmount(BigDecimal subAmt, BigDecimal notRepayAmt, BigDecimal repayAmt) {
        if (EmptyUtil.isEmpty((BigDecimal)subAmt)) {
            return subAmt;
        }
        BigDecimal subAmount = notRepayAmt.subtract(repayAmt);
        if (subAmt.compareTo(BigDecimal.ZERO) > 0) {
            if (subAmount.compareTo(subAmt) > 0) {
                return subAmt;
            }
            return subAmount;
        }
        if (repayAmt.compareTo(subAmt.abs()) > 0) {
            return subAmt;
        }
        return repayAmt.negate();
    }

    private DataSet getLoanAndInterestDs(DataSet loanBillDS, DataSet interestDS) {
        DataSet notSlRepaymentDs = interestDS.filter("loantype!='sl' and loantype!='bond'");
        DataSet slRepaymentDs = interestDS.filter("loantype='sl'");
        DataSet notSlloanBillDs = loanBillDS.filter("loantype!='sl' and loantype!='bond'").leftJoin(notSlRepaymentDs).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"paidintamt"}).finish();
        DataSet slloanBillDs = loanBillDS.filter("loantype='sl'").leftJoin(slRepaymentDs).on("loanbillid", "loanbillid").on("creditorid", "bankid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"slpaidintamt paidintamt"}).finish();
        DataSet bondloanBillDs = loanBillDS.filter("loantype='bond' and drawamount1>0").leftJoin(interestDS.filter("loantype='bond'")).on("loanbillid", "loanbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"drawamount*paidintamt/drawamount1 paidintamt"}).finish();
        loanBillDS = notSlloanBillDs.union(slloanBillDs).union(bondloanBillDs).updateField("paidintamt", "case when paidintamt=null then 0 else paidintamt end");
        return loanBillDS;
    }

    protected List<String> getExtendedColumnKeys(ReportQueryParam param) {
        String columnkeyStr = (String)param.getCustomParam().get("columnkeys");
        if (EmptyUtil.isEmpty((String)columnkeyStr)) {
            return Collections.emptyList();
        }
        String[] columns = columnkeyStr.split(",");
        ArrayList<String> keys = new ArrayList<String>(columns.length);
        for (String column : columns) {
            if (!column.endsWith(CUST_FIELD_SUFFIX)) continue;
            keys.add(column);
        }
        return keys;
    }

    protected String createExtendedColumnSelectStr(List<String> keys) {
        ArrayList<String> sel = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String str = key.substring(0, key.lastIndexOf(CUST_FIELD_SUFFIX)) + " as " + key;
            sel.add(str);
        }
        return String.join((CharSequence)",", sel);
    }

    protected DataSet addFeeAmtDs(DataSet loanBillDS, List<Long> loanBillIds) {
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "in", loanBillIds);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        DataSet feeDs = QueryServiceHelper.queryDataSet((String)"TradeFinanceDataListPlugin_Fee", (String)"cfm_feebill", (String)"entry.srcbillid as srcbillid,entry.feedetailamt as feedetailamt,entry.excrate as excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"");
        if (!feeDs.isEmpty()) {
            DataSet midFeeDs = feeDs.groupBy(new String[]{"srcbillid"}).sum("feedetailamt*excrate", "feeamt").finish().select("srcbillid,feeamt");
            loanBillDS = loanBillDS.leftJoin(midFeeDs).on("loanbillid", "srcbillid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"feeamt"}).finish().updateField("feeamt", "case when feeamt is null then 0 else feeamt end");
        } else {
            loanBillDS = loanBillDS.addField("0", "feeamt");
        }
        return loanBillDS.addField("estinterestamt + feeamt", "compamt");
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.addField("case when unpaidamt=0 and cleardate is not null then cleardate else expiredate end", "comprateenddate");
        DataSet compDs = this.buildCompCalcDs(dataSet.copy());
        dataSet = dataSet.leftJoin(compDs).on("loanbillid", "compid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"compyearday", "compdays"}).finish();
        dataSet = dataSet.addField("case when drawamount_statccy=0 or compdays=0 then 0 else compamt_statccy * 100 * compyearday  /(drawamount_statccy * compdays) end", "comprate_statccy");
        DataSet totalDs = dataSet.filter("sumlevel=2");
        dataSet = dataSet.filter("sumlevel!=2");
        dataSet = dataSet.orderBy(this.orderByFields().toArray(new String[0]));
        return dataSet.union(totalDs);
    }

    private DataSet buildCompCalcDs(DataSet dataSet) {
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("compid", (DataType)DataType.LongType));
        field.add(new Field("compyearday", (DataType)DataType.IntegerType));
        field.add(new Field("compdays", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"Build_Day_Calc_Ds").createDataSetBuilder(rowMeta);
        for (Row row : dataSet.filter("sumlevel=0")) {
            int diffDays;
            int yearDay;
            Date startDate = row.getDate("drawdate");
            Date endDate = row.getDate("comprateenddate");
            String basis = row.getString("basis");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate, basis})) {
                yearDay = 0;
                diffDays = 1;
            } else {
                yearDay = TermHelper.getBasis_YearDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis));
                diffDays = TermHelper.getBasis_BetweenDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis), null);
            }
            Object[] rowArr = new Object[]{row.getLong("loanbillid"), yearDay, diffDays};
            builder.append(rowArr);
        }
        return builder.build().groupBy(new String[]{"compid"}).max("compyearday").max("compdays").finish();
    }
}

