/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.cfm.report.helper.ReportFilterParamHelper;
import kd.tmc.cfm.report.helper.TradeFinanceFilterHelper;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.StringUtils;

public class TradeFinanceSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    protected Date cutoffdate;
    protected List<String> groupFields = new ArrayList<String>(10);
    private static String statDim = "org";
    protected static final String LOAN_FIELDS = "id, id loanbillid, org.id orgid, org.name orgname,loantype,finproduct.name finproductname, creditortype as fincreditortype, currency loancurrency, currency.name loancurrencyname, creditortype, 0 entryid,creditor creditorid, drawamount, drawamount drawamount1, 1 userate, textcreditor creditorname,0 repayamt,0 repayamt1,0 notrepayamt";
    protected static final String SL_FIELDS = "banksyndicate_entry.id id, id loanbillid, org.id orgid, org.name orgname,loantype,finproduct.name finproductname, creditortype as fincreditortype, currency loancurrency, currency.name loancurrencyname, banksyndicate_entry.e_bank.finorgtype.type creditortype, banksyndicate_entry.e_bank entryid,banksyndicate_entry.e_bank creditorid, banksyndicate_entry.e_shareamount drawamount, drawamount drawamount1,banksyndicate_entry.e_shareamount/drawamount userate, banksyndicate_entry.e_bank.name creditorname,0 repayamt,0 repayamt1,0 notrepayamt";
    protected static final String BOND_FIELDS = "investor_entry.id id, id loanbillid, org.id orgid, org.name orgname,loantype,finproduct.name finproductname, investor_entry.e_investortype fincreditortype, currency loancurrency, currency.name loancurrencyname, investor_entry.e_investortype creditortype,investor_entry.id entryid,investor_entry.e_investorid creditorid, investor_entry.e_investamount drawamount, drawamount drawamount1, investor_entry.e_investamount/drawamount userate, investor_entry.e_investorname creditorname,0 repayamt,0 repayamt1,0 notrepayamt";
    protected static final String[] COMMON_GROUP_PROPS = new String[]{"loanbillid", "orgid", "orgname", "finproductname", "loancurrency", "loancurrencyname", "drawamount1"};
    protected static final String[] AMT_FIELDS = new String[]{"drawamount", "unpaidamt"};
    protected static final String[] AMOUNT_SUM_FIELDS = new String[]{"drawamount_statccy", "unpaidamt_statccy"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.initParams(paramMap);
        List orgIds = this.getQueryOrgIds(queryParam);
        QFilter qFilter = TradeFinanceRptHelper.loanBillQFilter(paramMap, orgIds);
        DataSet loanBillDS = this.getLoanBillDS(queryParam, paramMap, qFilter);
        if (TradeFinanceRptHelper.isAddOther(paramMap)) {
            DataSet extraLoanBillDs = this.addExtraLoanBillDs(loanBillDS.copy().filter("loantype='bond'"), queryParam, paramMap, qFilter);
            loanBillDS = loanBillDS.union(extraLoanBillDs);
        }
        if (loanBillDS.isEmpty()) {
            return TradeFinanceRptHelper.createEmptyDS();
        }
        loanBillDS = loanBillDS.filter("drawamount>0");
        String bankLevel = (String)paramMap.get("filter_banklevel");
        List<String> containLoanerDim = Arrays.asList("orgname,creditorname,loancurrencyname", "creditorname,orgname,loancurrencyname", "creditorname,loancurrencyname");
        if ("1".equals(bankLevel)) {
            loanBillDS = TradeFinanceRptHelper.transToBankCate(loanBillDS);
            DataSet loanBillBankds = loanBillDS.copy().filter("creditortype='bank'");
            HashSet<Long> bankIds = new HashSet<Long>(16);
            loanBillBankds.copy().forEach(bank -> bankIds.add(bank.getLong("creditorid")));
            DataSet bankDs = TradeFinanceRptHelper.getBankDs(bankIds);
            loanBillDS = loanBillDS.leftJoin(bankDs).on("creditorid", "bankid").select(loanBillDS.getRowMeta().getFieldNames(), new String[]{"bankcgid"}).finish().updateField("creditorid", "case when bankcgid!=null then bankcgid else creditorid end");
        }
        if (containLoanerDim.contains(statDim)) {
            this.groupFields.add("creditorid");
        }
        loanBillDS = TradeFinanceRptHelper.addPaidAmtField(loanBillDS, this.cutoffdate);
        List<String> noBorrowerDim = Arrays.asList("creditorname,loancurrencyname", "fincreditortype,loancurrencyname", "loancurrencyname", "finproductname,loancurrencyname");
        ArrayList<String> list = new ArrayList<String>(this.groupFields);
        if (noBorrowerDim.contains(statDim)) {
            list.remove("orgid");
        }
        loanBillDS = TradeFinanceRptHelper.groupAndSumDataSet(loanBillDS, list.toArray(new String[0]), AMT_FIELDS);
        boolean showStep = "step".equals(paramMap.get("filter_showttype"));
        if (showStep && "orgname,loancurrencyname".equals(statDim)) {
            return loanBillDS.addFields(new String[]{"orgid", "orgname", "loancurrency"}, new String[]{"org", "orgtext", "currency"}).removeFields(new String[]{"orgname", "loancurrency", "loancurrencyname"});
        }
        return loanBillDS.addFields(new String[]{"loancurrency"}, new String[]{"currency"});
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        Map paramMap = this.transQueryParam(queryParam);
        boolean isStep = "step".equals(paramMap.get("filter_showttype"));
        if (isStep) {
            dataSet = dataSet.orderBy(this.orderFields());
        }
        return this.addDetail(dataSet);
    }

    protected void initParams(Map<String, Object> paramMap) {
        this.cutoffdate = ReportCommonHelper.getCutOffDate(paramMap);
        statDim = (String)paramMap.get("filter_statdim");
        this.groupFields = TradeFinanceRptHelper.getGroupFieldByDim(statDim);
        this.groupFields.add("orgid");
    }

    protected Date getExChangeEffectdate() {
        return DateUtils.truncateDate((Date)(this.cutoffdate == null ? DateUtils.getCurrentDate() : this.cutoffdate));
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        List<String> noOrgId = Arrays.asList("creditorname,loancurrencyname", "fincreditortype,loancurrencyname", "loancurrencyname", "finproductname,loancurrencyname");
        int num = 3;
        if (noOrgId.contains(statDim)) {
            num = 2;
        }
        if (this.groupFields.size() > num) {
            return super.addSubRowDataSet(bizDs, paramMap);
        }
        return bizDs;
    }

    public String subNameField() {
        return "loancurrencyname";
    }

    public String sumNameField() {
        return this.groupFields.get(0);
    }

    public List<String> groupFields() {
        List<String> noOrgId = Arrays.asList("creditorname,loancurrencyname", "fincreditortype,loancurrencyname", "loancurrencyname", "finproductname,loancurrencyname");
        int num = 3;
        if (noOrgId.contains(statDim)) {
            num = 2;
        }
        List<String> subGroupFields = this.groupFields.subList(0, this.groupFields.size() - num);
        return new ArrayList<String>(subGroupFields);
    }

    public List<String> sumAmountFields() {
        return Arrays.asList(AMOUNT_SUM_FIELDS);
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("drawamount", "unpaidamt");
    }

    protected String getReportField(String field) {
        return field + "_statccy";
    }

    protected DataSet getLoanBillDS(ReportQueryParam queryParam, Map<String, Object> paramMap, QFilter qFilter) {
        QFilter loanTypeFilter;
        String lenderNature;
        String algoKey = ((Object)((Object)this)).getClass().getName();
        QFilter loanQFilter = ReportFilterParamHelper.initLenderNatureFilter(paramMap, qFilter.copy());
        loanQFilter.and(new QFilter("debtortype", "not in", Arrays.asList("custom", "other")));
        QFilter credFilter = TradeFinanceFilterHelper.initCriditorFilter(paramMap);
        ArrayList<DataSet> dataDS = new ArrayList<DataSet>();
        String dataSource = paramMap.get("filter_datasource").toString();
        if (dataSource.contains("bond") && StringUtils.contains((CharSequence)(lenderNature = (String)paramMap.get("filter_lendernature")), (CharSequence)LenderNatureEnum.OUTGROUP.getValue())) {
            QFilter bondTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter(LoanTypeEnum.BOND.getValue());
            QFilter bondCredFilter = TradeFinanceRptHelper.getBondCreditorFilter(paramMap);
            DataSet bondDS = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloanbond"), (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])new QFilter[]{qFilter, bondTypeFilter, bondCredFilter, new QFilter("debtortype", "not in", Arrays.asList("custom", "other"))}, null);
            dataDS.add(bondDS);
        }
        if (dataSource.contains("fl")) {
            QFilter flTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter(LoanTypeEnum.FINLEASE.getValue());
            DataSet flDS = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryfl"), (String)"cfm_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{loanQFilter, flTypeFilter, credFilter}, null);
            dataDS.add(flDS);
        }
        if (dataSource.contains("entrustloan")) {
            loanTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter("");
            DataSet entrustloanBillDS = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryentrustloan"), (String)"cfm_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{loanQFilter, loanTypeFilter, credFilter}, null);
            dataDS.add(entrustloanBillDS);
        }
        if (dataSource.contains("bankloan")) {
            loanTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter("loan");
            DataSet loanBillDS = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloan"), (String)"cfm_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{loanQFilter, loanTypeFilter, credFilter}, null);
            QFilter slTypeFilter = TradeFinanceRptHelper.getLoanTypeFilter(LoanTypeEnum.BANKSLOAN.getValue());
            QFilter slCredFilter = TradeFinanceRptHelper.getSlCreditorFilter(paramMap);
            DataSet slLoanDS = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryloansl"), (String)"cfm_loanbill", (String)SL_FIELDS, (QFilter[])new QFilter[]{loanQFilter, slTypeFilter, slCredFilter}, null);
            slLoanDS = slLoanDS.updateField("creditortype", "case when creditortype='0' then 'bank' else 'finorg' end").updateField("fincreditortype", "creditortype");
            dataDS.add(loanBillDS.union(slLoanDS));
        }
        return (DataSet)dataDS.stream().reduce(DataSet::union).get();
    }

    protected DataSet getNoInvestorBondBill(DataSet dataSet, ReportQueryParam queryParam, Map<String, Object> paramMap, QFilter qFilter) {
        if (!TradeFinanceRptHelper.isAddOther(paramMap)) {
            return null;
        }
        RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet loanBillDS = Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        String lenderNature = (String)paramMap.get("filter_lendernature");
        String dataSource = paramMap.get("filter_datasource").toString();
        if (StringUtils.contains((CharSequence)lenderNature, (CharSequence)LenderNatureEnum.OUTGROUP.getValue()) && dataSource.contains("bond")) {
            QFilter bondFilter = new QFilter("loantype", "=", (Object)LoanTypeEnum.BOND.getValue()).and(QFilter.isNull((String)"investor_entry"));
            Set<Long> bondIds = TradeFinanceRptHelper.getBondIds(dataSet);
            if (bondIds.size() > 0) {
                bondFilter.and("id", "not in", bondIds);
            }
            loanBillDS = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryloanbond"), (String)"cfm_loanbill_bond", (String)"id loanbillid, org.id orgid, org.name orgname,finproduct.name finproductname, currency loancurrency, currency.name loancurrencyname,drawamount drawamount1,0 as drawamount,'' as fincreditortype", (QFilter[])new QFilter[]{qFilter, bondFilter}, null);
        }
        return loanBillDS;
    }

    protected DataSet addExtraLoanBillDs(DataSet loanBillDS, ReportQueryParam queryParam, Map<String, Object> paramMap, QFilter qFilter) {
        Field[] fields;
        DataSet dsTemp = loanBillDS.copy();
        GroupbyDataSet gdsTemp = dsTemp.groupBy(COMMON_GROUP_PROPS).sum("drawamount");
        DataSet ds = gdsTemp.finish().addNullField("fincreditortype");
        DataSet noInvestords = this.getNoInvestorBondBill(loanBillDS.copy(), queryParam, paramMap, qFilter);
        if (noInvestords != null && !noInvestords.isEmpty()) {
            ds = ds.union(noInvestords);
        }
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = loanBillDS.getRowMeta().getFields()) {
            if (Arrays.asList(COMMON_GROUP_PROPS).contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if ("drawamount".equals(field.getName())) {
                selectField.add("drawamount1-drawamount as " + field.getName());
                continue;
            }
            if (field.getName().equals("creditorname")) {
                selectField.add(String.format(ResManager.loadKDString((String)"'\u5176\u5b83' as %s", (String)"TradeFinancePlugin_0", (String)"tmc-cfm-report", (Object[])new Object[0]), field.getName()));
                continue;
            }
            if (field.getName().equals("userate")) {
                selectField.add("(drawamount1-drawamount)/drawamount1 as userate");
                continue;
            }
            if (field.getName().equals("id")) {
                selectField.add("loanbillid as id");
                continue;
            }
            if (field.getName().equals("fincreditortype")) {
                selectField.add("'other' as fincreditortype");
                continue;
            }
            if (field.getName().equals("creditortype")) {
                selectField.add("'other' as creditortype");
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        DataSet extendDs = TradeFinanceRptHelper.genId(Collections.singletonList(new String[]{"id"}), ds.select(String.join((CharSequence)",", selectField))).where("drawamount > 0");
        return extendDs.updateField("creditorid", "1");
    }

    protected boolean isNeedOrgTree() {
        return true;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    public DataSet addDetail(DataSet resultDS) {
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"RepaymentSumDataListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]);
        resultDS = resultDS.addField("case when (sumlevel = 0 or sumlevel=null) then '" + lvalue + "' else '' end as detail", "detail");
        return resultDS;
    }

    protected String[] orderFields() {
        return new String[]{this.sumField, "orgid"};
    }
}

