/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cfm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AvgInterestRateFormRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Long DEFAULT_FUN_ORG_VIEW_ID = 8L;

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        if (EmptyUtil.isEmpty((String)statdim)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"AvgInterestRateFormRptPlugin_01", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u67e5\u8be2\u65b9\u5f0f\u4e3a\u8d44\u91d1\u7ec4\u7ec7,\u501f\u6b3e\u4eba\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AvgInterestRateFormRptPlugin_02", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u7b97\u5e01\u79cd\u3002", (String)"AvgInterestRateFormRptPlugin_03", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        String currencyunit = (String)this.getModel().getValue("filter_currencyunit");
        if (EmptyUtil.isEmpty((String)currencyunit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d27\u5e01\u5355\u4f4d\u3002", (String)"AvgInterestRateFormRptPlugin_04", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        boolean isVerify = ReportCommonHelper.verifyQueryFilter(queryParam);
        if (!isVerify) {
            return isVerify;
        }
        Date startdate = (Date)this.getModel().getValue("filter_dateranges_startdate");
        Date enddate = (Date)this.getModel().getValue("filter_dateranges_enddate");
        if (EmptyUtil.isNoEmpty((Object)enddate) && enddate.compareTo(startdate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u7ed3\u675f\u65e5\u5fc5\u987b\u5927\u4e8e\u67e5\u8be2\u65e5\u671f\u5f00\u59cb\u65e5\u3002", (String)"AvgInterestRateFormRptPlugin_14", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("filter_orgview", (Object)DEFAULT_FUN_ORG_VIEW_ID);
        this.dateRangesChgEvt();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterOrgMustInput();
        this.setShowTypeVisible();
    }

    private void setFilterOrgMustInput() {
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay), (String[])new String[]{"filter_org"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (fieldKey) {
            case "filter_queryway": {
                this.setFilterOrgMustInput();
                this.setDefShowTypeValue();
                break;
            }
            case "filter_dateranges": {
                this.dateRangesChgEvt();
                break;
            }
            case "filter_statdim": {
                this.setShowTypeVisible();
                this.setDefShowTypeValue();
                this.autoSearch();
                break;
            }
            case "filter_summary": {
                ArrayList<ComboItem> detailItems = new ArrayList<ComboItem>();
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"AvgInterestRateFormRptPlugin_05", (String)"tmc-cfm-report", (Object[])new Object[0])), "org"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"AvgInterestRateFormRptPlugin_06", (String)"tmc-cfm-report", (Object[])new Object[0])), "creditor"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"AvgInterestRateFormRptPlugin_07", (String)"tmc-cfm-report", (Object[])new Object[0])), "finproduct"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b", (String)"AvgInterestRateFormRptPlugin_08", (String)"tmc-cfm-report", (Object[])new Object[0])), "type"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650", (String)"AvgInterestRateFormRptPlugin_09", (String)"tmc-cfm-report", (Object[])new Object[0])), "allterm"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"AvgInterestRateFormRptPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0])), "remainingterm"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u501f\u6b3e\u5e01\u79cd", (String)"AvgInterestRateFormRptPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0])), "currency"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u516c\u53f8+\u501f\u6b3e\u5e01\u79cd", (String)"AvgInterestRateFormRptPlugin_12", (String)"tmc-cfm-report", (Object[])new Object[0])), "org_currency"));
                detailItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b+\u501f\u6b3e\u5408\u540c", (String)"AvgInterestRateFormRptPlugin_13", (String)"tmc-cfm-report", (Object[])new Object[0])), "type_contractbillno"));
                ArrayList<ComboItem> sumItems = new ArrayList<ComboItem>();
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u501f\u6b3e\u4eba", (String)"AvgInterestRateFormRptPlugin_05", (String)"tmc-cfm-report", (Object[])new Object[0])), "org"));
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"AvgInterestRateFormRptPlugin_06", (String)"tmc-cfm-report", (Object[])new Object[0])), "creditor"));
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"AvgInterestRateFormRptPlugin_07", (String)"tmc-cfm-report", (Object[])new Object[0])), "finproduct"));
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650", (String)"AvgInterestRateFormRptPlugin_09", (String)"tmc-cfm-report", (Object[])new Object[0])), "allterm"));
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"AvgInterestRateFormRptPlugin_10", (String)"tmc-cfm-report", (Object[])new Object[0])), "remainingterm"));
                sumItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u501f\u6b3e\u5e01\u79cd", (String)"AvgInterestRateFormRptPlugin_11", (String)"tmc-cfm-report", (Object[])new Object[0])), "currency"));
                ComboEdit item = (ComboEdit)this.getControl("filter_statdim");
                if (((Boolean)changeData[0].getNewValue()).booleanValue()) {
                    item.setComboItems(sumItems);
                    this.getView().updateView("filter_statdim");
                    String statDim = (String)this.getModel().getValue("filter_statdim");
                    if (Arrays.asList("type", "org_currency", "type_contractbillno").contains(statDim)) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_statdim", (Object)"org");
                        this.getView().setVisible(Boolean.TRUE, new String[]{"filter_showttype"});
                        String queryway = (String)this.getModel().getValue("filter_queryway");
                        this.getModel().setValue("filter_showttype", (Object)("orgview".equals(queryway) ? "step" : "tile"));
                    } else {
                        this.getView().setVisible(Boolean.valueOf("org".equals(statDim)), new String[]{"filter_showttype"});
                        this.setDefShowTypeValue();
                    }
                } else {
                    item.setComboItems(detailItems);
                    this.getView().updateView("filter_statdim");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"filter_showttype"});
                }
                this.getView().setEnable(Boolean.valueOf((Boolean)changeData[0].getNewValue() == false), new String[]{"filter_statcurrency"});
                this.autoSearch();
                break;
            }
            case "filter_banklevel": {
                this.autoSearch();
            }
        }
    }

    private void dateRangesChgEvt() {
        String dateType = (String)this.getModel().getValue("filter_dateranges");
        if ("lastweek".equals(dateType)) {
            this.getModel().setValue("filter_dateranges_startdate", (Object)DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)DateUtils.getCurrentDate()), (int)7));
            this.getModel().setValue("filter_dateranges_enddate", (Object)DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)DateUtils.getCurrentDate()), (int)1));
        } else if ("thismonth".equals(dateType)) {
            this.getModel().setValue("filter_dateranges_startdate", (Object)DateUtils.getFirstDayOfMonth((Date)DateUtils.getCurrentDate()));
            this.getModel().setValue("filter_dateranges_enddate", (Object)DateUtils.getCurrentDate());
        } else if ("lastmonth".equals(dateType)) {
            this.getModel().setValue("filter_dateranges_startdate", (Object)DateUtils.getLastMonth((Date)DateUtils.getFirstDayOfMonth((Date)DateUtils.getCurrentDate()), (int)1));
            this.getModel().setValue("filter_dateranges_enddate", (Object)DateUtils.getFirstDayOfMonth((Date)DateUtils.getCurrentDate()));
        } else if ("thisyear".equals(dateType)) {
            this.getModel().setValue("filter_dateranges_startdate", (Object)DateUtils.getFirstYearDate((Date)DateUtils.getCurrentDate()));
            this.getModel().setValue("filter_dateranges_enddate", (Object)DateUtils.getLastYearDate((Date)DateUtils.getCurrentDate()));
        } else if ("lastyear".equals(dateType)) {
            this.getModel().setValue("filter_dateranges_startdate", (Object)DateUtils.getLastMonth((Date)DateUtils.getFirstYearDate((Date)DateUtils.getCurrentDate()), (int)12));
            this.getModel().setValue("filter_dateranges_enddate", (Object)DateUtils.getLastDay((Date)DateUtils.getFirstYearDate((Date)DateUtils.getCurrentDate()), (int)1));
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"filter_dateranges"});
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        long exchangeTabelId = 0L;
        try {
            exchangeTabelId = TmcBusinessBaseHelper.getExchageTableId((Long)RequestContext.get().getOrgId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (EmptyUtil.isEmpty((Long)exchangeTabelId)) {
            exchangeTabelId = TmcBusinessBaseHelper.getExchageTableId((Long)Long.parseLong(Objects.requireNonNull(this.getOrgRootId("08"))));
        }
        queryParam.getCustomParam().put("orgid", this.getCompanyId(RequestContext.get().getOrgId()));
        queryParam.getCustomParam().put("exchangeTabelId", exchangeTabelId);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        filter.addFilterItem("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        filter.addFilterItem("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        boolean isSummary = (Boolean)this.getModel().getValue("filter_summary");
        filter.addFilterItem("filter_summary", (Object)isSummary);
        filter.addFilterItem("filter_banklevel", this.getModel().getValue("filter_banklevel"));
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException var3) {
                this.getView().showErrorNotification(var3.getMessage());
            }
        }
    }

    private Long getCompanyId(Long orgId) {
        Map companyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        return (Long)companyMap.get("id");
    }

    private String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(index);
        DynamicObject bill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id,loantype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)rowData.getString("billno"))});
        if (bill != null) {
            IReportView view = this.getView();
            String loantype = bill.getString("loantype");
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setPkId((Object)bill.getLong("id"));
            parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if ("bond".equals(loantype)) {
                parameter.setFormId("cfm_loanbill_bond");
            } else if ("ec".equals(loantype)) {
                parameter.setFormId("cfm_loanbill_e_l");
            } else if ("finlease".equals(loantype)) {
                parameter.setFormId("fl_receiptbill");
            } else {
                parameter.setFormId("cfm_loanbill_b_l");
            }
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPageId(bill.getString("id"));
            view.showForm((FormShowParameter)parameter);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            if (!"billno".equals(event.getColumnName()) && !"contractbillno".equals(event.getColumnName()) && !"orgname".equals(event.getColumnName()) && !"finproduct".equals(event.getColumnName()) && !"textcreditor".equals(event.getColumnName())) continue;
            event.setSort(true);
            event.setFilter(true);
        }
    }

    private void setDefShowTypeValue() {
        String queryway = (String)this.getModel().getValue("filter_queryway");
        String statdim = (String)this.getModel().getValue("filter_statdim");
        boolean sumMary = (Boolean)this.getModel().getValue("filter_summary");
        String showType = sumMary && "org".equals(statdim) && "orgview".equals(queryway) ? "step" : "tile";
        this.getModel().setValue("filter_showttype", (Object)showType);
    }

    private void setShowTypeVisible() {
        String statDim = (String)this.getModel().getValue("filter_statdim");
        boolean sumMary = (Boolean)this.getModel().getValue("filter_summary");
        this.getView().setVisible(Boolean.valueOf(sumMary && "org".equals(statDim)), new String[]{"filter_showttype"});
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        String statdim = (String)this.getModel().getValue("filter_statdim");
        String showType = (String)this.getModel().getValue("filter_showttype");
        boolean sumMary = (Boolean)this.getModel().getValue("filter_summary");
        event.setTreeReportList(sumMary && "org".equals(statdim) && "step".equals(showType));
    }
}

