/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.report.form.TradeFinanceBaseFormListPlugin;
import kd.tmc.cfm.report.helper.TradeFinanceRptHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeFinanceSumFromListPlugin
extends TradeFinanceBaseFormListPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.initF7settlecenter();
        this.initFinproduct();
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initF7settlecenter() {
        if (this.isFromByInternalLoan()) {
            BasedataEdit company = (BasedataEdit)this.getControl("filter_settlecenter");
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNoEmpty((String)appId) ? appId : "cfm";
                List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                qFilters.add(new QFilter("finorgtype.type", "=", (Object)"1"));
                qFilters.add(new QFilter("org", "in", (Object)comIdList));
            });
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object datasource = this.getModel().getValue("filter_datasource");
        if (EmptyUtil.isEmpty((Object)datasource)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u3002", (String)"TradeFinanceFromListPlugin_5", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        String statdim = (String)model.getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        boolean showStep = "step".equals(model.getValue("filter_showttype"));
        DynamicObject currency = (DynamicObject)model.getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)model.getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
        if (StringUtils.contains((CharSequence)statdim, (CharSequence)"creditorname")) {
            String bankLevel = (String)model.getValue("filter_banklevel");
            queryParam.getFilter().addFilterItem("filter_banklevel", (Object)bankLevel);
        }
        IReportView view = this.getView();
        TradeFinanceRptHelper.initQueryColumn(view, statdim, showStep);
        ReportList listTable = (ReportList)view.getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<String> columnKeys = new ArrayList<String>(columns.size());
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            columnKeys.add(reportColumn.getFieldKey());
        }
        if ("bdim_loandynsumrpt".equals(this.getView().getFormShowParameter().getFormId())) {
            queryParam.getCustomParam().put("from", "bondissue");
        }
        queryParam.getCustomParam().put("columnkeys", String.join((CharSequence)",", columnKeys));
        queryParam.getCustomParam().put("appid", view.getFormShowParameter().getAppId());
        super.beforeQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "trackdetail": {
                this.trackDetailRpt();
                break;
            }
        }
    }

    protected void trackDetailRpt() {
        IReportView view = this.getView();
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IDataModel model = this.getModel();
        Object lenderNature = model.getValue("filter_lendernature");
        if (EmptyUtil.isEmpty((Object)lenderNature)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u6027\u8d28\u3002", (String)"TradeFinanceFromListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]));
            return;
        }
        Object creditor = model.getValue("filter_creditor");
        Object creditorId = EmptyUtil.isNoEmpty((Object)creditor) ? model.getValue("filter_creditorid") : null;
        Object bizDateRanges = model.getValue("bizdateranges");
        boolean isCustom = RptDateRangeEnum.CUSTOM.getValue().equals(bizDateRanges);
        Object bizDateStartDate = isCustom ? model.getValue("bizdateranges_startdate") : null;
        Object bizDateEndDate = isCustom ? model.getValue("bizdateranges_enddate") : null;
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(16);
        param.put("filter_querycutoffdate", model.getValue("filter_querycutoffdate"));
        param.put("filter_cutoffdate", model.getValue("filter_cutoffdate"));
        param.put("filter_lendernature", lenderNature);
        param.put("filter_queryway", model.getValue("filter_queryway"));
        param.put("filter_orgview", model.getValue("filter_orgview"));
        param.put("filter_org", model.getValue("filter_org"));
        param.put("filter_creditortype", model.getValue("filter_creditortype"));
        param.put("filter_creditor", creditor);
        param.put("filter_creditorid", creditorId);
        param.put("filter_finproduct", model.getValue("filter_finproduct"));
        param.put("bizdateranges", bizDateRanges);
        param.put("bizdateranges_startdate", bizDateStartDate);
        param.put("bizdateranges_enddate", bizDateEndDate);
        param.put("filter_currencies", model.getValue("filter_currencies"));
        param.put("filter_includecloseout", model.getValue("filter_includecloseout"));
        param.put("filter_includebond", model.getValue("filter_includebond"));
        param.put("filter_currencyunit", model.getValue("filter_currencyunit"));
        param.put("filter_statcurrency", model.getValue("filter_statcurrency"));
        param.put("filter_datasource", model.getValue("filter_datasource"));
        if (this.isFromByInternalLoan()) {
            showParameter.setFormId("ifm_internalloan_dtl_rpt");
            DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("filter_settlecenter");
            param.put("filter_settlecenter", value.stream().map(d -> d.getLong("fbasedataid_id")).toArray());
        } else if (this.isFromByLoan()) {
            showParameter.setFormId("bdim_loandyndetailrpt");
        } else if (this.isFromByEpeloancollect()) {
            showParameter.setFormId("cfm_epeloandetail_rpt");
        } else if (this.isFromFinlease()) {
            showParameter.setFormId("fl_tradefinancerpt");
        } else {
            showParameter.setFormId("cfm_tradefinancerpt");
        }
        String statdim = (String)model.getValue("filter_statdim");
        statdim = this.getDetailStadim().getOrDefault(statdim, "fincreditorname");
        param.put("filter_statdim", statdim);
        showParameter.setCustomParam("filters", (Object)SerializationUtils.serializeToBase64(param));
        view.showForm((FormShowParameter)showParameter);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        this.getView().setVisible(Boolean.valueOf("custom".equals(queryCutOffDate)), new String[]{"filter_cutoffdate"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "filter_banklevel": {
                this.reSearch();
                break;
            }
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_cutoffdate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_cutoffdate"});
                break;
            }
        }
    }

    private void initFinproduct() {
        BasedataEdit finproduct = (BasedataEdit)this.getControl("filter_finproduct");
        Boolean includebond = Boolean.parseBoolean(this.getModel().getValue("filter_includebond").toString());
        finproduct.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            if (!includebond.booleanValue()) {
                qFilters.add(new QFilter("finsource", "!=", (Object)"bond"));
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"detail")) {
            IReportView view = this.getView();
            IDataModel model = this.getModel();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Object lenderNature = model.getValue("filter_lendernature");
            if (EmptyUtil.isEmpty((Object)lenderNature)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503a\u6743\u4eba\u6027\u8d28\u3002", (String)"TradeFinanceFromListPlugin_3", (String)"tmc-cfm-report", (Object[])new Object[0]));
                return;
            }
            if (this.isFromByInternalLoan()) {
                showParameter.setFormId("ifm_internalloan_dtl_rpt");
            } else if (this.isFromByLoan()) {
                showParameter.setFormId("bdim_loandyndetailrpt");
            } else if (this.isFromByEpeloancollect()) {
                showParameter.setFormId("cfm_epeloandetail_rpt");
            } else if (this.isFromFinlease()) {
                showParameter.setFormId("fl_tradefinancerpt");
            } else {
                showParameter.setFormId("cfm_tradefinancerpt");
            }
            List<DynamicObject> rows = this.getHyperLinkData(reportList, hyperLinkClickEvent.getRowIndex());
            showParameter.setCustomParam("filters", (Object)SerializationUtils.serializeToBase64(this.getHyperLinkParam(rows)));
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private Map<String, Object> getHyperLinkParam(List<DynamicObject> curRowDatas) {
        String finProductName;
        DynamicObject finProduct;
        IDataModel model = this.getModel();
        Object bizDateRanges = model.getValue("bizdateranges");
        boolean isCustom = RptDateRangeEnum.CUSTOM.getValue().equals(bizDateRanges);
        Object bizDateStartDate = isCustom ? model.getValue("bizdateranges_startdate") : null;
        Object bizDateEndDate = isCustom ? model.getValue("bizdateranges_enddate") : null;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        StringBuilder creditorIds = new StringBuilder();
        StringBuilder creditors = new StringBuilder();
        MulBasedataDynamicObjectCollection loanCurrency = new MulBasedataDynamicObjectCollection();
        String statdim = (String)model.getValue("filter_statdim");
        for (DynamicObject curRowData : curRowDatas) {
            this.addOrgIds(orgIds, curRowData, statdim);
            this.addCreditorIds(creditorIds, curRowData);
            this.addCreditors(creditors, curRowData);
            this.addLoanCurrency(loanCurrency, curRowData);
        }
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(16);
        param.put("filter_querycutoffdate", model.getValue("filter_querycutoffdate"));
        param.put("filter_cutoffdate", model.getValue("filter_cutoffdate"));
        Object lenderNature = model.getValue("filter_lendernature");
        param.put("filter_lendernature", lenderNature);
        param.put("filter_queryway", model.getValue("filter_queryway"));
        param.put("filter_orgview", model.getValue("filter_orgview"));
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(model.getValue("filter_queryway")) && (statdim.contains("orgname") || statdim.contains("creditorname"))) {
            param.put("filter_queryway", ReportOrgQueryWayEnum.ORG.getValue());
            param.put("filter_orgview", null);
        }
        param.put("filter_org", orgIds.stream().toArray());
        param.put("filter_creditor", EmptyUtil.isNoEmpty((String)creditors.toString()) ? creditors.substring(0, creditors.length() - 1) : "");
        param.put("filter_creditorid", EmptyUtil.isNoEmpty((String)creditorIds.toString()) ? creditorIds.substring(0, creditorIds.length() - 1) : "");
        String creditType = (String)model.getValue("filter_creditortype");
        if (!this.isEntrust() && "fincreditortype,loancurrencyname".equals(statdim) && EmptyUtil.isNoEmpty(curRowDatas)) {
            creditType = curRowDatas.get(0).getString("fincreditortype");
            if (CreditorTypeEnum.OTHER.getValue().equals(creditType)) {
                creditType = "";
                param.put("filter_creditorid", "2");
            }
        }
        param.put("filter_creditortype", creditType);
        DynamicObjectCollection finProducts = (DynamicObjectCollection)model.getValue("filter_finproduct");
        List productIds = finProducts.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        if ("finproductname,loancurrencyname".equals(statdim) && EmptyUtil.isNoEmpty(curRowDatas) && EmptyUtil.isNoEmpty((DynamicObject)(finProduct = QueryServiceHelper.queryOne((String)"cfm_financingvarieties", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)(finProductName = curRowDatas.get(0).getString("finproductname")))})))) {
            productIds.add(finProduct.getLong("id"));
        }
        param.put("filter_finproduct", productIds.stream().toArray());
        param.put("bizdateranges", bizDateRanges);
        param.put("bizdateranges_startdate", bizDateStartDate);
        param.put("bizdateranges_enddate", bizDateEndDate);
        param.put("filter_currencies", loanCurrency.size() != 0 ? loanCurrency : null);
        param.put("filter_includecloseout", model.getValue("filter_includecloseout"));
        param.put("filter_includebond", model.getValue("filter_includebond"));
        param.put("filter_datasource", model.getValue("filter_datasource"));
        param.put("filter_currencyunit", model.getValue("filter_currencyunit"));
        String bankLevel = (String)model.getValue("filter_banklevel");
        if (!statdim.contains("creditorname")) {
            bankLevel = "2";
        }
        param.put("filter_banklevel", bankLevel);
        String statDim = this.getDetailStadim().getOrDefault(statdim, "fincreditorname");
        param.put("filter_statdim", statDim);
        param.put("filter_statcurrency", model.getValue("filter_statcurrency"));
        if (this.isFromByInternalLoan()) {
            DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("filter_settlecenter");
            param.put("filter_settlecenter", value.stream().map(d -> d.getLong("fbasedataid_id")).toArray());
        }
        return param;
    }

    private List<DynamicObject> getHyperLinkData(ReportList reportList, int rowIndex) {
        ArrayList<DynamicObject> hyperLinkData = new ArrayList<DynamicObject>(16);
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject selRow = reportModel.getRowData(rowIndex);
        String showType = (String)this.getModel().getValue("filter_showttype");
        if ("tile".equals(showType) || selRow.getDynamicObjectType().getProperties().containsKey((Object)"isgroupnode") && !selRow.getBoolean("isgroupnode")) {
            hyperLinkData.add(selRow);
            return hyperLinkData;
        }
        ArrayList<Object> rowIds = new ArrayList<Object>(16);
        rowIds.add(selRow.get("rowid"));
        int totalRecords = reportList.getTotalRecords();
        for (int i = rowIndex + 1; i <= totalRecords; ++i) {
            DynamicObject data = reportModel.getRowData(i);
            Object pId = data.get("pid");
            boolean isGroupNode = data.getBoolean("isgroupnode");
            if (!data.getString("sumlevel").equals("0") || !rowIds.contains(pId)) break;
            if (!isGroupNode) {
                hyperLinkData.add(data);
                continue;
            }
            rowIds.add(data.get("rowid"));
        }
        return hyperLinkData;
    }

    private void addOrgIds(List<Long> orgIds, DynamicObject curRowData, String statdim) {
        String orgId;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("orgid")) && EmptyUtil.isNoEmpty((String)(orgId = curRowData.getString(this.isEntrust() ? "creditorid" : "orgid")))) {
            orgIds.add(Long.valueOf(orgId));
            return;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
            orgIds.addAll(orgs.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void addCreditorIds(StringBuilder creditorIds, DynamicObject curRowData) {
        String creditorId;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("creditorid")) && EmptyUtil.isNoEmpty((String)(creditorId = curRowData.getString(this.isEntrust() ? "orgid" : "creditorid")))) {
            creditorIds.append(creditorId).append(";");
            return;
        }
        String filterCreditorIds = (String)this.getModel().getValue("filter_creditorid");
        if (EmptyUtil.isNoEmpty((String)filterCreditorIds)) {
            creditorIds.append(filterCreditorIds).append(";");
        }
    }

    private void addCreditors(StringBuilder creditors, DynamicObject curRowData) {
        String creditor;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("creditorname")) && EmptyUtil.isNoEmpty((String)(creditor = curRowData.getString(this.isEntrust() ? "orgname" : "creditorname")))) {
            creditors.append(creditor).append(";");
            return;
        }
        String filterCreditors = (String)this.getModel().getValue("filter_creditor");
        if (EmptyUtil.isNoEmpty((String)filterCreditors)) {
            creditors.append(filterCreditors).append(";");
        }
    }

    private void addLoanCurrency(MulBasedataDynamicObjectCollection loanCurrency, DynamicObject curRowData) {
        DynamicObject currency;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("loancurrency")) && !EmptyUtil.isEmpty((DynamicObject)(currency = curRowData.getDynamicObject("loancurrency")))) {
            loanCurrency.add(currency);
            return;
        }
        currency = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_currencies");
        for (DynamicObject c : currency) {
            loanCurrency.add(c);
        }
    }

    private boolean isFromByInternalLoan() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "ifm_internalloan_clt_rpt".equals(formId);
    }

    public boolean isFromByEpeloancollect() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "cfm_epeloancollect_rpt".equals(formId);
    }

    private boolean isFromByLoan() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "bdim_loandynsumrpt".equals(formId);
    }

    private boolean isFromFinlease() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "fl_tradefinancesumrpt".equals(formId);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        Boolean showStep = "step".equals(this.getModel().getValue("filter_showttype"));
        String statDim = (String)this.getModel().getValue("filter_statdim");
        event.setTreeReportList(showStep != false && "orgname,loancurrencyname".equals(statDim));
    }

    private Map<String, String> getDetailStadim() {
        HashMap<String, String> staDims = new HashMap<String, String>();
        staDims.put("creditorname,loancurrencyname", "fincreditorname");
        staDims.put("fincreditortype,loancurrencyname", "fincreditortype");
        staDims.put("finproductname,loancurrencyname", "finproductname");
        staDims.put("orgname,loancurrencyname", "fincompanyname");
        return staDims;
    }

    protected boolean isEntrust() {
        return false;
    }
}

