/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.cfm.common.enums.GuaranteeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.resource.CfmCommonResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySchemeEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entrys");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit referRateF7 = (BasedataEdit)this.getControl("s_referrate");
        referRateF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditLimitF7 = (BasedataEdit)this.getControl("e_creditlimit");
        creditLimitF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finProductF7 = (BasedataEdit)this.getControl("s_finproduct");
        finProductF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"e_textcost"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                LoanApplySchemeEditPlugin.this.setEntryFeildEnable();
                LoanApplySchemeEditPlugin.this.initCreditorTypeComb();
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)"e_textcost", (CharSequence)((TextEdit)evt.getSource()).getFieldKey())) {
            BasedataEdit sampleCostEdit = (BasedataEdit)this.getControl("samplecost");
            sampleCostEdit.click();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"e_scheme", (CharSequence)evt.getFieldName())) {
            BillShowParameter parameter = new BillShowParameter();
            DynamicObject entryRow = this.getModel().getEntryRowEntity("entrys", evt.getRowIndex());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setFormId("cfm_financingscheme");
            parameter.setPkId(entryRow.getDynamicObject("e_scheme").getPkValue());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        this.verifyInput(source.getKey(), e.getValue(), e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "s_name": 
            case "s_number": 
            case "s_currency": {
                this.syncCardInfo(propertyName);
                break;
            }
            case "s_interestrate": {
                this.setSchemeEntryValue("e_interestrate", newValue);
                this.calcInterestCostAmt();
                break;
            }
            case "s_compcostrate": {
                model.setValue("c_compcostrate", newValue, model.getEntryCurrentRowIndex("entry"), 0);
                break;
            }
            case "isneedscheme": {
                this.isNeedSchemeChgEvt();
                break;
            }
            case "e_costamt": {
                this.calcCompCost();
                break;
            }
            case "s_startdate": 
            case "s_enddate": {
                this.termDateChgEvt(propertyName, (Date)oldValue);
                break;
            }
            case "s_term": {
                this.calcEndDate();
            }
            case "s_compcost": 
            case "s_amount": {
                this.calcCompcostRate();
                this.calcInterestCostAmt();
                break;
            }
            case "s_interesttype": {
                this.calcInterestCostAmt();
                this.calcEntryInterestrate();
                break;
            }
            case "s_referrate": 
            case "s_ratesign": 
            case "s_ratefloatpoint": {
                this.getView().updateView(propertyName, 0, this.getModel().getEntryCurrentRowIndex("entry"));
                this.calcEntryInterestrate();
                this.calcInterestCostAmt();
                this.setSchemeEntryValue("e_interestrate", this.getCardEntryValue("s_interestrate"));
                break;
            }
            case "s_fintype": {
                int parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                String creditorType = (String)this.getModel().getValue("s_creditortype", 0, parentRowIndex);
                if (!this.isRightCreditorType(creditorType)) {
                    this.setSchemeEntryValue("s_creditortype", null);
                }
                this.initCreditorTypeComb();
                break;
            }
            case "samplecost": {
                boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
                if (!isNeedScheme || null == newValue) break;
                this.sampleCostChgEvt();
                break;
            }
            case "creditlimit": {
                if (model.getEntryRowCount("entrys") <= 0 || EmptyUtil.isEmpty((Object)newValue)) break;
                model.setValue("e_creditlimit", newValue, model.getEntryCurrentRowIndex("entrys"));
                break;
            }
            case "e_isselect": {
                boolean isSelect = (Boolean)newValue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"creditlimit", null);
                Integer currIndex = isSelect ? Integer.valueOf(model.getEntryCurrentRowIndex("entrys")) : null;
                this.registerCreditEnable(currIndex);
                break;
            }
            case "ratesign": 
            case "ratefloatpoint": {
                this.calcEntryInterestrate();
                break;
            }
            case "s_ratecyclesign": {
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                this.setSchemeEntryValue("s_ratecyclesign", "M");
                break;
            }
            case "s_finproduct": {
                this.autoWriteRateInfo();
                break;
            }
            case "s_creditortype": {
                if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(newValue) && !CreditorTypeEnum.SETTLECENTER.getValue().equals(oldValue)) break;
                this.setCardEntryValue("s_finproduct", null);
                break;
            }
            case "s_guaranteeway": {
                this.dealNoGuaranteeOnNumber(newValue, oldValue, propertyName);
                break;
            }
        }
    }

    private void dealNoGuaranteeOnNumber(Object newValue, Object oldValue, String propertyName) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        ComboEdit guarantee = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(8);
        if (!GuaranteeEnum.isSelectWithoutNone((String)((String)oldValue)) && GuaranteeEnum.isSelectAll((String)((String)newValue))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propertyName, (Object)",2,4,5,6,", (int)0, (int)parentRowIndex);
        } else if (newValue != null && ((String)newValue).contains(GuaranteeEnum.NONE.getValue())) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propertyName, (Object)"7", (int)0, (int)parentRowIndex);
        } else {
            data.add(new ComboItem(new LocaleString(GuaranteeEnum.getName((String)GuaranteeEnum.ENSURE.getValue())), GuaranteeEnum.ENSURE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeEnum.getName((String)GuaranteeEnum.MORTGAGE.getValue())), GuaranteeEnum.MORTGAGE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeEnum.getName((String)GuaranteeEnum.PLEDGE.getValue())), GuaranteeEnum.PLEDGE.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeEnum.getName((String)GuaranteeEnum.OTHER.getValue())), GuaranteeEnum.OTHER.getValue()));
            data.add(new ComboItem(new LocaleString(GuaranteeEnum.getName((String)GuaranteeEnum.NONE.getValue())), GuaranteeEnum.NONE.getValue()));
            guarantee.setComboItems(data);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entry".equals(entryName)) {
            this.genAndSetSchemeNumber(e);
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"costinfo"}, (boolean)true);
            int parentRowIndex = this.getModel().getEntryRowCount("entry") - 1;
            this.getModel().setValue("e_textcost", (Object)ResManager.loadKDString((String)"\u5229\u606f", (String)"LoanApplySchemeEditPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), 0, parentRowIndex);
            this.getModel().setValue("s_currency", this.getModel().getValue("currency"), 0, parentRowIndex);
            this.getModel().setValue("s_amount", this.getModel().getValue("amount"), 0, parentRowIndex);
            this.setEntryFeildEnable();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entry".equals(entryName)) {
            this.setCardEntryShowView();
        }
        if ("c_entry".equals(entryName)) {
            this.calcCompCost();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String viewType = StringUtils.equals((CharSequence)((String)model.getValue("billstatus")), (CharSequence)BillStatusEnum.SAVE.getValue()) ? "cardview" : "listview";
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"viewtype", (Object)viewType);
        this.switchView();
        this.registerCreditEnable(null);
        this.setCardEntryShowView();
        this.initSchemeSelect();
        model.setDataChanged(false);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexArr;
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (("c_entry".equals(entryProp.getName()) || "costentry".equals(entryProp.getName())) && (rowIndexArr = e.getRowIndexs())[0] == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5229\u606f\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"LoanApplySchemeEditPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (isNeedScheme.booleanValue() && ("submit".equals(operateKey) || "save".equals(operateKey))) {
            operate.getOption().setVariableValue("submit_by_card", "true");
            if (!this.validateSchemeNumber()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "switchview": {
                this.switchView();
                break;
            }
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                model.setValue("viewtype", (Object)"listview");
                this.switchView();
                this.initSchemeSelect();
                model.setDataChanged(false);
                break;
            }
            case "unaudit": 
            case "unsubmit": {
                if (!args.getOperationResult().isSuccess()) break;
                model.setValue("viewtype", (Object)"cardview");
                this.switchView();
                break;
            }
            case "save": {
                if (args.getOperationResult().isSuccess() && !((Boolean)model.getValue("isneedscheme")).booleanValue()) {
                    model.setValue("viewtype", (Object)"cardview");
                    boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
                    if (!isNeedScheme) {
                        this.getModel().deleteEntryData("entry");
                    }
                }
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("e_creditlimit".equals(propName)) {
            this.initCreditLimitFilter(evt);
        } else if ("s_referrate".equals(propName)) {
            this.initReferRateFilter(evt);
        } else if ("s_finproduct".equals(propName)) {
            this.initFinproductFilter(evt);
        }
    }

    private void initFinproductFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        int parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        String creditorType = (String)this.getModel().getValue("s_creditortype", 0, parentRowIndex);
        if (EmptyUtil.isEmpty((String)creditorType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"LoanApplySchemeEditPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("s_currency", 0, parentRowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"FinancingSchemeEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long creditor = (Long)this.getModel().getValue("s_creditor", 0, parentRowIndex);
            QFilter qFilter = new QFilter("currency", "=", currency.getPkValue());
            if (EmptyUtil.isNoEmpty((Long)creditor)) {
                qFilter.and(new QFilter("center.id", "=", (Object)creditor));
            }
            List ids = Arrays.stream(TmcDataServiceHelper.load((String)"ifm_ldproduct", (String)"id", (QFilter[])new QFilter[]{qFilter})).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
            qFilters.add(new QFilter("biztype", "=", (Object)"ifm"));
            showParameter.getCustomParams().put("containDefault", "true");
        } else {
            qFilters.add(new QFilter("biztype", "=", (Object)"cfm"));
        }
        showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if (StringUtils.equals((CharSequence)key, (CharSequence)"s_term") && !TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
            e.setCancel(true);
            this.getView().updateView(key, 0, this.getModel().getEntryCurrentRowIndex("entry"));
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"term") && !TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
            e.setCancel(true);
            this.getView().updateView(key);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"s_creditortype") && !this.isRightCreditorType((String)value)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u878d\u8d44\u4e1a\u52a1\u5206\u7c7b\u5bf9\u5e94\u7684\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"LoanApplySchemeEditPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key, 0, this.getModel().getEntryCurrentRowIndex("entry"));
        }
    }

    private void setSchemeEntryValue(String propName, Object value) {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("entry");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)value, (int)0, (int)currentRowIndex);
    }

    private void isNeedSchemeChgEvt() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"scheinfo"}, (boolean)isNeedScheme);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"fs_applyinfo"}, (!isNeedScheme ? 1 : 0) != 0);
        this.setCardEntryShowView();
        if (isNeedScheme && this.getModel().getEntryRowCount("entry") == 0) {
            this.getView().invokeOperation("newentry");
        }
    }

    private void sampleCostChgEvt() {
        IDataModel model = this.getModel();
        DynamicObject sampleCost = (DynamicObject)model.getValue("samplecost");
        int parentRowIndex = model.getEntryCurrentRowIndex("entry");
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("c_entry");
        model.setValue("e_cost", (Object)sampleCost, entryCurrentRowIndex, parentRowIndex);
        model.setValue("e_textcost", (Object)sampleCost.getString("name"), entryCurrentRowIndex, parentRowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"samplecost", null);
    }

    private void setEntryRate() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("entrys");
        if (!CollectionUtils.isEmpty((Collection)entrys)) {
            int len = entrys.size();
            for (int i = 0; i < len; ++i) {
                DynamicObject scheme = ((DynamicObject)entrys.get(i)).getDynamicObject("e_scheme");
                if (null == scheme) continue;
                String interestType = scheme.getString("interesttype");
                if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
                    model.setValue("e_rate", (Object)scheme.getBigDecimal("interestrate"), i);
                    continue;
                }
                DynamicObjectCollection costEntrys = scheme.getDynamicObjectCollection("entry");
                BigDecimal cost = costEntrys.stream().filter(v -> null == v.getDynamicObject("e_cost")).map(v -> v.getBigDecimal("e_interestrate")).findFirst().orElse(BigDecimal.ZERO);
                model.setValue("e_rate", (Object)cost, i);
            }
        }
    }

    private void calcEntryInterestrate() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("entry", currentRowIndex);
        if (null == cardEntry) {
            return;
        }
        DynamicObject schemeInfo = (DynamicObject)cardEntry.getDynamicObjectCollection("s_entry").get(0);
        IDataModel model = this.getModel();
        String interestType = schemeInfo.getString("s_interesttype");
        if (StringUtils.equals((CharSequence)interestType, (CharSequence)InterestTypeEnum.FIXED.getValue())) {
            return;
        }
        String rateSign = schemeInfo.getString("s_ratesign");
        if (EmptyUtil.isEmpty((String)rateSign)) {
            rateSign = RateSignEnum.ADD.getValue();
            this.setSchemeEntryValue("s_ratesign", rateSign);
        }
        DynamicObject referRate = schemeInfo.getDynamicObject("s_referrate");
        Date startDate = schemeInfo.getDate("s_startdate");
        if (null == referRate || null == startDate) {
            model.beginInit();
            this.setSchemeEntryValue("s_interestrate", 0);
            model.endInit();
            return;
        }
        BigDecimal rate = MarketDataServiceHelper.referRate((String)referRate.getString("number"), (Date)startDate, (boolean)false);
        if (null == rate || BigDecimal.ZERO.compareTo(rate) == 0) {
            this.setSchemeEntryValue("s_interestrate", null);
            return;
        }
        BigDecimal rateFloatPoint = schemeInfo.getBigDecimal("s_ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (StringUtils.equals((CharSequence)RateSignEnum.SUBTRACT.getValue(), (CharSequence)rateSign)) {
            rateFloat = rateFloat.negate();
        }
        this.setSchemeEntryValue("s_interestrate", rate.add(rateFloat));
    }

    private void calcInterestCostAmt() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("entry", entryCurrentRowIndex);
        DynamicObject schemeInfo = (DynamicObject)cardEntry.getDynamicObjectCollection("s_entry").get(0);
        Date startDate = schemeInfo.getDate("s_startdate");
        Date endDate = schemeInfo.getDate("s_enddate");
        if (EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
            return;
        }
        BigDecimal amount = schemeInfo.getBigDecimal("s_amount");
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            return;
        }
        int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
        BigDecimal rate = schemeInfo.getBigDecimal("s_interestrate");
        BigDecimal interestCostAmt = rate.multiply(new BigDecimal(termDays)).multiply(amount).divide(new BigDecimal(36000), amount.scale(), 4);
        this.getModel().setValue("e_costamt", (Object)interestCostAmt, 0, entryCurrentRowIndex);
    }

    private void registerCreditEnable(Integer rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("entrys");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        Object schemeId = null;
        if (null == rowIndex) {
            schemeId = entrys.stream().filter(v -> v.getBoolean("e_isselect")).map(v -> v.getDynamicObject("e_scheme").getPkValue()).findFirst().orElse(null);
            rowIndex = -1;
        }
        String selectscheme = (String)this.getView().getFormShowParameter().getCustomParams().get("selectscheme");
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject scheme = ((DynamicObject)entrys.get(i)).getDynamicObject("e_scheme");
            if (i == rowIndex || Objects.equals(schemeId, scheme.getPkValue())) {
                boolean isEnable;
                String creditorType = scheme.getString("creditortype");
                boolean isSelect = ((DynamicObject)entrys.get(i)).getBoolean("e_isselect");
                boolean bl = isEnable = !CreditorTypeEnum.OTHER.getValue().equals(creditorType);
                if (EmptyUtil.isNoEmpty((String)selectscheme) || isSelect) {
                    this.getView().setEnable(Boolean.valueOf(isEnable), rowIndex.intValue(), new String[]{"e_creditlimit"});
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex.intValue(), new String[]{"e_reson"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex.intValue(), new String[]{"e_creditlimit"});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex.intValue(), new String[]{"e_reson"});
                }
                DynamicObject creditLimit = (DynamicObject)model.getValue("creditlimit");
                if (!EmptyUtil.isEmpty((DynamicObject)creditLimit)) {
                    model.setValue("e_creditlimit", creditLimit.getPkValue(), i);
                }
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                valueMap.put("finproduct", scheme.get("finproduct"));
                valueMap.put("creditortype", scheme.get("creditortype"));
                valueMap.put("creditor", scheme.get("creditor"));
                valueMap.put("textcreditor", scheme.get("textcreditor"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, valueMap);
                model.setDataChanged(false);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_creditlimit", "e_reson"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"e_creditlimit", null, (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"e_reson", null, (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"e_isselect", (Object)"0", (int)i);
        }
    }

    private void calcEndDate() {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("s_entry", 0, currRowIndex);
        Date startDate = entry.getDate("s_startdate");
        String termStr = entry.getString("s_term");
        if (null == startDate || EmptyUtil.isEmpty((String)termStr)) {
            return;
        }
        Date endDate = TermHelper.getDateByTerm((String)termStr, (Date)startDate);
        this.setSchemeEntryValue("s_enddate", endDate);
    }

    private void calcTerm() {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("s_entry", 0, currRowIndex);
        Date startDate = entry.getDate("s_startdate");
        Date endDate = entry.getDate("s_enddate");
        if (null == startDate || null == endDate) {
            return;
        }
        String cardTerm = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
        this.setSchemeEntryValue("s_term", cardTerm);
    }

    private void calcCompCost() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("c_entry");
        this.setSchemeEntryValue("s_compcost", entryGrid.getSum("e_costamt"));
        this.calcCompcostRate();
    }

    private void termDateChgEvt(String propName, Date oldValue) {
        if (!this.checkDate()) {
            if (StringUtils.equals((CharSequence)"s_startdate", (CharSequence)propName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u5fc5\u987b\u5c0f\u4e8e\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanApplySchemeEditPlugin_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u9884\u8ba1\u5f00\u59cb\u65e5\u3002", (String)"LoanApplySchemeEditPlugin_9", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            this.setCardEntryValue(propName, oldValue);
            return;
        }
        this.calcTerm();
        this.calcCompcostRate();
        this.calcInterestCostAmt();
        this.calcEntryInterestrate();
    }

    private boolean checkDate() {
        Date endDate;
        Date startDate = (Date)this.getCardEntryValue("s_startdate");
        return EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate = (Date)this.getCardEntryValue("s_enddate")}) || startDate.compareTo(endDate) < 0;
    }

    private void switchView() {
        this.setEntryRate();
        String viewType = (String)this.getModel().getValue("viewtype");
        if (StringUtils.equals((CharSequence)viewType, (CharSequence)"cardview")) {
            this.refreshCardEntry();
        } else if (!StringUtils.equals((CharSequence)((String)this.getModel().getValue("billstatus")), (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.refreshSchemeEntrys();
        }
    }

    private void refreshCardEntry() {
        DynamicObject loanApplyBill = this.getModel().getDataEntity();
        DynamicObjectCollection schemeEntrys = loanApplyBill.getDynamicObjectCollection("entrys");
        if (CollectionUtils.isEmpty((Collection)schemeEntrys)) {
            return;
        }
        List schemes = schemeEntrys.stream().map(v -> v.getDynamicObject("e_scheme")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(schemes)) {
            Object[] schemesIds = schemes.stream().filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
            DynamicObject[] schemesFromDB = TmcDataServiceHelper.load((Object[])schemesIds, (DynamicObjectType)TmcDataServiceHelper.newDynamicObject((String)"cfm_financingscheme").getDynamicObjectType());
            schemes.clear();
            schemes.addAll(Arrays.asList(schemesFromDB));
        }
        DynamicObjectCollection entrys = loanApplyBill.getDynamicObjectCollection("entry");
        entrys.clear();
        String selectScheme = this.getSelectScheme(loanApplyBill);
        for (DynamicObject scheme : schemes) {
            DynamicObject bodyInfo = entrys.addNew();
            bodyInfo.set("c_number", (Object)scheme.getString("number"));
            bodyInfo.set("c_name", (Object)scheme.getString("name"));
            bodyInfo.set("c_currency", scheme.get("currency"));
            bodyInfo.set("c_compcostrate", (Object)scheme.getBigDecimal("compcostrate"));
            boolean isSelect = Objects.equals(selectScheme, scheme.getString("number"));
            bodyInfo.set("selecttag", (Object)isSelect);
            if (isSelect) {
                Label selectCard = (Label)this.getControl("selectcard");
                selectCard.setText(CfmCommonResourceEnum.LoanApplyCardEdit_0.loadKDString(new Object[]{selectScheme}));
            }
            DynamicObjectCollection sEntrys = bodyInfo.getDynamicObjectCollection("s_entry");
            DynamicObject newEntry = sEntrys.addNew();
            DataEntityPropertyCollection props = newEntry.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : props) {
                String propName = prop.getName();
                if (!propName.startsWith("s_")) continue;
                String realPropName = propName.replace("s_", "");
                newEntry.set(propName, scheme.get(realPropName));
            }
            this.getView().updateView("s_currency", 0, 0);
            DynamicObjectCollection cEntry = bodyInfo.getDynamicObjectCollection("c_entry");
            DynamicObjectCollection costEntrys = scheme.getDynamicObjectCollection("entry");
            for (DynamicObject schemeEntry : costEntrys) {
                DynamicObject newSchemeEntry = cEntry.addNew();
                newSchemeEntry.set("e_interestrate", schemeEntry.get("e_interestrate"));
                newSchemeEntry.set("e_cost", schemeEntry.get("e_cost"));
                newSchemeEntry.set("e_costamt", schemeEntry.get("e_costamt"));
                newSchemeEntry.set("e_textcost", schemeEntry.get("e_textcost"));
            }
        }
        this.getView().updateView("entry");
        CardEntry control = (CardEntry)this.getControl("entry");
        control.selectCard(Integer.valueOf(0));
    }

    private void refreshSchemeEntrys() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("entrys");
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject scheme = ((DynamicObject)entrys.get(i)).getDynamicObject("e_scheme");
            if (EmptyUtil.isEmpty((DynamicObject)scheme)) continue;
            model.setValue("e_schemename", (Object)scheme.getString("name"), i);
            model.setValue("e_finproduct", scheme.getDynamicObject("finproduct").getPkValue(), i);
            model.setValue("e_textcreditor", (Object)scheme.getString("textcreditor"), i);
            model.setValue("e_term", (Object)scheme.getString("term"), i);
            model.setValue("e_startdate", (Object)scheme.getDate("startdate"), i);
            model.setValue("e_enddate", (Object)scheme.getDate("enddate"), i);
            model.setValue("e_interesttype", (Object)scheme.getString("interesttype"), i);
            model.setValue("e_compcost", (Object)scheme.getBigDecimal("compcost"), i);
            model.setValue("e_compcostrate", (Object)scheme.getBigDecimal("compcostrate"), i);
            model.setValue("e_guaranteeway", (Object)scheme.getString("guaranteeway"), i);
            model.setValue("e_amount", (Object)scheme.getBigDecimal("amount"), i);
            DynamicObject settleScheme = scheme.getDynamicObject("settlescheme");
            if (null != settleScheme) {
                model.setValue("e_settlescheme", settleScheme.getPkValue(), i);
            }
            model.setValue("e_repaymentway", (Object)scheme.getString("repaymentway"), i);
            model.setValue("e_loancurrency", scheme.getDynamicObject("currency").getPkValue(), i);
            model.setValue("e_iscycleloan", (Object)scheme.getBoolean("iscycleloan"), i);
        }
    }

    private void genAndSetSchemeNumber(AfterAddRowEventArgs e) {
        if (!this.isExistSchemeCodeRule()) {
            return;
        }
        IDataModel model = this.getModel();
        String schemeNumber = CodeRuleHelper.generateNumber((String)"cfm_financingscheme", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cfm_financingscheme"), (String)model.getDataEntity().getDynamicObject("company").getString("id"), (String)"");
        int currRowIndex = e.getRowDataEntities()[0].getRowIndex();
        CardEntry cardEntry = (CardEntry)this.getControl("entry");
        cardEntry.selectCard(Integer.valueOf(currRowIndex));
        model.setValue("s_number", (Object)schemeNumber, 0, currRowIndex);
        model.setValue("c_number", (Object)schemeNumber, currRowIndex);
    }

    private void setCardEntryShowView() {
        IDataModel model = this.getModel();
        boolean isNeedScheme = (Boolean)model.getValue("isneedscheme");
        if (!isNeedScheme) {
            return;
        }
        DynamicObjectCollection entrys = model.getEntryEntity("entry");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            model.deleteEntryData("entry");
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"costinfo"}, (boolean)false);
        }
    }

    private void initSchemeSelect() {
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
            return;
        }
        boolean isNeedScheme = (Boolean)model.getValue("isneedscheme");
        if (!isNeedScheme) {
            return;
        }
        String selectScheme = this.getView().getFormShowParameter().getCustomParams().getOrDefault("selectscheme", "");
        String scene = (String)this.getView().getFormShowParameter().getCustomParams().get("SCENE");
        boolean isLock = StringUtils.equals((CharSequence)selectScheme, (CharSequence)"true") || StringUtils.equals((CharSequence)scene, (CharSequence)"AUDITFLOW");
        DynamicObjectCollection entrys = model.getEntryEntity("entrys");
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            this.getView().setEnable(Boolean.valueOf(isLock), i, new String[]{"e_isselect"});
            this.getView().setEnable(Boolean.valueOf(((DynamicObject)entrys.get(i)).getBoolean("e_isselect")), i, new String[]{"e_creditlimit", "e_reson"});
        }
    }

    private void calcCompcostRate() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("entry", currentRowIndex);
        DynamicObject schemeInfo = (DynamicObject)cardEntry.getDynamicObjectCollection("s_entry").get(0);
        IDataModel model = this.getModel();
        BigDecimal compCost = schemeInfo.getBigDecimal("s_compcost");
        BigDecimal amount = schemeInfo.getBigDecimal("s_amount");
        Date startDate = schemeInfo.getDate("s_startdate");
        Date endDate = schemeInfo.getDate("s_enddate");
        if (BigDecimal.ZERO.compareTo(compCost) == 0) {
            model.setValue("s_compcostrate", (Object)BigDecimal.ZERO, 0, currentRowIndex);
            return;
        }
        if (BigDecimal.ZERO.compareTo(compCost.multiply(amount)) == 0 || EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
            return;
        }
        int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
        BigDecimal compCostRate = compCost.multiply(new BigDecimal(36000)).divide(amount.multiply(new BigDecimal(termDays)), amount.scale(), 4);
        model.setValue("s_compcostrate", (Object)compCostRate, 0, currentRowIndex);
    }

    private boolean isExistSchemeCodeRule() {
        String isExistSchemeCodeRule = this.getPageCache().get("isExistSchemeCodeRule");
        if (!EmptyUtil.isEmpty((String)isExistSchemeCodeRule) && !isExistSchemeCodeRule.trim().equals("")) {
            return Boolean.parseBoolean(isExistSchemeCodeRule);
        }
        String orgID = this.getModel().getDataEntity().getDynamicObject("company").getString("id");
        boolean isExist = CodeRuleServiceHelper.isExist((String)"cfm_financingscheme", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cfm_financingscheme"), (String)orgID);
        this.getPageCache().put("isExistSchemeCodeRule", String.valueOf(isExist));
        return isExist;
    }

    private void setEntryFeildEnable() {
        this.getView().setEnable(Boolean.valueOf(!this.isExistSchemeCodeRule()), 0, new String[]{"s_number"});
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"e_textcost", "e_interestrate", "e_costamt"});
    }

    private boolean isRightCreditorType(String creditorType) {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("s_entry", 0, currRowIndex);
        if (EmptyUtil.isEmpty((String)creditorType)) {
            return true;
        }
        String finType = entry.getString("s_fintype");
        List<String> rightCreditorType = StringUtils.equals((CharSequence)LoanTypeEnum.BANKLOAN.getValue(), (CharSequence)finType) || StringUtils.equals((CharSequence)LoanTypeEnum.BANKSLOAN.getValue(), (CharSequence)finType) ? Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()) : Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue());
        return rightCreditorType.contains(creditorType);
    }

    private boolean validateSchemeNumber() {
        if (!((Boolean)this.getModel().getValue("isneedscheme")).booleanValue()) {
            return false;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return true;
        }
        HashSet<String> numbers = new HashSet<String>(entrys.size());
        for (DynamicObject entry : entrys) {
            String number = ((DynamicObject)entry.getDynamicObjectCollection("s_entry").get(0)).getString("s_number");
            if (EmptyUtil.isEmpty((String)number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u65b9\u6848\u7f16\u7801\u201d\u3002", (String)"LoanApplySchemeEditPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return false;
            }
            numbers.add(number);
        }
        if (numbers.size() != entrys.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u5148\u4fee\u6539\u3002", (String)"LoanApplySchemeEditPlugin_10", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter filter = new QFilter("number", "in", numbers);
        filter.and(new QFilter("loanapply", "!=", this.getModel().getDataEntity().getPkValue()));
        Object[] loanSchemes = TmcDataServiceHelper.load((String)"cfm_financingscheme", (String)"number", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])loanSchemes)) {
            List schemeNumbers = Arrays.stream(loanSchemes).map(v -> v.getString("number")).collect(Collectors.toList());
            String schemeNumberStr = String.join((CharSequence)"\uff0c", schemeNumbers);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801%s\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u4fee\u6539\u3002", (String)"LoanApplySchemeEditPlugin_11", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), schemeNumberStr));
            return false;
        }
        return true;
    }

    private void autoWriteRateInfo() {
        int currRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject schemeEntry = this.getModel().getEntryRowEntity("s_entry", 0, currRowIndex);
        String creditorType = schemeEntry.getString("s_creditortype");
        if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            return;
        }
        DynamicObject finProduct = schemeEntry.getDynamicObject("s_finproduct");
        if (finProduct == null) {
            this.setSchemeEntryValue("s_interesttype", null);
            this.setSchemeEntryValue("s_ratesign", null);
            this.setSchemeEntryValue("s_ratefloatpoint", null);
            this.setSchemeEntryValue("s_referrate", null);
            this.setSchemeEntryValue("s_interestrate", null);
            return;
        }
        DynamicObject ldProduct = QueryServiceHelper.queryOne((String)"ifm_ldproduct", (String)"id,ratetype,basis,floatrate,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finProduct.getLong("id"))});
        if (ldProduct == null) {
            return;
        }
        String rateType = ldProduct.getString("ratetype");
        boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(rateType);
        this.setSchemeEntryValue("s_interesttype", rateType);
        BigDecimal productRate = ldProduct.getBigDecimal("productprice");
        if (isFloatRate) {
            this.setSchemeEntryValue("s_ratesign", ldProduct.getString("ratesignbp"));
            this.setSchemeEntryValue("s_ratefloatpoint", ldProduct.get("ratefloatpoints"));
            this.setSchemeEntryValue("s_referrate", ldProduct.getLong("referrate"));
        } else {
            this.setSchemeEntryValue("s_interestrate", productRate);
        }
    }

    private void initReferRateFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        int parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("s_currency", 0, parentRowIndex);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        if (null != currency) {
            qFilters.add(new QFilter("currency", "in", currency.getPkValue()));
        } else {
            qFilters.add(new QFilter("currency", "=", (Object)0));
        }
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private void initCreditLimitFilter(BeforeF7SelectEvent evt) {
        evt.setCancel(true);
        if (StringUtils.equals((CharSequence)"setItemByNumber", (CharSequence)evt.getSourceMethod())) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject entry = model.getEntryRowEntity("entrys", model.getEntryCurrentRowIndex("entrys"));
        DynamicObject scheme = entry.getDynamicObject("e_scheme");
        if (scheme == null) {
            return;
        }
        model.beginInit();
        model.setValue("finproduct", scheme.get("finproduct"));
        model.setValue("creditortype", scheme.get("creditortype"));
        model.setValue("creditor", scheme.get("creditor"));
        model.setValue("textcreditor", scheme.get("textcreditor"));
        model.setValue("startdate", scheme.get("startdate"));
        model.setValue("enddate", scheme.get("enddate"));
        model.setValue("loantype", scheme.get("fintype"));
        model.endInit();
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("creditlimit");
        creditLimitEdit.click();
    }

    private Object getCardEntryValue(String propName) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        return this.getModel().getValue(propName, 0, parentRowIndex.intValue());
    }

    private void setCardEntryValue(String propName, Object value) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)value, (int)0, (int)parentRowIndex);
    }

    public void syncCardInfo(String propName) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject cardEntry = this.getModel().getEntryRowEntity("entry", rowIndex);
        Object value = ((DynamicObject)cardEntry.getDynamicObjectCollection("s_entry").get(0)).get(propName);
        this.getModel().setValue(propName.replace("s_", "c_"), value, rowIndex);
    }

    private void initCreditorTypeComb() {
        boolean isNeedScheme = (Boolean)this.getModel().getValue("isneedscheme");
        if (isNeedScheme) {
            String loanType = (String)this.getCardEntryValue("s_fintype");
            List<String> comboItemValues = StringUtils.equals((CharSequence)LoanTypeEnum.BANKLOAN.getValue(), (CharSequence)loanType) ? Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()) : (StringUtils.equals((CharSequence)LoanTypeEnum.BANKSLOAN.getValue(), (CharSequence)loanType) ? Collections.singletonList(CreditorTypeEnum.BANK.getValue()) : Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
            List<ComboItem> comboItems = this.getEntryComboItems(comboItemValues);
            if (EmptyUtil.isNoEmpty(comboItems)) {
                ((ComboEdit)this.getView().getControl("s_creditortype")).setComboItems(comboItems);
            }
        }
    }

    private List<ComboItem> getEntryComboItems(List<String> comboItemValues) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Optional<IDataEntityProperty> optional = properties.stream().filter(v -> v.getName().equals("creditortype")).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        ComboProp comboProp = (ComboProp)optional.get();
        List valueMapItems = comboProp.getComboItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        for (ValueMapItem valueMapItem : valueMapItems) {
            String value = valueMapItem.getValue();
            if (!comboItemValues.contains(value)) continue;
            comboItems.add(new ComboItem(valueMapItem.getName(), value));
        }
        return comboItems;
    }

    private String getSelectScheme(DynamicObject loanBill) {
        DynamicObjectCollection entry = loanBill.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return null;
        }
        return entry.stream().filter(v -> v.getBoolean("e_isselect")).map(r -> r.getDynamicObject("e_scheme")).filter(EmptyUtil::isNoEmpty).map(v -> v.getString("number")).findFirst().orElse(null);
    }
}

