/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.PayMentbyInstalmentsEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class PayMentbyInstalments
extends AbstractBasePlugIn {
    private static final String TMC_CFM_FORMPLUGIN = "tmc-cfm-formplugin";
    private static final Map<String, String> ckDayMap = new HashMap<String, String>(50);
    private static final Map<String, String> ckMonthMap = new HashMap<String, String>(12);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        this.addClickListeners(new String[]{"month", "flexpmb", "flexpmlab", "day", "flexpdb", "flexpdlab"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int billStatus = this.getView().getFormShowParameter().getStatus().getValue();
        this.getView().setVisible(Boolean.valueOf(billStatus != 0), new String[]{"preset"});
        boolean isChanged = this.getModel().getDataChanged();
        this.changeCkMonth();
        this.changeCkDay();
        this.getModel().setDataChanged(isChanged);
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propName;
        super.propertyChanged(arg0);
        switch (propName = arg0.getProperty().getName()) {
            case "period": {
                this.changeInteresetPd();
                break;
            }
            case "month": {
                this.changeCkMonth();
                break;
            }
            case "day": {
                this.changeCkDay();
                break;
            }
            case "name": {
                String newValue = this.getModel().getValue("name").toString();
                boolean flag = this.checkName(newValue);
                if (!flag) break;
                this.getView().showMessage(this.loadKDString("\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", "PayMentbyInstalments_0"));
                return;
            }
            default: {
                if (ckDayMap.containsKey(propName)) {
                    this.setControlValue("day", this.repeatByDay(propName));
                }
                if (!ckMonthMap.containsKey(propName)) break;
                this.setControlValue("month", this.repeatByMonth());
            }
        }
    }

    private void setControlValue(String name, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(name, value);
        this.getModel().endInit();
        this.updateView(name);
    }

    private void updateView(String ... propNames) {
        IFormView view = this.getView();
        for (String propName : propNames) {
            view.updateView(propName);
        }
    }

    private void changeInteresetPd() {
        boolean isCycle;
        String pd = this.getModel().getValue("period").toString();
        PayMentbyInstalmentsEnum inschemeEnum = PayMentbyInstalmentsEnum.getByValue((String)pd);
        if (inschemeEnum == null) {
            return;
        }
        this.setMonthDayValue(isCycle, (isCycle = PayMentbyInstalmentsEnum.isCycle((String)pd)) ? PayMentbyInstalmentsEnum.getMonths((PayMentbyInstalmentsEnum)inschemeEnum) : null, isCycle ? "20" : null);
        this.getModel().setValue("drawmonthsettle", (Object)(isCycle ? Boolean.FALSE : null));
        boolean isToCycle = PayMentbyInstalmentsEnum.isToCycle((String)pd);
        this.getModel().setValue("offetday", (Object)(isToCycle ? Integer.valueOf(1) : null));
        this.getModel().endInit();
        this.updateView("month", "day", "offetday", "drawmonthsettle");
        this.changeCkMonth();
        this.changeCkDay();
    }

    private void setControlVisible(Boolean isVisible, String ... controls) {
        this.getView().setVisible(isVisible, controls);
    }

    private void setControlValue(String propName, boolean mustInput, String value) {
        TextEdit month = (TextEdit)this.getView().getControl(propName);
        month.setMustInput(mustInput);
        this.getModel().setValue(propName, (Object)value);
    }

    private void setMonthDayValue(boolean mustInput, String monthValue, String dayValue) {
        this.setControlValue("month", mustInput, monthValue);
        this.setControlValue("day", mustInput, dayValue);
    }

    private String loadKDString(String desc, String resourceID) {
        return ResManager.loadKDString((String)desc, (String)resourceID, (String)TMC_CFM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private boolean checkName(String number) {
        QFilter Fname;
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection list;
        boolean flag = false;
        if (EmptyUtil.isNoEmpty((String)number) && null != (list = (orm = ORM.create()).query("cfm_repayagingcheme", filters = new QFilter[]{Fname = new QFilter("name", "=", (Object)number)})) && list.size() > 0) {
            flag = true;
            this.getModel().setValue("name", null);
        }
        return flag;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                String pd = (String)this.getModel().getValue("period");
                if (PayMentbyInstalmentsEnum.isCycle((String)pd) && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"month", "day"})) {
                    args.setCancel(true);
                }
                if (this.choose() && !this.validateDay()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "month": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("period"))) {
                    this.getView().showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u8fd8\u6b3e\u5468\u671f\u3002", "PayMentbyInstalments_1"));
                    return;
                }
                this.setControlVisible(true, "flexpmonths");
                break;
            }
            case "flexpmb": 
            case "flexpmlab": {
                this.setControlVisible(false, "flexpmonths");
                break;
            }
            case "day": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("period"))) {
                    this.getView().showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u8fd8\u6b3e\u5468\u671f\u3002", "PayMentbyInstalments_1"));
                    return;
                }
                this.setControlVisible(true, "flexpdays");
                break;
            }
            case "flexpdb": 
            case "flexpdlab": {
                this.setControlVisible(false, "flexpdays");
                break;
            }
        }
    }

    private boolean choose() {
        String selectedMonths = (String)this.getModel().getValue("month");
        if (EmptyUtil.isEmpty((String)selectedMonths)) {
            return true;
        }
        if (",".equals(selectedMonths.substring(0, 1))) {
            selectedMonths = selectedMonths.substring(1);
        }
        List monthList = ListUtils.strToIntList((String)selectedMonths);
        Integer[] newMonthArray = monthList.toArray(new Integer[monthList.size()]);
        int monthNum = newMonthArray.length;
        String period = this.getModel().getValue("period").toString();
        PayMentbyInstalmentsEnum inschemeEnum = PayMentbyInstalmentsEnum.getByValue((String)period);
        if (inschemeEnum == null) {
            return true;
        }
        switch (inschemeEnum) {
            case YEAR: {
                if (monthNum == 1) break;
                this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_2"));
                return false;
            }
            case HALFYEAR: {
                if (monthNum != 2) {
                    this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u4e24\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_3"));
                    return false;
                }
                if (newMonthArray[0] >= 1 && newMonthArray[0] <= 6 && newMonthArray[1] >= 7 && newMonthArray[1] <= 12) break;
                this.getView().showMessage(this.loadKDString("\u8bf7\u5728\u4e0a\u534a\u5e74\u4e0b\u534a\u5e74\u5404\u9009\u4e00\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_4"));
                return false;
            }
            case SEASON: {
                if (monthNum != 4) {
                    this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u56db\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_5"));
                    return false;
                }
                if (newMonthArray[0] >= 1 && newMonthArray[0] <= 3 && newMonthArray[1] >= 4 && newMonthArray[1] <= 6 && newMonthArray[2] >= 7 && newMonthArray[2] <= 9 && newMonthArray[3] >= 10 && newMonthArray[3] <= 12) break;
                this.getView().showMessage(this.loadKDString("\u8bf7\u6bcf\u4e2a\u5b63\u5ea6\u9009\u62e9\u4e00\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_6"));
                return false;
            }
            case MONTH: {
                if (monthNum == 12) break;
                this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u5341\u4e8c\u4e2a\u8fd8\u6b3e\u6708\u4efd\u3002", "PayMentbyInstalments_7"));
                return false;
            }
        }
        return true;
    }

    private String repeatByDay(String propName) {
        IDataModel dataModel = this.getModel();
        Boolean value = (Boolean)dataModel.getValue(propName);
        String day = "";
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            String key = cbox.getKey();
            if (key.equals(propName) && value.booleanValue()) {
                day = cbox.getValue();
            }
            if (key.equals(propName) || !value.booleanValue() || !((Boolean)dataModel.getValue(key)).booleanValue()) continue;
            this.setControlValue(key, Boolean.FALSE);
        }
        return day;
    }

    private void changeCkDay() {
        IDataModel dataModel = this.getView().getModel();
        String day = (String)dataModel.getValue("day");
        dataModel.beginInit();
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            dataModel.setValue(cbox.getKey(), (Object)day.equals(cbox.getValue()));
        }
        dataModel.endInit();
        this.updateView((String[])ckDayMap.keySet().stream().toArray(String[]::new));
    }

    private String repeatByMonth() {
        IDataModel dataModel = this.getView().getModel();
        ArrayList<String> ckeys = new ArrayList<String>();
        ArrayList<Integer> selectMonths = new ArrayList<Integer>(12);
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            if (!((Boolean)dataModel.getValue(cbox.getKey())).booleanValue()) continue;
            ckeys.add(cbox.getKey());
            selectMonths.add(Integer.valueOf(cbox.getValue()));
        }
        this.setCkMonthEnable(ckeys);
        Collections.sort(selectMonths);
        return selectMonths.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private void changeCkMonth() {
        IDataModel dataModel = this.getView().getModel();
        String months = (String)dataModel.getValue("month");
        ArrayList<String> ckMonthKeys = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)months)) {
            ckMonthKeys.addAll(Arrays.asList(months.split(",")));
        }
        ArrayList<String> ckeys = new ArrayList<String>();
        dataModel.beginInit();
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            boolean isContainKey = ckMonthKeys.contains(cbox.getValue());
            dataModel.setValue(cbox.getKey(), (Object)isContainKey);
            if (!isContainKey) continue;
            ckeys.add(cbox.getKey());
        }
        dataModel.endInit();
        this.updateView((String[])ckMonthMap.keySet().stream().toArray(String[]::new));
        this.setCkMonthEnable(ckeys);
    }

    private void setCkMonthEnable(List<String> ckeys) {
        Boolean cleDisEnable = Boolean.TRUE;
        String period = (String)this.getModel().getValue("period");
        PayMentbyInstalmentsEnum inschemeEnum = PayMentbyInstalmentsEnum.getByValue((String)period);
        if (inschemeEnum == null) {
            return;
        }
        int ckeySize = ckeys.size();
        switch (inschemeEnum) {
            case YEAR: {
                cleDisEnable = ckeySize == 0;
                break;
            }
            case HALFYEAR: {
                cleDisEnable = ckeySize <= 1;
                break;
            }
            case SEASON: {
                cleDisEnable = ckeySize <= 3;
                break;
            }
            case MONTH: {
                cleDisEnable = ckeySize <= 11;
            }
        }
        String[] keys = ckMonthMap.keySet().toArray(new String[ckMonthMap.size()]);
        if (cleDisEnable.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(true), keys);
        } else {
            List<String> ks = Arrays.stream(keys).filter(v -> !ckeys.contains(v)).collect(Collectors.toList());
            this.getView().setEnable(Boolean.valueOf(false), ks.toArray(new String[ks.size()]));
            this.getView().setEnable(Boolean.valueOf(true), ckeys.toArray(new String[ckeys.size()]));
        }
    }

    private boolean validateDay() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("day"))) {
            return false;
        }
        String pattern = "^[1-9]\\d*$";
        Pattern r = Pattern.compile(pattern);
        String day = (String)this.getModel().getValue("day");
        Matcher matcher = r.matcher(day);
        String msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5408\u7406\u7684\u8fd8\u6b3e\u65e5\u3002", (String)"PayMentbyInstalments_8", (String)TMC_CFM_FORMPLUGIN, (Object[])new Object[0]);
        if (!matcher.find()) {
            this.getView().showTipNotification(msg);
            return true;
        }
        int intDay = Integer.parseInt(day);
        if (intDay > 31) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    static {
        ckDayMap.put("ckone", "1");
        ckDayMap.put("cktwo", "2");
        ckDayMap.put("ckthree", "3");
        ckDayMap.put("ckfour", "4");
        ckDayMap.put("ckfive", "5");
        ckDayMap.put("cksix", "6");
        ckDayMap.put("ckseven", "7");
        ckDayMap.put("ckeight", "8");
        ckDayMap.put("cknine", "9");
        ckDayMap.put("ckten", "10");
        ckDayMap.put("ckeleven", "11");
        ckDayMap.put("cktwelve", "12");
        ckDayMap.put("ckthirteen", "13");
        ckDayMap.put("ckfourteen", "14");
        ckDayMap.put("ckfifteen", "15");
        ckDayMap.put("cksixteen", "16");
        ckDayMap.put("ckseventeen", "17");
        ckDayMap.put("ckeighteen", "18");
        ckDayMap.put("cknineteen", "19");
        ckDayMap.put("cktwenty", "20");
        ckDayMap.put("cktwentyone", "21");
        ckDayMap.put("cktwentytwo", "22");
        ckDayMap.put("cktwentythree", "23");
        ckDayMap.put("cktwentyfour", "24");
        ckDayMap.put("cktwentyfive", "25");
        ckDayMap.put("cktwentysix", "26");
        ckDayMap.put("cktwentyseven", "27");
        ckDayMap.put("cktwentyeight", "28");
        ckDayMap.put("cktwentynine", "29");
        ckDayMap.put("ckthirty", "30");
        ckDayMap.put("ckthirtyone", "31");
        ckMonthMap.put("ckjan", "1");
        ckMonthMap.put("ckfeb", "2");
        ckMonthMap.put("ckmar", "3");
        ckMonthMap.put("ckapr", "4");
        ckMonthMap.put("ckmay", "5");
        ckMonthMap.put("ckjun", "6");
        ckMonthMap.put("ckjul", "7");
        ckMonthMap.put("ckaug", "8");
        ckMonthMap.put("cksep", "9");
        ckMonthMap.put("ckoct", "10");
        ckMonthMap.put("cknov", "11");
        ckMonthMap.put("ckdec", "12");
    }
}

