/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractMultCateTextF7Plugin
extends AbstractBasePlugIn {
    private static final String CLOSECALLBACK_ACTION_ID = "_BD_F7ACTIONID";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.getTextPropName()});
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (key.equals(this.getTextPropName())) {
            String typePropDisplayName = this.getTypeDisplayName();
            String type = this.getTypePropValue();
            if (!this.getTypeOtherValue().equals(type)) {
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u975e\u5176\u4ed6\u7c7b\u578b\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\u3002", (String)"AbstractMultCateTextF7Plugin_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), typePropDisplayName));
                if (this.getEntryProp() != null) {
                    int entryIdx = this.getModel().getEntryCurrentRowIndex(this.getEntryProp());
                    if (this.isSubEntryProp()) {
                        this.getView().updateView(key, 0, entryIdx);
                    } else {
                        this.getView().updateView(key, entryIdx);
                    }
                } else {
                    this.getView().updateView(key);
                }
            }
        }
    }

    private String getTypeDisplayName() {
        ComboEdit control = (ComboEdit)this.getControl(this.getTypePropName());
        LocaleString typeDisplayName = control.getProperty().getDisplayName();
        String typePropDisplayName = typeDisplayName.toString();
        return typePropDisplayName;
    }

    private String getTypePropValue() {
        String type = null;
        if (this.getEntryProp() != null) {
            int entryIdx = this.getModel().getEntryCurrentRowIndex(this.getEntryProp());
            type = this.isSubEntryProp() ? (String)this.getModel().getValue(this.getTypePropName(), 0, entryIdx) : (String)this.getModel().getValue(this.getTypePropName(), entryIdx);
        } else {
            type = (String)this.getModel().getValue(this.getTypePropName());
        }
        return type;
    }

    public void click(EventObject evt) {
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if (key.equals(this.getTextPropName())) {
            String type = this.getTypePropValue();
            if (EmptyUtil.isEmpty((String)type)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"AbstractMultCateTextF7Plugin_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getTypeDisplayName()));
                return;
            }
            if (!this.getTypeOtherValue().equals(type)) {
                this.showF7(type);
            }
        }
    }

    protected String getTypeOtherValue() {
        return CreditorTypeEnum.OTHER.getValue();
    }

    protected String getF7FormId(String type) {
        return CreditorTypeEnum.getFormIdByValue((String)type.toLowerCase());
    }

    private void showF7(String type) {
        String f7FormId = this.getF7FormId(type);
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)f7FormId, (boolean)false, (int)3, (boolean)true);
        this.addCustomFilter(type, lsp);
        this.addCustomParam(type, lsp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTION_ID);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected void addCustomParam(String type, ListShowParameter lsp) {
        if (CreditorTypeEnum.INNERUNIT.getValue().equals(type)) {
            lsp.setCustomParam("orgFuncId", (Object)"08");
        }
    }

    protected void addCustomFilter(String type, ListShowParameter lsp) {
        List lspQFilter = lsp.getListFilterParameter().getQFilters();
        if (CreditorTypeEnum.BANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "=", (Object)"0"));
        } else if (CreditorTypeEnum.SETTLECENTER.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "=", (Object)"1"));
        } else if (CreditorTypeEnum.FINORG.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "not in", Arrays.asList("0", "1")));
        }
        lspQFilter.add(new QFilter("enable", "=", (Object)"1"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals(this.getTypePropName())) {
            if (this.getEntryProp() != null) {
                int entryRowIndex = this.getModel().getEntryCurrentRowIndex(this.getEntryProp());
                if (this.isSubEntryProp()) {
                    boolean isChanged = this.getModel().getDataChanged();
                    this.getModel().setValue(this.getIdPropName(), (Object)0L, 0, entryRowIndex);
                    if (!isChanged) {
                        this.getModel().setDataChanged(false);
                    }
                    this.getModel().setValue(this.getTextPropName(), null, 0, entryRowIndex);
                } else {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getIdPropName(), (Object)0L, (int)entryRowIndex);
                    this.getModel().setValue(this.getTextPropName(), null, entryRowIndex);
                }
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getIdPropName(), (Object)0L);
                this.getModel().setValue(this.getTextPropName(), null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (CLOSECALLBACK_ACTION_ID.equals(e.getActionId())) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)e.getReturnData();
            if (selectedRowCol == null) {
                return;
            }
            Long selectPk = (Long)selectedRowCol.get(0).getPrimaryKeyValue();
            String name = selectedRowCol.get(0).getName();
            this.getModel().setValue(this.getIdPropName(), (Object)selectPk);
            this.getModel().setValue(this.getTextPropName(), (Object)name);
        }
    }

    public void setLenderNature() {
        String type = (String)this.getModel().getValue(this.getTypePropName());
        if (EmptyUtil.isEmpty((String)type)) {
            type = "bank";
        }
        String loanType = (String)this.getModel().getValue("loantype");
        Long creditorId = (Long)this.getModel().getValue(this.getIdPropName());
        String lenderNature = LenderNatureEnum.OUTGROUP.getValue();
        switch (type) {
            case "innerunit": 
            case "settlecenter": {
                lenderNature = LenderNatureEnum.INGROUP.getValue();
                break;
            }
            case "bank": {
                if (LoanTypeEnum.isBankLoan((String)loanType)) {
                    lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                    break;
                }
                if (!LoanTypeEnum.isBanksLoan((String)loanType)) break;
                lenderNature = this.getLenderNatureByBanksLoan();
                break;
            }
            case "finorg": {
                lenderNature = this.getLenderNature(creditorId, "bd_finorginfo", "org");
                if (!LoanTypeEnum.isBanksLoan((String)loanType)) break;
                lenderNature = this.getLenderNatureByBanksLoan();
                break;
            }
            case "custom": {
                lenderNature = this.getLenderNature(creditorId, "bd_bizpartner", "internal_company");
                break;
            }
            case "other": {
                lenderNature = LenderNatureEnum.OUTGROUP.getValue();
                break;
            }
        }
        this.getModel().setValue("lendernature", (Object)lenderNature);
    }

    private String getLenderNatureByBanksLoan() {
        String lenderNature = LenderNatureEnum.OUTGROUP.getValue();
        DynamicObjectCollection bankCateEntrys = this.getModel().getEntryEntity("banksyndicate_entry");
        for (DynamicObject bankCateEntry : bankCateEntrys) {
            DynamicObject bank = bankCateEntry.getDynamicObject("e_bank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)bank)) continue;
            lenderNature = this.getLenderNature(bank.getLong("id"), "bd_finorginfo", "org");
            if (!LenderNatureEnum.OUTGROUP.getValue().equals(lenderNature)) continue;
            return lenderNature;
        }
        return lenderNature;
    }

    private String getLenderNature(Long creditorId, String entity, String proName) {
        DynamicObject finorg = QueryServiceHelper.queryOne((String)entity, (String)proName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)creditorId)});
        if (EmptyUtil.isEmpty((DynamicObject)finorg)) {
            return LenderNatureEnum.OUTGROUP.getValue();
        }
        return EmptyUtil.isEmpty((Object)finorg.get(proName)) ? LenderNatureEnum.OUTGROUP.getValue() : LenderNatureEnum.INGROUP.getValue();
    }

    protected abstract String getTypePropName();

    protected abstract String getTextPropName();

    protected abstract String getIdPropName();

    protected String getEntryProp() {
        return null;
    }

    protected boolean isSubEntryProp() {
        return false;
    }
}

