/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessInfoTabEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit te = (TextEdit)this.getControl("e_tf_relatebillno");
        if (te != null) {
            te.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_tf_relatebillno": {
                this.showTradefinRelateBillF7();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field = e.getKey();
        int rowIndex = e.getRowIndex();
        switch (field) {
            case "e_tf_relatebillno": {
                DynamicObject row = this.getModel().getEntryRowEntity("tradefin_entry", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)row)) {
                    return;
                }
                String relationType = row.getString("e_tf_relationtype");
                if (!RelationTypeEnum.IL.getValue().equals(relationType) && !RelationTypeEnum.EL.getValue().equals(relationType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u70b9\u51fb\u6309\u94ae\u6765\u9009\u62e9\u5355\u636e\u3002", (String)"BusinessInfoTabEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(field, rowIndex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (field) {
            case "e_tf_relationtype": {
                DynamicObjectCollection cols = this.getModel().getEntryEntity("tradefin_entry");
                DataEntityPropertyCollection properties = cols.getDynamicObjectType().getProperties();
                for (int i = 0; i < properties.size(); ++i) {
                    String entryField = ((IDataEntityProperty)properties.get(i)).getName();
                    if ("e_tf_relationtype".equals(entryField) || "seq".equals(entryField) || "id".equals(entryField)) continue;
                    this.getModel().setValue(entryField, null, rowIndex);
                }
                break;
            }
        }
    }

    private void showTradefinRelateBillF7() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("tradefin_entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("tradefin_entry", rowIndex);
        String relationType = entry.getString("e_tf_relationtype");
        if ("IL".equals(relationType)) {
            this.showLCForm("lc_arrival");
        }
        if ("EL".equals(relationType)) {
            this.showLCForm("lc_present");
        }
    }

    private void showLCForm(String formId) {
        String orgPropName = this.getModel().getDataEntityType().getMainOrg();
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)2);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        lsp.setCloseCallBack(closeCallBack);
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgPropName);
        QFilter qFilter = "lc_arrival".equals(formId) ? CfmContractBillHelper.getLcArrivalQfilter((DynamicObject)org) : CfmContractBillHelper.getLcPresentQfilter((DynamicObject)org);
        lsp.getListFilterParameter().getQFilters().add(qFilter);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if (("lc_arrival".equals(e.getActionId()) || "lc_present".equals(e.getActionId())) && !EmptyUtil.isEmpty((Object)(returnData = e.getReturnData()))) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            int curIndex = this.getModel().getEntryCurrentRowIndex("tradefin_entry");
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            String billType = e.getActionId();
            DynamicObject lcBill = TmcDataServiceHelper.loadSingle((Object)primaryKeyValues[0], (String)billType, (String)"id, billno, org, benefiterother, endpaydate, todoamount, arrivalcurrency");
            String billno = lcBill.getString("billno");
            String orgName = Optional.ofNullable(lcBill.getDynamicObject("org")).map(r -> r.getString("name")).orElse("");
            String beneficiary = lcBill.getString("benefiterother");
            String openPerson = "lc_arrival".equals(e.getActionId()) ? orgName : beneficiary;
            String benefitPerson = "lc_arrival".equals(e.getActionId()) ? beneficiary : orgName;
            Date expiredate = lcBill.getDate("endpaydate");
            BigDecimal amount = lcBill.getBigDecimal("todoamount");
            DynamicObject curreny = lcBill.getDynamicObject("arrivalcurrency");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_tf_relatebillno", (Object)billno, (int)curIndex);
            this.getModel().setValue("e_tf_letter", (Object)openPerson, curIndex);
            this.getModel().setValue("e_tf_beneficiary", (Object)benefitPerson, curIndex);
            this.getModel().setValue("e_tf_expiredate", (Object)expiredate, curIndex);
            this.getModel().setValue("e_tf_unpaidamount", (Object)amount, curIndex);
            this.getModel().setValue("e_tf_currency", (Object)curreny, curIndex);
            this.getModel().setValue("e_tf_relatebillid", (Object)lcBill.getLong("id"), curIndex);
        }
    }
}

