/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.feedetail.AbstractBizBillFeeTabEdit;
import org.apache.commons.lang3.tuple.Pair;

public class FeeDetailTabEdit
extends AbstractBizBillFeeTabEdit {
    private static final List<String> CALC_FEE_BASIS_TERM_LIST = new ArrayList<String>();

    public Pair<String, String> getBizBillFeeAmtFieldProp() {
        Pair pair;
        String entityName;
        switch (entityName = this.getModel().getDataEntityType().getName()) {
            case "cfm_loanbill": {
                pair = Pair.of((Object)"drawamount", (Object)ResManager.loadKDString((String)"\u63d0\u6b3e\u91d1\u989d", (String)"FeeDetailTabEdit_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cfm_loanbill_bond": {
                pair = Pair.of((Object)"drawamount", (Object)ResManager.loadKDString((String)"\u53d1\u884c\u91d1\u989d", (String)"FeeDetailTabEdit_03", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cfm_loancontractbill": {
                pair = Pair.of((Object)"amount", (Object)ResManager.loadKDString((String)"\u501f\u6b3e\u91d1\u989d", (String)"FeeDetailTabEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cfm_loancontract_bo": {
                pair = Pair.of((Object)"amount", (Object)ResManager.loadKDString((String)"\u53d1\u884c\u603b\u989d", (String)"FeeDetailTabEdit_05", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fl_leasecontractbill": 
            case "fl_leasecontractbill_init": {
                pair = Pair.of((Object)"amount", (Object)ResManager.loadKDString((String)"\u79df\u8d41\u672c\u91d1", (String)"FeeDetailTabEdit_08", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                break;
            }
            default: {
                pair = Pair.of((Object)"amount", (Object)ResManager.loadKDString((String)"\u91d1\u989d", (String)"FeeDetailTabEdit_06", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
        return pair;
    }

    public Pair<String, String> getBizBillCurrencyFieldProp() {
        return Pair.of((Object)"currency", (Object)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FeeDetailTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
    }

    public boolean isLoanOrCreditOrPresentFee(DynamicObject feeBill) {
        String entity = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if (ProductTypeEnum.LOANBILL_B_L.getEntity().equals(entity) || ProductTypeEnum.LOANBILL_E_L.getEntity().equals(entity) || ProductTypeEnum.LOANBILL_BOND.getEntity().equals(entity)) {
            return false;
        }
        String productType = String.valueOf(feeBill.get("entry.producttype"));
        return ProductTypeEnum.LOANBILL_B_L.getId().equals(productType) || ProductTypeEnum.LOANBILL_E_L.getId().equals(productType) || ProductTypeEnum.LOANBILL_BOND.getId().equals(productType);
    }

    public void addFeeBilIdQfilter(QFilter feeIdFilter) {
        String entityName = this.getModel().getDataEntityType().getName();
        if ("cfm_loancontractbill".equals(entityName) || "cfm_loancontract_bo".equals(entityName)) {
            Object[] loanBills;
            String loanEntity = "cfm_loanbill";
            if ("cfm_loancontract_bo".equals(entityName)) {
                loanEntity = "cfm_loanbill_bond";
            }
            if (EmptyUtil.isNoEmpty((Object[])(loanBills = TmcDataServiceHelper.load((String)loanEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", this.getModel().getValue("id"))})))) {
                List loanBillIds = Arrays.stream(loanBills).map(o -> o.getLong("id")).collect(Collectors.toList());
                feeIdFilter.or("entry.srcbillid", "in", loanBillIds);
            }
        }
    }

    private String getStartDateFieldProp() {
        String entityName = this.getModel().getDataEntityType().getName();
        String startDate = null;
        switch (entityName) {
            case "cfm_loanbill": 
            case "cfm_loanbill_bond": {
                startDate = "startintdate";
                break;
            }
            default: {
                startDate = "startdate";
            }
        }
        return startDate;
    }

    public String getBizBillTermFieldProp() {
        return "term";
    }

    private String getEndDateFieldProp() {
        String entityType = this.getModel().getDataEntityType().getName();
        String endDate = null;
        switch (entityType) {
            case "cfm_loanbill": 
            case "cfm_loanbill_bond": {
                endDate = "expiredate";
                break;
            }
            default: {
                endDate = "enddate";
            }
        }
        return endDate;
    }

    public BigDecimal getTerm(boolean isShowErrorTip) {
        if (!this.isCalcByYrBasisAndTerm()) {
            return super.getTerm(isShowErrorTip);
        }
        Date startDate = (Date)this.getModel().getValue(this.getStartDateFieldProp());
        Date endDate = (Date)this.getModel().getValue(this.getEndDateFieldProp());
        if (!this.verifyTerm(isShowErrorTip) || EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
            return null;
        }
        return BigDecimal.valueOf(DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1);
    }

    private boolean isCalcByYrBasisAndTerm() {
        String entityName = this.getModel().getDataEntityType().getName();
        String string = entityName = "fl_leasecontractbill_init".equals(entityName) ? "fl_leasecontractbill" : entityName;
        return CALC_FEE_BASIS_TERM_LIST.contains(entityName);
    }

    public BigDecimal getYrBasis(boolean isShowErrorTip) {
        if (!this.isCalcByYrBasisAndTerm()) {
            return super.getYrBasis(isShowErrorTip);
        }
        if (!this.verifyTerm(isShowErrorTip)) {
            return null;
        }
        if (!"cfm_loancontract_bo".equals(this.getModel().getDataEntityType().getName()) && EmptyUtil.isEmpty((Object)this.getModel().getValue("basis"))) {
            return null;
        }
        return BigDecimal.valueOf(TermHelper.getBasis_YearDay((Date)((Date)this.getModel().getValue(this.getStartDateFieldProp())), (Date)((Date)this.getModel().getValue(this.getEndDateFieldProp())), (BasisEnum)this.getYrBasisValue()));
    }

    private BasisEnum getYrBasisValue() {
        if ("cfm_loancontract_bo".equals(this.getModel().getDataEntityType().getName())) {
            return BasisEnum.getEnum((String)BasisEnum.Actual_365.getValue());
        }
        return BasisEnum.getEnum((String)((String)this.getModel().getValue("basis")));
    }

    public boolean verifyTerm(boolean isShowErrorTip) {
        String term = (String)this.getModel().getValue(this.getBizBillTermFieldProp());
        if (EmptyUtil.isEmpty((String)term)) {
            if (isShowErrorTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailTabEdit_07", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    static {
        CALC_FEE_BASIS_TERM_LIST.add("cfm_loanbill");
        CALC_FEE_BASIS_TERM_LIST.add("cfm_loanbill_bond");
        CALC_FEE_BASIS_TERM_LIST.add("cfm_loancontractbill");
        CALC_FEE_BASIS_TERM_LIST.add("cfm_loancontract_bo");
        CALC_FEE_BASIS_TERM_LIST.add("fl_leasecontractbill");
    }
}

