/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bond;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;

public class BondBillCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(1);
        fieldMap.put(this.getCreditLimitField(), "investor_entry");
        return fieldMap;
    }

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", "org");
        propertys.put("finorg", "e_investorid");
        propertys.put("drawamount", "e_investamount");
        propertys.put("startDate", "bizdate");
        propertys.put("endDate", "expiredate");
        propertys.put("currency", "currency");
        return propertys;
    }

    protected Set<String> getEntryFields() {
        HashSet<String> entryFields = new HashSet<String>();
        entryFields.add("e_investorid");
        entryFields.add("e_investamount");
        return entryFields;
    }

    protected Long getCreditTypeId() {
        DynamicObject finProduct = this.getFinProduct();
        DynamicObject credittype = finProduct.getDynamicObject("credittype");
        return credittype != null ? credittype.getLong("id") : 0L;
    }

    public boolean isPreOccupy() {
        Object status = this.getModel().getValue("billstatus");
        return BillStatusEnum.SAVE.getValue().equals(status);
    }

    protected BigDecimal setCreditRatio() {
        DynamicObject creditUseBill;
        BigDecimal creditRatio;
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        DynamicObject finProduct = this.getFinProduct();
        BigDecimal bigDecimal = creditRatio = finProduct != null ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
        if (creditLimit == null) {
            return creditRatio;
        }
        if (this.getPageCache().get("ratio") != null) {
            return new BigDecimal(this.getPageCache().get("ratio"));
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id")) && (creditUseBill = CreditLimitHelper.getCreditUseBill((Long)((Long)this.getModel().getValue("id")), (String)"cfm_loanbill")) != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return creditRatio;
    }

    private DynamicObject getFinProduct() {
        return (DynamicObject)this.getModel().getValue("finproduct");
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = this.getFinProduct();
        return finProduct.getString("name");
    }

    protected BigDecimal getAmount() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        return (BigDecimal)this.getModel().getValue("e_investamount", rowIdx);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("investor_entry".equals(entryName)) {
            this.getModel().setValue(GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"head_creditlimit"), null, e.getRowIndexs()[0]);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("investor_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.enableCredit(i);
        }
    }

    protected void setCreditUseFields() {
        super.setCreditUseFields();
        int entryRowCount = this.getModel().getEntryRowCount("investor_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            Object eLimit = this.getModel().getValue("e_creditlimit", i);
            if (!EmptyUtil.isEmpty((Object)eLimit)) continue;
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)i, (String[])new String[]{"e_creditcurrency", "e_creditamt"});
        }
        this.getView().updateView("investor_entry");
    }

    public boolean isSubmitReCreate() {
        return false;
    }

    public boolean checkCreditlimitParams() {
        StringBuilder errorMessage = new StringBuilder();
        if (this.getModel().getValue("currency") == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u53d1\u884c\u5e01\u79cd\u3002", (String)"BondBillCreditLimitPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("finproduct") == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u503a\u5238\u54c1\u79cd\u3002", (String)"BondBillCreditLimitPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        if (this.getModel().getValue("e_investorid", rowIdx) == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e3b\u8981\u6295\u8d44\u4eba\u3002", (String)"BondBillCreditLimitPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (((BigDecimal)this.getModel().getValue("e_investamount", rowIdx)).compareTo(BigDecimal.ZERO) <= 0) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u91d1\u989d\u3002", (String)"BondBillCreditLimitPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)errorMessage.toString())) {
            this.getView().showTipNotification(errorMessage.toString(), Integer.valueOf(6000));
        }
        return EmptyUtil.isNoEmpty((String)errorMessage.toString()) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected String creditType() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        String investorType = ((DynamicObject)this.getModel().getEntryEntity("investor_entry").get(rowIdx)).getString("e_investortype");
        if (CreditorTypeEnum.CUSTOM.getValue().equals(investorType)) {
            return CreditFinTypeEnum.BIZPARTNER.getValue();
        }
        return CreditFinTypeEnum.FINORG.getValue();
    }

    protected Long getSourceBillId() {
        return null;
    }

    protected String getSourceType() {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        super.propertyChanged(e);
        switch (prop = e.getProperty().getName()) {
            case "e_investortype": {
                this.clearFieldVal("e_investorname", "e_investorid", this.getCreditLimitField());
                this.controlCredit();
                break;
            }
            case "e_investamount": 
            case "e_investorname": {
                this.clearFieldVal(this.getCreditLimitField());
            }
        }
    }

    private void clearFieldVal(String ... fields) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        for (String field : fields) {
            if ("e_investorname".equals(field)) {
                this.getModel().setValue(field, (Object)"", rowIdx);
                continue;
            }
            if ("e_investorid".equals(field)) {
                this.getModel().setValue(field, (Object)0, rowIdx);
                continue;
            }
            this.getModel().setValue(field, null, rowIdx);
        }
    }

    private void controlCredit() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        this.enableCredit(rowIdx);
    }

    protected void enableCredit(int rowIdx) {
        String investorType = (String)this.getModel().getValue("e_investortype", rowIdx);
        this.getView().setEnable(Boolean.valueOf(!CreditorTypeEnum.OTHER.getValue().equals(investorType)), rowIdx, new String[]{this.getCreditLimitField()});
    }

    protected String getCreditUseAmtField() {
        return "e_creditamt";
    }

    protected String getCreditUseCurrencyField() {
        return "e_creditcurrency";
    }

    protected String getCreditLimitField() {
        return "e_creditlimit";
    }
}

