/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.bond;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillPayeeInfoBatchEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String PAYEECALLBACK = "payeetext_closeCallBack";
    private static final String PAYEEACCTCALLBACK = "payeeaccttext_closeCallBack";
    public static final String ENTRY = "entry";
    public static final String PAYEETYPE = "payeetype";
    public static final String PAYEE = "payee";
    public static final String PAYEETEXT = "payeetext";
    public static final String PAYEEACCTTEXT = "payeeaccttext";
    public static final String PAYEEBANK = "payeebank";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payeeText = (TextEdit)this.getView().getControl(PAYEETEXT);
        payeeText.addButtonClickListener((ClickListener)this);
        TextEdit payeeAcctText = (TextEdit)this.getView().getControl(PAYEEACCTTEXT);
        payeeAcctText.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeetext": {
                if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("company_filter_cache"))) {
                    return;
                }
                this.dealAndShowPayeeInfo();
                break;
            }
            case "payeeaccttext": {
                this.dealAndShowBankInfo();
                break;
            }
        }
    }

    private void dealAndShowPayeeInfo() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payeeType = this.getModel().getValue(PAYEETYPE, rowIndex).toString();
        if ("bd_supplier".equals(payeeType)) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company", rowIndex);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)payeeType, (Long)company.getLong("id"));
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)payeeType, (boolean)false, (int)3, (boolean)true);
            lsp.getListFilterParameter().getQFilters().add(orgFilter);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAYEECALLBACK);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void dealAndShowBankInfo() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payeeType = this.getModel().getValue(PAYEETYPE, rowIndex).toString();
        if (OppUnitTypeEnum.OTHER.getValue().equals(payeeType)) {
            return;
        }
        Object payee = this.getModel().getValue(PAYEE, rowIndex);
        if (EmptyUtil.isNoEmpty((Object)payee)) {
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                DynamicObject innerOrg;
                DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)"bd_supplier", (String)"internal_company");
                DynamicObject dynamicObject = innerOrg = basedata == null ? null : basedata.getDynamicObject("internal_company");
                if (innerOrg == null) {
                    QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(payee.toString()));
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)"bd_supplier", (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"BondBillPayeeInfoEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            lsp = EmptyUtil.isNoEmpty(innerOrgId) ? ListConstructorHelper.getAccountbanksInfoShowParameter(innerOrgId) : ListConstructorHelper.getSupplierBankInfoShowParameter((Object)payee);
            if (EmptyUtil.isNoEmpty((Object)lsp)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAYEEACCTCALLBACK);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "payeetext_closeCallBack": {
                    this.payeeCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "payeeaccttext_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void payeeCloseCallBack(ListSelectedRow row) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payeeType = this.getModel().getValue(PAYEETYPE, rowIndex).toString();
        if ("bd_supplier".equals(payeeType)) {
            String selectFields = "id, name, entry_bank, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank";
            QFilter qFilter = new QFilter("id", "=", row.getPrimaryKeyValue());
            DynamicObject entryBankDO = TmcDataServiceHelper.loadSingleFromCache((String)payeeType, (String)selectFields, (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)entryBankDO)) {
                DynamicObjectCollection entrys = entryBankDO.getDynamicObjectCollection("entry_bank");
                for (DynamicObject entry : entrys) {
                    if (!entry.getBoolean("isdefault_bank")) continue;
                    this.getModel().setValue(PAYEEACCTTEXT, (Object)entry.getString("bankaccount"), rowIndex);
                    this.getModel().setValue(PAYEEBANK, (Object)entry.getDynamicObject("bank"), rowIndex);
                }
            }
            this.getModel().setValue(PAYEE, (Object)entryBankDO.getLong("id"), rowIndex);
            this.getModel().setValue(PAYEETEXT, (Object)entryBankDO.getString("name"), rowIndex);
        }
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        Object payee;
        Object entryKey = row.getEntryPrimaryKeyValue();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payeeType = this.getModel().getValue(PAYEETYPE, rowIndex).toString();
        if ("bd_supplier".equals(payeeType) && EmptyUtil.isNoEmpty((Object)(payee = this.getModel().getValue(PAYEE, rowIndex))) && StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
            DynamicObject innerOrg;
            DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)"bd_supplier", (String)"internal_company");
            DynamicObject dynamicObject = innerOrg = basedata == null ? null : basedata.getDynamicObject("internal_company");
            if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)"bd_supplier", (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
                if (EmptyUtil.isEmpty((DynamicObject)oppUnitDetail)) {
                    return;
                }
                DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
                for (DynamicObject entry : entryBank) {
                    if (!entry.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue(PAYEEACCTTEXT, (Object)entry.getString("bankaccount"), rowIndex);
                    this.getModel().setValue(PAYEEBANK, (Object)entry.getDynamicObject("bank"), rowIndex);
                    break;
                }
            } else {
                DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
                if (EmptyUtil.isEmpty((DynamicObject)accountbanksDO)) {
                    return;
                }
                this.getModel().setValue(PAYEEACCTTEXT, (Object)accountbanksDO.getString("number"));
                DynamicObject bankDO = accountbanksDO.getDynamicObject("bank");
                if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                    this.getModel().setValue(PAYEEBANK, (Object)bankDO.getDynamicObject("bebank"));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (EmptyUtil.isNoEmpty((Object)newValue) && newValue != oldValue) {
            switch (key) {
                case "payeetype": {
                    this.clearPayeeInfo(PAYEE, PAYEETEXT, PAYEEACCTTEXT, PAYEEBANK);
                    break;
                }
            }
        }
    }

    private void clearPayeeInfo(String ... fields) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        for (String field : fields) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, null, (int)rowIndex);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String payeeType = this.getModel().getValue(PAYEETYPE, rowIndex).toString();
        if ("bd_supplier".equals(payeeType) && PAYEETEXT.equals(key)) {
            e.setCancel(true);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)key, null, (int)rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }
}

