/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.common;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.LinkBillSetEnum;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.bean.AttachViewInfo;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class AttachmentViewList
extends AbstractTmcBillBaseList {
    private static final Map<String, String> contract_ApplyMap = new HashMap<String, String>(16);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("viewattach".equals(operateKey) && opResult.isSuccess()) {
            String thisEntityName = this.getDataEntityName();
            Long selectedId = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)selectedId)) {
                return;
            }
            LinkedHashMap<String, HashSet<Long>> bizInfoMap = this.getLinkBillInfoMap(thisEntityName, selectedId);
            ArrayList<AttachViewInfo> attachViewInfos = new ArrayList<AttachViewInfo>();
            for (Map.Entry<String, HashSet<Long>> bizInfoEntry : bizInfoMap.entrySet()) {
                HashSet<Long> bizBillIds;
                String entityName = bizInfoEntry.getKey();
                Map attachInfos = TmcAttachmentHelper.getAttachments((String)entityName, (Long[])(bizBillIds = bizInfoEntry.getValue()).toArray(new Long[0]));
                if (EmptyUtil.isEmpty((Object)attachInfos) || attachInfos.size() <= 0) continue;
                DynamicObject[] bizBillInfos = TmcDataServiceHelper.load((String)entityName, (String)"id,billno", (QFilter[])new QFilter("id", "in", (Object)bizBillIds.toArray()).toArray());
                String localeValue = bizBillInfos[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                if ("cfm_rateadjustbill".equals(bizBillInfos[0].getDynamicObjectType().getName())) {
                    localeValue = CfmFormResourceEnum.AttachmentViewList_0.loadKDString();
                }
                Map<Long, String> bizIdNoMap = Arrays.stream(bizBillInfos).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("billno")));
                for (Map.Entry entrys : attachInfos.entrySet()) {
                    String bizBillId = (String)entrys.getKey();
                    List value = (List)entrys.getValue();
                    for (Map attachInfoMap : value) {
                        Long createDateLong;
                        AttachViewInfo attachViewInfo = new AttachViewInfo();
                        attachViewInfo.setBizBillNo(bizIdNoMap.get(Long.valueOf(bizBillId)));
                        attachViewInfo.setBizEntity((String)attachInfoMap.get("entityNum"));
                        attachViewInfo.setEntityname(localeValue);
                        attachViewInfo.setAttachName((String)attachInfoMap.get("name"));
                        OrmLocaleValue creator = (OrmLocaleValue)attachInfoMap.get("creator");
                        if (EmptyUtil.isNoEmpty((Object)creator)) {
                            attachViewInfo.setUploader(creator.getLocaleValue());
                        }
                        if (EmptyUtil.isNoEmpty((Long)(createDateLong = (Long)attachInfoMap.get("createdate")))) {
                            attachViewInfo.setUploadTime(new Date(createDateLong));
                        }
                        attachViewInfo.setRemark((String)attachInfoMap.get("description"));
                        attachViewInfo.setFileUrl((String)attachInfoMap.get("url"));
                        attachViewInfos.add(attachViewInfo);
                    }
                }
            }
            if (attachViewInfos.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u9644\u4ef6\u76f8\u5173\u4fe1\u606f\u3002", (String)"AttachmentViewList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setCustomParam("customparam_attachviewInfo", (Object)JSON.toJSONString(attachViewInfos));
                parameter.setFormId("tmc_attachview");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        }
    }

    private LinkedHashMap<String, HashSet<Long>> getLinkBillInfoMap(String thisEntityName, Long selectedId) {
        HashSet<Long> selectedSet = new HashSet<Long>();
        selectedSet.add(selectedId);
        Map upBillMap = BFTrackerServiceHelper.findSourceBills((String)thisEntityName, (Long[])new Long[]{selectedId});
        LinkedHashMap<String, HashSet<Long>> bizInfoMap = new LinkedHashMap<String, HashSet<Long>>(upBillMap);
        bizInfoMap.put(thisEntityName, selectedSet);
        Map downBillMap = BFTrackerServiceHelper.findTargetBills((String)thisEntityName, (Long[])new Long[]{selectedId});
        bizInfoMap.putAll(downBillMap);
        bizInfoMap.putAll(this.getContractApplyMap(thisEntityName, selectedId));
        LinkedHashMap<String, HashSet<Long>> resultBizInfoMap = new LinkedHashMap<String, HashSet<Long>>(bizInfoMap);
        for (Map.Entry entry : bizInfoMap.entrySet()) {
            List linkEntitys;
            Object[] bizDealBills;
            QFilter initBillFilter;
            Object[] contractInitBills;
            String srcEntity = (String)entry.getKey();
            HashSet bizBillIds = (HashSet)entry.getValue();
            List<String> contractList = Arrays.asList(LinkBillSetEnum.CONTRACTBILL.getSrcEntity(), LinkBillSetEnum.BOND_CONTRACTBILL.getSrcEntity(), LinkBillSetEnum.IFM_LOANCONTRACTBILL.getSrcEntity(), LinkBillSetEnum.INVEST_CONTRACT.getSrcEntity());
            if (contractList.contains(srcEntity) && EmptyUtil.isNoEmpty((Object[])(contractInitBills = TmcDataServiceHelper.load((String)srcEntity, (String)"initid,creditortype", (QFilter[])(initBillFilter = new QFilter("id", "in", (Object)bizBillIds).and("initid", ">", (Object)0)).toArray())))) {
                Set linkBillIds = Arrays.stream(contractInitBills).map(o -> o.getLong("initid")).collect(Collectors.toSet());
                String entityName = "cfm_initbill";
                if (LinkBillSetEnum.BOND_CONTRACTBILL.getSrcEntity().equals(srcEntity)) {
                    entityName = "cfm_initbill_bond";
                } else if (LinkBillSetEnum.IFM_LOANCONTRACTBILL.getSrcEntity().equals(srcEntity)) {
                    entityName = "ifm_initbill";
                } else if (LinkBillSetEnum.CONTRACTBILL.getSrcEntity().equals(srcEntity) && CreditorTypeEnum.SETTLECENTER.getValue().equals(contractInitBills[0].getString("creditortype"))) {
                    entityName = "ifm_initbill";
                } else if (LinkBillSetEnum.INVEST_CONTRACT.getSrcEntity().equals(srcEntity)) {
                    entityName = "cim_invest_initbill";
                }
                resultBizInfoMap.put(entityName, new HashSet(linkBillIds));
            }
            if ("fl_leasecontractbill".equals(srcEntity)) {
                resultBizInfoMap.put("fl_leasecontractbill_init", new HashSet(bizBillIds));
            }
            if (EmptyUtil.isNoEmpty((Object[])(bizDealBills = TmcDataServiceHelper.load((String)"ifm_bizdealbill", (String)"id", (QFilter[])new QFilter("sourcebillid", "in", (Object)bizBillIds).toArray())))) {
                Set linkBillIds = Arrays.stream(bizDealBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
                resultBizInfoMap.put("ifm_bizdealbill", new HashSet(linkBillIds));
            }
            if (!EmptyUtil.isNoEmpty((Object)(linkEntitys = LinkBillSetEnum.getLinkEntity((String)srcEntity)))) continue;
            for (String linkEntity : linkEntitys) {
                Set linkBillIds;
                Object[] linkBills;
                String linkField = LinkBillSetEnum.getLinkField((String)srcEntity, (String)linkEntity);
                if (LinkBillSetEnum.CONTRACTBILL.getLinkField().equals(linkField)) {
                    linkBills = TmcDataServiceHelper.load((String)linkEntity, (String)linkField, (QFilter[])new QFilter(linkField, "in", (Object)bizBillIds.toArray()).toArray());
                    if (!EmptyUtil.isNoEmpty((Object[])linkBills)) continue;
                    Set ids = Arrays.stream(linkBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
                    resultBizInfoMap.put(linkEntity, new HashSet(ids));
                    continue;
                }
                linkBills = TmcDataServiceHelper.load((String)srcEntity, (String)linkField, (QFilter[])new QFilter("id", "in", (Object)bizBillIds.toArray()).toArray());
                if (!EmptyUtil.isNoEmpty((Object[])linkBills) || !EmptyUtil.isNoEmpty(linkBillIds = Arrays.stream(linkBills).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject(linkField))).map(o -> o.getDynamicObject(linkField).getLong("id")).collect(Collectors.toSet()))) continue;
                resultBizInfoMap.put(linkEntity, new HashSet(linkBillIds));
            }
        }
        return resultBizInfoMap;
    }

    private LinkedHashMap<String, HashSet<Long>> getContractApplyMap(String entity, Long contractBillId) {
        DynamicObjectCollection contractApplyBills;
        QFilter qFilter = new QFilter("loancontractbill", "=", (Object)contractBillId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("bizstatus", "=", (Object)ApplyBizStatusEnum.DONE.getValue());
        String applyEntity = contract_ApplyMap.get(entity);
        LinkedHashMap<String, HashSet<Long>> bizInfoMap = new LinkedHashMap<String, HashSet<Long>>(2);
        if (EmptyUtil.isNoEmpty((String)applyEntity) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(contractApplyBills = QueryServiceHelper.query((String)applyEntity, (String)"id", (QFilter[])qFilter.toArray())))) {
            HashSet<Long> applyBillIdSet = new HashSet<Long>(2);
            for (DynamicObject applyBill : contractApplyBills) {
                applyBillIdSet.add(applyBill.getLong("id"));
            }
            bizInfoMap.put(applyEntity, applyBillIdSet);
        }
        return bizInfoMap;
    }

    static {
        contract_ApplyMap.put("cfm_loancontractbill", "cfm_contract_apply");
        contract_ApplyMap.put("cim_invest_contract", "cim_contract_apply");
        contract_ApplyMap.put("ifm_loancontractbill", "ifm_contract_apply");
    }
}

