/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CommonBillFormHelper {
    public static String getFormIdByShowParameter(IFormView view) {
        String billFormId = view.getFormShowParameter().getFormId();
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            billFormId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        }
        return billFormId;
    }

    public static List<String> getBizTypes(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        List<String> bizTypes = new ArrayList<String>(10);
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            bizTypes = Arrays.asList(bizType.split(","));
        }
        return bizTypes;
    }

    public static void setAccountF7Evt(BeforeF7SelectEvent evt, IDataModel model, IFormView view) {
        DynamicObject org;
        String mainOrgProp = "org";
        List<String> entityList = Arrays.asList("cim_invest_loanbill", "ifm_loanbill", "cim_invest_repaybill", "ifm_repaymentbill", "cim_invest_interestbill", "ifm_interestbill");
        if (entityList.contains(view.getFormShowParameter().getFormId())) {
            mainOrgProp = "creditorg";
        }
        if (EmptyUtil.isEmpty((DynamicObject)(org = (DynamicObject)model.getValue(mainOrgProp)))) {
            return;
        }
        long orgId = org.getLong("id");
        boolean isAccountOrg = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (isAccountOrg) {
            QFilter enableFilter;
            QFilter acctTypeFilter;
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            DynamicObject acctBook = TmcDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{orgFilter, acctTypeFilter = new QFilter("bookstype.accounttype", "=", (Object)"1"), enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
            if (EmptyUtil.isEmpty((DynamicObject)acctBook) || EmptyUtil.isEmpty((DynamicObject)acctBook.getDynamicObject("accounttable"))) {
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(orgFilter);
            qFilters.add(new QFilter("accounttable", "=", acctBook.getDynamicObject("accounttable").getPkValue()));
        }
    }

    public static String getLoanFormIdByInstPlan(IFormView view) {
        List<String> bizTypes = CommonBillFormHelper.getBizTypes(view);
        String formId = CommonBillFormHelper.getFormIdByShowParameter(view);
        if ("cim_invest_loanb_intplan".equals(formId)) {
            return "cim_invest_loanbill";
        }
        if ("cfm_loanbill_bond_intplan".equals(formId)) {
            return "cfm_loanbill_bond";
        }
        if ("ifm_loanbill_intplan".equals(formId)) {
            return "ifm_loanbill";
        }
        if ("cfm_loanbill_intplan".equals(formId)) {
            if (bizTypes.contains("entrust") || bizTypes.contains("ec")) {
                return "cfm_loanbill_e_l";
            }
            return "cfm_loanbill_b_l";
        }
        return "cfm_loanbill";
    }

    public static String getRepaymentFormId(IFormView view, Long repayId) {
        String formId = CommonBillFormHelper.getFormIdByShowParameter(view);
        if (CfmEntityEnum.INVEST_INTERESTBILL.getValue().equals(formId)) {
            formId = CfmEntityEnum.INVEST_REPAYBILL.getValue();
        } else {
            formId = CfmEntityEnum.REPAYMENTBILL.getValue();
            DynamicObject repayMentBill = TmcDataServiceHelper.loadSingle((Object)repayId, (String)"cfm_repaymentbill", (String)"id,loantype");
            if (repayMentBill != null) {
                formId = BizTypeEnum.ENTRUST.getValue().equals(repayMentBill.getString("loantype")) || BizTypeEnum.EC.getValue().equals(repayMentBill.getString("loantype")) ? CfmEntityEnum.REPAYMENTBILL_EL.getValue() : (BizTypeEnum.BOND.getValue().equals(repayMentBill.getString("loantype")) ? CfmEntityEnum.REPAYMENTBILL_BOND.getValue() : CfmEntityEnum.REPAYMENTBILL_BL.getValue());
            }
        }
        return formId;
    }

    public static String getInterestFormId(IFormView view) {
        String formId = CommonBillFormHelper.getFormIdByShowParameter(view);
        formId = "cim_invest_repaybill".equals(formId) ? "cim_invest_interestbill" : ("cfm_repaymentbill_bond".equals(formId) ? "cfm_interestbill_bond" : ("ifm_repaymentbill".equals(formId) ? "ifm_interestbill" : ("cfm_repaymentbill_e_l".equals(formId) ? "cfm_interestbill_e" : "cfm_interestbill_b")));
        return formId;
    }

    public static QFilter getBillListFilter(IFormView view) {
        String billFormId = CommonBillFormHelper.getFormIdByShowParameter(view);
        QFilter filter = null;
        if (!EmptyUtil.isEmpty((String)billFormId)) {
            if (billFormId.contains("cim_invest")) {
                filter = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
                filter.and(new QFilter("creditorg", ">", (Object)0L)).and(new QFilter("creditortype", "in", Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.SETTLECENTER.getValue())));
                filter.or(new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue()));
                filter.and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            } else if ("cim_invest_initbill".equals(billFormId)) {
                filter = new QFilter("debtor", ">", (Object)0L).and(new QFilter("debtortype", "in", Arrays.asList(CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue())));
            } else {
                filter = new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
                filter.and(new QFilter("org", ">", (Object)0L)).and(new QFilter("debtortype", "=", (Object)CreditorTypeEnum.INNERUNIT.getValue()));
                filter.or(new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue()));
            }
        }
        return filter;
    }
}

