/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.common;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillApplyFormHelper {
    public static void showChangePropForFormView(DynamicObject lastBill, DynamicObject nextBill, IFormView formView) {
        Map nextDataMap;
        Map lastDataMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)lastBill);
        Map entriesDiffering = DynamicObjectCompareHelper.entriesDiffering((Map)lastDataMap, (Map)(nextDataMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)nextBill)));
        if (CollectionUtils.isEmpty((Map)entriesDiffering)) {
            return;
        }
        for (Map.Entry entry : entriesDiffering.entrySet()) {
            if (((String)entry.getKey()).equals("billno") || ((String)entry.getKey()).equals("workcalendar") || ((String)entry.getKey()).equals("confirmdescription")) continue;
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("fc", "#ED9121");
            formView.updateControlMetadata((String)entry.getKey(), fieldMap);
        }
    }

    public static void validateCfmPlanParam(BeforeDoOperationEventArgs args, IFormView formView, DynamicObject loanBill) {
        String dataSource = loanBill.getString("datasource");
        if (DataSourceEnum.isBond((String)dataSource) || DataSourceEnum.isIfm((String)dataSource) || DataSourceEnum.isFl((String)dataSource)) {
            return;
        }
        if (CfmContractBillHelper.isChangePlanByApply((DynamicObject)loanBill)) {
            args.setCancel(true);
            formView.invokeOperation("change", OperateOption.create());
        }
    }

    public static boolean validateCfmPlanParam(DynamicObject loanBill) {
        String dataSource = loanBill.getString("datasource");
        if (DataSourceEnum.isBond((String)dataSource) || DataSourceEnum.isIfm((String)dataSource) || DataSourceEnum.isFl((String)dataSource)) {
            return false;
        }
        return CfmContractBillHelper.isChangePlanByApply((DynamicObject)loanBill);
    }

    public static void openApplyForm(IFormView formView, String formId, Object loanBillId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        switch (formId) {
            case "cfm_loanbill_b_l": 
            case "cfm_loanbill_e_l": {
                showParameter.setFormId("cfm_apply_loanbill");
                break;
            }
            case "cim_invest_loanbill": {
                showParameter.setFormId("cim_apply_loanbill");
                break;
            }
            default: {
                formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6682\u4e0d\u652f\u6301\u53d8\u66f4\u3002", (String)"ContractBaseList_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        showParameter.setCustomParam("change", (Object)"change");
        showParameter.setCustomParam("loanbill", loanBillId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setBillStatus(BillOperationStatus.EDIT);
        formView.showForm((FormShowParameter)showParameter);
    }

    public static boolean isOpenApplyForm(IFormView formView, Long selectedId) {
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return false;
        }
        DynamicObject loanBill = LoanBillRepository.getLoanBillById((Long)selectedId);
        if (!ConfirmStatusEnum.isYetconfirm((String)loanBill.getString("confirmstatus")) || !BillStatusEnum.isAudit((String)loanBill.getString("billstatus"))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"LoanBillList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!DrawTypeEnum.isDrawed((String)loanBill.getString("drawtype")) && !DrawTypeEnum.isPartpayment((String)loanBill.getString("drawtype"))) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
            formView.showTipNotification(bizResource.getLoanStatusByApply());
            return false;
        }
        Long loanBillId = loanBill.getLong("id");
        DynamicObject onWayApply = LoanBillApplyHelper.queryOnWayApply((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayApply)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u975e\u5df2\u529e\u7406\u7684\u53d8\u66f4\u5355\u636e%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayApply.getString("billno")}));
            return false;
        }
        DynamicObject onWayPayIntBatch = LoanBillApplyHelper.queryOnWayPayIntBatch((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayPayIntBatch)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_3", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayPayIntBatch.getString("billno")}));
            return false;
        }
        DynamicObject onWayPayInt = LoanBillApplyHelper.queryOnWayPayInt((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayPayInt)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u4ed8\u606f/\u6536\u606f\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_4", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayPayInt.getString("billno")}));
            return false;
        }
        DynamicObject onWayPreIntBatch = LoanBillApplyHelper.queryOnWayPreIntBatch((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayPreIntBatch)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_5", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayPreIntBatch.getString("billno")}));
            return false;
        }
        DynamicObject onWayPreInt = LoanBillApplyHelper.queryOnWayPreInt((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayPreInt)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_6", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayPreInt.getString("billno")}));
            return false;
        }
        DynamicObject onWayRepay = LoanBillApplyHelper.queryOnWayRepay((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayRepay)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_7", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayRepay.getString("billno")}));
            return false;
        }
        DynamicObject onWayAdjust = LoanBillApplyHelper.queryOnWayAdjust((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayAdjust)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_8", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayAdjust.getString("billno")}));
            return false;
        }
        DynamicObject onWayExtend = LoanBillApplyHelper.queryOnWayExtend((Long)loanBillId);
        if (EmptyUtil.isNoEmpty((DynamicObject)onWayExtend)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u5ba1\u6838\u6216\u672a\u786e\u8ba4\u7684\u5c55\u671f\u5355%s\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"LoanBillList_9", (String)"tmc-cfm-formplugin", (Object[])new Object[]{onWayExtend.getString("billno")}));
            return false;
        }
        return true;
    }
}

