/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.confirm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sdk.tmc.cfm.extpoint.confirm.IConfirmListInterface;
import kd.tmc.cfm.common.enums.ConfirmLayoutEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;
import org.apache.commons.lang3.StringUtils;

public class BusinessConfirmInitPlugin
extends AbstractTmcDyncListPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(BusinessConfirmInitPlugin.class);
    protected FilterContainerInitArgs initArgs;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_confirm": {
                this.toolbarOp("businessconfirm");
                break;
            }
            case "bar_back": {
                this.toolbarOp("back");
                break;
            }
            case "bar_refresh": {
                this.fillPageData();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillPageData();
    }

    protected void fillPageData() {
        String[] columnsName;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        String org = this.getOrgInfo();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List cacheFilters = this.getQFilterFromPagCache();
        HashSet<String> businesstypeSet = new HashSet<String>();
        if (cacheFilters != null) {
            for (QFilter qFilter : cacheFilters) {
                String[] property = qFilter.getProperty();
                if ("businesstype".equals(property)) {
                    businesstypeSet.add(qFilter.getValue().toString());
                    continue;
                }
                if ("createtime".equals(property)) {
                    String value = qFilter.getValue().toString();
                    if (value.contains("#")) {
                        String[] values = value.split("#");
                        qFilters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)DateUtils.stringToDate((String)values[0], (String)"yyyy-MM-dd"), (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)DateUtils.stringToDate((String)values[1], (String)"yyyy-MM-dd"), (boolean)false))));
                        continue;
                    }
                    this.getQfilter(value, qFilters);
                    continue;
                }
                if ("company.id".equals(property)) {
                    qFilter.__setProperty(org + ".id");
                    qFilters.add(qFilter);
                    continue;
                }
                qFilters.add(qFilter);
            }
        }
        qFilters.add(new QFilter("confirmstatus", "=", (Object)"waitconfirm"));
        qFilters.add(new QFilter("datasource", "=", (Object)this.getDataSource()));
        qFilters.add(new QFilter("creditortype", "!=", (Object)"settlecenter"));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("company", new Object[0]);
        vs.addField("businesstype", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("lender", new Object[0]);
        vs.addField("contractno", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("interestamount", new Object[0]);
        vs.addField("clientorg", new Object[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        vs.addField("registorg", new Object[0]);
        vs.addField("creator", new Object[0]);
        vs.addField("createtime", new Object[0]);
        for (String column : columnsName = this.addShowField()) {
            vs.addField(column, new Object[0]);
        }
        ArrayList<Object[]> allRow = new ArrayList<Object[]>();
        logger.info("customlog: businesstypeSet: {},qFilters: {}", businesstypeSet, qFilters);
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("contract")) {
            allRow.addAll(this.setQueryData("contract", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("loan")) {
            allRow.addAll(this.setQueryData("loan", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("repay")) {
            allRow.addAll(this.setQueryData("repay", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("extend")) {
            allRow.addAll(this.setQueryData("extend", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("contractchange")) {
            allRow.addAll(this.setQueryData("contractchange", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("preinterest")) {
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            allRow.addAll(this.setQueryData("preinterest", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("interest")) {
            qFilters.add(new QFilter("instbillctg", "!=", (Object)InterestbillctgEnum.PAYPRINANDINTE.getValue()));
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            allRow.addAll(this.setQueryData("interest", qFilters, org));
        }
        if (businesstypeSet.isEmpty() || businesstypeSet.contains("payprinandinte")) {
            qFilters.removeIf(v -> v.getProperty().equals("instbillctg"));
            qFilters.add(new QFilter("instbillctg", "=", (Object)InterestbillctgEnum.PAYPRINANDINTE.getValue()));
            allRow.addAll(this.setQueryData("payprinandinte", qFilters, org));
        }
        allRow.sort((d1, d2) -> {
            if (d1[15] == null) {
                return 1;
            }
            if (d2[15] == null) {
                return -1;
            }
            Date date1 = (Date)d1[15];
            Date date2 = (Date)d2[15];
            return date2.compareTo(date1);
        });
        for (Object[] objects : allRow) {
            vs.addRow(objects);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    private void getQfilter(String key, List<QFilter> qFilters) {
        switch (key) {
            case "13": {
                qFilters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)false))));
                break;
            }
            case "10": {
                qFilters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)((Date)DateUtils.getWeekDate().get("beginDate")), (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)((Date)DateUtils.getWeekDate().get("endDate")), (boolean)false))));
                break;
            }
            case "63": {
                qFilters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)DateUtils.getFirstDayOfCurMonth(), (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastDayOfCurMonth(), (boolean)false))));
                break;
            }
            case "24": {
                qFilters.add(new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)DateUtils.getLastMonth((Date)new Date(), (int)3), (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)false))));
            }
        }
    }

    protected String getEntityName() {
        return "cfm_business_confirm";
    }

    public String getOrgInfo() {
        return "";
    }

    public String getDataSource() {
        return "";
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        FilterContainerInitArgs args;
        this.initArgs = args = new FilterContainerInitArgs(event);
        if (this.getPageCache().get("isFirstInit") == null) {
            this.getPageCache().put("isFirstInit", "true");
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        this.fillPageData();
    }

    private void toolbarOp(String opType) {
        List errorInfos;
        OperationResult result;
        DynamicObject[] load;
        List<DynamicObject> selectedData = this.getSelectedData();
        if (selectedData == null) {
            return;
        }
        if (opType.equals("back")) {
            if (selectedData.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u56de\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"BusinessConfirmInitPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else if (selectedData.size() == 1) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cfm_confirm_back");
                showParameter.setCustomParam("billid", (Object)selectedData.get(0).getLong("id"));
                showParameter.setCustomParam("businesstype", (Object)selectedData.get(0).getString("businesstype"));
                showParameter.getOpenStyle().setShowType(ShowType.NonModal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_confirm_back"));
                this.getView().showForm(showParameter);
            }
            return;
        }
        List<String> contractList = selectedData.stream().filter(dy -> "contract".equals(dy.getString("businesstype"))).map(dy -> dy.getString("billno")).collect(Collectors.toList());
        List loanList = selectedData.stream().filter(dy -> "loan".equals(dy.getString("businesstype"))).collect(Collectors.toList());
        List repayList = selectedData.stream().filter(dy -> "repay".equals(dy.getString("businesstype"))).collect(Collectors.toList());
        List interestList = selectedData.stream().filter(dy -> StringUtils.equalsAny((CharSequence)dy.getString("businesstype"), (CharSequence[])new CharSequence[]{"interest", "payprinandinte"})).collect(Collectors.toList());
        List extendList = selectedData.stream().filter(dy -> "extend".equals(dy.getString("businesstype"))).collect(Collectors.toList());
        List contractChangeList = selectedData.stream().filter(dy -> "contractchange".equals(dy.getString("businesstype"))).collect(Collectors.toList());
        List preinterestList = selectedData.stream().filter(dy -> "preinterest".equals(dy.getString("businesstype"))).collect(Collectors.toList());
        ArrayList<String> failsBills = new ArrayList<String>();
        int failsCount = 0;
        if (!contractList.isEmpty()) {
            if (selectedData.size() == 1) {
                String formId = this.getQueryEntityName("contract", true);
                this.showBill(formId, selectedData.get(0).getLong("id"));
                return;
            }
            contractList.forEach(contract -> failsBills.add(String.format(ResManager.loadKDString((String)"%s:\u4e1a\u52a1\u786e\u8ba4\u7c7b\u578b\u4e3a\u5408\u540c\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessConfirmInitPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), contract)));
            failsCount = contractList.size();
        }
        if (!loanList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])loanList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("loan", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("loan", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + loanList.size() - result.getSuccessPkIds().size();
        }
        if (!repayList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])repayList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("repay", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("repay", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + repayList.size() - result.getSuccessPkIds().size();
        }
        if (!interestList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])interestList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("interest", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("interest", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + interestList.size() - result.getSuccessPkIds().size();
        }
        if (!extendList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])extendList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("extend", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("extend", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + extendList.size() - result.getSuccessPkIds().size();
        }
        if (!contractChangeList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])contractChangeList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("contractchange", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("contractchange", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + contractChangeList.size() - result.getSuccessPkIds().size();
        }
        if (!preinterestList.isEmpty()) {
            load = BusinessDataServiceHelper.load((Object[])preinterestList.stream().map(dy -> dy.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getQueryEntityName("preinterest", false)));
            result = OperationServiceHelper.executeOperate((String)opType, (String)this.getQueryEntityName("preinterest", false), (DynamicObject[])load, (OperateOption)OperateOption.create());
            errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                if (errorInfos.size() == 0) {
                    failsBills.add(result.getMessage());
                }
                for (IOperateInfo iOperateInfo : errorInfos) {
                    failsBills.add(iOperateInfo.getMessage());
                }
            }
            failsCount = failsCount + preinterestList.size() - result.getSuccessPkIds().size();
        }
        if (!failsBills.isEmpty()) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u786e\u8ba4\u6210\u529f%2$s\u6761\uff0c\u786e\u8ba4\u5931\u8d25%3$s\u6761\u3002", (String)"BusinessConfirmInitPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), selectedData.size(), selectedData.size() - failsCount, failsCount), String.join((CharSequence)"\n", failsBills), MessageTypes.Default);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BusinessConfirmInitPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        this.fillPageData();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"cfm_confirm_back")) {
            Map data = (Map)e.getReturnData();
            if (null != data) {
                String entityName = this.getQueryEntityName(String.valueOf(data.get("businesstype")), false);
                Object[] load = BusinessDataServiceHelper.load((Object[])new Object[]{data.get("billid")}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                if (EmptyUtil.isEmpty((Object[])load)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessConfirmInitPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    this.fillPageData();
                    return;
                }
                for (Object dynamicObject : load) {
                    dynamicObject.set("returnreason", (Object)String.valueOf(data.get("reason")));
                }
                OperationResult result = OperationServiceHelper.executeOperate((String)"back", (String)entityName, (DynamicObject[])load, (OperateOption)OperateOption.create());
                List errorInfos = result.getAllErrorOrValidateInfo();
                if (!result.isSuccess()) {
                    ArrayList<String> errorMessages = new ArrayList<String>(errorInfos.size());
                    for (IOperateInfo iOperateInfo : errorInfos) {
                        errorMessages.add(iOperateInfo.getMessage());
                    }
                    if (!errorMessages.isEmpty()) {
                        this.getView().showErrorNotification(String.join((CharSequence)"\n", errorMessages));
                    } else {
                        this.getView().showErrorNotification(result.getMessage());
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f\u3002", (String)"BusinessConfirmInitPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    this.fillPageData();
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"gotoConfirm")) {
            this.fillPageData();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters();
    }

    private List<DynamicObject> getSelectedData() {
        List selectedIdList = this.getSelectedIdList();
        DynamicObject dynFormObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dataList = dynFormObj.getDynamicObjectCollection("entryentity");
        if (selectedIdList == null) {
            return null;
        }
        List<DynamicObject> selectedList = dataList.stream().filter(i -> selectedIdList.contains(i.getLong("id"))).collect(Collectors.toList());
        return selectedList;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            String businesstype = entryRowEntity.getString("businesstype");
            businesstype = StringUtils.equals((CharSequence)businesstype, (CharSequence)"payprinandinte") ? "interest" : businesstype;
            String formId = this.getQueryEntityName(businesstype, true);
            this.showBill(formId, entryRowEntity.getLong("id"));
        }
    }

    private void showBill(String formId, Object pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.setCustomParam("confirm", (Object)"confirm");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "gotoConfirm");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getQueryEntityName(String businesstype, boolean isLayOut) {
        return ConfirmLayoutEntityEnum.getEntityFormId((String)businesstype, (String)this.getDataSource(), (boolean)isLayOut);
    }

    private List<Object[]> setQueryData(String businesstype, List<QFilter> qFilters, String org) {
        Set sourcebillids;
        boolean isInterest;
        String formId = this.getQueryEntityName(businesstype, false);
        if (StringUtils.equals((CharSequence)businesstype, (CharSequence)"payprinandinte")) {
            formId = this.getQueryEntityName("interest", false);
        }
        String sourcePro = ",sourcebillid";
        if (StringUtils.equals((CharSequence)"contract", (CharSequence)businesstype)) {
            sourcePro = "";
        } else if (StringUtils.equals((CharSequence)"repay", (CharSequence)businesstype) || StringUtils.equals((CharSequence)"contractchange", (CharSequence)businesstype)) {
            sourcePro = ",loancontractbill";
        }
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(10);
        queryFilter.addAll(qFilters);
        queryFilter.add(new QFilter(org + ".id", "in", (Object)TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cfm", (String)formId, (String)"47150e89000000ac")));
        logger.info("customlog: businesstype: {},queryFilter: {}", (Object)businesstype, queryFilter);
        String selects = "id," + org + ",billno,description" + sourcePro + ",registorg,creator,createtime,currency";
        boolean bl = isInterest = "cim_invest_interestbill".equals(formId) || "cfm_interestbill".equals(formId);
        if (isInterest) {
            selects = selects + ",actualinstamt,repaymentid";
        }
        if ("preinterest".equals(businesstype)) {
            selects = "id," + org + ",billno,description" + sourcePro + ",textcreditor,creator,createtime,currency";
        }
        if (StringUtils.equals((CharSequence)"repay", (CharSequence)businesstype)) {
            selects = selects + ",e_actintamt";
        }
        selects = EmptyUtil.isEmpty((String)this.getAmountFieldName(businesstype)) ? selects : selects + "," + this.getAmountFieldName(businesstype);
        selects = EmptyUtil.isEmpty((String)this.getInterestAmountFieldName(businesstype)) ? selects : selects + "," + this.getInterestAmountFieldName(businesstype);
        DynamicObject[] dataList = TmcDataServiceHelper.load((String)formId, (String)selects, (QFilter[])queryFilter.toArray(new QFilter[0]));
        Map<Long, Long> loanMap = null;
        sourcePro = "sourcebillid";
        if (StringUtils.equals((CharSequence)"contract", (CharSequence)businesstype)) {
            loanMap = Arrays.stream(dataList).map(dy -> dy.getLong("id")).collect(Collectors.toMap(m1 -> m1, m2 -> m2));
            sourcePro = "id";
        } else if (StringUtils.equals((CharSequence)"loan", (CharSequence)businesstype) || StringUtils.equals((CharSequence)"extend", (CharSequence)businesstype)) {
            loanMap = Arrays.stream(dataList).filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("sourcebillid"))).map(dy -> dy.getLong("sourcebillid")).collect(Collectors.toMap(m1 -> m1, m2 -> m2, (d1, d2) -> d1));
        } else if (StringUtils.equalsAny((CharSequence)businesstype, (CharSequence[])new CharSequence[]{"interest", "payprinandinte"})) {
            if (StringUtils.equals((CharSequence)businesstype, (CharSequence)"payprinandinte")) {
                Object[] repaymentIds = Arrays.stream(dataList).map(v -> v.get("repaymentid")).toArray();
                DynamicObjectCollection repayments = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)repaymentIds), new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())});
                if (null == repayments || repayments.size() == 0) {
                    return new ArrayList<Object[]>();
                }
                List repaymentIdList = repayments.stream().map(v -> v.get("id")).collect(Collectors.toList());
                dataList = (DynamicObject[])Arrays.stream(dataList).filter(v -> repaymentIdList.contains(v.get("repaymentid"))).toArray(DynamicObject[]::new);
            }
            sourcebillids = Arrays.stream(dataList).filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("sourcebillid"))).map(dy -> dy.getLong("sourcebillid")).collect(Collectors.toSet());
            loanMap = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcebillids)}).stream().filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("sourcebillid"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("sourcebillid")));
        } else if (StringUtils.equals((CharSequence)"repay", (CharSequence)businesstype)) {
            loanMap = Arrays.stream(dataList).filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("id")) && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("loancontractbill"))).collect(Collectors.toMap(m1 -> m1.getLong("id"), dy -> dy.getDynamicObject("loancontractbill").getLong("id"), (d1, d2) -> d1));
            sourcePro = "id";
        } else if (StringUtils.equals((CharSequence)"contractchange", (CharSequence)businesstype)) {
            loanMap = Arrays.stream(dataList).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("loancontractbill"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject("loancontractbill").getLong("id")));
            sourcePro = "id";
        } else if (StringUtils.equals((CharSequence)"preinterest", (CharSequence)businesstype)) {
            sourcebillids = Arrays.stream(dataList).filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("sourcebillid"))).map(dy -> dy.getLong("sourcebillid")).collect(Collectors.toSet());
            loanMap = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcebillids)}).stream().filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("sourcebillid"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("sourcebillid")));
        }
        String dataSource = this.getDataSource();
        String person = "textcreditor";
        if (StringUtils.equals((CharSequence)"cfm", (CharSequence)dataSource)) {
            person = "textdebtor";
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(dataList.length);
        if (loanMap != null && loanMap.size() > 0) {
            QFilter contractFilter = new QFilter("id", "in", loanMap.values());
            logger.info("customlog: businesstype: {},contractFilter: {}", (Object)businesstype, (Object)contractFilter);
            Map<Long, DynamicObject> sourceMap = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id,textcreditor,textdebtor,contractno,bizdate,currency,amount,clientorg,startdate,enddate", (QFilter[])contractFilter.toArray()).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            DynamicObject sourcebillid = null;
            for (DynamicObject row : dataList) {
                sourcebillid = sourceMap.get(loanMap.get(row.getLong(sourcePro)));
                Object[] objects = null;
                objects = EmptyUtil.isEmpty((DynamicObject)sourcebillid) ? new Object[]{row.get("id"), row.getDynamicObject(org) == null ? null : row.getDynamicObject(org).getPkValue(), businesstype, row.get("billno"), null, null, null, ((DynamicObject)row.get("currency")).get("id"), this.getAmount(row, businesstype, "amount"), this.getAmount(row, businesstype, "interest"), null, null, null, !row.containsProperty("registorg") || row.getDynamicObject("registorg") == null ? null : row.getDynamicObject("registorg").getPkValue(), row.getDynamicObject("creator") == null ? null : row.getDynamicObject("creator").getPkValue(), row.get("createtime")} : new Object[]{row.get("id"), row.getDynamicObject(org) == null ? null : row.getDynamicObject(org).getPkValue(), businesstype, row.get("billno"), sourcebillid.get(person), sourcebillid.get("contractno"), sourcebillid.get("bizdate"), ((DynamicObject)row.get("currency")).get("id"), this.getAmount(row, businesstype, "amount"), this.getAmount(row, businesstype, "interest"), sourcebillid.get("clientorg"), sourcebillid.get("startdate"), sourcebillid.get("enddate"), !row.containsProperty("registorg") || row.getDynamicObject("registorg") == null ? null : row.getDynamicObject("registorg").getPkValue(), row.getDynamicObject("creator") == null ? null : row.getDynamicObject("creator").getPkValue(), row.get("createtime")};
                objects = this.dealResultObject(row, objects);
                rows.add(objects);
            }
        }
        logger.info("customlog: rows.size: {}", (Object)rows.size());
        return rows;
    }

    private static BigDecimal getActIntAmt(boolean isInterest, DynamicObject row) {
        if (isInterest) {
            return row.getBigDecimal("actualinstamt");
        }
        if (row.containsProperty("loans") && EmptyUtil.isNoEmpty((DynamicObjectCollection)row.getDynamicObjectCollection("loans"))) {
            return row.getDynamicObjectCollection("loans").stream().map(d -> d.getBigDecimal("e_actintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(DynamicObject row, String businessType, String amountType) {
        String amountFieldName;
        BigDecimal amount = null;
        String string = amountFieldName = amountType.equals("amount") ? this.getAmountFieldName(businessType) : this.getInterestAmountFieldName(businessType);
        if (EmptyUtil.isEmpty((String)amountFieldName)) {
            return null;
        }
        switch (businessType) {
            case "repay": {
                DynamicObjectCollection loans = row.getDynamicObjectCollection("loans");
                amount = BigDecimal.ZERO;
                for (DynamicObject loan : loans) {
                    amount = amount.add(EmptyUtil.isEmpty((BigDecimal)loan.getBigDecimal(amountFieldName)) ? BigDecimal.ZERO : loan.getBigDecimal(amountFieldName));
                }
                break;
            }
            default: {
                amount = row.getBigDecimal(amountFieldName);
            }
        }
        return amount;
    }

    private String getAmountFieldName(String businessType) {
        String fieldName = "amount";
        switch (businessType) {
            case "contract": 
            case "contractchange": 
            case "extend": {
                fieldName = "amount";
                break;
            }
            case "loan": {
                fieldName = "drawamount";
                break;
            }
            case "repay": {
                fieldName = "e_convertrepayamt";
                break;
            }
            case "preinterest": {
                fieldName = "actpreinstamt";
                break;
            }
            case "interest": {
                fieldName = "";
                break;
            }
            case "payprinandinte": {
                fieldName = "";
            }
        }
        return fieldName;
    }

    private String getInterestAmountFieldName(String businessType) {
        String fieldName = "amount";
        switch (businessType) {
            case "contract": 
            case "loan": 
            case "preinterest": 
            case "extend": 
            case "contractchange": {
                fieldName = "";
                break;
            }
            case "repay": {
                fieldName = "e_convertactintamt";
                break;
            }
            case "interest": {
                fieldName = "actualinstamt";
                break;
            }
            case "payprinandinte": {
                fieldName = "actualinstamt";
            }
        }
        return fieldName;
    }

    private Object[] dealResultObject(DynamicObject row, Object[] result) {
        PluginProxy pluginProxy = PluginProxy.create(IConfirmListInterface.class, (String)"kd.sdk.tmc.cfm.extpoint.confirm.IConfirmListInterface");
        if (pluginProxy.getPlugins().isEmpty()) {
            return result;
        }
        List list = pluginProxy.callReplace(proxy -> {
            Object[] resultArr = proxy.resultObject(this.getDataSource(), row, result);
            return resultArr;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return (Object[])list.get(0);
    }

    private String[] addShowField() {
        PluginProxy pluginProxy = PluginProxy.create(IConfirmListInterface.class, (String)"kd.sdk.tmc.cfm.extpoint.confirm.IConfirmListInterface");
        if (pluginProxy.getPlugins().isEmpty()) {
            return new String[0];
        }
        List list = pluginProxy.callReplace(proxy -> {
            String[] columnName = proxy.columnsName(this.getDataSource());
            return columnName;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return (String[])list.get(0);
    }
}

