/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.ContractStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractApplyEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String[] GCProps = new String[]{"gcontract", "gratio", "gsrcbillid"};
    private static final List<String> propList = new ArrayList<String>(44);
    public static final String SELECT_CONTRACT_BILL_CALLBACK = "selectContractBillCallBack";
    public static final String STATUS = "status";
    public static final String CFM_LOANCONTRACTBILL_F7 = "cfm_loancontractbill_f7";
    public static final String CIM_LOANCONTRACTBILL_F7 = "cim_loancontractbill_f7";
    public static final String IFM_LOANCONTRACTBILL_F7 = "ifm_loancontractbill_f7";
    public static final String FL_LEASECONTRACTBILL_F7 = "fl_leasecontractbill_f7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit loanContractTextF7 = (TextEdit)this.getControl("contractbillno");
        BasedataEdit accountBankControl = (BasedataEdit)this.getControl("accountbank");
        BasedataEdit loanerAcctBank = (BasedataEdit)this.getControl("loaneracctbank");
        loanContractTextF7.addClickListener((ClickListener)this);
        accountBankControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (!"ifm_contract_apply".equals(this.getView().getFormShowParameter().getFormId())) {
            loanerAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object loanContractBillId = this.getView().getFormShowParameter().getCustomParam("loancontractbill");
        if (EmptyUtil.isNoEmpty((Object)loanContractBillId)) {
            this.initByLoanContract(loanContractBillId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initRepaymentWay();
    }

    private void initRepaymentWay() {
        String repayment = (String)this.getModel().getValue("repaymentway");
        if (RepaymentWayEnum.isHbfx((String)repayment)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"repaymentway"});
        } else {
            ComboEdit repaymentWay = (ComboEdit)this.getControl("repaymentway");
            List<RepaymentWayEnum> wayEnums = Arrays.asList(RepaymentWayEnum.bqhblsbq, RepaymentWayEnum.dqhblsbq, RepaymentWayEnum.bqhbdqhx, RepaymentWayEnum.dqhbdqhx, RepaymentWayEnum.zdyhk);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(wayEnums.size());
            for (RepaymentWayEnum wayEnum : wayEnums) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(wayEnum.getName()));
                item.setValue(wayEnum.getValue());
                comboItems.add(item);
            }
            repaymentWay.setComboItems(comboItems);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "submit": {
                op.getOption().setVariableValue("formId", ((FormView)this.getView()).getFormId());
                op.getOption().setVariableValue("op_from_edit_form", this.getView().getModel().getDataEntityType().getName());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "contractbillno": {
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                this.clear();
                break;
            }
            case "repaymentway": {
                this.repaymentWayOnChanged((String)newValue);
                break;
            }
        }
    }

    private void repaymentWayOnChanged(String repaymentWay) {
        if (RepaymentWayEnum.isHbfx((String)repaymentWay) || RepaymentWayEnum.isDqhbdqhx((String)repaymentWay) || RepaymentWayEnum.isDqhblsbq((String)repaymentWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"stageplan"});
        }
        if (RepaymentWayEnum.isBqhbdqhx((String)repaymentWay) || RepaymentWayEnum.isDqhbdqhx((String)repaymentWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"interestsettledplan"});
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        } else {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        }
    }

    protected ListShowParameter getF7TypeFilter() {
        ListShowParameter showParameter;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_contract_apply".equals(formId)) {
            showParameter = ShowFormHelper.createShowListForm((String)CFM_LOANCONTRACTBILL_F7, (boolean)false);
            QFilter filter = new QFilter("org", ">", (Object)0L).or(new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue())).and(new QFilter("loantype", "!=", (Object)BizTypeEnum.BOND.getValue())).and(new QFilter("datasource", "!=", (Object)DataSourceEnum.FL.getValue()));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("cim_contract_apply".equals(formId)) {
            showParameter = ShowFormHelper.createShowListForm((String)CIM_LOANCONTRACTBILL_F7, (boolean)false);
            QFilter filter = new QFilter("creditorg", ">", (Object)0L).or(new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue())).and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue())).and(new QFilter("loantype", "in", (Object)new String[]{BizTypeEnum.ENTRUST.getValue(), BizTypeEnum.EC.getValue()}));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("ifm_contract_apply".equals(formId)) {
            showParameter = ShowFormHelper.createShowListForm((String)IFM_LOANCONTRACTBILL_F7, (boolean)false);
            QFilter filter = new QFilter("org", ">", (Object)0L).or(new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue())).and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("fl_contract_apply".equals(formId)) {
            showParameter = ShowFormHelper.createShowListForm((String)FL_LEASECONTRACTBILL_F7, (boolean)false);
            QFilter filter = new QFilter("org", ">", (Object)0L).and("contractstatus", "=", (Object)ContractStatusEnum.EXECUTING.getValue()).and(new QFilter("datasource", "=", (Object)DataSourceEnum.FL.getValue()));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else {
            return null;
        }
        return showParameter;
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "contractbillno": {
                    ListShowParameter showParameter = this.getF7TypeFilter();
                    if (null == showParameter) {
                        return;
                    }
                    QFilter qFilter = new QFilter(STATUS, "=", (Object)BillStatusEnum.AUDIT.getValue());
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_CONTRACT_BILL_CALLBACK));
                    HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
                    if (result != null && !result.hasAllOrgPerm()) {
                        qFilter.and("org", "in", (Object)result.getHasPermOrgs());
                    }
                    qFilter.and("contractstatus", "=", (Object)ContractStatusEnum.EXECUTING.getValue());
                    if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id"))) {
                        DynamicObject originalObj = QueryServiceHelper.queryOne((String)"cfm_contract_apply", (String)"loancontractbill", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
                        qFilter.or("id", "=", originalObj.get("loancontractbill"));
                    }
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    showParameter.setCustomParam("need_status_filter", (Object)1);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals(SELECT_CONTRACT_BILL_CALLBACK)) {
            this.clear();
            ListSelectedRowCollection data = (ListSelectedRowCollection)event.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)data)) {
                Object loanContractBillId = data.get(0).getPrimaryKeyValue();
                this.initByLoanContract(loanContractBillId);
            }
        }
    }

    private void initByLoanContract(Object loanContractBillId) {
        DynamicObject loanContractBill = "ifm_contract_apply".equals(this.getView().getFormShowParameter().getFormId()) ? BusinessDataServiceHelper.loadSingle((Object)loanContractBillId, (String)"ifm_loancontractbill") : BusinessDataServiceHelper.loadSingle((Object)loanContractBillId, (String)"cfm_loancontractbill");
        DataEntityPropertyCollection loanContractProperties = loanContractBill.getDataEntityType().getProperties();
        for (IDataEntityProperty property : loanContractProperties) {
            String prop = property.getName();
            if (!propList.contains(prop)) continue;
            this.getModel().setValue(prop, loanContractBill.get(prop));
        }
        this.copyBankSyndicateEntry(loanContractBill);
        this.copyProjectEntry(loanContractBill);
        this.copyGuaranteeEntry(loanContractBill);
        this.getModel().setValue("contractbillno", loanContractBill.get("billno"));
        this.getModel().setValue("loancontractbill", (Object)loanContractBill);
    }

    private void clear() {
        for (String prop : propList) {
            this.getModel().setValue(prop, null);
        }
        this.getModel().deleteEntryData("project_entry");
        this.getModel().deleteEntryData("entry_gcontract");
        this.getModel().deleteEntryData("banksyndicate_entry");
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.getModel().setValue("loancontractbill", null);
    }

    private void copyGuaranteeEntry(DynamicObject loanContractBill) {
        DynamicObjectCollection guaranteeUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gcreditortype", "gcreditor", "gcreditortext", "gcontract.guaranteevarieties.creditguarantee as creditguarantee"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", loanContractBill.getPkValue())}, (String)"id");
        for (DynamicObject guaranteeEntryRow : guaranteeUseBills) {
            BigDecimal rate;
            int index = this.getModel().createNewEntryRow("entry_gcontract");
            this.getModel().setValue("gcontract", guaranteeEntryRow.get("gcontract"), index);
            this.getModel().setValue("gcreditguarantee", guaranteeEntryRow.get("creditguarantee"), index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)guaranteeEntryRow.get("gratio"), (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)guaranteeEntryRow.getBigDecimal("gamount"), (int)index);
            this.getModel().setValue("gcontractamount", guaranteeEntryRow.get("gcontract.amount"), index);
            this.getModel().setValue("gcontractcurrency", guaranteeEntryRow.get("gcontract.currency"), index);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency != null && guaranteeEntryRow.getLong("gcontract.currency") != currency.getLong("id")) {
                DynamicObject company = (DynamicObject)this.getModel().getValue("org");
                rate = TmcBusinessBaseHelper.getExchangeRate((long)currency.getLong("id"), (long)guaranteeEntryRow.getLong("gcontract.currency"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
            } else {
                rate = BigDecimal.ONE;
            }
            this.getModel().setValue("gexchrate", (Object)rate, index);
            this.getModel().setValue("gcomment", guaranteeEntryRow.get("gcomment"), index);
            this.getModel().setValue("gstatus", (Object)(guaranteeEntryRow.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0 ? "C" : "A"), index);
            if (!GuaranteeUseHelper.getMultiCreditorFlag((String)this.getModel().getDataEntityType().getName())) continue;
            this.getModel().setValue("gcreditortype", guaranteeEntryRow.get("gcreditortype"), index);
            this.getModel().setValue("gcreditor", guaranteeEntryRow.get("gcreditor"), index);
            this.getModel().setValue("gcreditortext", guaranteeEntryRow.get("gcreditortext"), index);
        }
    }

    private void copyProjectEntry(DynamicObject loanContractBill) {
        for (DynamicObject projectEntryRow : loanContractBill.getDynamicObjectCollection("project_entry")) {
            int index = this.getModel().createNewEntryRow("project_entry");
            this.getModel().setValue("e_project", projectEntryRow.get("e_project"), index);
            this.getModel().setValue("e_projdescription", projectEntryRow.get("e_projdescription"), index);
        }
    }

    private void copyBankSyndicateEntry(DynamicObject loanContractBill) {
        for (DynamicObject bankSyndicateEntryRow : loanContractBill.getDynamicObjectCollection("banksyndicate_entry")) {
            int index = this.getModel().createNewEntryRow("banksyndicate_entry");
            this.getModel().setValue("e_bankrole", bankSyndicateEntryRow.get("e_bankrole"), index);
            this.getModel().setValue("e_bank", bankSyndicateEntryRow.get("e_bank"), index);
            this.getModel().setValue("e_shareamount", bankSyndicateEntryRow.get("e_shareamount"), index);
            this.getModel().setValue("e_bankdescription", bankSyndicateEntryRow.get("e_bankdescription"), index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "accountbank": 
            case "loaneracctbank": {
                this.accountBankF7Evt(e);
                break;
            }
        }
    }

    private void accountBankF7Evt(BeforeF7SelectEvent evt) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("contractbillno"))) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u540c\u3002", (String)"ContractApplyEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        String entityType = this.getModel().getDataEntityType().getName();
        if (!this.isFilter(entityType, evt)) {
            return;
        }
        QFilter accQF = this.getBankAcctFilter(this.getCompany(entityType));
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            accQF.and(new QFilter("acctclassify", "=", (Object)"I"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            accQF.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
        } else {
            accQF.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(accQF);
    }

    private DynamicObject getCompany(String entityType) {
        String mainOrg = "cim_contract_apply".equals(entityType) ? "creditorg" : this.getModel().getDataEntityType().getMainOrg();
        return (DynamicObject)this.getModel().getValue(mainOrg);
    }

    private boolean isFilter(String entityType, BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("cim_contract_apply".equals(entityType) && key.equals("accountbank")) {
            return false;
        }
        if ("cfm_contract_apply".equals(entityType) && key.equals("loaneracctbank")) {
            return false;
        }
        return !"ifm_contract_apply".equals(entityType) || !key.equals("accountbank");
    }

    private String getPropLocalDisplayName(String propName) {
        return CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)propName);
    }

    private QFilter getBankAcctFilter(DynamicObject fundOrg) {
        long orgId = fundOrg == null ? 0L : Long.parseLong(fundOrg.getPkValue().toString());
        return TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
    }

    private BigDecimal queryContractBillEditableRatio(Object loanContractBillId) {
        BigDecimal ratio = Constants.ONE_HUNDRED;
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,creditlimit", (QFilter[])new QFilter("loancontractbill", "=", loanContractBillId).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()}).and("creditlimit", "is not null", null).toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBills)) {
            Set creditLimitIds = loanBills.stream().map(o -> o.get("creditlimit")).collect(Collectors.toSet());
            DynamicObjectCollection creditLimitGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GCProps), (QFilter[])new QFilter("gsrcbillid", "in", creditLimitIds).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimitGcBills)) {
                Map<Object, List<DynamicObject>> creditLimitGcBillMap = creditLimitGcBills.stream().collect(Collectors.groupingBy(o -> o.get("gsrcbillid")));
                QFilter filter = null;
                for (DynamicObject loanBill : loanBills) {
                    Object loanBillId = loanBill.get("id");
                    Object creditLimitId = loanBill.get("creditlimit");
                    List<DynamicObject> GcBills = creditLimitGcBillMap.get(creditLimitId);
                    if (EmptyUtil.isEmpty(GcBills)) continue;
                    QFilter appendFilter = new QFilter("gsrcbillid", "=", loanBillId).and("gcontract", "in", GcBills.stream().map(o -> o.get("gcontract")).collect(Collectors.toSet()));
                    if (filter == null) {
                        filter = appendFilter;
                        continue;
                    }
                    filter.or(appendFilter);
                }
                DynamicObjectCollection loanBillGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GCProps), (QFilter[])new QFilter[]{filter}, (String)"createtime asc");
                HashSet<Object> guaranteeContractIds = new HashSet<Object>();
                for (DynamicObject loanBillGcBill : loanBillGcBills) {
                    Object gContractId = loanBillGcBill.get("gcontract");
                    if (guaranteeContractIds.contains(gContractId)) continue;
                    guaranteeContractIds.add(gContractId);
                    ratio = ratio.subtract(loanBillGcBill.getBigDecimal("gratio"));
                }
            }
        }
        return ratio;
    }

    static {
        propList.add("registorg");
        propList.add("org");
        propList.add("lenderapplyno");
        propList.add("loantype");
        propList.add("finproduct");
        propList.add("productfactory");
        propList.add("textcreditor");
        propList.add("contractno");
        propList.add("contractname");
        propList.add("bizdate");
        propList.add("startdate");
        propList.add("term");
        propList.add("enddate");
        propList.add("creditortype");
        propList.add("currency");
        propList.add("amount");
        propList.add("drawway");
        propList.add("loanuse");
        propList.add("accountbank");
        propList.add("loaneracctbank");
        propList.add("guarantee");
        propList.add("region");
        propList.add("confirmdescription");
        propList.add("description");
        propList.add("creditor");
        propList.add("creditorg");
        propList.add("debtor");
        propList.add("settlecenter");
        propList.add("iscallint");
        propList.add("interesttype");
        propList.add("referencerate");
        propList.add("ratesign");
        propList.add("ratefloatpoint");
        propList.add("rateadjuststyle");
        propList.add("rateadjustcycle");
        propList.add("rateadjustcycletype");
        propList.add("rateadjustdate");
        propList.add("interestrate");
        propList.add("floatingratio");
        propList.add("repaymentway");
        propList.add("settleintmode");
        propList.add("basis");
        propList.add("stageplan");
        propList.add("interestsettledplan");
        propList.add("islimitclause");
        propList.add("limitclauseexplain");
        propList.add("otherexplain");
        propList.add("drawamount");
        propList.add("notrepayamount");
    }
}

