/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.BatchRateAdjustViewInfoEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.ContractPushHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.cfm.formplugin.rateadjust.CreateRateAdjustBill;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ContractBaseList
extends AbstractTmcBillBaseList {
    private static final String[] contractSelectProps = new String[]{"billno", "loantype", "isnofixedterm", "datasource", "billstatus", "contractstatus", "productfactory", "confirmstatus", "notdrawamount", "enddate", "productfactory", "interesttype", "drawdownplan_entry"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)true);
    }

    public void setFilter(SetFilterEvent e) {
        String formId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizType = (String)parameter.getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            String[] bizTypes = bizType.split(",");
            e.getQFilters().add(new QFilter("loantype", "in", (Object)bizTypes));
        }
        if ((formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()).startsWith("ifm_")) {
            QFilter qFilter = new QFilter("settlestatus", "!=", (Object)"submit");
            qFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            e.getQFilters().add(qFilter);
        } else if (formId.startsWith("cfm_") || formId.startsWith("cim_")) {
            e.getQFilters().add(new QFilter("settlestatus", "!=", (Object)"addnew"));
            if (!CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
                e.getQFilters().add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizType = (String)parameter.getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("cfm_financingvarieties".equals(args.getRefEntityId())) {
            QFilter fpQFilter = this.getFinProductQFilter();
            args.getQfilters().add(fpQFilter);
        }
    }

    private QFilter getFinProductQFilter() {
        Set bizTypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        QFilter fpQFilter = new QFilter("isleaf", "=", (Object)"1");
        if (bizTypes.contains(BizTypeEnum.BOND.getValue())) {
            fpQFilter.and(new QFilter("finsource", "=", (Object)"bond"));
        }
        return fpQFilter;
    }

    public List<QFilter> addCustomFilterForFilterCol(String field) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        if ("finproduct.name".equals(field)) {
            QFilter fpQFilter = this.getFinProductQFilter();
            qFilters.add(fpQFilter);
        }
        return qFilters;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                this.beforeDoDraw(args);
                break;
            }
            case "extend": {
                this.beforeDoExtend(args);
                break;
            }
            case "rateadjustop": {
                this.beforeDoRateAdjust(args);
                break;
            }
            case "endcontract": 
            case "activatecontract": {
                Long contractId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)contractId)) {
                    args.setCancel(true);
                    return;
                }
                formOperate.getOption().setVariableValue("CONTRACTBILL_FORMID", ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                break;
            }
            case "pushrepayment": {
                this.beforeDoRepay(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long selectedId;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("rateadjustop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.rateAdjust();
        } else if ("draw".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.pushDraw();
        } else if ("extend".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.pushExtend();
        } else if ("pushrepayment".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Long id = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            this.getPageCache().put("operationKey", operateKey);
            CfmContractBillHelper.contractRepay((Long)id, (IFormView)this.getView());
        } else if ("endcontract".equals(operateKey) || "activatecontract".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        } else if ("change".equals(operateKey) && args.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((Long)(selectedId = this.getSelectedId()))) {
            if (!QueryServiceHelper.exists((String)"cfm_loancontractbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue())})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u5408\u540c\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u7684\u6570\u636e\u3002", (String)"ContractBaseList_03", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.openApplyForm();
            }
        }
    }

    private void openApplyForm() {
        String formId;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        switch (formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()) {
            case "cfm_loancontract_bl_l": 
            case "cfm_loancontract_ic_l": {
                showParameter.setFormId("cfm_contract_apply");
                break;
            }
            case "cim_invest_contract": {
                showParameter.setFormId("cim_contract_apply");
                break;
            }
            case "ifm_loancontractbill": {
                showParameter.setFormId("ifm_contract_apply");
                break;
            }
            case "fl_leasecontractbill": {
                showParameter.setFormId("fl_contract_apply");
                break;
            }
            default: {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6682\u4e0d\u652f\u6301\u53d8\u66f4\u3002", (String)"ContractBaseList_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        showParameter.setCustomParam("change", (Object)"change");
        showParameter.setCustomParam("loancontractbill", (Object)this.getSelectedId());
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String customVaule;
        Map paramMap;
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_RATEADJUST_CALLBACK") && MessageBoxResult.Yes == res) {
            String customVaule2 = messageBoxClosedEvent.getCustomVaule();
            Map paramMap2 = (Map)JSON.parseObject((String)customVaule2, Map.class);
            if (EmptyUtil.isNoEmpty((Object)paramMap2)) {
                Long selectedId = (Long)paramMap2.get("selectedId");
                Long rateAdjustId = (Long)paramMap2.get("rateAdjustId");
                CfmRateAdjustHelper.showRateAdjustForm((Long)rateAdjustId, (Long)selectedId, (IFormView)this.getView());
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CALLBACK_OPENPERPETUAL") && MessageBoxResult.Yes == res && EmptyUtil.isNoEmpty((Object)(paramMap = (Map)JSON.parseObject((String)(customVaule = messageBoxClosedEvent.getCustomVaule()), Map.class)))) {
            Long selectedId = (Long)paramMap.get("selectedId");
            CfmRateAdjustHelper.showRateAdjustForm(null, (Long)selectedId, (IFormView)this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_RATE_ADJUST", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map returnDataMap = (Map)evt.getReturnData();
            HashMap<String, String> paramMap = new HashMap<String, String>(2);
            paramMap.put("dataSource", this.getDataSource());
            paramMap.put("dataSrc", "contractBill");
            paramMap.put("formId", CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
            List<DynamicObject> rateAdjustBills = CreateRateAdjustBill.createRateAdjustBill(returnDataMap, paramMap);
            if (EmptyUtil.isNoEmpty(rateAdjustBills)) {
                this.showRateAdjustForm(rateAdjustBills.get(0).getPkValue());
            }
        }
    }

    private boolean validateStatus(DynamicObject contract, AbstractBizResource biz2Resource) {
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)contract.getString("billstatus"))) {
            this.getView().showTipNotification(biz2Resource.getCbStatusError());
            return false;
        }
        String contractStatus = contract.getString("contractstatus");
        if (!StringUtils.equals((CharSequence)contractStatus, (CharSequence)LoanContractStatusEnum.REGISTERED.getValue()) && !StringUtils.equals((CharSequence)contractStatus, (CharSequence)LoanContractStatusEnum.EXECUTING.getValue())) {
            if (LoanTypeEnum.isBond((String)contract.getString("loantype"))) {
                this.getView().showTipNotification(biz2Resource.getCbBondContractStatusError());
            } else {
                this.getView().showTipNotification(biz2Resource.getCbContractStatusError());
            }
            return false;
        }
        String loanType = contract.getString("loantype");
        if ((BizTypeEnum.EC.getValue().equals(loanType) || BizTypeEnum.ENTRUST.getValue().equals(loanType)) && !CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)contract)) {
            this.getView().showTipNotification(biz2Resource.getConfirmStatusError());
            return false;
        }
        return true;
    }

    private void beforeDoDraw(BeforeDoOperationEventArgs evtArgs) {
        AbstractBizResource biz2Resource;
        Long contractId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)contractId)) {
            evtArgs.setCancel(true);
            return;
        }
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", contractSelectProps));
        if (!this.validateStatus(contract, biz2Resource = new BizResourceFactory().getBizResource(contract.getString("datasource")))) {
            evtArgs.setCancel(true);
            return;
        }
        BigDecimal noDrawAmount = contract.getBigDecimal("notdrawamount");
        if (noDrawAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(biz2Resource.getCbNotDrawamount());
            evtArgs.setCancel(true);
        }
        LoanBillFormHelper.validateIsDrawByPlan(contract, evtArgs, this.getView());
    }

    private void beforeDoRateAdjust(BeforeDoOperationEventArgs evtArgs) {
        Long contractId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)contractId)) {
            evtArgs.setCancel(true);
            return;
        }
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "creditortype", "datasource", "interesttype", "currency"));
        String dataSource = contract.getString("datasource");
        AbstractBizResource biz2Resource = new BizResourceFactory().getBizResource(dataSource);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        if (StringUtils.equals((CharSequence)"cfm_loancontract_bo", (CharSequence)billFormId)) {
            return;
        }
        if (!StringUtils.equals((CharSequence)"ifm_loancontractbill", (CharSequence)billFormId) && CreditorTypeEnum.SETTLECENTER.getValue().equals(contract.getString("creditortype"))) {
            this.getView().showTipNotification(biz2Resource.getCbUnAdjustOp());
            evtArgs.setCancel(true);
            return;
        }
        QFilter loanFilter = new QFilter("loancontractbill", "=", (Object)contractId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        boolean existsOnWayBill = QueryServiceHelper.exists((String)"cfm_loanbill", (QFilter[])new QFilter[]{loanFilter, statusFilter});
        if (existsOnWayBill) {
            this.getView().showTipNotification(biz2Resource.getCbInterestUnAdjustOp());
            evtArgs.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)"cfm_loancontract_ic_l", (CharSequence)billFormId) && StringUtils.equals((CharSequence)DataSourceEnum.INVEST.getValue(), (CharSequence)dataSource)) {
            this.getView().showTipNotification(biz2Resource.checkContractBillsAdjustOp());
            evtArgs.setCancel(true);
        }
    }

    private void beforeDoRepay(BeforeDoOperationEventArgs evtArgs) {
        Long contractId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)contractId)) {
            evtArgs.setCancel(true);
            return;
        }
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "creditortype", "datasource", "interesttype", "currency"));
        this.currencyValidator(evtArgs, contract, new BizResourceFactory().getBizResource(contract.getString("datasource")));
        this.validateContractApply(evtArgs, contractId);
    }

    private void validateContractApply(BeforeDoOperationEventArgs evtArgs, Long contractId) {
        QFilter qFilter = new QFilter("loancontractbill", "=", (Object)contractId);
        qFilter.and("bizstatus", "in", (Object)new String[]{ApplyBizStatusEnum.APPLYING.getValue(), ApplyBizStatusEnum.HANDING.getValue()});
        boolean exists = QueryServiceHelper.exists((String)"cfm_contract_apply", (QFilter[])qFilter.toArray());
        if (exists) {
            String formId = ((BillList)this.getControl("billlistap")).getBillFormId();
            String tipMsg = StringUtils.equals((CharSequence)formId, (CharSequence)"fl_leasecontractbill") ? CfmFormResourceEnum.ContractBaseEdit_21.loadKDString() : CfmFormResourceEnum.ContractBaseEdit_20.loadKDString();
            this.getView().showTipNotification(tipMsg);
            evtArgs.setCancel(true);
        }
    }

    private void currencyValidator(BeforeDoOperationEventArgs evtArgs, DynamicObject contract, AbstractBizResource biz2Resource) {
        DynamicObject currency = contract.getDynamicObject("currency");
        QFilter qFilter = new QFilter("loancontractbill", "=", (Object)this.getSelectedId());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("currency", "!=", currency.getPkValue()));
        boolean exists = TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getView().showTipNotification(biz2Resource.getDiffCurrencyRepayMsg());
            evtArgs.setCancel(true);
        }
    }

    private void beforeDoExtend(BeforeDoOperationEventArgs evtArgs) {
        AbstractBizResource biz2Resource;
        Long contractId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)contractId)) {
            evtArgs.setCancel(true);
            return;
        }
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "billno", "isnofixedterm", "loantype", "datasource", "billstatus", "contractstatus", "productfactory", "confirmstatus", "enddate", "notdrawamount"));
        if (!this.validateStatus(contract, biz2Resource = new BizResourceFactory().getBizResource(contract.getString("datasource"))) || !this.validateDate(contract)) {
            evtArgs.setCancel(true);
            return;
        }
        Pair result = ExtendHelper.isExtendAllowed((DynamicObject)contract);
        if (!((Boolean)result.getLeft()).booleanValue()) {
            this.getView().showTipNotification((String)result.getRight());
            evtArgs.setCancel(true);
        }
    }

    private void pushExtend() {
        Long contractId = this.getSelectedId();
        ContractPushHelper.pushExtend((IFormView)this.getView(), (Long)contractId);
    }

    private void pushDraw() {
        Long contractId = this.getSelectedId();
        CfmContractBillHelper.pushLoanBill((IFormView)this.getView(), (Long)contractId);
    }

    private void rateAdjust() {
        Long selectedId = this.getSelectedId();
        QFilter adjustFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("loancontractbill", "=", (Object)selectedId));
        Object[] rateAdjustBills = TmcDataServiceHelper.load((String)"cfm_rateadjustbill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{adjustFilter});
        if (EmptyUtil.isNoEmpty((Object[])rateAdjustBills)) {
            Long rateAdjustId = rateAdjustBills[0].getLong("id");
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("selectedId", selectedId);
            paramMap.put("rateAdjustId", rateAdjustId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u6709\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355\uff0c\u662f\u5426\u8fdb\u884c\u7f16\u8f91\u8be5\u5355\u636e\uff1f", (String)"ContractBaseList_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_RATEADJUST_CALLBACK"), new HashMap(), JSON.toJSONString(paramMap));
        } else {
            String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"cfm_loancontract_bo")) {
                long openPerpetual = CfmRateAdjustHelper.getLoanBondBillNum((long)selectedId);
                if (openPerpetual > 0L) {
                    HashMap<String, Long> paramMap = new HashMap<String, Long>();
                    paramMap.put("selectedId", selectedId);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u503a\u5238\u53d1\u884c\u5df2\u8bbe\u7f6e\u5229\u7387\u52a0\u70b9\u6570\uff0c\u8c03\u6574\u751f\u6548\u65e5\u671f\u4ee5\u540e\u7684\u52a0\u70b9\u6570\u5c06\u5931\u6548\u3002", (String)"ContractBaseList_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CALLBACK_OPENPERPETUAL"), new HashMap(), JSON.toJSONString(paramMap));
                } else {
                    this.showRateAdjustBatchForm(selectedId, this.getView());
                }
            } else {
                this.showRateAdjustBatchForm(selectedId, this.getView());
            }
        }
    }

    public void showRateAdjustBatchForm(Long contractId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        this.configShowParameter(showParameter, view);
        String dataSource = this.getDataSource();
        showParameter.getCustomParams().put("formid", CfmRateAdjustHelper.getFormIdFromView((IFormView)view));
        showParameter.getCustomParams().put("dataSrc", "contractBill");
        showParameter.getCustomParams().put("biztype", CfmRateAdjustHelper.getBizTypes((IFormView)view));
        showParameter.getCustomParams().put("contractId", contractId);
        showParameter.getCustomParams().put("dataSource", dataSource);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_RATE_ADJUST"));
        view.showForm(showParameter);
    }

    private void showRateAdjustForm(Object id) {
        BatchRateAdjustViewInfoEnum viewInfoEnum = BatchRateAdjustViewInfoEnum.getInfoEnumByContractFormId((String)CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(id);
        parameter.setFormId(viewInfoEnum.getParentFormId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showRateAdjustListForm(DynamicObjectCollection contractBills) {
        ListShowParameter listShowParameter = new ListShowParameter();
        BatchRateAdjustViewInfoEnum viewInfoEnum = BatchRateAdjustViewInfoEnum.getInfoEnumByContractFormId((String)CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
        listShowParameter.setBillFormId(viewInfoEnum.getParentFormId());
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getCustomParams().put("contractBills", this.getContractBills(contractBills));
        listShowParameter.getPageId();
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private String getContractBills(DynamicObjectCollection contractBills) {
        return ((DynamicObject)contractBills.get(0)).getDynamicObject("fbasedataid").getString("number");
    }

    private void configShowParameter(FormShowParameter showParameter, IFormView view) {
        String formId = CfmRateAdjustHelper.getFormIdFromView((IFormView)view);
        if (StringUtils.equals((CharSequence)"cim_invest_contract", (CharSequence)formId)) {
            showParameter.setFormId("cim_rateadjust_batch");
        } else if (StringUtils.equals((CharSequence)"cfm_loancontract_bo", (CharSequence)formId)) {
            showParameter.setFormId("cfm_rateadjust_bond_batch");
        } else {
            showParameter.setFormId("ifm_rateadjust_batch");
        }
    }

    private String getDataSource() {
        BatchRateAdjustViewInfoEnum viewInfoEnum = BatchRateAdjustViewInfoEnum.getInfoEnumByContractFormId((String)CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
        return viewInfoEnum.getDataSource();
    }

    private boolean validateDate(DynamicObject contract) {
        String contractStatus = contract.getString("contractstatus");
        String loanType = contract.getString("loantype");
        if (BizTypeEnum.BOND.getValue().equals(loanType)) {
            if (!StringUtils.equals((CharSequence)contractStatus, (CharSequence)LoanContractStatusEnum.EXECUTING.getValue())) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getBondContractStatusError());
                return false;
            }
            if (EmptyUtil.isEmpty((String)contract.getString("enddate"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getBondContractEndDateError());
                return false;
            }
        }
        return true;
    }
}

