/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractDrawLoanApplyEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        TextEdit applynoEdit = (TextEdit)this.getControl("lenderapplyno");
        if (applynoEdit != null) {
            applynoEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lenderapplyno": {
                DynamicObject org = null;
                String orgProp = "org";
                if ("cim_invest_contract".equals(this.getModel().getDataEntityType().getName())) {
                    orgProp = "creditorg";
                }
                if (!EmptyUtil.isEmpty((DynamicObject)(org = this.getModel().getDataEntity().getDynamicObject(orgProp)))) break;
                evt.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s", (String)"ContractDrawLoanApplyEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)orgProp)));
                break;
            }
        }
    }

    private void initProperty() {
        if ("fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName())) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate", "synccreditlimit", "fixedrepayamount"});
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "lenderapplyno": {
                    this.drawLoanApplyBill();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("lenderapplyno".equals(key) && EmptyUtil.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
            DynamicObjectCollection lkEntry = this.getModel().getEntryEntity("billhead_lk");
            Long applyId = (Long)this.getModel().getValue("sourcebillid");
            if (EmptyUtil.isEmpty((Long)applyId)) {
                return;
            }
            int rowIdx = -1;
            for (int i = 0; i < lkEntry.size(); ++i) {
                DynamicObject lk = (DynamicObject)lkEntry.get(i);
                Long sbillId = lk.getLong("billhead_lk_sbillid");
                if (!applyId.equals(sbillId)) continue;
                rowIdx = i;
                break;
            }
            if (rowIdx > -1) {
                this.getModel().deleteEntryRow("billhead_lk", rowIdx);
            }
            this.getModel().setValue("loanapply", null);
            this.getModel().setValue("sourcebillid", (Object)0L);
            this.getModel().deleteEntryData("tradefin_entry");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"lenderapplyno", (CharSequence)actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (EmptyUtil.isEmpty((Collection)rows)) {
                return;
            }
            Object[] selectIds = rows.getPrimaryKeyValues();
            if (selectIds.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ContractDrawLoanApplyEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            String sourceEntity = CfmEntityEnum.LOAN_APPLY.getValue();
            if ("fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName())) {
                sourceEntity = CfmEntityEnum.FL_FINANCELEASE_APPLY.getValue();
            }
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)sourceEntity, (Long[])new Long[]{(Long)selectIds[0]});
            Object currObjId = this.getModel().getDataEntity().getPkValue();
            if (!EmptyUtil.isEmpty((Object)targetBills) && targetBills.size() > 0) {
                HashSet ids = new HashSet(1);
                if (EmptyUtil.isNoEmpty(targetBills.get("cfm_loancontractbill"))) {
                    ids.addAll((Collection)targetBills.get("cfm_loancontractbill"));
                }
                if (EmptyUtil.isNoEmpty(targetBills.get("cim_invest_contract"))) {
                    ids.addAll((Collection)targetBills.get("cim_invest_contract"));
                }
                if (EmptyUtil.isNoEmpty(targetBills.get("fl_leasecontractbill"))) {
                    ids.addAll((Collection)targetBills.get("fl_leasecontractbill"));
                }
                if (EmptyUtil.isNoEmpty(ids)) {
                    ids.remove(currObjId);
                }
                DynamicObject mianOrgDy = (DynamicObject)this.getModel().getValue("org");
                String dataSource = (String)this.getModel().getValue("datasource");
                boolean isAllowManyPush = false;
                if (DataSourceEnum.isCfm((String)dataSource) && EmptyUtil.isNoEmpty((DynamicObject)mianOrgDy)) {
                    isAllowManyPush = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)mianOrgDy.getLong("id"), (String)"cfm010");
                }
                if (!isAllowManyPush && EmptyUtil.isNoEmpty(ids)) {
                    String resource = ResManager.loadKDString((String)"\u6240\u9009\u878d\u8d44\u501f\u6b3e\u7533\u8bf7%s\u5df2\u7ecf\u6709\u4e0b\u6e38\u5408\u540c\u4e86\u3002", (String)"ContractDrawLoanApplyEdit_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
                    if ("fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName())) {
                        resource = ResManager.loadKDString((String)"\u6240\u9009\u878d\u8d44\u79df\u8d41\u7533\u8bf7%s\u5df2\u7ecf\u6709\u4e0b\u6e38\u5408\u540c\u4e86", (String)"ContractDrawLoanApplyEdit_03", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
                    }
                    throw new KDBizException(String.format(resource, rows.get(0).getBillNo()));
                }
            }
            this.getModel().deleteEntryData("banksyndicate_entry");
            this.getView().getPageCache().put("isDeleteEntry", "false");
            this.initProperty();
            TmcBotpHelper.doDraw((IFormView)this.getView(), (String)sourceEntity, (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
            if (LoanTypeEnum.BANKSLOAN.getValue().equals(this.getModel().getValue("loantype"))) {
                this.getModel().createNewEntryRow("banksyndicate_entry");
                this.getModel().setValue("e_bankrole", (Object)"MB");
                this.getModel().setValue("e_bank", this.getModel().getValue("creditor"));
                int index = this.getModel().getEntryRowCount("banksyndicate_entry") - 1;
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"e_bankrole", "e_bank"});
            }
            if (LoanTypeEnum.FINLEASE.getValue().equals(this.getModel().getValue("loantype"))) {
                DynamicObject credit = (DynamicObject)this.getModel().getValue("creditlimit");
                if (EmptyUtil.isNoEmpty((DynamicObject)credit)) {
                    this.getModel().setValue("creditcurrency", credit.getDynamicObject("currency").getPkValue());
                }
                this.getModel().setValue("synccreditlimit", null);
            }
        }
    }

    private void drawLoanApplyBill() {
        DynamicObject org;
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "lenderapplyno");
        QFilter qFilter = null;
        boolean mainOrgPerm = true;
        if ("cim_invest_contract".equals(this.getModel().getDataEntityType().getName())) {
            org = this.getModel().getDataEntity().getDynamicObject("creditorg");
            qFilter = new QFilter("creditor", "=", org.getPkValue());
            mainOrgPerm = false;
        } else {
            org = this.getModel().getDataEntity().getDynamicObject("org");
            qFilter = new QFilter("company", "=", org.getPkValue());
            QFilter bizTypeFilter = this.getBizTypeFilter();
            if (bizTypeFilter != null) {
                qFilter.and(bizTypeFilter);
            }
        }
        String sourceEntity = CfmEntityEnum.LOAN_APPLY.getValue();
        if ("fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName())) {
            sourceEntity = CfmEntityEnum.FL_FINANCELEASE_APPLY.getValue();
        }
        TmcBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)sourceEntity, (String)sourceEntity, (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilter, (CloseCallBack)closeCallBack, (boolean)mainOrgPerm);
    }

    private QFilter getBizTypeFilter() {
        String biztype = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.LOAN.getValue().equals(biztype) || BizTypeEnum.SL.getValue().equals(biztype)) {
            return new QFilter("loantype", "in", (Object)new String[]{BizTypeEnum.LOAN.getValue(), BizTypeEnum.SL.getValue()});
        }
        if (BizTypeEnum.ENTRUST.getValue().equals(biztype) || BizTypeEnum.EC.getValue().equals(biztype)) {
            return new QFilter("loantype", "in", (Object)new String[]{BizTypeEnum.ENTRUST.getValue(), BizTypeEnum.EC.getValue()});
        }
        if (BizTypeEnum.FINLEASE.getValue().equals(biztype)) {
            return new QFilter("loantype", "=", (Object)BizTypeEnum.FINLEASE.getValue());
        }
        return new QFilter("1", "=", (Object)2);
    }
}

