/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractDrawPlanImportPlugin
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(ContractDrawPlanImportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "drawplanentryimport": {
                this.showForm();
            }
        }
    }

    private void showForm() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("cfm_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("BillFormId", this.getModel().getDataEntityType().getName());
        params.put("BillEntryId", "drawdownplan_entry");
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_entryimport"));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("cfm_entryimport".equals(e.getActionId())) {
            Map data = (Map)e.getReturnData();
            if (data == null) {
                return;
            }
            this.entryImportDataHandler(data);
        }
    }

    private void entryImportDataHandler(Map<String, Object> importReturnData) {
        Object imptMethod = importReturnData.get("imptmethod");
        if ("cover".equals(imptMethod)) {
            this.getModel().deleteEntryData("drawdownplan_entry");
        } else if ("append".equals(imptMethod)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("drawdownplan_entry");
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                if (!EmptyUtil.isEmpty((Object)entry.get("e_plandrawdate")) && !EmptyUtil.isEmpty((Object)entry.get("e_plandrawamt"))) continue;
                this.getModel().deleteEntryRow("drawdownplan_entry", i);
                this.getView().updateView("drawdownplan_entry");
            }
        }
        List rowDatas = (List)importReturnData.get("rowDatas");
        Set billnos = rowDatas.stream().map(o -> (String)o.get("billno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7f16\u53f7\u5b58\u5728\u591a\u4e2a,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ContractDrawPlanImportPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() == 1 && !billnos.toArray()[0].equals(this.getModel().getValue("billno"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u7684\u5355\u636e\u7f16\u53f7\u4e0e\u5f53\u524d\u5355\u636e\u7f16\u53f7\u4e0d\u4e00\u81f4,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ContractDrawPlanImportPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dealImportData("drawdownplan_entry", rowDatas);
        this.getModel().endInit();
        this.getView().updateView("drawdownplan_entry");
    }

    private void dealImportData(String entryProp, List<Map<String, String>> rowDatas) {
        StringBuilder errorInfo = new StringBuilder();
        this.getModel().beginInit();
        String dataSource = (String)this.getModel().getValue("datasource");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        block8: for (Map<String, String> row : rowDatas) {
            String tips;
            int rowIndex = this.getModel().createNewEntryRow(entryProp);
            try {
                for (Map.Entry<String, String> r : row.entrySet()) {
                    String tips2;
                    String key = r.getKey();
                    String value = r.getValue();
                    IDataEntityProperty property = this.getModel().getProperty(key);
                    if ("e_plandrawdate".equals(key)) {
                        try {
                            if (EmptyUtil.isEmpty((String)value)) {
                                throw new KDBizException(bizResource.getPlanDrawDateNull());
                            }
                            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = sf.parse(value);
                            this.getModel().setValue(key, (Object)date, rowIndex);
                        }
                        catch (KDBizException bizExp) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            tips2 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"ContractDrawPlanImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                            errorInfo.append(tips2).append("\n");
                            continue block8;
                        }
                        catch (Exception e) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            String importTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5, \u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"ContractDrawPlanImportPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(importTip).append("\n");
                            continue block8;
                        }
                    }
                    if ("e_plandrawamt".equals(key)) {
                        try {
                            if (EmptyUtil.isEmpty((String)value)) {
                                throw new KDBizException(bizResource.getPlanDrawAmountNull());
                            }
                            BigDecimal amount = new BigDecimal(value);
                            if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                                throw new KDBizException(bizResource.getPlanDrawAmountNull());
                            }
                            if (amount.compareTo(new BigDecimal("999999999.99")) > 0) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u503c\u4e0d\u80fd\u5927\u4e8e999999999.99\u3002", (String)"ContractDrawPlanImportPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                            }
                            this.getModel().setValue(key, (Object)amount, rowIndex);
                        }
                        catch (Exception e) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            tips2 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"ContractDrawPlanImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                            errorInfo.append(tips2).append("\n");
                            continue block8;
                        }
                    }
                    if ("e_drawdescription".equals(key)) {
                        TextProp text = new TextProp();
                        if (property instanceof TextProp) {
                            text = (TextProp)property;
                        }
                        if (text.getMaxLenth() > 0 && EmptyUtil.isNoEmpty((String)value) && value.length() > text.getMaxLenth()) {
                            value = value.substring(0, text.getMaxLenth());
                            String maxTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"ContractDrawPlanImportPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(maxTip).append("\n");
                        }
                        this.getModel().setValue(key, (Object)value, rowIndex);
                    }
                    if (!"e_drawacctbank.bankaccountnumber".equals(key)) continue;
                    if (EmptyUtil.isEmpty((String)value)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractDrawPlanImportPlugin_7", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    }
                    QFilter[] filter = new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)value)};
                    DynamicObject account = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bankaccountnumber,name", (QFilter[])filter);
                    if (EmptyUtil.isEmpty((DynamicObject)account)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5165\u7684\u8d26\u6237\u4e0d\u5b58\u5728\u3002", (String)"ContractDrawPlanImportPlugin_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("e_drawacctbank", (Object)account, rowIndex);
                }
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"ContractDrawPlanImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"ContractDrawPlanImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + e.getMessage());
            }
        }
        if (EmptyUtil.isNoEmpty((String)errorInfo.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38, \u8bf7\u67e5\u770b\u3002", (String)"ContractDrawPlanImportPlugin_9", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }
}

