/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ContractDrawdownTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String[] drawProps = new String[]{"renewalexpiredate", "expiredate", "drawtype"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initTabListFilter();
        BillList drawbillList = (BillList)this.getControl("drawbilllistap");
        if (drawbillList != null) {
            drawbillList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private QFilter getContractQFilter() {
        Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Long)contractBillId)) {
            return new QFilter("1", "=", (Object)2);
        }
        return new QFilter("sourcebillid", "=", (Object)contractBillId);
    }

    private void initTabListFilter() {
        QFilter contractFilter = this.getContractQFilter();
        if ("ifm_loancontractbill".equals(this.getModel().getDataEntityType().getName())) {
            contractFilter.and(new QFilter("settlestatus", "in", Arrays.asList("addnew", "accept")));
        }
        if (this.getControl("drawbilllistap") != null) {
            BillList drawbilllist = (BillList)this.getControl("drawbilllistap");
            drawbilllist.addSetFilterListener(evt -> evt.getQFilters().add(contractFilter));
            drawbilllist.addBeforePackageDataListener(evt -> {
                DynamicObjectCollection pageDatas = evt.getPageData();
                for (DynamicObject rowData : pageDatas) {
                    if (!rowData.containsProperty("description")) continue;
                    rowData.set("description", (Object)this.getOverdueDate(rowData));
                }
            });
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        CharSequence[] selectProps = drawProps;
        Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProps), (QFilter[])new QFilter[]{contractFilter, statusFilter});
        Boolean isOverdue = Boolean.FALSE;
        if (!EmptyUtil.isEmpty((Object[])loanBills)) {
            for (Object loanBill : loanBills) {
                if (this.getOverdueDate((DynamicObject)loanBill) <= 0) continue;
                isOverdue = Boolean.TRUE;
                break;
            }
        }
        this.getModel().setValue("isoverdue", (Object)isOverdue);
    }

    private int getOverdueDate(DynamicObject loanBill) {
        int overdueDate = 0;
        if (loanBill.containsProperty("drawtype") && !StringUtils.equals((CharSequence)DrawTypeEnum.CLOSEOUT.getValue(), (CharSequence)loanBill.getString("drawtype"))) {
            int diffDays;
            Date endDate = loanBill.getDate("renewalexpiredate");
            if (endDate == null) {
                endDate = loanBill.getDate("expiredate");
            }
            if ((diffDays = DateUtils.getDiffDays((Date)endDate, (Date)DateUtils.getCurrentDate())) > 1) {
                overdueDate = diffDays - 1;
            }
        }
        return overdueDate;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        BillList sourceBill = (BillList)evt.getSource();
        String entytyId = sourceBill.getEntityId();
        Object billId = sourceBill.getFocusRowPkId();
        if (StringUtils.equals((CharSequence)entytyId, (CharSequence)"fl_receiptbill") || StringUtils.equals((CharSequence)entytyId, (CharSequence)"cfm_loanbill") || StringUtils.equals((CharSequence)entytyId, (CharSequence)"cfm_loanbill_bond")) {
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
                FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()), (Object)billId);
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"payeebillno")) {
                TmcBotpHelper.showBillParamter((String)entytyId, (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_recbill");
            }
        } else if (StringUtils.equals((CharSequence)entytyId, (CharSequence)"cim_invest_loanbill")) {
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
                FormParameterHelper.showForm((IFormView)this.getView(), (String)"cim_invest_loanbill", (Object)billId);
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"paybillno")) {
                TmcBotpHelper.showBillParamter((String)"cim_invest_loanbill", (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_paybill");
            }
        } else if (StringUtils.equals((CharSequence)entytyId, (CharSequence)"ifm_loanbill")) {
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
                FormParameterHelper.showForm((IFormView)this.getView(), (String)"ifm_loanbill", (Object)billId);
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"payeebillno")) {
                TmcBotpHelper.showBillParamter((String)"cfm_loanbill", (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_recbill");
            }
        }
    }
}

