/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ContractInterestTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String interestProps = String.join((CharSequence)",", "interest_entry", "handinstplan", "currency", "interest_entry.interestseq", "interest_entry.intstartdate", "interest_entry.intenddate", "interest_entry.interesdate", "interest_entry.intway", "interest_entry.intstate", "interest_entry.interestcalamount", "interest_entry.instdescription", "interest_entry.seq");

    public void registerListener(EventObject e) {
        BillList ra_loanbillList;
        BillList interestPlanLoanBillList;
        super.registerListener(e);
        this.initControlEvt();
        this.initTabListFilter();
        BillList interestbillList = (BillList)this.getControl("interestbilllistap");
        if (interestbillList != null) {
            interestbillList.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((interestPlanLoanBillList = (BillList)this.getControl("ic_loanbilllistap")) != null) {
            interestPlanLoanBillList.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((ra_loanbillList = (BillList)this.getControl("ra_loanbilllistap")) != null) {
            ra_loanbillList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private void initControlEvt() {
        if (this.getControl("ic_loanbilllistap") != null) {
            ((BillList)this.getControl("ic_loanbilllistap")).addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent evt) {
                    ListSelectedRow row = evt.getCurrentListSelectedRow();
                    if (EmptyUtil.isEmpty((Object)row)) {
                        return;
                    }
                    boolean isChanged = ContractInterestTabEdit.this.getModel().getDataChanged();
                    ContractInterestTabEdit.this.loadInterestCalList((Long)row.getPrimaryKeyValue());
                    ContractInterestTabEdit.this.getModel().setDataChanged(isChanged);
                }
            });
        }
        ((Tab)this.getControl("tab_contractinfo")).addTabSelectListener(evt -> {
            BillList icLoanList;
            String tabKey = evt.getTabKey();
            if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"interestcaltab") && EmptyUtil.isEmpty((Collection)(icLoanList = (BillList)this.getControl("ic_loanbilllistap")).getSelectedRows())) {
                icLoanList.selectRows(0);
            }
        });
    }

    private QFilter getContractQFilter() {
        Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Long)contractBillId)) {
            return new QFilter("1", "=", (Object)2);
        }
        return new QFilter("sourcebillid", "=", (Object)contractBillId);
    }

    private void initTabListFilter() {
        if (this.getControl("interestbilllistap") != null) {
            BillList interestList = (BillList)this.getControl("interestbilllistap");
            interestList.addSetFilterListener(evt -> {
                QFilter loanBillStatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                DynamicObject[] loanBillIdDOs = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id", (QFilter[])new QFilter[]{this.getContractQFilter(), loanBillStatusFilter});
                Long[] loanBillIds = new Long[loanBillIdDOs.length];
                for (int i = 0; i < loanBillIdDOs.length; ++i) {
                    loanBillIds[i] = (Long)loanBillIdDOs[i].getPkValue();
                }
                QFilter interestFilter = new QFilter("sourcebillid", "in", (Object)loanBillIds);
                evt.getQFilters().add(interestFilter);
            });
        }
        if (this.getControl("ic_loanbilllistap") != null) {
            BillList icLoanBillList = (BillList)this.getControl("ic_loanbilllistap");
            icLoanBillList.setFilter(this.getContractQFilter());
            icLoanBillList.addBeforePackageDataListener(evt -> {
                DynamicObjectCollection pageDatas = evt.getPageData();
                for (DynamicObject rowData : pageDatas) {
                    if (rowData.getDate("renewalexpiredate") == null) continue;
                    rowData.set("expiredate", (Object)rowData.getDate("renewalexpiredate"));
                }
            });
        }
    }

    private void loadInterestCalList(Long loanBillId) {
        if (this.getControl("ic_interestcal") != null) {
            this.getModel().deleteEntryData("ic_interestcal");
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)interestProps);
            DynamicObjectCollection interestCals = loanBill.getDynamicObjectCollection("interest_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestCals)) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("icl_intway", new Object[0]).addField("icl_seq", new Object[0]).addField("icl_intstartdate", new Object[0]).addField("icl_intenddate", new Object[0]).addField("icl_caldate", new Object[0]).addField("icl_loancurrency", new Object[0]).addField("icl_calamount", new Object[0]).addField("icl_intstate", new Object[0]).addField("icl_instdescription", new Object[0]).addField("icl_handint", new Object[0]).addField("icl_entryid", new Object[0]).addField("icl_loanbillid", new Object[0]);
                for (DynamicObject interestCal : interestCals) {
                    if (interestCal.getInt("seq") < 0) continue;
                    vs.addRow(new Object[]{interestCal.getString("intway"), interestCal.get("interestseq"), interestCal.get("intstartdate"), interestCal.get("intenddate"), interestCal.get("interesdate"), loanBill.getDynamicObject("currency").getPkValue(), interestCal.get("interestcalamount"), interestCal.getString("intstate"), interestCal.get("instdescription"), loanBill.get("handinstplan"), interestCal.get("id"), loanBillId});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("ic_interestcal", vs);
                model.endInit();
                this.getView().updateView("ic_interestcal");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "viewinterestcal": {
                IDataModel model = this.getModel();
                DynamicObject interest_entry = (DynamicObject)model.getEntryEntity("ic_interestcal").get(model.getEntryCurrentRowIndex("ic_interestcal"));
                if (interest_entry.getBoolean("icl_handint")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u624b\u5de5\u7ef4\u62a4\u7684\u4ed8/\u6536\u606f\u8ba1\u5212,\u4e0d\u80fd\u70b9\u51fb\u67e5\u770b\u6d4b\u7b97\u8be6\u7ec6\u3002", (String)"ContractInterestTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                long loanBillId = interest_entry.getLong("icl_loanbillid");
                DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill", (String)"issofrrate");
                if (loanBill.getBoolean("issofrrate")) {
                    param.put("formId", "cfm_intcaldetailsofrcard");
                } else {
                    param.put("formId", "cfm_intcaldetailcard");
                }
                param.put("loanBillId", loanBillId);
                param.put("interestEntryId", interest_entry.getLong("icl_entryid"));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Object billId;
        String fieldName = evt.getFieldName();
        BillList sourceBill = (BillList)evt.getSource();
        String entityId = sourceBill.getEntityId();
        Object pkId = billId = sourceBill.getFocusRowPkId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"cfm_interestbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"cim_invest_interestbill")) {
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
                FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getInterestBillFormByBizType((IFormView)this.getView()), (Object)pkId);
            } else {
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"loanbillno")) {
                    DynamicObject repayBill = TmcDataServiceHelper.loadSingle((Object)billId, (String)"cfm_interestbill", (String)"sourcebillid");
                    FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()), (Object)repayBill.get("sourcebillid"));
                    return;
                }
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"payeebillno")) {
                    TmcBotpHelper.showBillParamter((String)"cfm_interestbill", (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_paybill");
                    return;
                }
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"recbillno")) {
                    TmcBotpHelper.showBillParamter((String)"cim_invest_interestbill", (Long)((Long)billId), (IFormView)this.getView(), (String)"cas_recbill");
                    return;
                }
            }
        }
        if ((StringUtils.equals((CharSequence)entityId, (CharSequence)"cfm_loanbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"ifm_loanbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"cim_invest_loanbill") || StringUtils.equals((CharSequence)entityId, (CharSequence)"cfm_loanbill_bond")) && (StringUtils.equals((CharSequence)fieldName, (CharSequence)"ic_billno") || StringUtils.equals((CharSequence)fieldName, (CharSequence)"ra_billno") || StringUtils.equals((CharSequence)fieldName, (CharSequence)"rh_billno"))) {
            FormParameterHelper.showForm((IFormView)this.getView(), (String)FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()), (Object)pkId);
        }
    }
}

