/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractTradeFinInfoEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit te = (TextEdit)this.getControl("e_tf_relatebillno");
        if (te != null) {
            te.addClickListener((ClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "e_tf_relationtype": {
                this.relationTypeChgEvt(e);
                break;
            }
            case "e_tf_relatebillno": {
                this.relateBillNoChgEvt(e);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_tf_relatebillno": {
                this.showTradefinRelateBillF7();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        DynamicObject loanApplyF7 = (DynamicObject)this.getModel().getValue("loanapply");
        if (EmptyUtil.isNoEmpty((DynamicObject)loanApplyF7) && EmptyUtil.isNoEmpty((String)billStatus) && BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            DynamicObjectCollection tradefins = this.getModel().getEntryEntity("tradefin_entry");
            EntryGrid control = (EntryGrid)this.getControl("tradefin_entry");
            ArrayList<Integer> needLockRows = new ArrayList<Integer>(10);
            for (int i = 0; i < tradefins.size(); ++i) {
                boolean isNeedLock = this.isNeedLockEntry((DynamicObject)tradefins.get(i));
                if (!isNeedLock) continue;
                needLockRows.add(i);
            }
            if (EmptyUtil.isNoEmpty(needLockRows)) {
                control.setRowLock(true, needLockRows.stream().mapToInt(Integer::intValue).toArray());
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field = e.getKey();
        int rowIndex = e.getRowIndex();
        switch (field) {
            case "e_tf_relatebillno": {
                DynamicObject row = this.getModel().getEntryRowEntity("tradefin_entry", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)row)) {
                    return;
                }
                String relationType = row.getString("e_tf_relationtype");
                if (!RelationTypeEnum.IL.getValue().equals(relationType) && !RelationTypeEnum.EL.getValue().equals(relationType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u70b9\u51fb\u6309\u94ae\u6765\u9009\u62e9\u5355\u636e\u3002", (String)"BusinessInfoTabEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(field, rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject tradefins;
        boolean isNeedLock;
        int entryRowCount;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("tradefindeleteentry".equalsIgnoreCase(op.getOperateKey()) && (entryRowCount = this.getModel().getEntryCurrentRowIndex("tradefin_entry")) > -1 && (isNeedLock = this.isNeedLockEntry(tradefins = this.getModel().getEntryRowEntity("tradefin_entry", entryRowCount)))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%d\u3011\u884c\u6765\u6e90\u4e3a\u4fe1\u7528\u8bc1\u5355\u636e\u878d\u8d44,\u4e0d\u80fd\u5220\u9664\u3002", (String)"ContractTradeFinInfoEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), entryRowCount + 1));
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if (("relatebillno_lc_arrival".equals(e.getActionId()) || "relatebillno_lc_present".equals(e.getActionId())) && !EmptyUtil.isEmpty((Object)(returnData = e.getReturnData()))) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            int curIndex = this.getModel().getEntryCurrentRowIndex("tradefin_entry");
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            String billType = "relatebillno_lc_arrival".equals(e.getActionId()) ? "lc_arrival" : "lc_present";
            this.setTradeFinInfo(curIndex, primaryKeyValues, billType);
        }
    }

    private boolean isNeedLockEntry(DynamicObject tradefin) {
        String relationType = tradefin.getString("e_tf_relationtype");
        String relatebillNo = tradefin.getString("e_tf_relatebillno");
        if (EmptyUtil.isEmpty((String)relationType) || EmptyUtil.isEmpty((String)relatebillNo)) {
            return false;
        }
        DynamicObject loanApplyF7 = (DynamicObject)this.getModel().getValue("loanapply");
        if (EmptyUtil.isEmpty((DynamicObject)loanApplyF7)) {
            return false;
        }
        String sourceBillType = loanApplyF7.getString("sourcebilltype");
        long sourceBillId = loanApplyF7.getLong("sourcebillid");
        List<String> lcSourceTypes = Arrays.asList("lc_arrival", "lc_present");
        return lcSourceTypes.contains(sourceBillType) && sourceBillId > 0L;
    }

    private void setTradeFinInfo(int curIndex, Object[] primaryKeyValues, String billType) {
        Object[] lcBills = TmcDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billType));
        if (EmptyUtil.isEmpty((Object[])lcBills)) {
            return;
        }
        Object lcBill = lcBills[0];
        String letter = "lc_arrival".equals(billType) ? lcBill.getDynamicObject("org").getString("name") : lcBill.getString("benefiterother");
        String beneficiaryer = "lc_present".equals(billType) ? lcBill.getDynamicObject("org").getString("name") : lcBill.getString("benefiterother");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_tf_relatebillno", (Object)lcBill.getString("billno"), (int)curIndex);
        this.getModel().setValue("e_tf_letter", (Object)letter, curIndex);
        this.getModel().setValue("e_tf_beneficiary", (Object)beneficiaryer, curIndex);
        this.getModel().setValue("e_tf_expiredate", (Object)lcBill.getDate("endpaydate"), curIndex);
        this.getModel().setValue("e_tf_unpaidamount", (Object)lcBill.getBigDecimal("todoamount"), curIndex);
        this.getModel().setValue("e_tf_description", null, curIndex);
        this.getModel().setValue("e_tf_currency", (Object)lcBill.getDynamicObject("arrivalcurrency"), curIndex);
        this.getModel().setValue("e_tf_relatebillid", lcBill.getPkValue(), curIndex);
    }

    private void showTradefinRelateBillF7() {
        DynamicObject org;
        CloseCallBack closeCallBack;
        ListShowParameter lsp;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("tradefin_entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("tradefin_entry", rowIndex);
        String relationType = entry.getString("e_tf_relationtype");
        String orgPropName = this.getModel().getDataEntityType().getMainOrg();
        if (RelationTypeEnum.IL.getValue().equals(relationType)) {
            lsp = ShowFormHelper.createShowListForm((String)RelationTypeEnum.IL.getEntiy(), (boolean)false, (int)2);
            closeCallBack = new CloseCallBack((IFormPlugin)this, "relatebillno_lc_arrival");
            lsp.setCloseCallBack(closeCallBack);
            org = (DynamicObject)this.getModel().getValue(orgPropName);
            lsp.getListFilterParameter().getQFilters().add(CfmContractBillHelper.getLcArrivalQfilter((DynamicObject)org));
            this.getView().showForm((FormShowParameter)lsp);
        }
        if (RelationTypeEnum.EL.getValue().equals(relationType)) {
            lsp = ShowFormHelper.createShowListForm((String)RelationTypeEnum.EL.getEntiy(), (boolean)false, (int)2);
            closeCallBack = new CloseCallBack((IFormPlugin)this, "relatebillno_lc_present");
            lsp.setCloseCallBack(closeCallBack);
            org = (DynamicObject)this.getModel().getValue(orgPropName);
            lsp.getListFilterParameter().getQFilters().add(CfmContractBillHelper.getLcPresentQfilter((DynamicObject)org));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void relateBillNoChgEvt(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        int curIndex = changeData[0].getRowIndex();
        this.clearEntryValue(curIndex, "e_tf_beneficiary", "e_tf_letter", "e_tf_expiredate", "e_tf_unpaidamount", "e_tf_description", "e_tf_currency", "e_tf_relatebillid");
    }

    private void relationTypeChgEvt(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        int curIndex = changeData[0].getRowIndex();
        this.clearEntryValue(curIndex, "e_tf_relatebillno", "e_tf_beneficiary", "e_tf_expiredate", "e_tf_unpaidamount", "e_tf_letter", "e_tf_description", "e_tf_currency", "e_tf_relatebillid");
    }

    private void clearEntryValue(int row, String ... fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null, row);
        }
    }
}

