/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;

public class ContractUnderwriterEdit
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"e_underwritertype", "e_underwriter", "e_underwriteratio", "e_underwriteamount"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if ("underwriter_entry".equals(entryProp.getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            if (rowIndex == 0) {
                this.getModel().setValue("e_underwritertype", (Object)"lead", rowIndex);
                this.getModel().setValue("e_isbookrunner", (Object)true, rowIndex);
            } else {
                this.getModel().setValue("e_underwritertype", (Object)"joint", rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "e_underwriteratio": 
            case "e_underwriteamount": 
            case "e_isbookrunner": {
                this.underwriteChgEvt(e);
                break;
            }
            case "amount": {
                this.amountChgEvt();
                break;
            }
            case "guarantee": {
                this.guaranteePropChange(e);
                break;
            }
        }
    }

    private void guaranteePropChange(PropertyChangedArgs e) {
        Object oldValue;
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (GuaranteeWayEnum.isAllNumValueSelect((String)((String)newValue), (String)((String)(oldValue = e.getChangeSet()[0].getOldValue())))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guarantee", (Object)GuaranteeWayEnum.genAllGuaranteeWayNumValues());
        }
    }

    private void amountChgEvt() {
        int row = this.getModel().getEntryRowCount("underwriter_entry");
        this.getModel().beginInit();
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("amount");
        for (int rowIndex = 0; rowIndex < row; ++rowIndex) {
            BigDecimal ratio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
            this.getModel().setValue("e_underwriteamount", (Object)ratio.multiply(totalAmt).divide(BigDecimal.valueOf(100L)), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("underwriter_entry");
    }

    private void underwriteChgEvt(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("amount");
        block5 : switch (key) {
            case "e_underwriteratio": {
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)BigDecimal.ZERO, (int)rowIndex);
                    break;
                }
                BigDecimal underwriteAmt = totalAmt.multiply((BigDecimal)newValue).divide(BigDecimal.valueOf(100L));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)underwriteAmt, (int)rowIndex);
                break;
            }
            case "e_underwriteamount": {
                BigDecimal underwriteRatio;
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)BigDecimal.ZERO, (int)rowIndex);
                    return;
                }
                BigDecimal underWriteAmount = (BigDecimal)newValue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("underwriter_entry");
                BigDecimal sum_underWriteAmount = entryGrid.getSum("e_underwriteamount").subtract(underWriteAmount);
                if (underWriteAmount.compareTo(totalAmt.subtract(sum_underWriteAmount)) == 0) {
                    BigDecimal rowIndexRatio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
                    BigDecimal sum_underWriteRatio = entryGrid.getSum("e_underwriteratio").subtract(rowIndexRatio);
                    underwriteRatio = new BigDecimal("100").subtract(sum_underWriteRatio);
                } else {
                    underwriteRatio = underWriteAmount.divide(totalAmt, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)underwriteRatio, (int)rowIndex);
                break;
            }
            case "e_isbookrunner": {
                boolean isBookrunner = (Boolean)newValue;
                if (!isBookrunner) break;
                int rc = this.getModel().getEntryRowCount("underwriter_entry");
                for (int i = 0; i < rc; ++i) {
                    boolean _isbookrunner = (Boolean)this.getModel().getValue("e_isbookrunner", i);
                    if (!_isbookrunner || i == rowIndex) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_isbookrunner", (Object)Boolean.FALSE, (int)i);
                    break block5;
                }
                break;
            }
        }
    }
}

