/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.convert;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().getName())) {
            DynamicObject contractBillDO = extendedDataEntity.getDataEntity();
            this.setTradeFinInfo(contractBillDO);
        }
    }

    private void setTradeFinInfo(DynamicObject contractBillDO) {
        DynamicObject loanApplyF7 = contractBillDO.getDynamicObject("loanapply");
        String repaymentWay = contractBillDO.getString("repaymentway");
        if (EmptyUtil.isEmpty((String)repaymentWay)) {
            contractBillDO.set("repaymentway", (Object)RepaymentWayEnum.bqhbdqhx);
        }
        if (EmptyUtil.isEmpty((DynamicObject)loanApplyF7)) {
            return;
        }
        String sourceBillType = loanApplyF7.getString("sourcebilltype");
        long sourceBillId = loanApplyF7.getLong("sourcebillid");
        List<String> lcSourceTypes = Arrays.asList("lc_arrival", "lc_present");
        if (lcSourceTypes.contains(sourceBillType) && sourceBillId > 0L) {
            DynamicObject lcBill = TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
            String letter = "lc_arrival".equals(sourceBillType) ? lcBill.getDynamicObject("org").getString("name") : lcBill.getString("benefiterother");
            String beneficiaryer = "lc_present".equals(sourceBillType) ? lcBill.getDynamicObject("org").getString("name") : lcBill.getString("benefiterother");
            DynamicObjectCollection tradeEntry = contractBillDO.getDynamicObjectCollection("tradefin_entry");
            tradeEntry.clear();
            DynamicObject newEntry = tradeEntry.addNew();
            newEntry.set("e_tf_relationtype", (Object)("lc_arrival".equals(sourceBillType) ? RelationTypeEnum.IL.getValue() : RelationTypeEnum.EL.getValue()));
            newEntry.set("e_tf_relatebillno", (Object)lcBill.getString("billno"));
            newEntry.set("e_tf_letter", (Object)letter);
            newEntry.set("e_tf_beneficiary", (Object)beneficiaryer);
            newEntry.set("e_tf_expiredate", (Object)lcBill.getDate("endpaydate"));
            newEntry.set("e_tf_unpaidamount", (Object)lcBill.getBigDecimal("todoamount"));
            newEntry.set("e_tf_currency", (Object)lcBill.getDynamicObject("arrivalcurrency"));
            newEntry.set("e_tf_relatebillid", lcBill.getPkValue());
        }
    }
}

