/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.convert;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitMergeConvertPlugin
extends AbstractConvertPlugIn {
    private static final String CREDITORG = "t_cfm_creditlimit_org";
    private static final String CREDITTYPE = "t_cfm_creditlimit_type";

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject targetBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object srcId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((Object)srcId, (String)targetBill.getDynamicObjectType().getName());
            this.groupByCompanyType(targetBill, "entry_org", "o_totalamt", CREDITORG);
            this.groupByCompanyType(targetBill, "entry_type", "t_totalamt", CREDITTYPE);
            DynamicObjectCollection sourceBillCol = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)targetBill, (String)"sourcebillids", (DynamicObject[])new DynamicObject[]{sourceBill});
            targetBill.set("sourcebillids", (Object)sourceBillCol);
            targetBill.set("ismergenew", (Object)"1");
        }
    }

    private void groupByCompanyType(DynamicObject targetBill, String entry, String totalField, String tableName) {
        DynamicObjectCollection detailEntrys = targetBill.getDynamicObjectCollection(entry);
        long count = detailEntrys.stream().filter(o -> o.getBigDecimal(totalField).compareTo(BigDecimal.ZERO) > 0).count();
        if (EmptyUtil.isEmpty((Long)count)) {
            targetBill.getDynamicObjectCollection(entry).clear();
        }
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)((int)count));
        int i = 0;
        Long entryId = 0L;
        for (DynamicObject detailEntry : detailEntrys) {
            BigDecimal totalAmt = detailEntry.getBigDecimal(totalField);
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0 && i < ids.length) {
                entryId = ids[i];
                detailEntry.set("id", (Object)entryId);
                ++i;
                continue;
            }
            detailEntry.set("pid", (Object)entryId);
        }
    }
}

