/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.drawapply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DrawApplyBillEdit
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(DrawApplyBillEdit.class);
    private static final String DRAW_CLOSECALLBACK = "draw_closecallback";
    private static final String FIELDS_CONTRACTBILL = "id, org, currency, amount, notdrawamount, drawdownplan_entry, drawdownplan_entry.e_plandrawdate, drawdownplan_entry.e_plandrawamt,  drawdownplan_entry.e_drawstate, drawdownplan_entry.e_drawdescription, drawdownplan_entry.e_drawacctbank, drawdownplan_entry.e_drawmodifier, drawdownplan_entry.e_drawmodifytime";
    private static final String COLOR = "#fcf0c7";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadDrawPlans(this.queryDrawPlans());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("loancontractbill"))) break;
                this.getView().showErrorNotification(CfmFormResourceEnum.DrawApplyBillEdit_1.loadKDString());
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "loandraw": {
                this.loanDrawOp();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        if (DRAW_CLOSECALLBACK.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            this.drawCloseCallback(selectedRows.get(0));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("predrawdate".equals(key)) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loancontractbill"))) {
                this.getView().showErrorNotification(CfmFormResourceEnum.DrawApplyBillEdit_1.loadKDString());
                e.setCancel(true);
                return;
            }
            this.preDrawDateBeforePost(e, value);
        }
    }

    private void loanDrawOp() {
        QFilter comFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("contractstatus", "in", Arrays.asList(LoanContractStatusEnum.REGISTERED.getValue(), LoanContractStatusEnum.EXECUTING.getValue())).and("loantype", "not in", Arrays.asList(BizTypeEnum.BOND.getValue(), BizTypeEnum.FINLEASE.getValue())).and("notdrawamount", ">", (Object)0);
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cfm_loancontractbill", (String)"47150e89000000ac");
        QFilter permQfilter = new QFilter("org.id", "in", (Object)comIdList);
        comFilter.and(permQfilter);
        QFilter ingApplyFilter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue())).and(permQfilter);
        DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"id, loancontractbill", (QFilter[])ingApplyFilter.toArray());
        Set<Long> contractIdSet = this.getContractIds(permQfilter);
        for (DynamicObject drawApplyBill : drawApplyBills) {
            contractIdSet.add(drawApplyBill.getLong("loancontractbill"));
        }
        if (EmptyUtil.isNoEmpty(contractIdSet)) {
            comFilter.and("id", "not in", contractIdSet);
        }
        this.showBillF7(comFilter);
    }

    private Set<Long> getContractIds(QFilter permQfilter) {
        DynamicObjectCollection loadBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id, confirmstatus, currency, contractcny, loancontractbill", (QFilter[])permQfilter.toArray());
        HashSet<Long> ids = new HashSet<Long>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loadBills)) {
            return ids;
        }
        for (DynamicObject loanBill : loadBills) {
            if (loanBill.getLong("currency") == loanBill.getLong("contractcny") && ConfirmStatusEnum.isYetconfirm((String)loanBill.getString("confirmstatus"))) continue;
            ids.add(loanBill.getLong("loancontractbill"));
        }
        return ids;
    }

    private void showBillF7(QFilter filter) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"cfm_loancontractbill", (boolean)false, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.getListFilterParameter().getQFilters().add(filter);
        logger.info("show cfm_loancontractbill filter: " + lsp.getListFilterParameter().getQFilters());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DRAW_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void drawCloseCallback(ListSelectedRow listSelectedRow) {
        DynamicObject contractBill = TmcDataServiceHelper.loadSingleFromCache((Object)listSelectedRow.getPrimaryKeyValue(), (String)"cfm_loancontractbill", (String)FIELDS_CONTRACTBILL);
        this.getModel().setValue("loancontractbill", contractBill.getPkValue());
        this.getModel().setValue("org", contractBill.getDynamicObject("org").getPkValue());
        this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        this.getModel().setValue("amount", (Object)contractBill.getBigDecimal("amount"));
        this.getModel().setValue("notdrawamount", (Object)contractBill.getBigDecimal("notdrawamount"));
        this.getModel().setValue("predrawdate", (Object)new Date());
        this.getModel().setValue("predrawamount", (Object)BigDecimal.ZERO);
        this.getView().setEnable(Boolean.TRUE, new String[]{"predrawdate", "predrawamount"});
        this.getModel().deleteEntryData("drawplan");
        DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((DynamicObjectCollection)drawPlans)), new String[]{"drawplan"});
        Optional<DynamicObject> firstPlan = drawPlans.stream().filter(v -> "0".equals(v.getString("e_drawstate"))).findFirst();
        if (firstPlan.isPresent()) {
            DynamicObject plan = firstPlan.get();
            this.getModel().setValue("predrawdate", (Object)plan.getDate("e_plandrawdate"));
            this.getModel().setValue("predrawamount", (Object)plan.getBigDecimal("e_plandrawamt"));
        }
        this.loadDrawPlans(drawPlans);
    }

    private void loadDrawPlans(DynamicObjectCollection drawPlans) {
        if (null == drawPlans) {
            return;
        }
        Date preDrawDate = (Date)this.getModel().getValue("predrawdate");
        BigDecimal preDrawAmount = (BigDecimal)this.getModel().getValue("predrawamount");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("drawplan");
        boolean isSetColor = Boolean.FALSE;
        for (DynamicObject drawPlan : drawPlans) {
            int rowIndex = this.getModel().createNewEntryRow("drawplan");
            this.getModel().setValue("e_plandrawdate", (Object)drawPlan.getDate("e_plandrawdate"), rowIndex);
            this.getModel().setValue("e_plandrawamt", (Object)drawPlan.getBigDecimal("e_plandrawamt"), rowIndex);
            this.getModel().setValue("e_drawstate", (Object)drawPlan.getString("e_drawstate"), rowIndex);
            this.getModel().setValue("e_drawdescription", (Object)drawPlan.getString("e_drawdescription"), rowIndex);
            this.getModel().setValue("e_drawacctbank", drawPlan.get("e_drawacctbank"), rowIndex);
            this.getModel().setValue("e_drawmodifier", drawPlan.get("e_drawmodifier"), rowIndex);
            this.getModel().setValue("e_drawmodifytime", (Object)drawPlan.getDate("e_drawmodifytime"), rowIndex);
            if (isSetColor || !EmptyUtil.isNoEmpty((Object)preDrawDate) || preDrawDate.compareTo(drawPlan.getDate("e_plandrawdate")) != 0 || !EmptyUtil.isNoEmpty((BigDecimal)preDrawAmount) || preDrawAmount.compareTo(drawPlan.getBigDecimal("e_plandrawamt")) != 0) continue;
            entryGrid.setRowBackcolor(COLOR, new int[]{rowIndex});
            isSetColor = Boolean.TRUE;
        }
        this.getView().updateView("drawplan");
    }

    private DynamicObjectCollection queryDrawPlans() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (null == contractBill) {
            return null;
        }
        contractBill = TmcDataServiceHelper.loadSingleFromCache((Object)contractBill.getPkValue(), (String)"cfm_loancontractbill", (String)FIELDS_CONTRACTBILL);
        DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        return drawPlans;
    }

    private void preDrawDateBeforePost(BeforeFieldPostBackEvent e, Object value) {
        String fmtStr = ((DateEdit)this.getControl("predrawdate")).getFormatString();
        Date preDrawDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        Date contractStartDate = contractBill.getDate("startdate");
        Date contractEndDate = contractBill.getDate("enddate");
        Date renewalExpiredate = contractBill.getDate("renewalexpiredate");
        if (EmptyUtil.isNoEmpty((Object)renewalExpiredate)) {
            contractEndDate = renewalExpiredate;
        }
        String drawDatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"predrawdate");
        if (EmptyUtil.isNoEmpty((Object)preDrawDate) && preDrawDate.before(contractStartDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_1.loadKDString(drawDatePropName, DateUtils.formatString((Date)contractStartDate, (String)"yyyy-MM-dd")));
            this.getView().updateView("predrawdate");
        }
        if (EmptyUtil.isNoEmpty((Object)contractEndDate) && preDrawDate.after(contractEndDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(CfmFormResourceEnum.DrawPlanModifyPlugin_2.loadKDString(drawDatePropName, DateUtils.formatString((Date)contractEndDate, (String)"yyyy-MM-dd")));
            this.getView().updateView("predrawdate");
        }
    }
}

