/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.extendbill;

import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ExtendBillDrawContractEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        TextEdit contractEdit = (TextEdit)this.getControl("contractbillno");
        if (contractEdit != null) {
            contractEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "contractbillno": {
                    this.drawContractBill();
                    break;
                }
            }
        }
    }

    private void drawContractBill() {
        QFilter filter = this.getQFilter();
        filter.and("isnofixedterm", "=", (Object)"0");
        String targetEntityNumber = this.getModel().getDataEntityType().getName();
        if ("ifm_contractextendbill".equals(targetEntityNumber)) {
            filter.and("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue());
        } else {
            filter.and(this.getBizTypeFilter());
        }
        TmcBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)this.getSrcContractEntityNumber(), (String)targetEntityNumber, (Boolean)false, (QFilter)filter, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "contractbillno"));
    }

    private QFilter getQFilter() {
        QFilter filter = new QFilter("contractstatus", "in", (Object)new String[]{LoanContractStatusEnum.EXECUTING.getValue(), LoanContractStatusEnum.REGISTERED.getValue()});
        if ("cfm_contractextend_bo".equals(this.getView().getEntityId())) {
            filter = new QFilter("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue());
            filter.and("enddate", "!=", null);
        }
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"contractbillno", (CharSequence)actionId) && this.checkSelectRowExtendStatus(rows = (ListSelectedRowCollection)e.getReturnData()).booleanValue()) {
            TmcBotpHelper.doDraw((IFormView)this.getView(), (String)this.getSrcContractEntityNumber(), (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
        }
    }

    private QFilter getBizTypeFilter() {
        Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        String loantype = (String)this.getModel().getValue("loantype");
        if (EmptyUtil.isNoEmpty((String)loantype)) {
            if (BizTypeEnum.LOAN.getValue().equals(loantype) || BizTypeEnum.SL.getValue().equals(loantype)) {
                biztypes.add(BizTypeEnum.LOAN.getValue());
                biztypes.add(BizTypeEnum.SL.getValue());
            }
            if (BizTypeEnum.EC.getValue().equals(loantype) || BizTypeEnum.ENTRUST.getValue().equals(loantype)) {
                biztypes.add(BizTypeEnum.EC.getValue());
                biztypes.add(BizTypeEnum.ENTRUST.getValue());
            }
        }
        return new QFilter("loantype", "in", (Object)biztypes);
    }

    private Boolean checkSelectRowExtendStatus(ListSelectedRowCollection rows) {
        if (!EmptyUtil.isEmpty((Collection)rows)) {
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue(), (String)"cfm_loancontractbill");
            Pair result = ExtendHelper.isExtendAllowed((DynamicObject)contractBill);
            if (!((Boolean)result.getLeft()).booleanValue()) {
                this.getView().showTipNotification((String)result.getRight());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getSrcContractEntityNumber() {
        if ("cim_invest_extendbill".equals(this.getModel().getDataEntityType().getName())) {
            return "cim_invest_contract";
        }
        if ("ifm_contractextendbill".equals(this.getModel().getDataEntityType().getName())) {
            return "ifm_loancontractbill";
        }
        if ("cfm_contractextend_bo".equals(this.getModel().getDataEntityType().getName())) {
            return "cfm_loancontract_bo";
        }
        return "cfm_loancontractbill";
    }
}

