/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.RepayDateRangesEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.bean.ModelRequestBean;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DebtServiceWarnPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DebtServiceWarnPlugin.class);
    private static final String SELECT_FIELD = "org,currency,loantype,amount,case when account is null or account=0 then accountbank else account end account";
    private static final String SELECT_REPAY_FIELD = "org,accountbank,lastrepaydate,currency,loantype,repayplan_entry.exrepaymentdate date,repayplan_entry.enotrepayamount amount,repayplan_entry.repayaccount account";
    private static final String SELECT_INTERES_FIELD = "org,accountbank,lastrepaydate,currency,loantype,interest_entry.interesdate date,interest_entry.interestcalamount amount,interest_entry.intaccount account";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh_btn"});
        BasedataEdit companyF7 = (BasedataEdit)this.getControl("company");
        companyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean hasPermision;
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = RequestContext.get().getOrgId();
        String entityName = "cfm_loanbill";
        if ("bdim".equals(appId)) {
            entityName = "cfm_loanbill_bond";
        }
        if ((hasPermision = TmcOrgDataHelper.hasPermission((String)appId, (long)RequestContext.get().getCurrUserId(), (long)orgId, (String)entityName, (String)"47150e89000000ac")) && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"08")) {
            this.getModel().setValue("company", (Object)new Object[]{orgId});
            this.loanData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName;
        switch (propName = event.getProperty().getName()) {
            case "company": {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                Long userPK = RequestContext.get().getCurrUserId();
                String appId = this.getView().getFormShowParameter().getAppId();
                String entityName = "cfm_loanbill";
                if ("bond".equals(appId)) {
                    entityName = "cfm_loanbill_bond";
                }
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)entityName, (String)"47150e89000000ac");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIdSet));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "company": {
                Object company = this.getModel().getValue("company");
                if (company == null) break;
                this.loanData();
                break;
            }
            case "repaydateranges": {
                String repaydateranges = (String)this.getModel().getValue("repaydateranges");
                if (!"customrange".equals(repaydateranges) && !"customday".equals(repaydateranges)) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"day"});
                    this.loanData();
                    break;
                }
                if ("customrange".equals(repaydateranges)) {
                    this.getModel().deleteEntryData("entryentity");
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"day"});
                    break;
                }
                if (!"customday".equals(repaydateranges)) break;
                this.getModel().deleteEntryData("entryentity");
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"day"});
                break;
            }
            case "custrepaydate_enddate": {
                Date custrepaydate = (Date)this.getModel().getValue("custrepaydate_enddate");
                if (custrepaydate == null) {
                    return;
                }
                this.loanData();
                break;
            }
            case "loantype": {
                String bizType = (String)this.getModel().getValue("loantype");
                if (EmptyUtil.isEmpty((String)bizType)) {
                    this.getModel().deleteEntryData("entryentity");
                    break;
                }
                this.loanData();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refresh_btn".equals(key)) {
            Integer day;
            if ("customrange".equals(this.getModel().getValue("repaydateranges"))) {
                Date endDate = (Date)this.getModel().getValue("custrepaydate_enddate");
                if (endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u586b\u3002", (String)"DebtServiceWarnPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("custrepaydate_startdate");
                if (startDate != null && startDate.after(endDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"DebtServiceWarnPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ("customday".equals(this.getModel().getValue("repaydateranges")) && ((day = (Integer)this.getModel().getValue("day")) == null || day <= 0 || day > 365)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63d0\u524d\u9884\u8b66\u5929\u6570\uff0c\u8303\u56f4\u4e3a1~365\u5929", (String)"DebtServiceWarnPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.loanData()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"DebtServiceWarnPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "opviewloanbill": {
                IDataModel model = this.getModel();
                DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                if (entryEntity.size() == 0) {
                    return;
                }
                DynamicObject entry = (DynamicObject)entryEntity.get(model.getEntryCurrentRowIndex("entryentity"));
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("isquerydefault", (Object)"no");
                String bizType = entry.getString("biztype");
                if (BizTypeEnum.FINLEASE.getValue().equals(bizType)) {
                    DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"fl_receiptbill", (String)"loancontractbill", (QFilter[])new QFilter[]{this.getQFilter(entry)});
                    Set contractIds = loanBills.stream().map(dyn -> dyn.getLong("loancontractbill")).collect(Collectors.toSet());
                    QFilter idFilter = new QFilter("id", "in", contractIds);
                    showParameter.setBillFormId("fl_leasecontractbill");
                    showParameter.getListFilterParameter().setFilter(idFilter);
                } else {
                    showParameter.setBillFormId(this.getEntryName(bizType));
                    showParameter.getListFilterParameter().getQFilters().add(this.getQFilter(entry));
                }
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private QFilter getQFilter(DynamicObject entry) {
        String bizType = entry.getString("biztype");
        Long orgId = entry.getDynamicObject("org").getLong("id");
        Long accountBankId = entry.getDynamicObject("accountbank").getLong("id");
        Long currencyId = entry.getDynamicObject("currency").getLong("id");
        Pair<Date, Date> queryDates = this.transDate();
        QFilter filter = new QFilter("loantype", "=", (Object)bizType).and(new QFilter("org", "=", (Object)orgId)).and(new QFilter("currency", "=", (Object)currencyId)).and(new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()})).and(new QFilter("accountbank", "=", (Object)accountBankId).or("repayplan_entry.repayaccount", "=", (Object)accountBankId).or("interest_entry.intaccount", "=", (Object)accountBankId));
        filter.and(this.getDateFilter((Date)queryDates.getLeft(), (Date)queryDates.getRight(), true).or(this.getDateFilter((Date)queryDates.getLeft(), (Date)queryDates.getRight(), false)));
        QFilter baseFilter = this.getBaseFilter();
        if (EmptyUtil.isNoEmpty((Object)baseFilter)) {
            filter.and(baseFilter);
        }
        return filter;
    }

    private String getEntryName(String bizType) {
        if (BizTypeEnum.BOND.getValue().equals(bizType)) {
            return "cfm_loanbill_bond";
        }
        if (BizTypeEnum.EC.getValue().equals(bizType) || BizTypeEnum.ENTRUST.getValue().equals(bizType)) {
            return "cfm_loanbill_e_l";
        }
        if (BizTypeEnum.FINLEASE.getValue().equals(bizType)) {
            return "fl_leasecontractbill";
        }
        return "cfm_loanbill_b_l";
    }

    private QFilter getBaseFilter() {
        String bizTypes = (String)this.getModel().getValue("loantype");
        if (EmptyUtil.isEmpty((String)bizTypes)) {
            return null;
        }
        Set bizType = Arrays.stream(bizTypes.split(",")).filter(o -> EmptyUtil.isNoEmpty((String)o)).collect(Collectors.toSet());
        return new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()}).and("loantype", "in", bizType);
    }

    private QFilter getDateFilter(Date startDate, Date endDate, boolean isRepay) {
        String dateField = "repayplan_entry.exrepaymentdate";
        String amountField = "repayplan_entry.enotrepayamount";
        if (!isRepay) {
            dateField = "interest_entry.interesdate";
            amountField = "interest_entry.interestcalamount";
        }
        QFilter dateFilter = new QFilter(dateField, "<=", (Object)endDate).and(amountField, ">", (Object)BigDecimal.ZERO);
        if (startDate != null) {
            dateFilter.and(dateField, ">=", (Object)startDate);
        }
        return dateFilter;
    }

    private boolean loanData() {
        ModelRequestBean runningBalanceBatch;
        IDataModel model = this.getModel();
        String dataSource = this.getView().getEntityId().startsWith("fl") ? DataSourceEnum.FL.getValue() : DataSourceEnum.CFM.getValue();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
        QFilter baseFilter = this.getBaseFilter();
        if (baseFilter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5206\u7c7b\u3002", (String)"DebtServiceWarnPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            model.deleteEntryData("entryentity");
            return false;
        }
        QFilter companyFilter = this.getOrgFilter();
        if (companyFilter == null) {
            this.getView().showTipNotification(bizResource.getOrg());
            model.deleteEntryData("entryentity");
            return false;
        }
        DataSet groupBillDs = this.getGroupBillDs(baseFilter, companyFilter);
        if (groupBillDs.isEmpty()) {
            model.deleteEntryData("entryentity");
            return true;
        }
        Map<String, BigDecimal> bankCurrencyAmt = this.getBankCurrencyAmt(groupBillDs.copy());
        model.deleteEntryData("entryentity");
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        TableValueSetter vs = this.getTableValueSetter();
        String balanceSufficient = "2";
        String balanceDeficient = "1";
        ArrayList<BizBalanceModelBean> bizBalanceModelBeanList = new ArrayList<BizBalanceModelBean>();
        HashMap<Long, String> balanceTypeMap = new HashMap<Long, String>(10);
        for (Row row : groupBillDs.copy()) {
            String balanceType;
            Long accountId = row.getLong("account");
            Long currencyId = row.getLong("currency");
            Long orgId = row.getLong("org");
            if (!balanceTypeMap.containsKey(orgId)) {
                balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
                balanceTypeMap.put(orgId, balanceType);
            }
            balanceType = (String)balanceTypeMap.get(orgId);
            BizBalanceModelBean currBalance = new BizBalanceModelBean();
            currBalance.setBalanceType(balanceType);
            currBalance.setAccountId(accountId);
            currBalance.setCurrencyId(currencyId);
            bizBalanceModelBeanList.add(currBalance);
        }
        ModelRequestBean modelRequestBean = new ModelRequestBean();
        modelRequestBean.setBizBeans(bizBalanceModelBeanList);
        try {
            runningBalanceBatch = BizBalanceModelHelper.getRunningBalanceBatch((ModelRequestBean)modelRequestBean);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        List bizBeans = runningBalanceBatch.getBizBeans();
        HashMap<String, BizBalanceModelBean> bizBeanMap = new HashMap<String, BizBalanceModelBean>(bizBeans.size());
        for (BizBalanceModelBean bizBean : bizBeans) {
            bizBeanMap.put(bizBean.getAccountId() + "-" + bizBean.getCurrencyId() + "-" + bizBean.getBalanceType(), bizBean);
        }
        for (Row row : groupBillDs.copy()) {
            Long accountId = row.getLong("account");
            Long currencyId = row.getLong("currency");
            Long orgId = row.getLong("org");
            String balanceType = (String)balanceTypeMap.get(orgId);
            BizBalanceModelBean currBalance = (BizBalanceModelBean)bizBeanMap.get(accountId + "-" + currencyId + "-" + balanceType);
            BigDecimal amount = row.getBigDecimal("amount");
            if (currBalance == null || currBalance.getAmount() == null) continue;
            vs.addRow(new Object[]{row.get("org"), row.get("loantype"), accountId, currencyId, amount, currBalance.getAmount(), currBalance.getAmount().compareTo(amount) > 0 ? "2" : "1"});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity");
        return true;
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org", new Object[0]);
        vs.addField("biztype", new Object[0]);
        vs.addField("accountbank", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("repayamt", new Object[0]);
        vs.addField("actbalance", new Object[0]);
        vs.addField("warnstatus", new Object[0]);
        return vs;
    }

    private DataSet getGroupBillDs(QFilter baseFilter, QFilter companyFilter) {
        Pair<Date, Date> queryDates = this.transDate();
        Date startDate = (Date)queryDates.getLeft();
        Date endDate = (Date)queryDates.getRight();
        DataSet repayDataBills = QueryServiceHelper.queryDataSet((String)"repayloanData", (String)"cfm_loanbill", (String)SELECT_REPAY_FIELD, (QFilter[])new QFilter[]{baseFilter, this.getDateFilter(startDate, endDate, true), companyFilter}, null);
        QFilter statusFilter = new QFilter("interest_entry.intstate", "=", (Object)"0");
        DataSet interestDataBills = QueryServiceHelper.queryDataSet((String)"interestloanData", (String)"cfm_loanbill", (String)SELECT_INTERES_FIELD, (QFilter[])new QFilter[]{baseFilter, this.getDateFilter(startDate, endDate, false), companyFilter, statusFilter}, null);
        DataSet groupBillDs = repayDataBills.union(interestDataBills).select(SELECT_FIELD).filter("account is not null").groupBy(new String[]{"org", "account", "currency", "loantype"}).sum("amount").finish();
        return groupBillDs;
    }

    private Map<String, BigDecimal> getBankCurrencyAmt(DataSet billDs) {
        HashMap<String, Pair> bankCurrMap = new HashMap<String, Pair>();
        for (Row row : billDs) {
            Long currencyId;
            Long accountbankId = row.getLong("account");
            String keyStr = this.getKey(accountbankId, currencyId = row.getLong("currency"));
            if (bankCurrMap.containsKey(keyStr)) continue;
            bankCurrMap.put(keyStr, Pair.of((Object)accountbankId, (Object)currencyId));
        }
        HashMap<String, BigDecimal> bankAmtMap = new HashMap<String, BigDecimal>();
        Set accountBankIds = bankCurrMap.values().stream().map(o -> (Long)o.getLeft()).collect(Collectors.toSet());
        Map accountBankMap = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,company,issetbankinterface,acctclassify", (QFilter[])new QFilter[]{new QFilter("id", "in", accountBankIds)});
        for (Map.Entry bank : bankCurrMap.entrySet()) {
            DynamicObject accountBank;
            Long currencyId;
            Long bankId = (Long)((Pair)bank.getValue()).getLeft();
            String keyStr = this.getKey(bankId, currencyId = (Long)((Pair)bank.getValue()).getRight());
            if (bankAmtMap.containsKey(keyStr) || (accountBank = (DynamicObject)accountBankMap.get(bankId)) == null) continue;
            BigDecimal currBalance = this.getBankCurrBalance(accountBank, currencyId);
            bankAmtMap.put(keyStr, currBalance);
        }
        return bankAmtMap;
    }

    private String getKey(Long acountBankId, Long currencyId) {
        return String.valueOf(acountBankId) + currencyId;
    }

    private Pair<Date, Date> transDate() {
        Integer day;
        Date startDate = DateUtils.getCurrentDate();
        Date endDate = DateUtils.getCurrentDate();
        String repaydateranges = (String)this.getModel().getValue("repaydateranges");
        if (RepayDateRangesEnum.THISWEEK.getValue().equals(repaydateranges)) {
            startDate = DateUtils.getFirstDayOfWeek((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)endDate);
        } else if (RepayDateRangesEnum.THISMONTH.getValue().equals(repaydateranges)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)endDate);
        } else if (RepayDateRangesEnum.NEXTWEEK.getValue().equals(repaydateranges)) {
            startDate = DateUtils.getNextWeekMonday((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)startDate);
        } else if (RepayDateRangesEnum.NEXTMONTH.getValue().equals(repaydateranges)) {
            startDate = DateUtils.getFirstDateOfNextMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)startDate);
        } else if ("customrange".equals(repaydateranges)) {
            startDate = (Date)this.getModel().getValue("custrepaydate_startdate");
            endDate = (Date)this.getModel().getValue("custrepaydate_enddate");
            if (endDate != null) {
                endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
            }
        } else if ("customday".equals(repaydateranges) && (day = (Integer)this.getModel().getValue("day")) != null) {
            endDate = DateUtils.getNextDay((Date)endDate, (int)day);
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    private BigDecimal getBankCurrBalance(DynamicObject bankAcct, Object currencyId) {
        Object balance = null;
        if (AcctClassifyEnum.INNER_ACCOUNT.getValue().equals(bankAcct.getString("acctclassify"))) {
            DynamicObjectCollection balanceArr = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"amount", (QFilter[])new QFilter("accountbank", "=", bankAcct.getPkValue()).toArray(), (String)"bizdate desc", (int)1);
            return EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceArr) ? ((DynamicObject)balanceArr.get(0)).getBigDecimal("amount") : BigDecimal.ZERO;
        }
        return this.getBankBalance(bankAcct, currencyId);
    }

    private BigDecimal getBankBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = null;
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        if (isOpenBei) {
            balance = this.getBeiCurrBalance(bankAcct, currencyId);
        } else {
            try {
                balance = this.getAcctCurrBalance(bankAcct, currencyId);
            }
            catch (KDBizException e) {
                return BigDecimal.ZERO;
            }
        }
        return balance;
    }

    private BigDecimal getBeiCurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = BankServiceHelper.getCurBalance((Long)((Long)bankAcct.getPkValue()), (Long)((Long)currencyId));
        balance = balance == null ? BigDecimal.ZERO : balance;
        return balance;
    }

    private BigDecimal getAcctCurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = CasBusinessHelper.getBalance((long)((Long)bankAcct.get("company_id")), (long)((Long)bankAcct.getPkValue()), (long)((Long)currencyId));
        balance = balance == null ? BigDecimal.ZERO : balance;
        return balance;
    }

    private QFilter getOrgFilter() {
        ArrayList<Long> comIist = new ArrayList<Long>();
        DynamicObjectCollection companys = (DynamicObjectCollection)this.getModel().getValue("company");
        for (DynamicObject company : companys) {
            comIist.add(((DynamicObject)company.get("fbasedataid")).getLong("id"));
        }
        QFilter ofilter = null;
        if (comIist.size() > 0) {
            ofilter = new QFilter("org", "in", comIist);
        }
        return ofilter;
    }
}

