/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbsInitBillFeeInfoEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String OPPACCTBANK_CLOSECALLBACK = "oppacctbank_closeCallBack";
    private static final BigDecimal MAX_FEE = new BigDecimal("9999999999999.999999");
    private static final BigDecimal MIN_FEE = BigDecimal.ZERO;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit feeAcctBank = (BasedataEdit)this.getView().getControl(this.getFeeProp("feeacctbank"));
        feeAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit feeScheme = (BasedataEdit)this.getView().getControl(this.getFeeProp("feescheme"));
        feeScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit oppUnit = (TextEdit)this.getControl(this.getFeeProp("feeoppunittext"));
        oppUnit.addClickListener((ClickListener)this);
        TextEdit oppAcctbank = (TextEdit)this.getControl(this.getFeeProp("feeoppacctbank"));
        oppAcctbank.addClickListener((ClickListener)this);
    }

    abstract String getFeeProp(String var1);

    abstract String getFeeEntryProp();

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (this.getFeeProp("feeacctbank").equals(key)) {
            this.acctBankF7Evt(evt);
        }
        if (this.getFeeProp("feescheme").equals(key)) {
            this.feeSchemeF7(evt);
        }
    }

    private void feeSchemeF7(BeforeF7SelectEvent evt) {
        String keyName = evt.getProperty().getName();
        String entityName = this.getModel().getDataEntityType().getName();
        ProductTypeEnum TypeEnum2 = ProductTypeEnum.LOANCONTRACT_BL_L;
        if ("cfm_initbill_bond".equals(entityName)) {
            TypeEnum2 = ProductTypeEnum.LOANCONTRACT_BO;
            if ("lfeescheme".equals(keyName)) {
                TypeEnum2 = ProductTypeEnum.LOANBILL_BOND;
            }
        } else if ("lfeescheme".equals(keyName)) {
            TypeEnum2 = ProductTypeEnum.LOANBILL_B_L;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)currency) && EmptyUtil.isNoEmpty((String)TypeEnum2.getId())) {
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            qFilter.and("currency", "=", currency.getPkValue()).and("tradetype", "=", (Object)Long.valueOf(TypeEnum2.getId()));
            sp.getListFilterParameter().getQFilters().add(qFilter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ec4\u7ec7\u548c\u5e01\u79cd\u3002", (String)"AbsInitBillFeeInfoEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
        long orgId = mainOrg == null ? 0L : Long.parseLong(mainOrg.getPkValue().toString());
        QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
        if (filter == null) {
            filter = QFilter.of((String)"1=0", (Object[])new Object[0]);
        }
        QFilter qFilter = filter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "feeoppacctbank": 
            case "lfeeoppacctbank": {
                this.dealAndShowBankInfo();
                break;
            }
            case "feeoppunittext": 
            case "lfeeoppunittext": {
                this.dealOppUnitF7();
            }
        }
    }

    private void dealOppUnitF7() {
        int indexRow = this.getModel().getEntryCurrentRowIndex(this.getFeeEntryProp());
        DynamicObject rowInfo = this.getModel().getEntryRowEntity(this.getFeeEntryProp(), indexRow);
        String oppUnitType = rowInfo.getString(this.getFeeProp("feeoppunittype"));
        if (OppUnitTypeEnum.OTHER.getValue().equals(oppUnitType)) {
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl(this.getFeeProp("feeoppunit"));
        control.click();
    }

    private void dealAndShowBankInfo() {
        int indexRow = this.getModel().getEntryCurrentRowIndex(this.getFeeEntryProp());
        DynamicObject rowInfo = this.getModel().getEntryRowEntity(this.getFeeEntryProp(), indexRow);
        String oppUnitType = rowInfo.getString(this.getFeeProp("feeoppunittype"));
        if (OppUnitTypeEnum.FINORGINFO.getValue().equals(oppUnitType) || OppUnitTypeEnum.OTHER.getValue().equals(oppUnitType)) {
            return;
        }
        DynamicObject oppUnit = rowInfo.getDynamicObject(this.getFeeProp("feeoppunit"));
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            Object oppUnitId = oppUnit.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = CfmBillCommonHelper.getInternalOrg((DynamicObject)oppUnit);
                if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                    String qFilter = new QFilter("id", "=", oppUnitId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"AbsInitBillFeeInfoEdit_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (oppUnitEntityType) {
                case "bd_supplier": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bd_customer": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)oppUnitId);
                    break;
                }
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPPACCTBANK_CLOSECALLBACK);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "oppacctbank_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        int indexRow = this.getModel().getEntryCurrentRowIndex(this.getFeeEntryProp());
        DynamicObject rowInfo = this.getModel().getEntryRowEntity(this.getFeeEntryProp(), indexRow);
        DynamicObject oppUnit = rowInfo.getDynamicObject(this.getFeeProp("feeoppunit"));
        Object entryKey = row.getEntryPrimaryKeyValue();
        String entityName = oppUnit.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = CfmBillCommonHelper.getInternalOrg((DynamicObject)oppUnit);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)oppUnit.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)entryBank)) {
                for (DynamicObject entry : entryBank) {
                    if (!entry.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue(this.getFeeProp("feeoppacctbank"), (Object)entry.getString("bankaccount"), indexRow);
                    this.getModel().setValue(this.getFeeProp("feeoppbebank"), (Object)entry.getDynamicObject("bank"), indexRow);
                    break;
                }
            }
        } else if ("bos_org".equals(entityName) || EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject bebankDO;
            DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            this.getModel().setValue(this.getFeeProp("feeoppacctbank"), (Object)accountbanksDO.getString("number"), indexRow);
            DynamicObject bankDO = accountbanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO) && !EmptyUtil.isEmpty((DynamicObject)(bebankDO = bankDO.getDynamicObject("bebank")))) {
                this.getModel().setValue(this.getFeeProp("feeoppbebank"), bebankDO.getPkValue(), indexRow);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "currency": {
                this.headCurrenyChg((DynamicObject)newValue);
            }
        }
    }

    protected void currencyChgEvt(int parentRowIndex, int rowIndex) {
        DynamicObject headCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject feeCurrency = (DynamicObject)this.getModel().getValue(this.getFeeProp("feecurrency"), rowIndex, parentRowIndex);
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        DynamicObject org = (DynamicObject)this.getModel().getValue(mainOrg);
        this.getModel().setValue(this.getFeeProp("excrate"), (Object)this.getExcRate(org, headCurrency, feeCurrency, rowIndex, parentRowIndex), rowIndex, parentRowIndex);
    }

    protected void amtCalChgEvt(int parentRowIndex, int rowIndex, String fieldProp) {
        boolean calRate;
        BigDecimal bizAmt;
        DynamicObject feeCur = (DynamicObject)this.getModel().getValue(this.getFeeProp("feecurrency"), rowIndex);
        BigDecimal excRate = (BigDecimal)this.getModel().getValue(this.getFeeProp("excrate"), rowIndex);
        if (parentRowIndex >= 0) {
            DynamicObject loanEntry = this.getModel().getEntryRowEntity("loanentry", parentRowIndex);
            bizAmt = loanEntry.getBigDecimal("drawamount");
            if (BigDecimal.ZERO.compareTo(bizAmt) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u5f55\u63d0\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_7", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isEmpty((DynamicObject)feeCur)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u63d0\u6b3e\u4fe1\u606f\u7684\u7b2c%s\u884c\u7684\u8d39\u7528\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[]{rowIndex + 1}));
                return;
            }
            if (BigDecimal.ZERO.compareTo(excRate) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u63d0\u6b3e\u4fe1\u606f\u7684\u7b2c%s\u884c\u7684\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[]{rowIndex + 1}));
                return;
            }
        } else {
            bizAmt = (BigDecimal)this.getModel().getValue("amount");
            if (BigDecimal.ZERO.compareTo(bizAmt) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u7684\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isEmpty((DynamicObject)feeCur)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u8d39\u7528\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[]{rowIndex + 1}));
                return;
            }
            if (BigDecimal.ZERO.compareTo(excRate) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbsInitBillFeeInfoEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[]{rowIndex + 1}));
                return;
            }
        }
        BigDecimal feeRate = (BigDecimal)this.getModel().getValue(this.getFeeProp("feerate"), rowIndex);
        BigDecimal feeAmt = (BigDecimal)this.getModel().getValue(this.getFeeProp("feeamt"), rowIndex);
        boolean calAmt = EmptyUtil.isNoEmpty((BigDecimal)feeRate) && this.getFeeProp("feerate").equals(fieldProp);
        boolean bl = calRate = EmptyUtil.isNoEmpty((BigDecimal)feeAmt) && (this.getFeeProp("feeamt").equals(fieldProp) || this.getFeeProp("excrate").equals(fieldProp));
        if (calAmt) {
            BigDecimal newAmt = bizAmt.multiply(feeRate).divide(excRate, 10, RoundingMode.HALF_UP).divide(Constants.ONE_HUNDRED, bizAmt.scale(), RoundingMode.HALF_UP);
            if (MIN_FEE.compareTo(newAmt) > 0 || MAX_FEE.compareTo(newAmt) < 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u8303\u56f4\u3002", (String)"AbsInitBillFeeInfoEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feeamt"), (Object)newAmt, (int)rowIndex, (int)parentRowIndex);
            }
        }
        if (calRate) {
            BigDecimal newRate = feeAmt.multiply(excRate).multiply(Constants.ONE_HUNDRED).divide(bizAmt, bizAmt.scale(), RoundingMode.HALF_UP);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feerate"), (Object)newRate, (int)rowIndex, (int)parentRowIndex);
        }
    }

    private BigDecimal getExcRate(DynamicObject org, DynamicObject headCur, DynamicObject feeCur, int rowIndex, int parentRowIndex) {
        if (headCur.getPkValue().equals(feeCur.getPkValue())) {
            this.getModel().setValue(this.getFeeProp("ishandexcrate"), (Object)false, rowIndex, parentRowIndex);
            return BigDecimal.ONE;
        }
        Long exchangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)org.getLong("id"));
        if (EmptyUtil.isEmpty((Long)exchangeTableId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s:\u6ca1\u6709\u5728\u51fa\u7eb3\u521d\u59cb\u5316\u91cc\u7ef4\u62a4\u6c47\u7387\u8868,\u8bf7\u7ef4\u62a4\u3002", (String)"BatchFeeInputPlugin_09", (String)"tmc-cfm-formplugin", (Object[])new Object[]{org.getString("name")}));
            this.getModel().setValue(this.getFeeProp("ishandexcrate"), (Object)true, rowIndex, parentRowIndex);
            return BigDecimal.ONE;
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)feeCur.getLong("id"), (Long)headCur.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((BigDecimal)exchangeRate)) {
            this.getModel().setValue(this.getFeeProp("ishandexcrate"), (Object)false, rowIndex, parentRowIndex);
            return exchangeRate;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362[%3$s]\u7684\u6c47\u7387\u3002", (String)"BatchFeeInputPlugin_10", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), org.getString("name"), feeCur.getString("name"), headCur.getString("name")));
        this.getModel().setValue(this.getFeeProp("ishandexcrate"), (Object)true, rowIndex, parentRowIndex);
        return BigDecimal.ONE;
    }

    protected void feeSchemeChgEvt(int parentRowIndex, int rowIndex, DynamicObject feeScheme) {
        boolean schemeNoEmpty = EmptyUtil.isNoEmpty((DynamicObject)feeScheme);
        this.getModel().setValue(this.getFeeProp("feetype"), schemeNoEmpty ? feeScheme.getDynamicObject("feetype") : Integer.valueOf(0), rowIndex);
        if (schemeNoEmpty) {
            this.getModel().setValue(this.getFeeProp("feeissettle"), (Object)(!feeScheme.getBoolean("handsettle") ? 1 : 0), rowIndex);
            String feeCalType = feeScheme.getString("feecaltype");
            BigDecimal amt = feeScheme.getBigDecimal("amountrate");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feerate"), (Object)amt, (int)rowIndex);
                this.amtCalChgEvt(parentRowIndex, rowIndex, this.getFeeProp("feerate"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feeamt"), (Object)amt, (int)rowIndex);
                this.amtCalChgEvt(parentRowIndex, rowIndex, this.getFeeProp("feeamt"));
            }
        } else {
            this.getModel().setValue(this.getFeeProp("feeissettle"), (Object)false, rowIndex);
        }
        this.setFeeEntryEnableByScheme(rowIndex);
    }

    protected void oppUnitChgEvt(int rowIndex, DynamicObject oppUnit) {
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            this.getModel().setValue(this.getFeeProp("feeoppunittext"), (Object)oppUnit.getString("name"), rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feeoppacctbank"), null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)this.getFeeProp("feeoppbebank"), null, (int)rowIndex);
        }
    }

    private void setFeeEntryEnableByScheme(Integer rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getFeeEntryProp());
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (null != rowIndex && rowIndex == i) {
                this.setRowEnable(rowIndex, entry);
                continue;
            }
            if (null != rowIndex) continue;
            this.setRowEnable(i, entry);
        }
    }

    private void setRowEnable(int i, DynamicObject entry) {
        DynamicObject feeScheme = entry.getDynamicObject(this.getFeeProp("feescheme"));
        if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{this.getFeeProp("feetype"), this.getFeeProp("feeissettle")});
            String feeCalType = feeScheme.getString("feecaltype");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{this.getFeeProp("feerate")});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{this.getFeeProp("feeamt")});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{this.getFeeProp("feeamt")});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{this.getFeeProp("feerate")});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{this.getFeeProp("feetype"), this.getFeeProp("feeamt"), this.getFeeProp("feerate"), this.getFeeProp("feeissettle")});
        }
    }

    private void headCurrenyChg(DynamicObject curreny) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getFeeEntryProp());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue(this.getFeeProp("feecurrency"), (Object)curreny, i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if (this.getFeeEntryProp().equals(entryName)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.getModel().setValue(this.getFeeProp("feecurrency"), (Object)currency, index);
                this.getModel().setValue(this.getFeeProp("feesource"), (Object)FeeSourceEnum.LINKGEN.getValue(), index);
            }
        }
    }
}

