/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.formplugin.common.InitBillCreditLinkGmHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.GuaUseStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillGuaranteeUsePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public static final String CONFIRM_GUARANTEE_AMOUNT = "confirm_guarantee_amount";
    public static final String AFTER_CONFIRM = "afterConfirm";
    private static Map<String, String> guaranteeWayMap = new HashMap<String, String>(8);

    public void registerListener(EventObject e) {
        BasedataEdit gContract;
        super.registerListener(e);
        EntryGrid gContractGrid = (EntryGrid)this.getControl("gmsubentry");
        if (gContractGrid != null) {
            gContractGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((gContract = (BasedataEdit)this.getView().getControl("gcontract")) != null) {
            gContract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (!key.equals("gcontract")) {
            return;
        }
        QFilter gQF = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (!this.addQFilter_debtor(evt, gQF)) {
            return;
        }
        if (!this.addQFilter_guaranteeWay(evt, gQF)) {
            return;
        }
        int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        DynamicObject parentRow = this.getModel().getEntryRowEntity("loanentry", parentIndex);
        DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)subEntry)) {
            List gcIds = subEntry.stream().filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("gcontract"))).map(r -> r.getDynamicObject("gcontract")).map(r -> r.getPkValue()).collect(Collectors.toList());
            gQF.and(new QFilter("id", "not in", gcIds));
        }
        gQF.and(new QFilter("guaranteevarieties.creditguarantee", "=", (Object)"cfm_creditlimit".equals(this.getModel().getDataEntity().getDataEntityType().getName())));
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        showParam.getListFilterParameter().getQFilters().add(gQF);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyName) {
            case "gcontract": {
                String gContractBillNo;
                if (EmptyUtil.isNoEmpty((Object)oldValue) && EmptyUtil.isNoEmpty((String)(gContractBillNo = this.filterOriginalGContract(Collections.singletonList(((DynamicObject)oldValue).getLong("id")))))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u62c5\u4fdd\u5408\u540c\u3010%s\u3011\u4e0d\u80fd\u4fee\u6539", (String)"InitBillGuaranteeUsePlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[]{gContractBillNo}));
                    this.getModel().setValue("gcontract", oldValue, rowIndex);
                    break;
                }
                this.gContractChgEvt_init(rowIndex, newValue);
                break;
            }
            case "gamount": {
                this.gRatioChgEvt_init(rowIndex, newValue);
                break;
            }
            case "gratio": {
                this.gAmountChgEvt_init(rowIndex, newValue);
                break;
            }
            case "gstatus": {
                if (!GuaUseStatusEnum.RELIEVED.getValue().equals(newValue)) break;
                this.getModel().setValue("gratio", (Object)BigDecimal.ZERO, rowIndex);
                break;
            }
        }
        this.bizPropChanged(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        EntryProp entryProp = e.getEntryProp();
        switch (entryName = entryProp.getName()) {
            case "loanentry": {
                Object[] dataEntities = e.getRowDataEntities();
                if (EmptyUtil.isEmpty((Object[])dataEntities)) {
                    return;
                }
                int rowIndex = dataEntities[0].getRowIndex();
                if (rowIndex == 0) {
                    return;
                }
                DynamicObject preRow = this.getModel().getEntryRowEntity("loanentry", rowIndex - 1);
                DynamicObjectCollection preRowSubEntry = preRow.getDynamicObjectCollection("gmsubentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)preRowSubEntry)) {
                    return;
                }
                DynamicObject curRow = this.getModel().getEntryRowEntity("loanentry", rowIndex);
                DynamicObjectCollection curRowSubEntry = curRow.getDynamicObjectCollection("gmsubentry");
                curRowSubEntry.clear();
                for (DynamicObject preSub : preRowSubEntry) {
                    if (preSub.getBoolean("gcreditguarantee")) continue;
                    DynamicObject curSub = curRowSubEntry.addNew();
                    curSub.set("gcontract", preSub.get("gcontract"));
                    curSub.set("gcreditguarantee", preSub.get("gcreditguarantee"));
                    curSub.set("gratio", preSub.get("gratio"));
                    curSub.set("gcontractamount", preSub.get("gcontractamount"));
                    curSub.set("gcontractcurrency", preSub.get("gcontractcurrency"));
                    curSub.set("gexchrate", preSub.get("gexchrate"));
                    curSub.set("gcomment", preSub.get("gcomment"));
                    curSub.set("gcreditortype", preSub.get("gcreditortype"));
                    curSub.set("gcreditor", preSub.get("gcreditor"));
                    curSub.set("gcreditortext", preSub.get("gcreditortext"));
                }
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        if ("gratio".equals(source.getKey()) && (e.getValue() == null || BigDecimal.ZERO.compareTo(new BigDecimal((String)e.getValue())) == 0)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62c5\u4fdd\u6bd4\u4f8b(%)\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"InitBillGuaranteeUsePlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView("gratio", e.getRowIndex());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate op = (FormOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "save": {
                this.verifyGuaranteeContractAmt(args, op);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_GUARANTEE_AMOUNT.equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CONFIRM, "true");
            this.getView().invokeOperation("save", option);
        }
    }

    private boolean addQFilter_guaranteeWay(BeforeF7SelectEvent evt, QFilter gQF) {
        String gWayPropName = this.getGuaranteeWayProp();
        String gWays = null;
        if (gWayPropName.indexOf(46) > 0) {
            String[] gwayProps = gWayPropName.split("\\.");
            String gwayParent = gwayProps[0];
            String gwayProp = gwayProps[1];
            DynamicObject gwayPDO = (DynamicObject)this.getModel().getValue(gwayParent);
            if (gwayPDO != null) {
                gWays = gwayPDO.getString(gwayProp);
            }
        } else {
            gWays = (String)this.getModel().getValue(gWayPropName);
        }
        if (gWays == null || EmptyUtil.isEmpty((String)gWays.replaceAll(",", ""))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62c5\u4fdd\u65b9\u5f0f", (String)"InitBillGuaranteeUsePlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return false;
        }
        String[] gWaysArr = gWays.split(",");
        gWaysArr = this.convertGuaranteeWay(gWaysArr);
        QFilter gwayQF = new QFilter("1", "=", (Object)2);
        for (String qw : gWaysArr) {
            if (!EmptyUtil.isNoEmpty((String)qw)) continue;
            gwayQF.or(new QFilter("guaranteeway", "like", (Object)("%" + qw + "%")));
        }
        gQF.and(gwayQF);
        return true;
    }

    private boolean addQFilter_creditor(BeforeF7SelectEvent evt, QFilter gQF) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_initbill_bond".equals(formId)) {
            return true;
        }
        String textCreditor = (String)this.getModel().getValue("textcreditor");
        if (EmptyUtil.isEmpty((String)textCreditor)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d", (String)"InitBillGuaranteeUsePlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getModel().getProperty("textcreditor").getDisplayName().getLocaleValue()));
            evt.setCancel(true);
            return false;
        }
        if (CreditorTypeEnum.OTHER.getValue().equals(this.getModel().getValue("creditortype"))) {
            gQF.and("creditortext", "=", (Object)textCreditor);
        } else {
            gQF.and("creditor", "=", this.getModel().getValue("creditor"));
        }
        return true;
    }

    private boolean addQFilter_debtor(BeforeF7SelectEvent evt, QFilter gQF) {
        boolean isInvestInit = "cim_invest_initbill".equals(this.getView().getFormShowParameter().getFormId());
        if (isInvestInit) {
            if (CreditorTypeEnum.OTHER.getValue().equals(this.getModel().getValue("debtortype"))) {
                String textDebtor = (String)this.getModel().getValue("textdebtor");
                if (EmptyUtil.isEmpty((String)textDebtor)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d", (String)"InitBillGuaranteeUsePlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getModel().getProperty("org").getDisplayName().getLocaleValue()));
                    evt.setCancel(true);
                    return false;
                }
                gQF.and("entry_guaranteedorg.b_guaranteedorgtext", "=", (Object)textDebtor);
            } else {
                Long debtorId = (Long)this.getModel().getValue("debtor");
                if (EmptyUtil.isEmpty((Long)debtorId)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d", (String)"InitBillGuaranteeUsePlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getModel().getProperty("org").getDisplayName().getLocaleValue()));
                    evt.setCancel(true);
                    return false;
                }
                gQF.and("entry_guaranteedorg.b_guaranteedorg", "in", (Object)debtorId);
            }
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (EmptyUtil.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d", (String)"InitBillGuaranteeUsePlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), this.getModel().getProperty("org").getDisplayName().getLocaleValue()));
                evt.setCancel(true);
                return false;
            }
            gQF.and("entry_guaranteedorg.b_guaranteedorg", "in", org.getPkValue());
        }
        return true;
    }

    protected String[] convertGuaranteeWay(String[] gWaysArr) {
        ArrayList<String> gWays = new ArrayList<String>(gWaysArr.length);
        for (String w : gWaysArr) {
            String gw = guaranteeWayMap.get(w);
            if (gw != null) {
                gWays.add(gw);
                continue;
            }
            gWays.add(w);
        }
        return gWays.toArray(new String[0]);
    }

    protected String getBizPropName(String prop) {
        if ("bizamount".equals(prop)) {
            if ("ifm_bizdealbill_fin".equals(((FormView)this.getView()).getFormId())) {
                return "amount";
            }
            if ("ifm_bizdealbill_loan".equals(((FormView)this.getView()).getFormId())) {
                return "drawamount";
            }
        }
        String entityName = this.getModel().getDataEntityType().getName();
        return GuaranteeUseHelper.getBizPropName((String)entityName, (String)prop);
    }

    protected String getGuaranteeOrgProp() {
        return this.getBizPropName("debtor");
    }

    protected String getGuaranteeWayProp() {
        return this.getBizPropName("bizguaranteeway");
    }

    protected String getBizAmountProp() {
        return this.getBizPropName("bizamount");
    }

    protected String getBizCurrencyProp() {
        return this.getBizPropName("bizcurrency");
    }

    private String filterOriginalGContract(List<Long> guaranteeContractIds) {
        DynamicObject sourceBill = null;
        if ("gm_letterofguaapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("letterofguarantee");
        } else if ("cfm_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName()) || "ifm_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName()) || "cim_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        } else if ("lc_bizapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("lettercredit");
        }
        if (sourceBill == null) {
            return null;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", sourceBill.getPkValue());
        Object[] gcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return null;
        }
        List selectedOldGContracts = Arrays.stream(gcBills).filter(o -> guaranteeContractIds.contains(o.getDynamicObject("gcontract").getLong("id"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(selectedOldGContracts)) {
            StringBuilder gContractBillNos = new StringBuilder();
            for (int i = 0; i < selectedOldGContracts.size(); ++i) {
                DynamicObject selectedOldGContract = (DynamicObject)selectedOldGContracts.get(i);
                gContractBillNos.append(selectedOldGContract.getDynamicObject("gcontract").getString("billno"));
                if (i == selectedOldGContracts.size() - 1) continue;
                gContractBillNos.append(",");
            }
            return gContractBillNos.toString();
        }
        return null;
    }

    protected void bizPropChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "currency": 
            case "org": 
            case "creditor": 
            case "textcreditor": 
            case "debtor": {
                DynamicObjectCollection parentEntry = this.getModel().getEntryEntity("loanentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)parentEntry)) {
                    return;
                }
                this.getModel().deleteEntryData("loanentry");
                break;
            }
            case "drawamount": {
                BigDecimal newBizAmount = (BigDecimal)newValue;
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObject parentRow = this.getModel().getEntryRowEntity("loanentry", rowIndex);
                DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry)) {
                    return;
                }
                String creditorType = (String)this.getModel().getValue("creditortype");
                Long creditor = (Long)this.getModel().getValue("creditor");
                List gcList = subEntry.stream().filter(f -> EmptyUtil.isNoEmpty((String)creditorType) && creditor != null && creditorType.equals(f.getString("gcreditortype")) && creditor.equals(f.getLong("gcreditor"))).collect(Collectors.toList());
                BigDecimal sumRatio = gcList.stream().map(v -> v.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumAmount = BigDecimal.ZERO;
                for (int i = 0; i < subEntry.size(); ++i) {
                    DynamicObject gcBill = (DynamicObject)subEntry.get(i);
                    if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !creditorType.equals(gcBill.getString("gcreditortype")) || !creditor.equals(gcBill.getLong("gcreditor"))) continue;
                    BigDecimal ratio = (BigDecimal)this.getModel().getValue("gratio", i, rowIndex);
                    if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == subEntry.size() - 1) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)newBizAmount.subtract(sumAmount), (int)i, (int)rowIndex);
                        continue;
                    }
                    BigDecimal gAmount = newBizAmount.multiply(ratio).divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)gAmount, (int)i, (int)rowIndex);
                    sumAmount = sumAmount.add((BigDecimal)this.getModel().getValue("gamount", i, rowIndex));
                }
                break;
            }
        }
    }

    private void gContractChgEvt_init(int rowIndex, Object newValue) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            BigDecimal rate;
            boolean diffCurrency;
            DynamicObject gContractF7 = (DynamicObject)newValue;
            int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            this.getModel().setValue("gcontractamount", (Object)gContractF7.getBigDecimal("amount"), rowIndex, parentIndex);
            this.getModel().setValue("gcontractcurrency", (Object)gContractF7.getDynamicObject("currency"), rowIndex, parentIndex);
            this.setCreditGuarantee(gContractF7, rowIndex, parentIndex);
            if (((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex, parentIndex)).booleanValue()) {
                return;
            }
            DynamicObject gCcy = gContractF7.getDynamicObject("currency");
            String bizCcyPropName = this.getBizCurrencyProp();
            DynamicObject bizCCy = (DynamicObject)this.getModel().getValue(bizCcyPropName);
            boolean bl = diffCurrency = bizCCy != null && !gCcy.getPkValue().equals(bizCCy.getPkValue());
            if (diffCurrency) {
                String gOrgPropName = this.getGuaranteeOrgProp();
                DynamicObject company = (DynamicObject)this.getModel().getValue(gOrgPropName);
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCCy.getLong("id"), (long)gCcy.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
            } else {
                rate = BigDecimal.ONE;
            }
            this.getView().setEnable(Boolean.valueOf(diffCurrency), parentIndex, new String[]{"gexchrate"});
            this.getModel().setValue("gexchrate", (Object)rate, rowIndex, parentIndex);
            DynamicObject parentRow = this.getModel().getEntryRowEntity("loanentry", parentIndex);
            BigDecimal bizAmount = parentRow.getBigDecimal("drawamount");
            String curCreditorType = (String)this.getModel().getValue("creditortype");
            Long curCreditor = (Long)this.getModel().getValue("creditor");
            this.getModel().setValue("gcreditortype", (Object)curCreditorType, rowIndex, parentIndex);
            this.getModel().setValue("gcreditor", (Object)curCreditor, rowIndex, parentIndex);
            this.getModel().setValue("gcreditortext", this.getModel().getValue("textcreditor"), rowIndex, parentIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)bizAmount, (int)rowIndex, (int)parentIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)Constants.ONE_HUNDRED, (int)rowIndex, (int)parentIndex);
        }
    }

    private void setCreditGuarantee(DynamicObject gContract, int rowIdx, int parentIndex) {
        DynamicObject guarantee;
        if (gContract != null && (guarantee = gContract.getDynamicObject("guaranteevarieties")) != null) {
            DynamicObject guaranteeVar = TmcDataServiceHelper.loadSingleFromCache((Object)guarantee.getPkValue(), (String)"gm_guaranteevarieties", (String)"id,creditguarantee");
            this.getModel().setValue("gcreditguarantee", (Object)guaranteeVar.getBoolean("creditguarantee"), rowIdx, parentIndex);
        }
    }

    private void gRatioChgEvt_init(int rowIndex, Object newValue) {
        int i;
        int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        if (EmptyUtil.isEmpty((Object)newValue)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)0, (int)rowIndex, (int)parentIndex);
            return;
        }
        DynamicObject parentRow = this.getModel().getEntryRowEntity("loanentry", parentIndex);
        DynamicObject curGmContract = (DynamicObject)this.getModel().getValue("gcontract", rowIndex, parentIndex);
        if (EmptyUtil.isEmpty((DynamicObject)curGmContract)) {
            return;
        }
        BigDecimal bizAmount = parentRow.getBigDecimal("drawamount");
        DynamicObjectCollection gcs = parentRow.getDynamicObjectCollection("gmsubentry");
        List gcsList = gcs.stream().collect(Collectors.toList());
        String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex, parentIndex);
        Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex, parentIndex);
        if (EmptyUtil.isNoEmpty((String)curCreditorType) && curCreditor != null) {
            Map<String, BigDecimal> bizAmountMap = InitBillCreditLinkGmHelper.getInitBankSyncMaps(this.getModel().getDataEntityType().getName(), this.getModel(), parentIndex);
            bizAmount = bizAmountMap.containsKey(curCreditorType + curCreditor) ? bizAmountMap.get(curCreditorType + curCreditor) : bizAmount;
            gcsList = new ArrayList(gcs.size());
            for (DynamicObject gc : gcs) {
                String creditorType = gc.getString("gcreditortype");
                Long creditor = gc.getLong("gcreditor");
                if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                gcsList.add(gc);
            }
        }
        if (bizAmount.compareTo(BigDecimal.ZERO) == 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)0, (int)rowIndex, (int)parentIndex);
            return;
        }
        BigDecimal sumAmount = gcsList.stream().map(g -> g.getBigDecimal("gamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumRatio = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> gRatioMap = new HashMap<Long, BigDecimal>(gcsList.size());
        for (i = 0; i < gcsList.size(); ++i) {
            BigDecimal gRatio;
            DynamicObject gContract = ((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract");
            if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
            if (sumAmount.compareTo(bizAmount) == 0 && i == gcsList.size() - 1) {
                gRatio = Constants.ONE_HUNDRED.subtract(sumRatio);
            } else {
                gRatio = Constants.ONE_HUNDRED.multiply(((DynamicObject)gcsList.get(i)).getBigDecimal("gamount")).divide(bizAmount, 10, RoundingMode.HALF_UP);
                sumRatio = sumRatio.add(gRatio);
            }
            gRatioMap.put(gContract.getLong("id"), gRatio);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)Constants.ONE_HUNDRED.multiply((BigDecimal)newValue).divide(bizAmount, 10, RoundingMode.HALF_UP), (int)rowIndex, (int)parentIndex);
        if (sumAmount.compareTo(bizAmount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u91d1\u989d\u4e4b\u548c\u5927\u4e8e\u4e1a\u52a1\u91d1\u989d\u3002", (String)"InitBillGuaranteeUsePlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        } else if (sumAmount.compareTo(bizAmount) == 0) {
            for (i = 0; i < gcs.size(); ++i) {
                DynamicObject gc = (DynamicObject)gcs.get(i);
                DynamicObject gContract = gc.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
                String creditorType = gc.getString("gcreditortype");
                Long creditor = gc.getLong("gcreditor");
                if (!EmptyUtil.isNoEmpty((String)curCreditorType) || curCreditor == null || !EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", gRatioMap.get(gContract.getLong("id")), (int)i, (int)parentIndex);
            }
        }
    }

    private int getBaseCurrencyScale() {
        DynamicObject baseCurrencyDo = (DynamicObject)this.getModel().getValue("currency");
        return EmptyUtil.isNoEmpty((DynamicObject)baseCurrencyDo) ? baseCurrencyDo.getInt("amtprecision") : 6;
    }

    private void gAmountChgEvt_init(int rowIndex, Object newValue) {
        int i;
        int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        if (EmptyUtil.isEmpty((Object)newValue)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)0, (int)rowIndex, (int)parentIndex);
            return;
        }
        DynamicObject parentRow = this.getModel().getEntryRowEntity("loanentry", parentIndex);
        BigDecimal bizAmount = parentRow.getBigDecimal("drawamount");
        DynamicObjectCollection gcs = parentRow.getDynamicObjectCollection("gmsubentry");
        List gcsList = gcs.stream().collect(Collectors.toList());
        String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex, parentIndex);
        Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex, parentIndex);
        if (EmptyUtil.isNoEmpty((String)curCreditorType) && curCreditor != null) {
            Map<String, BigDecimal> bizAmountMap = InitBillCreditLinkGmHelper.getInitBankSyncMaps(this.getModel().getDataEntityType().getName(), this.getModel(), parentIndex);
            bizAmount = bizAmountMap.containsKey(curCreditorType + curCreditor) ? bizAmountMap.get(curCreditorType + curCreditor) : bizAmount;
            gcsList = new ArrayList(gcs.size());
            for (DynamicObject gc : gcs) {
                String creditorType = gc.getString("gcreditortype");
                Long creditor = gc.getLong("gcreditor");
                if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                gcsList.add(gc);
            }
        }
        if (bizAmount.compareTo(BigDecimal.ZERO) == 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)0, (int)rowIndex, (int)parentIndex);
            return;
        }
        int scale = this.getBaseCurrencyScale();
        BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAmount = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> gAmountMap = new HashMap<Long, BigDecimal>(gcsList.size());
        for (i = 0; i < gcsList.size(); ++i) {
            BigDecimal gAmount;
            DynamicObject gContract = ((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract");
            if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                gAmount = bizAmount.subtract(sumAmount);
            } else {
                BigDecimal gRatio = ((DynamicObject)gcsList.get(i)).getBigDecimal("gratio");
                gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            gAmountMap.put(gContract.getLong("id"), gAmount);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)bizAmount.multiply((BigDecimal)newValue).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP), (int)rowIndex, (int)parentIndex);
        if (sumRatio.compareTo(Constants.ONE_HUNDRED) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u6bd4\u4f8b\u4e4b\u548c\u8d85\u8fc7100%\u3002", (String)"InitBillGuaranteeUsePlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        } else if (sumRatio.compareTo(Constants.ONE_HUNDRED) == 0) {
            for (i = 0; i < gcs.size(); ++i) {
                DynamicObject gc = (DynamicObject)gcs.get(i);
                DynamicObject gContract = gc.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
                String creditorType = gc.getString("gcreditortype");
                Long creditor = gc.getLong("gcreditor");
                if (!EmptyUtil.isNoEmpty((String)curCreditorType) || curCreditor == null || !EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContract.getLong("id")), (int)i, (int)parentIndex);
            }
        }
    }

    private void verifyGuaranteeContractAmt(BeforeDoOperationEventArgs args, FormOperate op) {
        if (!op.getOption().getVariables().containsKey(AFTER_CONFIRM)) {
            DynamicObjectCollection parentEntry = this.getModel().getEntryEntity("loanentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)parentEntry)) {
                return;
            }
            ArrayList<String> seq = new ArrayList<String>(parentEntry.size());
            for (DynamicObject parentRow : parentEntry) {
                DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                DynamicObject parentCreditLimit = parentRow.getDynamicObject("creditlimit");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry) || EmptyUtil.isEmpty((DynamicObject)parentCreditLimit)) continue;
                for (int i = 0; i < subEntry.size(); ++i) {
                    BigDecimal availAmt;
                    DynamicObject subRow = (DynamicObject)subEntry.get(i);
                    DynamicObject gc = subRow.getDynamicObject("gcontract");
                    if (EmptyUtil.isEmpty((DynamicObject)gc)) continue;
                    BigDecimal gAmount = subRow.getBigDecimal("gamount");
                    BigDecimal exRate = subRow.getBigDecimal("gexchrate");
                    if (EmptyUtil.isEmpty((BigDecimal)gAmount) || (availAmt = GuaranteeUseHelper.getGContractAvailableDutyAmt((Long)gc.getLong("id"), (Long)parentCreditLimit.getDynamicObject("org").getLong("id"))) == null || availAmt.compareTo(gAmount.multiply(exRate)) >= 0) continue;
                    seq.add(i + 1 + "");
                }
            }
            if (!seq.isEmpty()) {
                this.getView().showConfirm(String.format(ResManager.loadResFormat((String)"\u62c5\u4fdd\u4fe1\u606f\u7b2c%s\u884c\u5206\u5f55\u4e2d\u7684\u62c5\u4fdd\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u88ab\u62c5\u4fdd\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f ", (String)"InitBillGuaranteeUsePlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", seq)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_GUARANTEE_AMOUNT, (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject gContract;
        int rowIdx = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        if ("gcontract".equals(fieldName) && (gContract = (DynamicObject)this.getModel().getValue("gcontract", rowIdx)) != null) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId("gm_guaranteecontract");
            param.setPkId(gContract.getPkValue());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    static {
        guaranteeWayMap.put("2", "ensure");
        guaranteeWayMap.put("3", "ensuamt");
        guaranteeWayMap.put("4", "mortgage");
        guaranteeWayMap.put("5", "pledge");
    }
}

