/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import org.apache.commons.lang3.StringUtils;

public class InitBillList
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn companyFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"creditorg.name")).findFirst().orElse(null);
        if (companyFilterCol == null) {
            return;
        }
        companyFilterCol.getDefaultValues().clear();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ("tracecontract".equals(opKey) && result != null && result.getValidateResult().isSuccess()) {
            this.openContractEditPage();
        }
        if ("endinit".equals(opKey) || "disendinit".equals(opKey)) {
            this.getView().updateView();
        }
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizType = parameter.getCustomParams().containsKey("biztype") ? (String)parameter.getCustomParam("biztype") : this.getDefaultBizType();
        String[] bizTypes = bizType.split(",");
        e.getQFilters().add(new QFilter("loantype", "in", (Object)bizTypes));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        } else {
            e.getParameter().getCustomParams().put("biztype", this.getDefaultBizType());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("cfm_financingvarieties".equals(args.getRefEntityId())) {
            if ("ifm_initbill".equals(this.getFormId())) {
                return;
            }
            List<String> bizTypes = this.getBizTypes();
            if (bizTypes.contains("loan") || bizTypes.contains("sl")) {
                args.getQfilters().add(new QFilter("finsource", "=", (Object)"bank"));
            } else if (bizTypes.contains("bond")) {
                args.getQfilters().add(new QFilter("finsource", "=", (Object)"bond"));
            }
            args.getQfilters().add(new QFilter("isleaf", "=", (Object)"1"));
        }
    }

    public List<QFilter> addCustomFilterForFilterCol(String field) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        if ("finproduct.name".equals(field)) {
            if ("ifm_initbill".equals(this.getFormId())) {
                return qFilters;
            }
            List<String> bizTypes = this.getBizTypes();
            if (bizTypes.contains("loan") || bizTypes.contains("sl")) {
                qFilters.add(new QFilter("finsource", "=", (Object)"bank"));
            } else if (bizTypes.contains("bond")) {
                qFilters.add(new QFilter("finsource", "=", (Object)"bond"));
            }
            qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        }
        return qFilters;
    }

    private void openContractEditPage() {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        DynamicObject initBill = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"cfm_initbill", (String)"loantype,initstatus");
        if (EmptyUtil.isEmpty((DynamicObject)initBill)) {
            return;
        }
        if (InitStatusEnum.INITING.getValue().equals(initBill.getString("initstatus"))) {
            String tipStr = ResManager.loadKDString((String)"\u8054\u67e5\u5408\u540c", (String)"InitBillList_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            if (BizTypeEnum.BOND.getValue().equals(initBill.getString("loantype"))) {
                tipStr = ResManager.loadKDString((String)"\u8054\u67e5\u53d1\u884c\u8ba1\u5212", (String)"InitBillList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u72b6\u6001\u4e3a\u5b8c\u6210\u624d\u80fd\u70b9\u51fb\u201c%s\u201d\u3002", (String)"InitBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), tipStr));
            return;
        }
        DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"id", (QFilter[])new QFilter("initid", "=", initBill.getPkValue()).toArray());
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(FormParameterHelper.getContractFormIdByBizType((DynamicObject)initBill, (IFormView)this.getView()));
        parameter.setPkId(contractBill.getPkValue());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private List<String> getBizTypes() {
        List<String> bizTypes;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            bizTypes = Arrays.asList(bizType.split(","));
        } else {
            bizTypes = Arrays.asList(this.getDefaultBizType().split(","));
        }
        return bizTypes;
    }

    private String getDefaultBizType() {
        String billFormId = this.getFormId();
        if ("cfm_initbill_bond".equals(billFormId)) {
            return "bond";
        }
        if ("cfm_initbill_b".equals(billFormId)) {
            return "loan,ls";
        }
        if ("ifm_initbill".equals(billFormId)) {
            return "loan";
        }
        return "entrust,ec";
    }

    private String getFormId() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
    }
}

